/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.Util;
import oracle.pg.rdbms.OracleElementIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraphException;

public class PGUtils {
    static SimpleLog ms_log = SimpleLog.getLog(PGUtils.class);
    public static final RDFPredicate[] CONST_NO_VERTEX_ATTR = null;
    public static final RDFPredicate[] CONST_ALL_PRED2EDGES = null;
    private static final String CONST_VT_SUFFIX = "VT$";
    private static final String CONST_GE_SUFFIX = "GE$";
    private static final String CONST_XMLDT_STRING = "http://www.w3.org/2001/XMLSchema#string";
    private static final String CONST_XMLDT_DECIMAL = "http://www.w3.org/2001/XMLSchema#decimal";
    private static final String CONST_XMLDT_INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    private static final String CONST_XMLDT_FLOAT = "http://www.w3.org/2001/XMLSchema#float";
    private static final String CONST_XMLDT_DOUBLE = "http://www.w3.org/2001/XMLSchema#double";
    private static final String CONST_XMLDT_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    private static final String CONST_XMLDT_DATE = "http://www.w3.org/2001/XMLSchema#date";
    private static final String CONST_XMLDT_DATETIME = "http://www.w3.org/2001/XMLSchema#dateTime";

    public static void createPropertyGraphViewOnRDF(Connection conn, String pgGraphName, String rdfModelName, boolean virtualModel, RDFPredicate[] predListForVertexAttrs, RDFPredicate[] predListForEdges) {
        try {
            rdfModelName = virtualModel ? "MDSYS." + Util.enquoteNameSQLName((Connection)conn, (String)("SEMV_" + rdfModelName.toUpperCase())) : "MDSYS." + Util.enquoteNameSQLName((Connection)conn, (String)("RDFM_" + rdfModelName.toUpperCase()));
            String vtViewName = pgGraphName + CONST_VT_SUFFIX;
            String geViewName = pgGraphName + CONST_GE_SUFFIX;
            if (predListForEdges == CONST_ALL_PRED2EDGES) {
                if (predListForVertexAttrs == CONST_NO_VERTEX_ATTR) {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"createPropertyGraphViewOnRDF: predListForVertexAttrs = CONST_NO_VERTEX_ATTR and predListForEdges = CONST_ALL_PRED2EDGES");
                    }
                    PGUtils.createEmptyVertexView(conn, vtViewName);
                    PGUtils.createEdgeView(conn, geViewName, rdfModelName, null, null, true);
                } else {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"createPropertyGraphViewOnRDF: predListForVertexAttrs != CONST_NO_VERTEX_ATTR and predListForEdges = CONST_ALL_PRED2EDGES");
                    }
                    PGUtils.createVertexView(conn, vtViewName, rdfModelName, predListForVertexAttrs, null, false, true);
                    PGUtils.createEdgeView(conn, geViewName, rdfModelName, null, predListForVertexAttrs, true);
                }
            } else if (predListForVertexAttrs == CONST_NO_VERTEX_ATTR) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"createPropertyGraphViewOnRDF: predListForVertexAttrs = CONST_NO_VERTEX_ATTR and predListForEdges != CONST_ALL_PRED2EDGES");
                }
                PGUtils.createEmptyVertexView(conn, vtViewName);
                PGUtils.createEdgeView(conn, geViewName, rdfModelName, predListForEdges, null, false);
            } else {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"createPropertyGraphViewOnRDF: predListForVertexAttrs != CONST_NO_VERTEX_ATTR and predListForEdges != CONST_ALL_PRED2EDGES");
                }
                PGUtils.createVertexView(conn, vtViewName, rdfModelName, predListForVertexAttrs, null, false, true);
                PGUtils.createEdgeView(conn, geViewName, rdfModelName, predListForEdges, null, false);
            }
        }
        catch (SQLException sqle) {
            throw new OraclePropertyGraphException(sqle);
        }
    }

    private static void createEmptyVertexView(Connection conn, String viewName) {
        PreparedStatement stmt = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\n create view ").append(Util.enquoteNameSQLName((Connection)conn, (String)viewName)).append(" as").append("\n   select null as vid, null as k, null as t, null as v, null as vn, null as vt, null as sl, null as vts, null as vte, null as fe, null as vl from dual where 1=0");
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)("createEmptyVertexView: stmt is " + sb.toString()));
            }
            stmt = conn.prepareStatement(sb.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new OraclePropertyGraphException(e);
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(stmt);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(stmt);
    }

    private static void createVertexView(Connection conn, String viewName, String rdfModelName, RDFPredicate[] incPreds, RDFPredicate[] excPreds, boolean allVertices, boolean kv) {
        PreparedStatement stmt = null;
        try {
            Object predSet;
            Object type;
            Long id;
            String uri;
            int i;
            HashMap<String, Long> mapIncPredURI2ID = new HashMap<String, Long>();
            HashMap<String, String> mapIncPredURI2Label = new HashMap<String, String>();
            HashMap<String, Integer> mapIncPredURI2Type = new HashMap<String, Integer>();
            HashMap<String, Long> mapExcPredURI2ID = new HashMap<String, Long>();
            HashMap<String, String> mapExcPredURI2Label = new HashMap<String, String>();
            HashMap<String, Integer> mapExcPredURI2Type = new HashMap<String, Integer>();
            if (incPreds != null && incPreds.length != 0) {
                for (i = 0; i < incPreds.length; ++i) {
                    uri = incPreds[i].getURI();
                    id = PGUtils.getPredicateID(conn, uri);
                    type = PGUtils.getPredicateType(conn, rdfModelName, id);
                    mapIncPredURI2ID.put(uri, id);
                    mapIncPredURI2Label.put(uri, incPreds[i].getLabel());
                    mapIncPredURI2Type.put(uri, (Integer)type);
                }
            }
            if (excPreds != null && excPreds.length != 0) {
                for (i = 0; i < excPreds.length; ++i) {
                    uri = excPreds[i].getURI();
                    id = PGUtils.getPredicateID(conn, uri);
                    type = PGUtils.getPredicateType(conn, rdfModelName, id);
                    mapExcPredURI2ID.put(uri, id);
                    mapExcPredURI2Label.put(uri, excPreds[i].getLabel());
                    mapExcPredURI2Type.put(uri, (Integer)type);
                }
            }
            StringBuilder sb = new StringBuilder();
            if (allVertices) {
                sb.append("\n create view ").append(Util.enquoteNameSQLName((Connection)conn, (String)viewName)).append(" as").append("\n   select distinct inner.vid as VID,").append("\n          null as VL,").append("\n          ' '  as K,").append("\n          null as T,").append("\n          null as V,").append("\n          null as VN,").append("\n          null as VT,").append("\n          null as SL,").append("\n          null as VTS,").append("\n          null as VTE,").append("\n          null as FE").append("\n  from").append("\n  (").append("\n     select distinct g.start_node_id as vid, p_value_id from ").append(Util.myCheckName((String)rdfModelName)).append(" g").append("\n   union").append("\n     select distinct g.canon_end_node_id as vid, p_value_id from ").append(Util.myCheckName((String)rdfModelName)).append(" g").append("\n  ) inner");
                if (mapExcPredURI2ID != null && mapExcPredURI2ID.size() != 0) {
                    sb.append("\n   where inner.p_value_id not in (");
                    int excPredSize = mapExcPredURI2ID.size();
                    int excPredCount = 0;
                    for (String uri2 : mapExcPredURI2ID.keySet()) {
                        sb.append(mapExcPredURI2ID.get(uri2));
                        if (excPredCount != excPredSize - 1) {
                            sb.append(",");
                        }
                        ++excPredCount;
                    }
                    sb.append(")");
                }
            } else if (!kv) {
                sb.append("\n create view ").append(Util.enquoteNameSQLName((Connection)conn, (String)viewName)).append(" as").append("\n   select distinct inner.vid as VID,").append("\n          null as VL,").append("\n          ' '  as K,").append("\n          null as T,").append("\n          null as V,").append("\n          null as VN,").append("\n          null as VT,").append("\n          null as SL,").append("\n          null as VTS,").append("\n          null as VTE,").append("\n          null as FE").append("\n  from").append("\n  (").append("\n     select distinct g.start_node_id as vid, p_value_id from ").append(Util.myCheckName((String)rdfModelName)).append(" g").append("\n   union").append("\n     select distinct g.canon_end_node_id as vid, p_value_id from ").append(Util.myCheckName((String)rdfModelName)).append(" g").append("\n  ) inner");
                predSet = new HashSet();
                predSet.addAll(mapIncPredURI2ID.keySet());
                predSet.removeAll(mapExcPredURI2ID.keySet());
                if (predSet.size() != 0) {
                    sb.append("\n   where inner.p_value_id in (");
                    int predSize = predSet.size();
                    int count = 0;
                    Iterator iterator = predSet.iterator();
                    while (iterator.hasNext()) {
                        String uri3 = (String)iterator.next();
                        sb.append(mapIncPredURI2ID.get(uri3));
                        if (count != predSize - 1) {
                            sb.append(",");
                        }
                        ++count;
                    }
                    sb.append(")");
                }
            } else {
                sb.append("\n create view ").append(Util.enquoteNameSQLName((Connection)conn, (String)viewName)).append(" as").append("\n   select inner.vid as VID,").append("\n   null as VL,").append("\n   inner.k as K,").append("\n   inner.t as T,");
                sb.append("\n   (case");
                sb.append("\n    when inner.t=").append(1).append(" then v.value_name");
                sb.append("\n    when inner.t=").append(6).append(" then v.value_name");
                sb.append("\n    else null end) as V,");
                sb.append("\n   (case");
                sb.append("\n    when inner.t=").append(2).append(" then v.value_name");
                sb.append("\n    when inner.t=").append(3).append(" then v.value_name");
                sb.append("\n    when inner.t=").append(4).append(" then v.value_name");
                sb.append("\n    when inner.t=").append(7).append(" then v.value_name");
                sb.append("\n    when inner.t=").append(8).append(" then v.value_name");
                sb.append("\n    else null end) as VN,");
                sb.append("\n   (case");
                sb.append("\n    when inner.t=").append(5).append(" and v.literal_type='").append(CONST_XMLDT_DATETIME).append("' then sem_apis.getV$DateTimetzVal(v.value_type, v.vname_prefix, v.VNAME_SUFFIX, v.literal_type, v.LANGUAGE_TYPE)");
                sb.append("\n    when inner.t=").append(5).append(" and v.literal_type='").append(CONST_XMLDT_DATE).append("' then sem_apis.getV$DateTzVal(v.value_type, v.vname_prefix, v.VNAME_SUFFIX, v.literal_type, v.LANGUAGE_TYPE)");
                sb.append("\n    else null end) as VT,");
                sb.append("\n   null as SL,").append("\n   null as VTS,").append("\n   null as VTE,").append("\n   null as FE").append("\n   from").append("\n   (").append("\n     select g.start_node_id as VID,");
                sb.append("\n           (case");
                for (String uri4 : mapIncPredURI2ID.keySet()) {
                    long pid = (Long)mapIncPredURI2ID.get(uri4);
                    String label = (String)mapIncPredURI2Label.get(uri4);
                    sb.append("\n           when g.p_value_id=").append(pid).append(" then ").append(Util.enquoteLiteral((Connection)conn, (String)label, (int)4000));
                }
                sb.append("\n           else null end) as K,");
                sb.append("\n           (case");
                for (String uri4 : mapIncPredURI2ID.keySet()) {
                    long pid = (Long)mapIncPredURI2ID.get(uri4);
                    int type2 = (Integer)mapIncPredURI2Type.get(uri4);
                    sb.append("\n           when g.p_value_id=").append(pid).append(" then ").append(type2);
                }
                sb.append("\n           else null end) as T,");
                sb.append("\n           canon_end_node_id as oid,").append("\n           row_number() over (partition by g.start_node_id, g.p_value_id order by g.start_node_id) as rn").append("\n     from (").append("\n       select * from ").append(Util.myCheckName((String)rdfModelName)).append("\n       where p_value_id in (");
                predSet = new HashSet();
                predSet.addAll(mapIncPredURI2ID.keySet());
                predSet.removeAll(mapExcPredURI2ID.keySet());
                int predSize = predSet.size();
                int count = 0;
                Iterator iterator = predSet.iterator();
                while (iterator.hasNext()) {
                    String uri5 = (String)iterator.next();
                    sb.append(mapIncPredURI2ID.get(uri5));
                    if (count != predSize - 1) {
                        sb.append(",");
                    }
                    ++count;
                }
                sb.append(")");
                sb.append("\n     ) g");
                sb.append("\n   ) inner, mdsys.rdf_value$ v");
                sb.append("\n   where rn=1 and v.value_id = inner.oid");
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)("createVertexView: stmt is " + sb.toString()));
            }
            stmt = conn.prepareStatement(sb.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new OraclePropertyGraphException(e);
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(stmt);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(stmt);
    }

    private static void createEdgeView(Connection conn, String viewName, String rdfModelName, RDFPredicate[] incPreds, RDFPredicate[] excPreds, boolean allEdges) {
        PreparedStatement stmt = null;
        try {
            Double weight;
            Object type;
            Long id;
            String uri;
            int i;
            HashMap<String, Long> mapIncPredURI2ID = new HashMap<String, Long>();
            HashMap<String, String> mapIncPredURI2Label = new HashMap<String, String>();
            HashMap<String, Object> mapIncPredURI2Type = new HashMap<String, Object>();
            HashMap<String, Double> mapIncPredURI2Weight = new HashMap<String, Double>();
            HashMap<String, Long> mapExcPredURI2ID = new HashMap<String, Long>();
            HashMap<String, Object> mapExcPredURI2Type = new HashMap<String, Object>();
            if (incPreds != null && incPreds.length != 0) {
                for (i = 0; i < incPreds.length; ++i) {
                    uri = incPreds[i].getURI();
                    id = PGUtils.getPredicateID(conn, uri);
                    type = PGUtils.getPredicateType(conn, rdfModelName, id);
                    String label = incPreds[i].getLabel();
                    weight = incPreds[i].getWeight();
                    mapIncPredURI2ID.put(uri, id);
                    mapIncPredURI2Label.put(uri, label);
                    mapIncPredURI2Type.put(uri, type);
                    mapIncPredURI2Weight.put(uri, weight);
                }
            }
            if (excPreds != null && excPreds.length != 0) {
                for (i = 0; i < excPreds.length; ++i) {
                    uri = excPreds[i].getURI();
                    id = PGUtils.getPredicateID(conn, uri);
                    type = PGUtils.getPredicateType(conn, rdfModelName, id);
                    mapExcPredURI2ID.put(uri, id);
                    mapExcPredURI2Type.put(uri, type);
                }
            }
            StringBuilder sbCondition = new StringBuilder();
            if (allEdges) {
                if (mapExcPredURI2ID != null && mapExcPredURI2ID.size() != 0) {
                    sbCondition.append(" where p_value_id not in (");
                    int excPredSize = mapExcPredURI2ID.size();
                    int excPredCount = 0;
                    for (Object uri2 : mapExcPredURI2ID.keySet()) {
                        sbCondition.append(mapExcPredURI2ID.get(uri2));
                        if (excPredCount != excPredSize - 1) {
                            sbCondition.append(",");
                        }
                        ++excPredCount;
                    }
                    sbCondition.append(")");
                }
            } else {
                HashSet predSet = new HashSet();
                predSet.addAll(mapIncPredURI2ID.keySet());
                predSet.removeAll(mapExcPredURI2ID.keySet());
                sbCondition.append(" where p_value_id in (");
                int predSize = predSet.size();
                int count = 0;
                for (String uri3 : predSet) {
                    sbCondition.append(mapIncPredURI2ID.get(uri3));
                    if (count != predSize - 1) {
                        sbCondition.append(",");
                    }
                    ++count;
                }
                sbCondition.append(")");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("\n create view ").append(Util.enquoteNameSQLName((Connection)conn, (String)viewName)).append(" as").append("\n   select inner.eid as EID,").append("\n          inner.svid as SVID,").append("\n          inner.dvid as DVID,");
            if (mapIncPredURI2ID != null && mapIncPredURI2ID.size() != 0) {
                sb.append("\n          (case");
                for (String uri4 : mapIncPredURI2Label.keySet()) {
                    Long id2 = (Long)mapIncPredURI2ID.get(uri4);
                    String label = (String)mapIncPredURI2Label.get(uri4);
                    sb.append("\n           when inner.el_id=").append(id2).append(" then ").append(Util.enquoteLiteral((Connection)conn, (String)label, (int)4000));
                }
                sb.append("\n           else null end) as EL,");
                sb.append("\n          (case").append("\n           when inner.vn is null then ' '").append("\n           else 'weight' end) as K,").append("\n          (case").append("\n           when inner.vn is null then null").append("\n           else 4 end) as T,");
            } else {
                sb.append("\n          v.value_name as EL,").append("\n          ' ' as K,").append("\n          null as T,");
            }
            sb.append("\n          null as V,").append("\n          inner.vn as VN,").append("\n          null as VT,").append("\n          null as SL,").append("\n          null as VTS,").append("\n          null as VTE,").append("\n          null as FE").append("\n   from").append("\n   (").append("\n      select rownum as eid,").append("\n             start_node_id as svid,").append("\n             canon_end_node_id as dvid,").append("\n             p_value_id as el_id,");
            if (mapIncPredURI2ID != null && mapIncPredURI2ID.size() != 0) {
                sb.append("\n             (case");
                for (String uri5 : mapIncPredURI2ID.keySet()) {
                    Long pid = (Long)mapIncPredURI2ID.get(uri5);
                    weight = (Double)mapIncPredURI2Weight.get(uri5);
                    if (weight != null) {
                        sb.append("\n              when g.p_value_id=").append(pid).append(" then ").append(weight);
                        continue;
                    }
                    sb.append("\n             when g.p_value_id=").append(pid).append(" then null");
                }
                sb.append("\n              else null end) as vn");
            } else {
                sb.append("\n             null as vn");
            }
            sb.append("\n      from (").append("\n              select * ").append("\n              from ").append(Util.myCheckName((String)rdfModelName));
            sb.append((CharSequence)sbCondition);
            sb.append("\n              ) g");
            if (allEdges) {
                sb.append("\n   ) inner, mdsys.rdf_value$ v where v.value_id = inner.el_id");
            } else {
                sb.append("\n   ) inner");
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)("createEdgeView: stmt is " + sb.toString()));
            }
            stmt = conn.prepareStatement(sb.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new OraclePropertyGraphException(e);
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(stmt);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(stmt);
    }

    private static long getPredicateID(Connection conn, String predURI) {
        long id = 0L;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)("getPredicateID: predURI = " + predURI));
            }
            StringBuilder query = new StringBuilder().append("\n select sem_apis.res2vid('MDSYS.RDF_VALUE$', ?) from dual");
            stmt = conn.prepareStatement(query.toString());
            stmt.setString(1, "<" + predURI + ">");
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)("getPredicateID: stmt is " + query.toString()));
            }
            if ((rs = stmt.executeQuery()).next()) {
                id = rs.getLong(1);
            }
            ms_log.debug((Object)("getPredicateID: id = " + id));
        }
        catch (SQLException e) {
            try {
                throw new OraclePropertyGraphException(e);
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
        return id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getPredicateType(Connection conn, String rdfModelName, long predicateID) {
        int type = 0;
        StringBuilder query = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)("getPredicateType: predicateID = " + predicateID));
            }
            query = new StringBuilder();
            query.append("\n select value_type, literal_type from mdsys.rdf_value$ where value_id =");
            query.append("\n  (select canon_end_node_id from ").append(Util.myCheckName((String)rdfModelName)).append(" where p_value_id =").append(predicateID).append(" and rownum<=1)");
            stmt = conn.prepareStatement(query.toString());
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)("getPredicateType: stmt is " + query.toString()));
            }
            rs = stmt.executeQuery();
            String valueType = null;
            String literalType = null;
            if (rs.next()) {
                valueType = rs.getString(1);
                literalType = rs.getString(2);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)("getPredicateType: valueType = " + (valueType != null ? valueType : "NULL")));
                    ms_log.debug((Object)("getPredicateType: literalType = " + (literalType != null ? literalType : "NULL")));
                }
                if (valueType.equalsIgnoreCase("TL")) {
                    if (literalType == null) {
                        type = 1;
                    } else if (literalType.equalsIgnoreCase(CONST_XMLDT_STRING)) {
                        type = 1;
                    } else if (literalType.equalsIgnoreCase(CONST_XMLDT_DECIMAL)) {
                        type = 4;
                    } else if (literalType.equalsIgnoreCase(CONST_XMLDT_INTEGER)) {
                        type = 2;
                    } else if (literalType.equalsIgnoreCase(CONST_XMLDT_FLOAT)) {
                        type = 3;
                    } else if (literalType.equalsIgnoreCase(CONST_XMLDT_DOUBLE)) {
                        type = 4;
                    } else if (literalType.equalsIgnoreCase(CONST_XMLDT_BOOLEAN)) {
                        type = 6;
                    } else if (literalType.equalsIgnoreCase(CONST_XMLDT_DATE)) {
                        type = 5;
                    } else {
                        if (!literalType.equalsIgnoreCase(CONST_XMLDT_DATETIME)) throw new UnsupportedOperationException("getPredicateType: unsupported predicate type");
                        type = 5;
                    }
                } else {
                    type = 1;
                }
            }
            ms_log.debug((Object)("getPredicateType: " + type));
        }
        catch (SQLException e) {
            try {
                throw new OraclePropertyGraphException(e);
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
        return type;
    }

    public static class RDFPredicate {
        private String uri = null;
        private String label = null;
        private Double weight = null;

        public static RDFPredicate getInstance(String uri) {
            return RDFPredicate.getInstance(uri, null);
        }

        public static RDFPredicate getInstance(String uri, String label) {
            return RDFPredicate.getInstance(uri, label, null);
        }

        public static RDFPredicate getInstance(String uri, String label, Double weight) {
            RDFPredicate predicate = new RDFPredicate(uri, label, weight);
            return predicate;
        }

        private RDFPredicate(String uri, String label, Double weight) {
            this.uri = uri;
            this.label = label;
            this.weight = weight;
        }

        public String getURI() {
            return this.uri;
        }

        public String getLabel() {
            return this.label;
        }

        public Double getWeight() {
            return this.weight;
        }

        public void setURI(String uri) {
            this.uri = uri;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setWeight(Double weight) {
            this.weight = weight;
        }
    }
}

