/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.pg.common.SimpleLog;
import oracle.pg.rdbms.OracleCommonIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraphException;
import oracle.pg.rdbms.Parameters;

public class OrderedVertexIdIteratorImpl
extends OracleCommonIteratorImpl
implements Iterator<Long> {
    static SimpleLog ms_log = SimpleLog.getLog(OrderedVertexIdIteratorImpl.class);
    protected boolean bFirstItem;
    protected long longPrevID;

    OrderedVertexIdIteratorImpl(ResultSet rs) {
        ms_log.debug((Object)"OrderedVertexIdIteratorImpl: constructor");
        this.rs = rs;
        this.bNextInovked = false;
        this.bNextExhausted = false;
        this.bFirstItem = true;
    }

    public void close() {
        if (this.rs != null) {
            this.safeCloseAndDeregisterIfNeeded(this.rs);
            this.rs = null;
        }
    }

    @Override
    public Long next() {
        boolean b;
        if (ms_log.isDebugEnabled() && Parameters.getInstance().isSuperVerboseOn()) {
            ms_log.debug((Object)"next: start");
        }
        if (!this.bNextInovked && !(b = this.hasNext())) {
            throw new NoSuchElementException(MSG_ERR_NO_ELEM_TO_BE_CONSUMED.toString());
        }
        Long lVID = null;
        try {
            lVID = this.rs.getLong(1);
            if (this.bFirstItem) {
                this.bFirstItem = false;
            } else if (lVID < this.longPrevID) {
                throw new OraclePropertyGraphException("Values are not in ascending order: longPrevID " + this.longPrevID + ", lVID " + lVID);
            }
            this.longPrevID = lVID;
            this.moveCursor();
            if (this.m_gracefulTimeout) {
                this.m_bTimedOut = this.checkGracefulTimeout();
            } else {
                this.checkQueryExecutionTimeOut();
            }
        }
        catch (Exception sqle) {
            ms_log.debug((Object)"next: Exception ", (Throwable)sqle);
            try {
                this.safeCloseAndDeregisterIfNeeded(this.rs);
                this.rs = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sqle instanceof SQLException) {
                if (((SQLException)sqle).getErrorCode() == 1013) {
                    this.m_bHitTimeoutAlready = true;
                    ms_log.debug((Object)"next: Query timeout exception(1013)");
                    if (this.m_gracefulTimeout) {
                        return lVID;
                    }
                }
            } else {
                ms_log.debug((Object)"next: exception ", (Throwable)sqle);
            }
            throw new OraclePropertyGraphException(sqle);
        }
        return lVID;
    }
}

