/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.util.NoSuchElementException;
import oracle.pg.common.CloseableIterator;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.VertexFilterCallback;
import oracle.pg.common.messages.MesgConsts;
import oracle.pg.common.messages.Message;
import oracle.pg.rdbms.OraclePropertyGraph;
import oracle.pg.rdbms.OracleVertex;
import oracle.pg.rdbms.OracleVertexIteratorImpl;

public class OracleVertexFilterIteratorImpl
implements CloseableIterator<OracleVertexBase>,
AutoCloseable,
MesgConsts {
    private OracleVertexIteratorImpl m_vIter = null;
    private VertexFilterCallback m_vfc = null;
    private boolean m_bClosed = false;
    private OracleVertex m_lastVertex = null;
    private boolean m_bUsed = false;
    private OraclePropertyGraphBase.OptimizationFlag m_optFlag;
    private OracleVertex EMPTY_VERTEX = OracleVertex.getEmptyInstance();
    Message MSG_ERR_NO_ELEM_TO_BE_CONSUMED = new Message("ERR_NO_ELEM_TO_BE_CONSUMED");

    OracleVertexFilterIteratorImpl(OracleVertexIteratorImpl iter, VertexFilterCallback vfc, OraclePropertyGraphBase.OptimizationFlag flag) {
        this.m_vIter = iter;
        this.m_vfc = vfc;
        this.m_bClosed = false;
        this.m_bUsed = false;
        this.m_optFlag = flag;
    }

    @Override
    public void close() {
        if (this.m_bClosed) {
            return;
        }
        if (this.m_vIter != null) {
            this.m_vIter.close();
        }
        this.m_vIter = null;
        this.m_bClosed = false;
    }

    public boolean hasNext() {
        if (this.m_bClosed) {
            return false;
        }
        if (!this.m_bUsed && this.m_lastVertex != null) {
            return true;
        }
        if (this.m_vIter == null || !this.m_vIter.hasNext()) {
            this.close();
            return false;
        }
        this.moveCursor();
        return this.m_lastVertex != null;
    }

    protected void moveCursor() {
        this.m_lastVertex = null;
        this.m_bUsed = true;
        if (this.m_vIter == null || !this.m_vIter.hasNext()) {
            this.close();
            return;
        }
        while (this.m_vIter.hasNext()) {
            OracleVertex v = this.m_vIter.next();
            if (this.m_vfc != null && !this.m_vfc.keepVertex((OracleVertexBase)v)) continue;
            this.m_lastVertex = v;
            this.m_bUsed = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleVertex next() {
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException(this.MSG_ERR_NO_ELEM_TO_BE_CONSUMED.toString());
            }
            OracleVertex v = this.m_lastVertex;
            this.m_lastVertex = null;
            this.m_bUsed = true;
            if (this.m_optFlag != null && OraclePropertyGraphBase.OptimizationFlag.DO_NOT_CREATE_OBJECT.equals((Object)this.m_optFlag)) {
                OracleVertex oracleVertex = this.EMPTY_VERTEX;
                return oracleVertex;
            }
            if (this.m_optFlag != null && OraclePropertyGraphBase.OptimizationFlag.JUST_VERTEX_ID.equals((Object)this.m_optFlag)) {
                OracleVertex ov = OracleVertex.getInstance((OraclePropertyGraph)v.graph(), (Long)v.id(), true, this.m_vIter.getSkipStoreToCache());
                ov.setCreatedWithOptFlag(true);
                OracleVertex oracleVertex = ov;
                return oracleVertex;
            }
            OracleVertex oracleVertex = v;
            return oracleVertex;
        }
        finally {
            this.moveCursor();
        }
    }

    public void remove() {
        Message msg = new Message("ERR_NO_OP_SUPPORTED", (Object)"remove");
        throw new UnsupportedOperationException(msg.toString());
    }
}

