/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.pool.OracleDataSource;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OraclePropertyGraphUtilsBase;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.SQLUtils;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.Util;
import oracle.pg.common.messages.Message;
import oracle.pg.rdbms.InternalDS;
import oracle.pg.rdbms.Oracle;
import oracle.pg.rdbms.OracleElementIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraph;
import oracle.pg.rdbms.Parameters;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.sql.TIMESTAMPTZ;
import org.apache.commons.io.IOUtils;

public class OraclePropertyGraphUtils
extends OraclePropertyGraphUtilsBase {
    static SimpleLog ms_log = SimpleLog.getLog(OraclePropertyGraphUtils.class);
    static int TYPE_DT_EMPTY = 0;
    static int TYPE_DT_STRING = 1;
    static int TYPE_DT_INTEGER = 2;
    static int TYPE_DT_FLOAT = 3;
    static int TYPE_DT_DOUBLE = 4;
    static int TYPE_DT_DATE = 5;
    static int TYPE_DT_BOOL = 6;
    static int TYPE_DT_LONG = 7;
    static int TYPE_DT_SHORT = 8;
    static int TYPE_DT_CHAR = 10;
    static int TYPE_DT_BYTE = 9;
    static int TYPE_DT_SERI = 101;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validatePGFlatFiles(String vertexFile, String edgeFile, boolean continueOnError) {
        BufferedInputStream vis = null;
        BufferedInputStream eis = null;
        PrintStream psVertexOutput = null;
        PrintStream psEdgeOutput = null;
        try {
            FileInputStream fisV = new FileInputStream(vertexFile);
            vis = new BufferedInputStream(fisV);
            FileInputStream fisE = new FileInputStream(edgeFile);
            eis = new BufferedInputStream(fisE);
            psVertexOutput = new PrintStream(System.err);
            psEdgeOutput = new PrintStream(System.err);
            OraclePropertyGraphUtils.validateVertexFlatFileSyntax(vis, continueOnError, psVertexOutput);
            OraclePropertyGraphUtils.validateEdgeFlatFileSyntax(eis, continueOnError, psEdgeOutput);
            psVertexOutput.flush();
            psEdgeOutput.flush();
        }
        catch (FileNotFoundException ex) {
            try {
                System.err.println("validatePGFlatFiles: hit FileNotFoundException. " + ex.getMessage());
            }
            catch (Throwable throwable) {
                OraclePropertyGraphUtils.quietlyClose(vis);
                OraclePropertyGraphUtils.quietlyClose(eis);
                OraclePropertyGraphUtils.quietlyClose(psVertexOutput);
                OraclePropertyGraphUtils.quietlyClose(psEdgeOutput);
                throw throwable;
            }
            OraclePropertyGraphUtils.quietlyClose((InputStream)vis);
            OraclePropertyGraphUtils.quietlyClose(eis);
            OraclePropertyGraphUtils.quietlyClose(psVertexOutput);
            OraclePropertyGraphUtils.quietlyClose(psEdgeOutput);
            return;
        }
        OraclePropertyGraphUtils.quietlyClose((InputStream)vis);
        OraclePropertyGraphUtils.quietlyClose((InputStream)eis);
        OraclePropertyGraphUtils.quietlyClose((OutputStream)psVertexOutput);
        OraclePropertyGraphUtils.quietlyClose((OutputStream)psEdgeOutput);
    }

    public static void validateVertexFlatFileSyntax(InputStream is, boolean continueOnError, PrintStream psOutput) {
        try {
            String delimiter = ",";
            String emptyKey = "%20";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            long iLine = 1L;
            String line = null;
            boolean bValidLine = true;
            while ((line = br.readLine()) != null) {
                bValidLine = OraclePropertyGraphUtils.validateVertexLine(iLine, line, delimiter, emptyKey, sdf, psOutput);
                ++iLine;
                if (bValidLine || continueOnError) {
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            psOutput.println("validateVertexFlatFileSyntax: hit IOException. " + ex.getMessage());
            return;
        }
    }

    public static List<String> getGraphNames(Oracle oracle) {
        ArrayList<String> arrayList;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        ArrayList<String> graphNames = new ArrayList<String>();
        try {
            StringBuilder sbQuery = new StringBuilder();
            sbQuery.append("SELECT table_name FROM user_tables where table_name like '%VT$' ").append(" union ").append(" SELECT view_name FROM user_views where view_name like '%VT$' ");
            if (ms_log.isInfoEnabled() && Parameters.getInstance().showProgress()) {
                ms_log.info((Object)"getGraphNames: query ", (Object)sbQuery.toString());
            }
            if ((rs = (stmt = oracle.getConnection().prepareStatement(sbQuery.toString())).executeQuery()) != null) {
                ms_log.debug((Object)"getGraphNames: exists graphs, get list of names");
                while (rs.next()) {
                    String szGraphName = rs.getString(1);
                    int len = szGraphName.length();
                    if (len > 3) {
                        szGraphName = szGraphName.substring(0, len - 3);
                    }
                    if (graphNames.contains(szGraphName)) continue;
                    if (ms_bDebug) {
                        ms_log.debug((Object)"getGraphNames: add to list, graph name ", (Object)szGraphName);
                    }
                    graphNames.add(szGraphName);
                }
            }
            arrayList = graphNames;
        }
        catch (SQLException sqle) {
            try {
                throw new OraclePropertyGraphException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
        return arrayList;
    }

    public static void renameGraph(Oracle oracle, String graphName, String newGraphName) throws IOException, Exception {
        OraclePropertyGraphUtils.renameGraph(oracle, graphName, newGraphName, true, "");
    }

    public static void renameGraph(Oracle oracle, String graphName, String newGraphName, boolean nologging, String szOptions) throws IOException, Exception {
        ms_log.debug((Object)"renameGraph: start");
        OraclePropertyGraph opg = null;
        CallableStatement cs = null;
        try {
            if (OraclePropertyGraphUtils.existsGraph(oracle, newGraphName)) {
                opg = OraclePropertyGraph.getInstance(oracle, newGraphName);
                if (!opg.isEmpty()) {
                    opg.close();
                    Message msg = new Message("ERR_PG_NOT_EMPTY", (Object)newGraphName);
                    throw new OraclePropertyGraphException(msg.toString());
                }
                opg.close();
                Message msg = new Message("ERR_PG_ALREADY_EXISTS", (Object)newGraphName);
                throw new OraclePropertyGraphException(msg.toString());
            }
            cs = oracle.getConnection().prepareCall("begin opg_apis.rename_pg(:1, :2); end;");
            cs.setString(1, graphName);
            cs.setString(2, newGraphName);
            cs.execute();
            oracle.commitTransaction();
        }
        catch (SQLException sqle) {
            try {
                ms_log.error((Object)"clearPropertyGraph: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    public static void copyGraph(Oracle oracle, String graphName, String newGraphName) throws IOException, Exception {
        OraclePropertyGraphUtils.copyGraph(oracle, graphName, newGraphName, Parameters.getInstance().getDOP());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyGraph(Oracle oracle, String graphName, String newGraphName, int dop) throws IOException, Exception {
        ms_log.debug((Object)"copyGraph: start");
        OraclePropertyGraph opg = null;
        Object csV = null;
        if (OraclePropertyGraphUtils.existsGraph(oracle, newGraphName)) {
            opg = OraclePropertyGraph.getInstance(oracle, newGraphName);
            if (!opg.isEmpty()) {
                opg.close();
                Message msg = new Message("ERR_PG_NOT_EMPTY", (Object)newGraphName);
                throw new OraclePropertyGraphException(msg.toString());
            }
            Message msg = new Message("ERR_PG_ALREADY_EXISTS", (Object)newGraphName);
            throw new OraclePropertyGraphException(msg.toString());
        }
        try (OraclePropertyGraph opgCopy = null;){
            opgCopy = OraclePropertyGraph.getInstance(oracle, newGraphName);
            OraclePropertyGraphUtils.copyDataFromSourceTableIntoDestTable((Connection)oracle.getConnection(), opgCopy.getVertexTabName(), OraclePropertyGraph.getVertexTabName(oracle, graphName), dop);
            OraclePropertyGraphUtils.copyDataFromSourceTableIntoDestTable((Connection)oracle.getConnection(), opgCopy.getEdgeTabName(), OraclePropertyGraph.getEdgeTabName(oracle, graphName), dop);
            if (!opgCopy.isFeatureSupported(SQLUtils.DbFeature.DISTINCT_PG_TABLES)) {
                OraclePropertyGraphUtils.copyDataFromSourceTableIntoDestTable((Connection)oracle.getConnection(), opgCopy.getSkeletonTabName(), OraclePropertyGraph.getSkeletonTabName(oracle, graphName), dop);
            }
            OraclePropertyGraphUtils.copyDataFromSourceTableIntoDestTable((Connection)oracle.getConnection(), opgCopy.getTextIndexTabName(), OraclePropertyGraph.getTextIndexTabName(oracle, graphName), dop);
            OraclePropertyGraphUtils.copyDataFromSourceTableIntoDestTable((Connection)oracle.getConnection(), opgCopy.getSnapshotTabName(), OraclePropertyGraph.getSnapshotTabName(oracle, graphName), dop);
        }
    }

    private static void copyDataFromSourceTableIntoDestTable(Connection connection, String destTable, String sourceTable, int dop) {
        try {
            StringBuilder sbCopyTable = new StringBuilder();
            sbCopyTable.append(" insert /*+ append parallel(").append(dop).append(") */ into ").append(destTable).append(" select * from ").append(Util.enquoteNameSQLName((Connection)connection, (String)sourceTable));
            try (CallableStatement cs = connection.prepareCall(sbCopyTable.toString());){
                ms_log.debug((Object)"copyDataFromSourceTableIntoDestTable: executed with stmt ", (Object)sbCopyTable.toString());
                cs.execute();
            }
            connection.commit();
        }
        catch (SQLException sqle) {
            ms_log.error((Object)"copyGraph: ", (Throwable)sqle);
            throw new OraclePropertyGraphException((Throwable)sqle);
        }
    }

    public static void validateEdgeFlatFileSyntax(InputStream is, boolean continueOnError, PrintStream psOutput) {
        try {
            String delimiter = ",";
            String emptyKey = "%20";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            long iLine = 1L;
            String line = null;
            boolean bValidLine = true;
            while ((line = br.readLine()) != null) {
                bValidLine = OraclePropertyGraphUtils.validateEdgeLine(iLine, line, delimiter, emptyKey, sdf, psOutput);
                ++iLine;
                if (bValidLine || continueOnError) {
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            psOutput.println("validateEdgeFlatFileSyntax: hit IOException. " + ex.getMessage());
            return;
        }
    }

    private static boolean validateVertexLine(long iLine, String line, String delimiter, String emptyKey, SimpleDateFormat sdf, PrintStream psOutput) {
        boolean bValid = true;
        String[] saFields = line.split(delimiter, -1);
        if (saFields.length != 6) {
            psOutput.println("validateVertexLine: line " + iLine + ", invalid number of fields, should be 6");
            bValid = false;
        }
        try {
            Long.parseLong(saFields[0]);
        }
        catch (NumberFormatException ex) {
            psOutput.println("validateVertexLine: line " + iLine + ", vid => [" + saFields[0] + "], invalid long value");
            bValid = false;
        }
        boolean bValidKV = OraclePropertyGraphUtils.validateKeyValues(iLine, 0, saFields, emptyKey, sdf, psOutput);
        bValid = bValid && bValidKV;
        return bValid;
    }

    private static boolean validateEdgeLine(long iLine, String line, String delimiter, String emptyKey, SimpleDateFormat sdf, PrintStream psOutput) {
        boolean bValid = true;
        String[] saFields = line.split(delimiter, -1);
        if (saFields.length != 9) {
            psOutput.println("validateEdgeLine: line " + iLine + ", invalid number of fields, should be 9");
            bValid = false;
        }
        try {
            Long.parseLong(saFields[0]);
        }
        catch (NumberFormatException ex) {
            psOutput.println("validateEdgeLine: line " + iLine + ", eid => [" + saFields[0] + "], invalid long value");
            bValid = false;
        }
        try {
            Long.parseLong(saFields[1]);
        }
        catch (NumberFormatException ex) {
            psOutput.println("validateEdgeLine: line " + iLine + ", svid => [" + saFields[1] + "], invalid long value");
            bValid = false;
        }
        try {
            Long.parseLong(saFields[2]);
        }
        catch (NumberFormatException ex) {
            psOutput.println("validateEdgeLine: line " + iLine + ", dvid => [" + saFields[2] + "], invalid long value");
            bValid = false;
        }
        boolean bValidKV = OraclePropertyGraphUtils.validateKeyValues(iLine, 3, saFields, emptyKey, sdf, psOutput);
        bValid = bValid && bValidKV;
        return bValid;
    }

    private static boolean validateKeyValues(long iLine, int fieldIdx, String[] saFields, String emptyKey, SimpleDateFormat sdf, PrintStream psOutput) {
        boolean bValid = true;
        if (!saFields[fieldIdx + 1].isEmpty() && !saFields[fieldIdx + 1].equals(emptyKey)) {
            int t = 0;
            try {
                t = Integer.parseInt(saFields[fieldIdx + 2]);
            }
            catch (NumberFormatException ex) {
                psOutput.println("validateKeyValues: line " + iLine + ", t => [" + saFields[fieldIdx + 2] + "], invalid integer value");
                bValid = false;
            }
            if (t == TYPE_DT_STRING) {
                if (!saFields[fieldIdx + 4].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vn => [" + saFields[fieldIdx + 4] + "], invalid value, should be null");
                    bValid = false;
                }
                if (!saFields[fieldIdx + 5].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vt => [" + saFields[fieldIdx + 5] + "], invalid value, should be null");
                    bValid = false;
                }
            } else if (t == TYPE_DT_INTEGER) {
                if (!saFields[fieldIdx + 3].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", v => [" + saFields[fieldIdx + 3] + "], invalid value, should be null");
                    bValid = false;
                }
                try {
                    Integer.parseInt(saFields[fieldIdx + 4]);
                }
                catch (NumberFormatException ex) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vn => [" + saFields[fieldIdx + 4] + "], invalid integer value");
                    bValid = false;
                }
                if (!saFields[fieldIdx + 5].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vt => [" + saFields[fieldIdx + 5] + "], invalid value, should be null");
                    bValid = false;
                }
            } else if (t == TYPE_DT_FLOAT) {
                if (!saFields[fieldIdx + 3].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", v => [" + saFields[fieldIdx + 3] + "], invalid value, should be null");
                    bValid = false;
                }
                try {
                    Float.parseFloat(saFields[fieldIdx + 4]);
                }
                catch (NumberFormatException ex) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vn => [" + saFields[fieldIdx + 4] + "], invalid float value");
                    bValid = false;
                }
                if (!saFields[fieldIdx + 5].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vt => [" + saFields[fieldIdx + 5] + "], invalid value, should be null");
                    bValid = false;
                }
            } else if (t == TYPE_DT_DOUBLE) {
                if (!saFields[fieldIdx + 3].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", v => [" + saFields[fieldIdx + 3] + "], invalid value, should be null");
                    bValid = false;
                }
                try {
                    Double.parseDouble(Parameters.checkInput(saFields[fieldIdx + 4]));
                }
                catch (NumberFormatException ex) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vn => [" + saFields[fieldIdx + 4] + "], invalid double value");
                    bValid = false;
                }
                if (!saFields[fieldIdx + 5].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vt => [" + saFields[fieldIdx + 5] + "], invalid value, should be null");
                    bValid = false;
                }
            } else if (t == TYPE_DT_LONG) {
                if (!saFields[fieldIdx + 3].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", v => [" + saFields[fieldIdx + 3] + "], invalid value, should be null");
                    bValid = false;
                }
                try {
                    Long.parseLong(saFields[fieldIdx + 4]);
                }
                catch (NumberFormatException ex) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vn => [" + saFields[fieldIdx + 4] + "], invalid long value");
                    bValid = false;
                }
                if (!saFields[fieldIdx + 5].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vt => [" + saFields[fieldIdx + 5] + "], invalid value, should be null");
                    bValid = false;
                }
            } else if (t == TYPE_DT_SHORT) {
                if (!saFields[fieldIdx + 3].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", v => [" + saFields[fieldIdx + 3] + "], invalid value, should be null");
                    bValid = false;
                }
                try {
                    Short.parseShort(saFields[fieldIdx + 4]);
                }
                catch (NumberFormatException ex) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vn => [" + saFields[fieldIdx + 4] + "], invalid short value");
                    bValid = false;
                }
                if (!saFields[fieldIdx + 5].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vt => [" + saFields[fieldIdx + 5] + "], invalid value, should be null");
                    bValid = false;
                }
            } else if (t == TYPE_DT_BYTE) {
                if (!saFields[fieldIdx + 3].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", v => [" + saFields[fieldIdx + 3] + "], invalid value, should be null");
                    bValid = false;
                }
                try {
                    Byte.parseByte(saFields[fieldIdx + 4]);
                }
                catch (NumberFormatException ex) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vn => [" + saFields[fieldIdx + 4] + "], invalid byte value");
                    bValid = false;
                }
                if (!saFields[fieldIdx + 5].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vt => [" + saFields[fieldIdx + 5] + "], invalid value, should be null");
                    bValid = false;
                }
            } else if (t == TYPE_DT_CHAR) {
                if (!saFields[fieldIdx + 4].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vn => [" + saFields[fieldIdx + 4] + "], invalid value, should be null");
                    bValid = false;
                }
                if (!saFields[fieldIdx + 5].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vt => [" + saFields[fieldIdx + 5] + "], invalid value, should be null");
                    bValid = false;
                }
            } else if (t == TYPE_DT_DATE) {
                if (!saFields[fieldIdx + 3].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", v => [" + saFields[fieldIdx + 3] + "], invalid value, should be null");
                    bValid = false;
                }
                if (!saFields[fieldIdx + 4].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vn => [" + saFields[fieldIdx + 4] + "], invalid value, should be null");
                    bValid = false;
                }
                try {
                    Date ex = new Date(sdf.parse(saFields[fieldIdx + 5]).getTime());
                }
                catch (Exception ex) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vt => [" + saFields[fieldIdx + 5] + "], invalid value, should be in the form of [" + sdf.toPattern() + "]");
                    bValid = false;
                }
            } else if (t == TYPE_DT_BOOL) {
                if (!saFields[fieldIdx + 3].equalsIgnoreCase("Y") && !saFields[fieldIdx + 3].equalsIgnoreCase("N")) {
                    psOutput.println("validateKeyValues: line " + iLine + ", v => [" + saFields[fieldIdx + 3] + "], invalid bool value, should be Y/y or N/n");
                }
                if (!saFields[fieldIdx + 4].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vn => [" + saFields[fieldIdx + 4] + "], invalid value, should be null");
                    bValid = false;
                }
                if (!saFields[fieldIdx + 5].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vt => [" + saFields[fieldIdx + 5] + "], invalid value, should be null");
                    bValid = false;
                }
            } else if (t == TYPE_DT_SERI) {
                if (!saFields[fieldIdx + 4].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vn => [" + saFields[fieldIdx + 4] + "], invalid value, should be null");
                    bValid = false;
                }
                if (!saFields[fieldIdx + 5].isEmpty()) {
                    psOutput.println("validateKeyValues: line " + iLine + ", vt => [" + saFields[fieldIdx + 5] + "], invalid value, should be null");
                    bValid = false;
                }
            } else {
                psOutput.println("validateKeyValues: line " + iLine + ", t => [" + saFields[fieldIdx + 2] + "], invalid value, should be 1, 2, 3, 4, 5, 6, 101");
                bValid = false;
            }
        } else {
            if (!saFields[fieldIdx + 2].isEmpty()) {
                psOutput.println("validateKeyValues: line " + iLine + ", t => [" + saFields[fieldIdx + 2] + "], invalid value, should be null");
                bValid = false;
            }
            if (!saFields[fieldIdx + 3].isEmpty()) {
                psOutput.println("validateKeyValues: line " + iLine + ", v => [" + saFields[fieldIdx + 3] + "], invalid value, should be null");
                bValid = false;
            }
            if (!saFields[fieldIdx + 4].isEmpty()) {
                psOutput.println("validateKeyValues: line " + iLine + ", vn => [" + saFields[fieldIdx + 4] + "], invalid value, should be null");
                bValid = false;
            }
            if (!saFields[fieldIdx + 5].isEmpty()) {
                psOutput.println("validateKeyValues: line " + iLine + ", vt => [" + saFields[fieldIdx + 5] + "], invalid value, should be null");
                bValid = false;
            }
        }
        return bValid;
    }

    /*
     * Exception decompiling
     */
    public static boolean existsGraph(Oracle conn, String graphName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void dropPropertyGraphTables(Oracle oracle, String szGraphName) throws SQLException {
        ms_log.debug((Object)"dropPropertyGraphTables: start");
        try (CallableStatement cs = oracle.getConnection().prepareCall("begin opg_apis.drop_pg(:1); end;");){
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"dropPropertyGraph: execute opg_apis.drop_pg with graph name", (Object)szGraphName);
            }
            cs.setString(1, szGraphName);
            cs.execute();
            oracle.commitTransaction();
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 942) {
                ms_log.debug((Object)"dropPropertyGraphTables: Table does not exists. ", (Throwable)sqle);
            }
            throw new OraclePropertyGraphException((Throwable)sqle);
        }
        ms_log.debug((Object)"dropPropertyGraphTables: done");
    }

    public static void dropPropertyGraph(Oracle oracle, String szGraphName) throws SQLException {
        ms_log.debug((Object)"dropPropertyGraph: start");
        if (OraclePropertyGraphUtils.existsGraph(oracle, szGraphName)) {
            ms_log.debug((Object)"dropPropertyGraph: delete tables");
            OraclePropertyGraphUtils.dropPropertyGraphTables(oracle, szGraphName);
        }
        ms_log.debug((Object)"dropPropertyGraph: done");
    }

    public static void clearPropertyGraph(Oracle oracle, String szGraphName) throws SQLException {
        ms_log.debug((Object)"clearPropertyGraph: start");
        CallableStatement cs = null;
        try {
            cs = oracle.getConnection().prepareCall("begin opg_apis.clear_pg(:1); end;");
            cs.setString(1, szGraphName);
            cs.execute();
        }
        catch (SQLException sqle) {
            try {
                ms_log.error((Object)"clearPropertyGraph: ", (Throwable)sqle);
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
        ms_log.debug((Object)"clearPropertyGraph: done");
    }

    public static void exportFlatFiles(String jdbcUrl, String user, String password, String propertyGraphName, String vertexFileName, String edgeFileName) throws SQLException, IOException, FileNotFoundException {
        Oracle oracle = new Oracle(jdbcUrl, user, password);
        OraclePropertyGraph pg = OraclePropertyGraph.getInstance(oracle, propertyGraphName);
        OraclePropertyGraphUtils.exportFlatFiles((OraclePropertyGraphBase)pg, (String)vertexFileName, (String)edgeFileName, (boolean)false);
        pg.close();
        oracle.dispose();
    }

    public static void cloneGraph(Connection conn, String szOrgGraphName, String szNewGraphName, int iDOP, int iNumSubPtns, String szTBS, String szOptions) throws SQLException {
        ms_log.debug((Object)"cloneGraph: start");
        if (conn == null) {
            throw new IllegalArgumentException("connection MUST not be null");
        }
        if (szOrgGraphName == null) {
            throw new IllegalArgumentException("orginal graph name MUST not be null");
        }
        if (szNewGraphName == null) {
            throw new IllegalArgumentException("new graph name MUST not be null");
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)("cloneGraph: with dop  " + iDOP + " szOrgGraphName " + szOrgGraphName + ", szNewGraphName " + szNewGraphName + " , iNumSubPtns " + iNumSubPtns + ", szTBS " + szTBS + ", szOptions = " + szOptions));
        }
        CallableStatement cs = null;
        try {
            cs = conn.prepareCall("begin opg_apis.clone_graph(:1, :2, :3, :4, :5, :6); end;");
            int idx = 1;
            cs.setString(idx++, szOrgGraphName);
            cs.setString(idx++, szNewGraphName);
            cs.setInt(idx++, iDOP);
            cs.setInt(idx++, iNumSubPtns);
            cs.setString(idx++, szTBS);
            cs.setString(idx++, szOptions);
            cs.execute();
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            ms_log.debug((Object)"cloneGraph: done");
            OracleElementIteratorImpl.quietlyCloseStmt(cs);
        }
    }

    public static final void exportFlatFiles(OraclePropertyGraph pg, OutputStream osVertex, OutputStream osEdge, int dop, boolean append) throws IOException, FileNotFoundException {
        OraclePropertyGraphUtils.exportFlatFiles(pg, osVertex, osEdge, dop, append, true);
    }

    public static void exportFlatFiles(OraclePropertyGraph pg, OutputStream osVertex, OutputStream osEdge, int dop, boolean append, boolean closeStreams) throws IOException, FileNotFoundException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"exportFlatFiles: start");
        }
        OraclePropertyGraphUtils.exportVertexFlatFile((OraclePropertyGraphBase)pg, (OutputStream)osVertex, (int)dop, (boolean)append, (boolean)closeStreams);
        OraclePropertyGraphUtils.exportEdgeFlatFile((OraclePropertyGraphBase)pg, (OutputStream)osEdge, (int)dop, (boolean)append, (boolean)closeStreams);
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"exportFlatFiles: end");
        }
    }

    public static void quietlyCloseConnections(Oracle[] oracleArray, Connection[] connections) {
        int idx;
        ms_log.debug((Object)"quietlyCloseConnections: starts");
        if (oracleArray != null && oracleArray.length > 0) {
            for (idx = 0; idx < oracleArray.length; ++idx) {
                if (oracleArray[idx] == null) continue;
                if (ms_bDebug) {
                    ms_log.debug((Object)"quietlyCloseConnections: closing connection connection ", (Object)idx);
                }
                try {
                    oracleArray[idx].dispose();
                    continue;
                }
                catch (Throwable t) {
                    ms_log.error((Object)"quietlyCloseConnections: connection cannot be closed. Exception is", t);
                }
            }
            oracleArray = null;
        }
        if (connections != null && connections.length > 0) {
            for (idx = 0; idx < connections.length; ++idx) {
                if (connections[idx] == null) continue;
                if (ms_bDebug) {
                    ms_log.debug((Object)"quietlyCloseConnections: closing connection connection ", (Object)idx);
                }
                try {
                    if (connections[idx].isClosed()) continue;
                    connections[idx].close();
                    continue;
                }
                catch (Throwable t) {
                    ms_log.error((Object)"quietlyCloseConnections: connection cannot be closed. Exception is", t);
                }
            }
            connections = null;
        }
        ms_log.debug((Object)"quietlyCloseConnections: done");
    }

    public static boolean checkSnapshotTableExist(String szGraphName, String tableOwner, Connection conn) throws SQLException {
        return OraclePropertyGraphUtils.existsTable(szGraphName + "SS$", tableOwner, conn);
    }

    public static boolean checkSnapshotExist(String szGraphName, String tableOwner, Connection conn, long lSnapshotID) throws SQLException {
        boolean bl;
        ResultSet rs;
        CallableStatement stmt;
        block7: {
            ms_log.debug((Object)"checkSnapshotExist: started");
            StringBuffer sb = new StringBuffer();
            String szTableName = szGraphName + "SS$";
            String enquotedTableName = Util.enquoteNameSQLName((Connection)conn, (String)szTableName);
            if (tableOwner != null) {
                enquotedTableName = Util.enquoteNameSQLName((Connection)conn, (String)tableOwner) + "." + enquotedTableName;
            }
            String szQuery = sb.append(" select SSID from ").append(enquotedTableName).append(" where SSID = ? ").toString();
            if (ms_bDebug) {
                ms_log.debug((Object)"checkSnapshotExist: execute statement ", (Object)szQuery);
            }
            stmt = null;
            rs = null;
            stmt = conn.prepareCall(szQuery);
            stmt.setLong(1, lSnapshotID);
            rs = stmt.executeQuery();
            if (rs != null && rs.next()) break block7;
            boolean bl2 = false;
            ms_log.debug((Object)"checkSnapshotExist: close statement and result set ");
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (Exception e) {
            try {
                throw new OraclePropertyGraphException((Throwable)e);
            }
            catch (Throwable throwable) {
                ms_log.debug((Object)"checkSnapshotExist: close statement and result set ");
                OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                throw throwable;
            }
        }
        ms_log.debug((Object)"checkSnapshotExist: close statement and result set ");
        OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
        return bl;
    }

    public static void storeBinaryInMemGraphSnapshot(String szGraphName, String tableOwner, Connection conn, InputStream is, long lSnapshotID, int dop) throws OraclePropertyGraphException {
        java.util.Date currentTime = new java.util.Date();
        OraclePropertyGraphUtils.storeBinaryInMemGraphSnapshot(szGraphName, tableOwner, conn, is, lSnapshotID, currentTime.getTime(), dop);
    }

    public static void storeBinaryInMemGraphSnapshot(String szGraphName, String tableOwner, Connection conn, InputStream is, long lSnapshotID, long lTimestamp, int dop) throws OraclePropertyGraphException {
        PreparedStatement stmt = null;
        try {
            String szTableName = szGraphName + "SS$";
            String enquotedTableName = Util.enquoteNameSQLName((Connection)conn, (String)szTableName);
            String enquotedTableOwner = Util.enquoteNameSQLName((Connection)conn, (String)tableOwner);
            if (!OraclePropertyGraphUtils.existsTable(szTableName, tableOwner, conn)) {
                OraclePropertyGraphUtils.createSnapshotTable(szGraphName, tableOwner, conn, dop, "", "", true);
            }
            if (tableOwner != null) {
                enquotedTableName = Util.enquoteNameSQLName((Connection)conn, (String)tableOwner) + "." + enquotedTableName;
            }
            ms_log.debug((Object)"storeBinaryInMemGraphSnapshot: started");
            StringBuffer sb = new StringBuffer();
            String szInsert = sb.append("declare b blob; begin b:=?; merge into ").append(enquotedTableName).append(" using dual on (ssid=?) ").append(" when not matched then insert (SSID, CONTENTS, TS) values ( ?, b, ? )").append(" when     matched then update set CONTENTS=b, TS=?; end; ").toString();
            if (ms_bDebug) {
                ms_log.debug((Object)"storeBinaryInMemGraphSnapshot: execute statement ", (Object)szInsert);
            }
            Timestamp ts = new Timestamp(lTimestamp);
            stmt = conn.prepareStatement(szInsert);
            stmt.setBinaryStream(1, is);
            stmt.setLong(2, lSnapshotID);
            stmt.setLong(3, lSnapshotID);
            stmt.setTimestamp(4, ts);
            stmt.setTimestamp(5, ts);
            stmt.execute();
        }
        catch (Exception e) {
            try {
                throw new OraclePropertyGraphException((Throwable)e);
            }
            catch (Throwable throwable) {
                ms_log.debug((Object)"storeBinaryInMemGraphSnapshot: close statement");
                OracleElementIteratorImpl.quietlyCloseStmt(stmt);
                throw throwable;
            }
        }
        ms_log.debug((Object)"storeBinaryInMemGraphSnapshot: close statement");
        OracleElementIteratorImpl.quietlyCloseStmt(stmt);
    }

    public static void readBinaryInMemGraphSnapshot(String szGraphName, String tableOwner, Connection conn, OutputStream[] os, long lSnapshotID, int dop) throws OraclePropertyGraphException, SQLException {
        ms_log.debug((Object)"readBinaryInMemGraphSnapshot: started");
        StringBuffer sb = new StringBuffer();
        String szTableName = szGraphName + "SS$";
        String enquotedTableName = Util.enquoteNameSQLName((Connection)conn, (String)szTableName);
        if (tableOwner != null) {
            enquotedTableName = Util.enquoteNameSQLName((Connection)conn, (String)tableOwner) + "." + enquotedTableName;
        }
        String szQuery = sb.append(" select CONTENTS from ").append(enquotedTableName).append(" where SSID = ? ").toString();
        if (ms_bDebug) {
            ms_log.debug((Object)"readBinaryInMemGraphSnapshot: execute statement ", (Object)szQuery);
        }
        CallableStatement stmt = null;
        ResultSet rs = null;
        InputStream is = null;
        try {
            stmt = conn.prepareCall(szQuery);
            stmt.setLong(1, lSnapshotID);
            rs = stmt.executeQuery();
            if (rs == null || !rs.next()) {
                throw new OraclePropertyGraphException("No entry for snapshot ID " + lSnapshotID + "] in graph " + szGraphName);
            }
            Blob blob = rs.getBlob(1);
            is = blob.getBinaryStream();
            IOUtils.copy((InputStream)is, (OutputStream)os[0]);
            os[0].flush();
        }
        catch (Exception e) {
            try {
                throw new OraclePropertyGraphException((Throwable)e);
            }
            catch (Throwable throwable) {
                OraclePropertyGraphUtils.quietlyClose(is);
                ms_log.debug((Object)"readBinaryInMemGraphSnapshot: close statement and result set ");
                OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                throw throwable;
            }
        }
        OraclePropertyGraphUtils.quietlyClose((InputStream)is);
        ms_log.debug((Object)"readBinaryInMemGraphSnapshot: close statement and result set ");
        OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void createSnapshotTable(String szGraphName, String tableOwner, Connection conn, int dop, String options, String tablespace, boolean nologging) throws SQLException {
        block9: {
            CallableStatement cs = null;
            try {
                cs = conn.prepareCall("begin opg_apis.create_pg_snapshot_tab(:1, :2, :3, :4, :5); end;");
                cs.setString(1, tableOwner);
                cs.setString(2, szGraphName);
                cs.setInt(3, dop);
                cs.setString(4, tablespace);
                if (nologging) {
                    cs.setString(5, options);
                } else {
                    cs.setString(5, ",NOLOGGING=F," + options);
                }
                cs.execute();
            }
            catch (SQLException sqle) {
                if (sqle.getErrorCode() == 910) {
                    ms_log.error((Object)"createSnapshotTable: Please enable 32K maximum length support to avoid the following error. ", (Throwable)sqle);
                    break block9;
                }
                if (sqle.getErrorCode() == 1031) {
                    ms_log.debug((Object)"createSnapshotTable: ", (Throwable)sqle);
                    break block9;
                }
                ms_log.error((Object)"createSnapshotTable: ", (Throwable)sqle);
                throw sqle;
            }
            finally {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
            }
        }
    }

    private static boolean existsTable(String tableName, String tableOwner, Connection conn) {
        boolean bl;
        CallableStatement stmt;
        ResultSet rs;
        block13: {
            block11: {
                boolean bl2;
                block12: {
                    rs = null;
                    stmt = null;
                    String szQuery = "select table_name from all_tables where table_name = ? and owner=?";
                    if (ms_bDebug) {
                        ms_log.debug((Object)("existsTable: prepare callable statement " + szQuery), (Object)(" for table " + tableName));
                    }
                    stmt = conn.prepareCall(szQuery);
                    stmt.setString(1, tableName.toUpperCase());
                    stmt.setString(2, tableOwner.toUpperCase());
                    if (ms_bDebug) {
                        ms_log.debug((Object)"existsTable: execute query");
                    }
                    if ((rs = stmt.executeQuery()) == null || !rs.next()) break block11;
                    if (ms_bDebug) {
                        ms_log.debug((Object)"existsTable: table exists, return true");
                    }
                    bl2 = true;
                    if (!ms_bDebug) break block12;
                    ms_log.debug((Object)"existsTable: done .................... ");
                }
                OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                return bl2;
            }
            try {
                if (ms_bDebug) {
                    ms_log.debug((Object)"existsTable: table not defined in the database, ", (Object)"return false");
                }
                bl = false;
                if (!ms_bDebug) break block13;
            }
            catch (SQLException e) {
                try {
                    if (ms_bDebug) {
                        ms_log.error((Object)"existsTable: SQL Statement cannot be executed, Exception is ", (Throwable)e);
                    }
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                    throw new OraclePropertyGraphException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (ms_bDebug) {
                        ms_log.debug((Object)"existsTable: done .................... ");
                    }
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                    throw throwable;
                }
            }
            ms_log.debug((Object)"existsTable: done .................... ");
        }
        OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
        return bl;
    }

    public static boolean hasTable(Connection conn, String tableName, String tableOwner) {
        return OraclePropertyGraphUtils.existsTable(tableName, tableOwner, conn);
    }

    public static void dropTable(Connection conn, String owner, String tableName) throws SQLException {
        if (tableName == null) {
            return;
        }
        CallableStatement cs = null;
        try {
            StringBuilder sb = new StringBuilder("drop table ");
            sb.append(Util.enquoteNameSQLName((Connection)conn, (String)owner)).append(".").append(Util.enquoteNameSQLName((Connection)conn, (String)tableName));
            cs = conn.prepareCall(sb.toString());
            cs.execute();
        }
        catch (SQLException sqle) {
            try {
                if (sqle.getErrorCode() == 942 && ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"dropTable: hit ORA_TABLE_OR_VIEW_DOES_NOT_EXIST exception. Continue");
                }
                if (sqle.getErrorCode() == 910) {
                    ms_log.error((Object)"dropTable: Please enable 32K maximum length support to avoid the following error. ", (Throwable)sqle);
                    throw sqle;
                }
                if (sqle.getErrorCode() == 1031) {
                    ms_log.debug((Object)"dropTable: ", (Throwable)sqle);
                    throw sqle;
                }
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"dropTable: hit SQLException.");
                }
                throw sqle;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    public static void dropTable(Connection conn, String tableName) throws SQLException {
        if (tableName == null) {
            return;
        }
        CallableStatement cs = null;
        try {
            cs = conn.prepareCall("begin opg_apis.truncate_and_drop_ignore(:1, :2); end;");
            cs.setString(1, tableName);
            cs.setLong(2, 942L);
            cs.execute();
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 942 && ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"dropTable: hit ORA_TABLE_OR_VIEW_DOES_NOT_EXIST exception. Continue");
            }
            if (sqle.getErrorCode() == 910) {
                ms_log.error((Object)"dropTable: Please enable 32K maximum length support to avoid the following error. ", (Throwable)sqle);
                throw sqle;
            }
            if (sqle.getErrorCode() == 1031) {
                ms_log.debug((Object)"dropTable: ", (Throwable)sqle);
                throw sqle;
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"dropTable: hit SQLException.");
            }
            throw sqle;
        }
        finally {
            OracleElementIteratorImpl.quietlyCloseStmt(cs);
        }
    }

    public static PropertyType idTypeAsPropertyType(IdType type) {
        if (IdType.INTEGER.equals((Object)type)) {
            return PropertyType.INTEGER;
        }
        if (IdType.STRING.equals((Object)type)) {
            return PropertyType.STRING;
        }
        return PropertyType.LONG;
    }

    private static Object getValueBasedOnPropertyType(PropertyType type, Object value) {
        if (PropertyType.STRING.equals((Object)type)) {
            return (String)value;
        }
        if (PropertyType.INTEGER.equals((Object)type)) {
            return (Integer)value;
        }
        if (PropertyType.LONG.equals((Object)type)) {
            return (Long)value;
        }
        if (PropertyType.FLOAT.equals((Object)type)) {
            return (Float)value;
        }
        if (PropertyType.DOUBLE.equals((Object)type)) {
            return (Double)value;
        }
        if (PropertyType.TIMESTAMP.equals((Object)type)) {
            return (Timestamp)value;
        }
        if (PropertyType.TIMESTAMP_WITH_TIMEZONE.equals((Object)type)) {
            return (TIMESTAMPTZ)value;
        }
        if (PropertyType.BOOLEAN.equals((Object)type)) {
            return (Boolean)value;
        }
        throw new OraclePropertyGraphException("Storing properties of type " + type + " in a database table not supported");
    }

    private static void setArgumentForStmt(OraclePreparedStatement stmt, int idx, Object val) throws SQLException {
        if (val == null) {
            stmt.setString(idx, (String)null);
        }
        if (val instanceof String) {
            ms_log.debug((Object)"setArgumentForStmt: TYPE_DT_STRING");
            stmt.setString(idx, (String)val);
            stmt.setFormOfUse(idx, (short)2);
        } else if (val instanceof Float) {
            ms_log.debug((Object)"setArgumentForStmt: TYPE_DT_FLOAT");
            stmt.setFloat(idx, ((Float)val).floatValue());
        } else if (val instanceof Integer) {
            ms_log.debug((Object)"setArgumentForStmt: TYPE_DT_INTEGER");
            stmt.setInt(idx, ((Integer)val).intValue());
        } else if (val instanceof Double) {
            ms_log.debug((Object)"setArgumentForStmt: TYPE_DT_DOUBLE");
            stmt.setDouble(idx, ((Double)val).doubleValue());
        } else if (val instanceof Long) {
            ms_log.debug((Object)"setArgumentForStmt: TYPE_DT_LONG");
            stmt.setLong(idx, ((Long)val).longValue());
        } else if (val instanceof Boolean) {
            ms_log.debug((Object)"setArgumentForStmt: TYPE_DT_BOOL");
            stmt.setString(idx, (Boolean)val != false ? "Y" : "N");
        } else if (val instanceof java.util.Date) {
            ms_log.debug((Object)"setArgumentForStmt: TYPE_DT_DATE");
            stmt.setDate(idx, new Date(((java.util.Date)val).getTime()));
        } else if (val instanceof Timestamp) {
            ms_log.debug((Object)"setArgumentForStmt: TYPE_DT_TIMESTAMP");
            stmt.setObject(idx, (Object)((Timestamp)val));
        } else if (val instanceof LocalDateTime) {
            ms_log.debug((Object)"setArgumentForStmt: TYPE_DT_TIMESTAMP");
            stmt.setObject(idx, (Object)((LocalDateTime)val));
        } else if (val instanceof OffsetDateTime) {
            ms_log.debug((Object)"setArgumentForStmt: TYPE_DT_TIMESTAMP");
            stmt.setObject(idx, (Object)((OffsetDateTime)val));
        } else if (val instanceof Timestamp) {
            ms_log.debug((Object)"setArgumentForStmt: TYPE_DT_TIMESTAMP");
            stmt.setTimestamp(idx, (Timestamp)val);
        } else if (val instanceof TIMESTAMPTZ) {
            ms_log.debug((Object)"setArgumentForStmt: TYPE_DT_TIMESTAMPTZ");
            stmt.setTimestamp(idx, ((TIMESTAMPTZ)val).timestampValue(stmt.getConnection()));
        } else {
            throw new OraclePropertyGraphException("setArgumentForStmt:   unsupported type. " + val.getClass().getName());
        }
    }

    public static DataSource getDataSource(String dsName) throws SQLException, NamingException {
        ms_log.debug((Object)"getDataSource: starts");
        if (dsName == null || dsName.trim().length() == 0) {
            dsName = "OraclePgDS";
        }
        ms_log.debug((Object)"getDataSource: dsName: ", (Object)dsName);
        String szDsPrefix = "";
        if (OraclePropertyGraphUtils.isServerProviderAvailable("jboss", Parameters.getInstance().getJBossEnvDetectionClassName())) {
            szDsPrefix = "java:jboss/datasources/";
        } else if (OraclePropertyGraphUtils.isServerProviderAvailable("tomcat", Parameters.getInstance().getTomcatEnvDetectionClassName())) {
            szDsPrefix = "java:comp/env/";
        }
        InitialContext ic = new InitialContext();
        DataSource dsOracle = null;
        try {
            dsOracle = (DataSource)ic.lookup(szDsPrefix + dsName);
        }
        catch (NameNotFoundException nnfe) {
            ms_log.debug((Object)"getDataSource: first attempt failed ");
            dsOracle = (DataSource)ic.lookup("java:jboss/datasources/" + dsName);
            dsOracle = InternalDS.getInstance(dsOracle);
            ms_log.debug((Object)"getDataSource: use InternalDS");
        }
        ms_log.debug((Object)"getDataSource: type of datasource: ", (Object)dsOracle.getClass().getName());
        if (dsOracle instanceof OracleDataSource) {
            OracleDataSource ods = (OracleDataSource)dsOracle;
            ms_log.debug((Object)"getDataSource: implicit cache enabled: ", (Object)ods.getImplicitCachingEnabled());
            ms_log.debug((Object)"getDataSource: connection properties: ", (Object)ods.getConnectionProperties());
        }
        return dsOracle;
    }

    private static boolean isServerProviderAvailable(String serverProvider, String className) {
        ms_log.debug((Object)("getDataSource: detect " + serverProvider + " by class "), (Object)className);
        try {
            Class.forName(className);
            ms_log.debug((Object)"getDataSource: in ", (Object)serverProvider);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            ms_log.debug((Object)"getDataSource: not in ", (Object)serverProvider);
            return false;
        }
    }

    protected static class TwoTablesEdgeLoader
    implements Runnable {
        static SimpleLog ms_log = SimpleLog.getLog(TwoTablesEdgeLoader.class);
        private Iterator<OracleEdgeBase> m_iterator = null;
        private Set<String> m_propertyKeys = null;
        private int m_indexThread;
        private OraclePreparedStatement m_stmt = null;
        private PropertyType m_edgeIDType = null;
        private PropertyType m_vertexIDType = null;
        private boolean m_bHasEdgeLabel = true;
        private boolean m_bHasEdgeId = true;
        private int m_iBatchSize = 1000;

        @Override
        public void run() {
            int lCount = 0;
            try {
                while (this.m_iterator.hasNext()) {
                    OracleEdgeBase e = this.m_iterator.next();
                    int idx = 1;
                    if (this.m_bHasEdgeId) {
                        Object eid = OraclePropertyGraphUtils.getValueBasedOnPropertyType(this.m_edgeIDType, e.id());
                        OraclePropertyGraphUtils.setArgumentForStmt(this.m_stmt, idx++, eid);
                    }
                    if (this.m_bHasEdgeLabel) {
                        this.m_stmt.setString(idx++, e.label());
                    }
                    Object svid = OraclePropertyGraphUtils.getValueBasedOnPropertyType(this.m_vertexIDType, e.outVertex().id());
                    OraclePropertyGraphUtils.setArgumentForStmt(this.m_stmt, idx++, svid);
                    Object dvid = OraclePropertyGraphUtils.getValueBasedOnPropertyType(this.m_vertexIDType, e.inVertex().id());
                    OraclePropertyGraphUtils.setArgumentForStmt(this.m_stmt, idx++, dvid);
                    for (String key : this.m_propertyKeys) {
                        Object val = e.property(key).value();
                        OraclePropertyGraphUtils.setArgumentForStmt(this.m_stmt, idx++, val);
                    }
                    this.m_stmt.addBatch();
                    if (++lCount % this.m_iBatchSize != 0) continue;
                    this.m_stmt.executeBatch();
                }
                if (lCount > 0) {
                    this.m_stmt.executeBatch();
                }
            }
            catch (Exception ex) {
                ms_log.error((Object)("run: Exception found. Exception is" + ex));
                throw new OraclePropertyGraphException((Throwable)ex);
            }
            if (ms_bShowProgress) {
                ms_log.info((Object)("run [" + this.m_indexThread + "] : total number of elements processed " + lCount));
            }
        }

        public TwoTablesEdgeLoader(Iterator<OracleEdgeBase> it, int idx, OraclePreparedStatement stmt, int batchSize, Set<String> propertyKeys, PropertyType edgeIDType, PropertyType vertexIDType, boolean hasEdgeId, boolean hasEdgeLabel) {
            this.m_iterator = it;
            this.m_indexThread = idx;
            this.m_stmt = stmt;
            this.m_iBatchSize = batchSize;
            this.m_edgeIDType = edgeIDType != null ? edgeIDType : PropertyType.LONG;
            this.m_vertexIDType = vertexIDType != null ? vertexIDType : PropertyType.LONG;
            this.m_bHasEdgeLabel = hasEdgeLabel;
            this.m_bHasEdgeId = hasEdgeId;
            this.m_propertyKeys = propertyKeys;
        }

        public String getName() {
            return "TwoTablesEdgeLoader[" + this.m_indexThread + "]";
        }
    }

    protected static class TwoTablesVertexLoader
    implements Runnable {
        static SimpleLog ms_log = SimpleLog.getLog(TwoTablesVertexLoader.class);
        private Iterator<OracleVertexBase> m_iterator = null;
        private Set<String> m_propertyKeys = null;
        private int m_indexThread;
        private OraclePreparedStatement m_stmt = null;
        private int m_iBatchSize = 1000;
        private PropertyType m_vertexIDType = null;

        @Override
        public void run() {
            int lCount = 0;
            try {
                while (this.m_iterator.hasNext()) {
                    OracleVertexBase v = this.m_iterator.next();
                    int idx = 1;
                    Object vid = OraclePropertyGraphUtils.getValueBasedOnPropertyType(this.m_vertexIDType, v.id());
                    OraclePropertyGraphUtils.setArgumentForStmt(this.m_stmt, idx++, vid);
                    for (String key : this.m_propertyKeys) {
                        Object val = v.property(key).value();
                        OraclePropertyGraphUtils.setArgumentForStmt(this.m_stmt, idx++, val);
                    }
                    this.m_stmt.addBatch();
                    if (++lCount % this.m_iBatchSize != 0) continue;
                    this.m_stmt.executeBatch();
                }
                if (lCount > 0) {
                    this.m_stmt.executeBatch();
                }
            }
            catch (Exception e) {
                ms_log.error((Object)("run: Exception found. Exception is " + e));
                throw new OraclePropertyGraphException((Throwable)e);
            }
            if (ms_bShowProgress) {
                ms_log.info((Object)("run [" + this.m_indexThread + "] : total number of elements processed " + lCount));
            }
        }

        public TwoTablesVertexLoader(Iterator<OracleVertexBase> it, int idx, OraclePreparedStatement stmt, int batchSize, Set<String> propertyKeys, PropertyType vertexIDType) {
            this.m_iterator = it;
            this.m_indexThread = idx;
            this.m_stmt = stmt;
            this.m_vertexIDType = vertexIDType != null ? vertexIDType : PropertyType.LONG;
            this.m_iBatchSize = batchSize;
            this.m_propertyKeys = propertyKeys;
        }

        public String getName() {
            return "TwoTablesVertexLoader[" + this.m_indexThread + "]";
        }
    }
}

