/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.pg.common.Direction;
import oracle.pg.common.EdgeCache;
import oracle.pg.common.EdgeFilterCallback;
import oracle.pg.common.OpCallback;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OracleElementBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphConstants;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.ProgressListener;
import oracle.pg.common.SQLUtils;
import oracle.pg.common.SimpleJsonDataWrapper;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.SimpleRdfDataWrapper;
import oracle.pg.common.SimpleSpatialDataWrapper;
import oracle.pg.common.Util;
import oracle.pg.common.VertexCache;
import oracle.pg.common.VertexFilterCallback;
import oracle.pg.common.exceptions.FeatureNotSupportedException;
import oracle.pg.common.messages.Message;
import oracle.pg.rdbms.EdgeChange;
import oracle.pg.rdbms.EdgeChangeIteratorImpl;
import oracle.pg.rdbms.Oracle;
import oracle.pg.rdbms.OracleChangeTracker;
import oracle.pg.rdbms.OracleEdge;
import oracle.pg.rdbms.OracleEdgeFilterIteratorImpl;
import oracle.pg.rdbms.OracleEdgeIteratorImpl;
import oracle.pg.rdbms.OracleElementIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraphAnalytics;
import oracle.pg.rdbms.OraclePropertyGraphConfigurationConstants;
import oracle.pg.rdbms.OraclePropertyGraphUtils;
import oracle.pg.rdbms.OracleVertex;
import oracle.pg.rdbms.OracleVertexFilterIteratorImpl;
import oracle.pg.rdbms.OracleVertexIteratorImpl;
import oracle.pg.rdbms.OrderedEdgeIdIteratorImpl;
import oracle.pg.rdbms.OrderedVertexIdIteratorImpl;
import oracle.pg.rdbms.Parameters;
import oracle.pg.rdbms.RDBMSIndexManager;
import oracle.pg.rdbms.RdbmsPropertyGraphConstants;
import oracle.pg.rdbms.SQLAnalyticsGraph;
import oracle.pg.rdbms.VertexChange;
import oracle.pg.rdbms.VertexChangeIteratorImpl;
import oracle.pg.text.OracleIndexManager;
import oracle.pg.text.OracleIndexUtils;
import oracle.pg.text.Parameter;
import oracle.pgx.config.PgRdbmsGraphConfig;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class OraclePropertyGraph
extends SQLAnalyticsGraph
implements OraclePropertyGraphAnalytics,
OracleChangeTracker,
RdbmsPropertyGraphConstants,
OraclePropertyGraphConfigurationConstants {
    static SimpleLog ms_log = SimpleLog.getLog(OraclePropertyGraph.class);
    protected static final boolean ms_bShowProgress = Parameters.getInstance().showProgress();
    boolean m_bIsFromGraphConfig = false;
    static boolean ms_bDebug = false;
    private Oracle m_oracle;
    private String m_szVertexTabName;
    private String m_szEdgeTabName;
    private String m_szIdxMetaTabName;
    private String m_szSnapshotTabName;
    private String m_szDistinctVertexTabName;
    private String m_szSkeletonTabName;
    private String m_szXQVIndexName;
    private String m_szXQDIndexName;
    private String m_szXQEIndexName;
    private String m_szXQGIndexName;
    private String m_szXVPIndexName;
    private String m_szXDEIndexName;
    private String m_szXSEIndexName;
    private String m_szXEPIndexName;
    private String m_szXDGIndexName;
    private String m_szXSGIndexName;
    private CallableStatement m_csGetInternalID = null;
    private OracleCallableStatement m_csAddVertex = null;
    private OracleCallableStatement m_csAddEdge = null;
    private PreparedStatement m_csDeleteVertex = null;
    private PreparedStatement m_psDeleteEdge = null;
    private PreparedStatement m_psGetSCN = null;
    private PreparedStatement m_psGetPtnNum = null;
    private long m_lBatchVertexInserts = 0L;
    private long m_lBatchEdgeInserts = 0L;
    private long m_lBatchVertexDeletes = 0L;
    private long m_lBatchEdgeDeletes = 0L;
    private long maxPropertyNameLengthAllowed = 15000L;
    private long maxValueLengthAllowed = 15000L;
    private long maxLabelLengthAllowed = 15000L;
    private int dbMajorVersion = -1;
    private String opgVersion = null;
    private boolean m_bTreatTimestampTzAsStr = Parameters.getInstance().getTreatTimestampTzAsStr();
    String m_sFormNCharSetting = null;
    protected boolean m_bDB11g = Parameters.getInstance().force11g();
    protected boolean m_bHashPtn = true;
    protected int m_iDOP = 4;
    protected int m_iDefaultNumHashPtns = 8;
    protected String m_szOptions = "";
    protected String m_szTBS = "";
    protected String m_szTBSSet = "";
    private boolean m_bPGViewOnRDFFlag = false;
    final String distinctTableValidation = "Distinct table";
    final String distinctTableTriggerAndIndicesValidation = "Distinct table trigger and indices";
    static AtomicInteger ms_aiInstances;
    private String m_szGraphOwner = null;
    private java.sql.Date m_dateVTS = null;
    private java.sql.Date m_dateVTE = null;
    private long m_lCntAddVertex = 0L;
    private long m_lCntAddEdge = 0L;
    private String m_szNumerToCharSqlFormat;
    private String m_szTimeToCharSqlFormat;
    private int m_iRowPrefetch = Parameters.getInstance().getRowPrefetch();
    private int m_iDefaultDOPPerPtn = Parameters.getInstance().getDefaultDOPPerPtn();
    private boolean m_bShutdownCalled = false;
    protected boolean m_bDisposed = false;
    protected int queryFetchSize = 1000;
    private OracleIndexManager m_indexManager;
    private int m_iSessionQueryDOP = 1;

    public void treatTimestampTzAsStr(boolean b) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"treatTimestampTzAsStr: ", (Object)Boolean.toString(b));
        }
        this.m_bTreatTimestampTzAsStr = b;
    }

    public boolean getTreatTimestampTzAsStr() {
        return this.m_bTreatTimestampTzAsStr;
    }

    String processVT(String szVtColName) {
        if (this.getTreatTimestampTzAsStr()) {
            return "TO_CHAR(" + szVtColName + ",'YYYY-MM-DD\"T\"HH24:MI:SS.FFTZH:TZM') AS " + szVtColName + "  ";
        }
        return szVtColName;
    }

    public void setSkipFormNCharSettingForTextQuery(String s) {
        this.m_sFormNCharSetting = s;
    }

    public boolean getSkipFormNCharSettingForTextQuery() {
        String s = this.m_sFormNCharSetting;
        if (this.m_sFormNCharSetting == null) {
            s = Parameters.getInstance().getSkipFormNCharSetting();
        }
        boolean skipForm = true;
        if (s != null && s.toUpperCase().startsWith("F")) {
            skipForm = false;
        }
        if (ms_bDebug) {
            ms_log.debug((Object)"getSkipFormNCharSettingForTextQuery: value is ", (Object)skipForm);
        }
        return skipForm;
    }

    public String getTextIndexDirectoryPrefix() {
        return "ORA_PG_";
    }

    public Class getDatatypeClassFromValueObjForTextIndex(Object value) {
        return OracleIndexUtils.getDatatypeClass((Object)value);
    }

    public String parseValueToCharSQLFormatString(Object value) {
        OracleCallableStatement cs = null;
        ResultSet rs = null;
        if (value == null) {
            return null;
        }
        try {
            String szQuery = "\n declare vn number; df varchar2(3100); nf varchar2(3100);            t number; vt timestamp(6) with time zone;           v nvarchar2(31000); begin  t:=?;  vn:=?;  vt:=?;  nf:=?; df:=?;  case when t in (2,3,4,7,8,9) then v:= to_char(vn, nf);                               else v:= to_char(vt, df); end case;  ?:= v;end;";
            cs = (OracleCallableStatement)this.m_oracle.getConnection().prepareCall(szQuery);
            if (value instanceof String) {
                String string = "{" + (String)value + "}";
                return string;
            }
            if (value instanceof Float) {
                cs.setInt(1, 3);
                cs.setFloat(2, ((Float)value).floatValue());
                cs.setTimestamp(3, null);
                cs.setString(4, this.getNumberToCharSqlFormatString());
                cs.setString(5, this.getTimeToCharSqlFormatString());
                cs.registerOutParameter(6, -9);
            } else if (value instanceof Integer) {
                cs.setInt(1, 2);
                cs.setInt(2, (Integer)value);
                cs.setTimestamp(3, null);
                cs.setString(4, this.getNumberToCharSqlFormatString());
                cs.setString(5, this.getTimeToCharSqlFormatString());
                cs.registerOutParameter(6, -9);
            } else if (value instanceof Double) {
                cs.setInt(1, 4);
                cs.setDouble(2, (Double)value);
                cs.setTimestamp(3, null);
                cs.setString(4, this.getNumberToCharSqlFormatString());
                cs.setString(5, this.getTimeToCharSqlFormatString());
                cs.registerOutParameter(6, -9);
            } else if (value instanceof Long) {
                cs.setInt(1, 7);
                cs.setLong(2, (Long)value);
                cs.setTimestamp(3, null);
                cs.setString(4, this.getNumberToCharSqlFormatString());
                cs.setString(5, this.getTimeToCharSqlFormatString());
                cs.registerOutParameter(6, -9);
            } else if (value instanceof Short) {
                cs.setInt(1, 8);
                cs.setShort(2, (Short)value);
                cs.setTimestamp(3, null);
                cs.setString(4, this.getNumberToCharSqlFormatString());
                cs.setString(5, this.getTimeToCharSqlFormatString());
                cs.registerOutParameter(6, -9);
            } else if (value instanceof Byte) {
                cs.setInt(1, 9);
                cs.setByte(2, (Byte)value);
                cs.setTimestamp(3, null);
                cs.setString(4, this.getNumberToCharSqlFormatString());
                cs.setString(5, this.getTimeToCharSqlFormatString());
                cs.registerOutParameter(6, -9);
            } else {
                if (value instanceof Character) {
                    String string = String.valueOf((Character)value);
                    return string;
                }
                if (value instanceof Date) {
                    Timestamp dateV = new Timestamp(((Date)value).getTime());
                    cs.setInt(1, 5);
                    cs.setNull(2, 4);
                    cs.setObject(3, dateV);
                    cs.setString(4, this.getNumberToCharSqlFormatString());
                    cs.setString(5, this.getTimeToCharSqlFormatString());
                    cs.registerOutParameter(6, 12);
                } else {
                    if (value instanceof Boolean) {
                        String dateV = (Boolean)value != false ? "Y" : "N";
                        return dateV;
                    }
                    if (value instanceof SimpleSpatialDataWrapper) {
                        String str = ((SimpleSpatialDataWrapper)value).serialize();
                        if (str.length() > 255) {
                            String string = str.substring(0, 255) + "%";
                            return string;
                        }
                        String string = "{" + str + "}";
                        return string;
                    }
                    if (value instanceof SimpleRdfDataWrapper) {
                        String str = ((SimpleRdfDataWrapper)value).serialize();
                        if (str.length() > 255) {
                            String string = str = str.substring(0, 255) + "%";
                            return string;
                        }
                        String string = str;
                        return string;
                    }
                    if (value instanceof SimpleJsonDataWrapper) {
                        String str = ((SimpleJsonDataWrapper)value).serialize();
                        if (str.length() > 255) {
                            String string = str.substring(0, 255) + "%";
                            return string;
                        }
                        str = str.replace("{", "");
                        str = str.replace("}", "");
                        String string = "{" + str + "}";
                        return string;
                    }
                    if (value instanceof Serializable) {
                        String str = OraclePropertyGraph.serializableToStr((Serializable)((Serializable)value));
                        if (str.length() > 255) {
                            String string = str.substring(0, 255) + "%";
                            return string;
                        }
                        String string = "{" + str + "}";
                        return string;
                    }
                    throw new OraclePropertyGraphException("parseValueToCharSQLFormatString: TODO  unsupported type. " + value.getClass().getName());
                }
            }
            cs.execute();
            String string = "{" + cs.getString(6) + "}";
            return string;
        }
        catch (IOException | SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
        finally {
            OracleElementIteratorImpl.quietlyCloseResultSet(rs);
        }
    }

    @Override
    public Oracle getOracle() {
        return this.m_oracle;
    }

    public boolean isDB11g() {
        return this.m_bDB11g;
    }

    protected boolean useHashPtn() {
        return this.m_bHashPtn;
    }

    int getDDLDOP() {
        return this.m_iDOP;
    }

    protected int getDefaultNumHashPtns() {
        return this.m_iDefaultNumHashPtns;
    }

    public boolean getPGViewOnRDFFlag() {
        return this.m_bPGViewOnRDFFlag;
    }

    public void setPGViewOnRDFFlag(boolean flag) {
        this.m_bPGViewOnRDFFlag = flag;
    }

    String getPtnClause(String col) {
        if (!this.useHashPtn()) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append("partition by hash(").append(col).append(") (");
        for (int idx = 1; idx <= this.getDefaultNumHashPtns(); ++idx) {
            if (idx > 1) {
                sb.append(",");
            }
            sb.append("partition p").append(idx);
        }
        sb.append(")");
        return sb.toString();
    }

    String getVertexPtnClause() {
        return this.getPtnClause("vid");
    }

    String getEdgePtnClause() {
        return this.getPtnClause("eid");
    }

    String getIndexPtnClause() {
        if (this.useHashPtn()) {
            return " local ";
        }
        return "";
    }

    String getOptions() {
        return this.m_szOptions;
    }

    public String getTablespace() {
        return this.m_szTBS;
    }

    public String getTablespaceSet() {
        return this.m_szTBSSet;
    }

    protected synchronized void createIndexTable(boolean nologging) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.m_oracle.getConnection().prepareCall("begin opg_apis.create_pg_textidx_tab(:1, :2, :3, :4, :5); end;");
            String szOwner = this.getGraphOwner().toUpperCase();
            cs.setString(1, szOwner.substring(1, szOwner.length() - 1));
            cs.setString(2, this.getGraphName());
            cs.setInt(3, this.m_iDOP);
            cs.setString(4, this.m_szTBS);
            String szOptions = this.m_szOptions;
            boolean bShardingDb = this.isShardingDb();
            if (nologging) {
                szOptions = szOptions + ",NOLOGGING=F,";
            }
            if (bShardingDb) {
                szOptions = szOptions + ",SHARDING=T,";
            }
            cs.setString(5, szOptions);
            cs.execute();
        }
        catch (SQLException sqle) {
            block11: {
                block10: {
                    try {
                        if (sqle.getErrorCode() != 910) break block10;
                        ms_log.error((Object)"createIndexTable: Please enable 32K maximum length support to avoid the following error. ", (Throwable)sqle);
                    }
                    catch (Throwable throwable) {
                        OracleElementIteratorImpl.quietlyCloseStmt(cs);
                        throw throwable;
                    }
                    OracleElementIteratorImpl.quietlyCloseStmt(cs);
                    return;
                }
                if (sqle.getErrorCode() != 1031) break block11;
                ms_log.debug((Object)"createIndexTable: ", (Throwable)sqle);
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                return;
            }
            if (sqle.getErrorCode() == 54) {
                ms_log.debug((Object)"createIndexTable: ", (Throwable)sqle);
            } else {
                ms_log.error((Object)"createIndexTable: ", (Throwable)sqle);
            }
            throw new OraclePropertyGraphException((Throwable)sqle);
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void createSnapshotTable(boolean nologging) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = this.m_oracle.getConnection().prepareCall("begin opg_apis.create_pg_snapshot_tab(:1, :2, :3, :4, :5); end;");
            String szOwner = this.getGraphOwner().toUpperCase();
            cs.setString(1, szOwner.substring(1, szOwner.length() - 1));
            cs.setString(2, this.getGraphName());
            cs.setInt(3, this.m_iDOP);
            cs.setString(4, this.m_szTBS);
            boolean bShardingDb = this.getOracle().isShardingDb();
            String szOptions = this.m_szOptions;
            if (bShardingDb) {
                szOptions = szOptions + ",SHARDING=T,";
            }
            if (nologging) {
                cs.setString(5, this.m_szOptions);
            } else {
                cs.setString(5, ",NOLOGGING=F," + szOptions);
            }
            cs.execute();
        }
        catch (SQLException sqle) {
            block12: {
                block11: {
                    block10: {
                        try {
                            if (sqle.getErrorCode() != 910) break block10;
                            ms_log.error((Object)"createSnapshotTable: Please enable 32K maximum length support to avoid the following error. ", (Throwable)sqle);
                        }
                        catch (Throwable throwable) {
                            OracleElementIteratorImpl.quietlyCloseStmt(cs);
                            throw throwable;
                        }
                        OracleElementIteratorImpl.quietlyCloseStmt(cs);
                        return;
                    }
                    if (sqle.getErrorCode() != 1031) break block11;
                    ms_log.debug((Object)"createSnapshotTable: ", (Throwable)sqle);
                    OracleElementIteratorImpl.quietlyCloseStmt(cs);
                    return;
                }
                if (sqle.getErrorCode() == 54) {
                    ms_log.debug((Object)"createSnapshotTable: ", (Throwable)sqle);
                    break block12;
                }
                ms_log.error((Object)"createSnapshotTable: ", (Throwable)sqle);
            }
            OracleElementIteratorImpl.quietlyCloseStmt(cs);
        }
        OracleElementIteratorImpl.quietlyCloseStmt(cs);
    }

    public boolean isShardingDb() {
        return this.getOracle().isShardingDb();
    }

    private void initTableNames() {
        try {
            OracleConnection conn = this.getOracle().getConnection();
            this.m_szVertexTabName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "VT$"));
            this.m_szEdgeTabName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "GE$"));
            this.m_szIdxMetaTabName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "IT$"));
            this.m_szSnapshotTabName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "SS$"));
            this.m_szDistinctVertexTabName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "VD$"));
            this.m_szSkeletonTabName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "GT$"));
        }
        catch (SQLException ex) {
            throw new OraclePropertyGraphException((Throwable)ex);
        }
    }

    private void initIndexNames() {
        try {
            OracleConnection conn = this.getOracle().getConnection();
            this.m_szXQVIndexName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "XQV$"));
            this.m_szXQDIndexName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "XQD$"));
            this.m_szXQEIndexName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "XQE$"));
            this.m_szXQGIndexName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "XQG$"));
            this.m_szXVPIndexName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "XVP$"));
            this.m_szXDEIndexName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "XDE$"));
            this.m_szXSEIndexName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "XSE$"));
            this.m_szXEPIndexName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "XEP$"));
            this.m_szXDGIndexName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "XDG$"));
            this.m_szXSGIndexName = Util.simpleSqlNameCheck((Connection)conn, (String)(this.getGraphName() + "XSG$"));
        }
        catch (SQLException ex) {
            throw new OraclePropertyGraphException((Throwable)ex);
        }
    }

    private synchronized void createGraphTables(boolean nologging, boolean bShardingDb) throws SQLException {
        int dbVersion = this.getDatabaseMajorVersion();
        String opgVersion = this.getOpgVersion();
        boolean createPgWithTbsSet = SQLUtils.DbFeature.CREATE_PG_WITH_TBS_SET.isSupported(dbVersion, opgVersion);
        if (bShardingDb && !SQLUtils.DbFeature.SHARDING.isSupported(dbVersion, opgVersion)) {
            throw new OraclePropertyGraphException("Sharding is not supported in 12c database version");
        }
        String stmtStr = "begin opg_apis.create_pg(graph_owner => ?, graph_name => ?, dop => ?, num_hash_ptns => ?, tbs => ?, options => ?); end;";
        if (createPgWithTbsSet) {
            stmtStr = "begin opg_apis.create_pg(graph_owner => ?, graph_name => ?, dop => ?, num_hash_ptns => ?, tbs => ?, tbs_set => ?, options => ?); end;";
        }
        try (CallableStatement cs = this.m_oracle.getConnection().prepareCall(stmtStr);){
            int idx = 1;
            cs.setString(idx++, this.m_szGraphOwner);
            cs.setString(idx++, this.getGraphName());
            cs.setInt(idx++, this.m_iDOP);
            cs.setInt(idx++, this.m_iDefaultNumHashPtns);
            cs.setString(idx++, this.m_szTBS);
            String szOptions = this.preprocessStatementOptions(this.m_szOptions, nologging, bShardingDb);
            if (createPgWithTbsSet) {
                cs.setString(idx++, this.m_szTBSSet);
            }
            cs.setString(idx++, szOptions);
            cs.execute();
        }
        catch (SQLException sqle) {
            this.handleSQLExceptionOnCreateTable(sqle);
        }
    }

    private String preprocessStatementOptions(String options, boolean nologging, boolean bShardingDb) {
        if (nologging) {
            options = options + ",NOLOGGING=F,";
        }
        if (bShardingDb) {
            options = options + ",SHARDING=T,";
        }
        return options;
    }

    private void handleSQLExceptionOnCreateTable(SQLException sqle) {
        if (sqle.getErrorCode() == 910) {
            ms_log.error((Object)"handleSQLExceptionOnCreateTable: Please enable 32K maximum length support to avoid the following error. ", (Throwable)sqle);
            return;
        }
        if (sqle.getErrorCode() == 1031) {
            ms_log.debug((Object)"handleSQLExceptionOnCreateTable: ", (Throwable)sqle);
            return;
        }
        if (sqle.getErrorCode() == 54) {
            ms_log.debug((Object)"handleSQLExceptionOnCreateTable: ", (Throwable)sqle);
        } else {
            ms_log.error((Object)("handleSQLExceptionOnCreateTable: error code " + sqle.getErrorCode()), (Throwable)sqle);
        }
        throw new OraclePropertyGraphException((Throwable)sqle);
    }

    public LinkedList<String> getIndexNames(String szTabName) throws SQLException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"getIndexNames: start");
        }
        LinkedList<String> slIdxes = new LinkedList<String>();
        ResultSet rsIdx = null;
        OraclePreparedStatement ps = null;
        try {
            String query = "Select INDEX_NAME from ALL_INDEXES where OWNER = ? and TABLE_NAME = ? and USER = ?";
            String userName = this.getOracle().getUsername().toUpperCase();
            String tableName = this.stripSchema(szTabName).toUpperCase();
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)("getIndexNames: query = " + query + ", userName = " + userName + ", tableName = " + tableName));
            }
            ps = (OraclePreparedStatement)this.getOracle().getConnection().prepareStatement(query);
            ps.setString(1, userName);
            ps.setString(2, tableName);
            ps.setString(3, userName);
            rsIdx = ps.executeQuery();
            while (rsIdx.next()) {
                String szIdxName = rsIdx.getString(1);
                slIdxes.add(szIdxName);
                if (!ms_log.isDebugEnabled()) continue;
                ms_log.debug((Object)("getIndexNames: get index " + szIdxName));
            }
        }
        catch (SQLException ex) {
            try {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"getIndexNames: hit SQLException", (Throwable)ex);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rsIdx, ps);
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rsIdx, (Statement)ps);
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"getIndexNames: end");
        }
        return slIdxes;
    }

    public LinkedList<String> getConstraintNames(String szTabName) throws SQLException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"getConstraintNames: start");
        }
        LinkedList<String> slConstraints = new LinkedList<String>();
        try (ResultSet rsConstraint = null;){
            String query = "Select constraint_name from ALL_CONSTRAINTS where OWNER = ? and TABLE_NAME = ?";
            String userName = this.getGraphOwner();
            String tableName = this.stripSchema(szTabName).toUpperCase();
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)("getConstraintNames: query = " + query + ", userName = " + userName + ", tableName = " + tableName));
            }
            rsConstraint = this.getOracle().executeQueryWithArg(query, userName, tableName);
            while (rsConstraint.next()) {
                String szConstraintName = rsConstraint.getString(1);
                slConstraints.add(szConstraintName);
                if (!ms_log.isDebugEnabled()) continue;
                ms_log.debug((Object)("getConstraintNames: get constraint " + szConstraintName));
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"getConstraintNames: end");
        }
        return slConstraints;
    }

    @Deprecated
    public <T extends OracleElementBase> void validateDistinctTableForDbVersion(String operationType, Class<T> elementClass) throws FeatureNotSupportedException {
        if (!this.isFeatureSupported(SQLUtils.DbFeature.DISTINCT_PG_TABLES)) {
            throw new FeatureNotSupportedException(operationType, elementClass, (double)this.getDatabaseMajorVersion());
        }
    }

    @Deprecated
    public List<String> disableDistinctVertexTable() throws SQLException {
        this.validateDistinctTableForDbVersion("Distinct table", OracleVertexBase.class);
        this.alterDistinctVertexTableTriggers(false);
        return this.disableVertexTableIndices(false);
    }

    public List<String> disableDistinctEdgeTable() throws SQLException {
        if (this.isFeatureSupported(SQLUtils.DbFeature.DISTINCT_PG_TABLES)) {
            ms_log.debug((Object)"disableDistinctEdgeTable: disable edge triggers");
            this.alterDistinctEdgeTableTriggers(false);
        }
        return this.disableEdgeTableIndices(false);
    }

    private void alterDistinctVertexTableTriggers(boolean enable) throws SQLException {
        this.validateDistinctTableForDbVersion("Distinct table trigger and indices", OracleVertexBase.class);
        this.alterDistinctTableTriggers(enable, true);
    }

    private void alterDistinctEdgeTableTriggers(boolean enable) throws SQLException {
        this.validateDistinctTableForDbVersion("Distinct table trigger and indices", OracleEdgeBase.class);
        this.alterDistinctTableTriggers(enable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterDistinctTableTriggers(boolean enable, boolean isVertexTable) throws SQLException {
        block11: {
            String szTriggerName = isVertexTable ? this.getVertexTabName() + "_TR_DML" : this.getEdgeTabName() + "_TR_DML";
            StringBuilder sbAlterTrigger = new StringBuilder("\nAlter Trigger ").append(szTriggerName);
            if (enable) {
                sbAlterTrigger.append(" Enable");
            } else {
                sbAlterTrigger.append(" Disable");
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"alterDistinctTableTriggers: alter trigger stmt: ", (Object)sbAlterTrigger.toString());
            }
            Statement ps = null;
            int iErrorCode = 4080;
            try {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"alterDistinctTableTriggers: szStmt ", (Object)sbAlterTrigger.toString());
                }
                ps = this.getOracle().getConnection().prepareStatement(sbAlterTrigger.toString());
                ps.execute();
                ms_log.debug((Object)"alterDistinctTableTriggers: done successfully");
            }
            catch (SQLException sqle) {
                if (sqle.getErrorCode() == iErrorCode) {
                    ms_log.debug((Object)("alterDistinctTableTriggers: ignore error per request " + iErrorCode + ", [ " + sbAlterTrigger.toString() + " ]"));
                    break block11;
                }
                ms_log.debug((Object)"alterDistinctTableTriggers: hit unexpected exception");
                throw sqle;
            }
            finally {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> disableVertexTableIndices(boolean disableVTIndices) throws SQLException {
        LinkedList<String> llIndices = null;
        LinkedList<String> llIndicesToReturn = null;
        try {
            int iErrorCode;
            Statement ps;
            String szUQName;
            block23: {
                String szTableName = disableVTIndices ? this.getVertexTabName() : this.getDistinctVertexTabName();
                llIndices = this.getIndexNames(szTableName);
                llIndicesToReturn = new LinkedList<String>(llIndices);
                szUQName = disableVTIndices ? this.getVertexTabIdxName("UQ") : this.getDistinctVertexTabIdxName("UQ");
                StringBuilder sbDropIdx = new StringBuilder("\nDrop Index ").append(szUQName);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"disableVertexTableIndices: drop index stmt: ", (Object)sbDropIdx.toString());
                }
                if (ms_bShowProgress) {
                    ms_log.info((Object)"disableVertexTableIndices: drop index stmt: ", (Object)sbDropIdx.toString());
                }
                ps = null;
                iErrorCode = 1418;
                try {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"disableVertexTableIndices: szStmt ", (Object)sbDropIdx.toString());
                    }
                    ps = this.getOracle().getConnection().prepareStatement(sbDropIdx.toString());
                    ps.execute();
                    ms_log.debug((Object)"disableVertexTableIndices: done successfully");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == iErrorCode) {
                        ms_log.debug((Object)("disableVertexTableIndices: ignore error per request " + iErrorCode + ", [ " + sbDropIdx.toString() + " ]"));
                        break block23;
                    }
                    ms_log.debug((Object)"disableVertexTableIndices: hit unexpected exception");
                    throw sqle;
                }
                finally {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
            }
            llIndices.remove(this.stripSchema(szUQName).toUpperCase());
            StringBuilder sbDisableIdx = null;
            for (String szIdxName : llIndices) {
                sbDisableIdx = new StringBuilder("\nAlter Index ").append(Util.enquoteTableName((Connection)this.getOracle().getConnection(), (String)szIdxName)).append(" Unusable");
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"disableVertexTableIndices: disable index stmt: ", (Object)sbDisableIdx.toString());
                }
                if (ms_bShowProgress) {
                    ms_log.info((Object)"disableVertexTableIndices: disable index stmt: ", (Object)sbDisableIdx.toString());
                }
                ps = null;
                iErrorCode = 1418;
                try {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"executeUpdateAndIgnoreError: szStmt ", (Object)sbDisableIdx.toString());
                    }
                    ps = this.getOracle().getConnection().prepareStatement(sbDisableIdx.toString());
                    ps.execute();
                    ms_log.debug((Object)"executeUpdateAndIgnoreError: done successfully");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == iErrorCode) {
                        ms_log.debug((Object)("executeUpdateAndIgnoreError: ignore error per request " + iErrorCode + ", [ " + sbDisableIdx.toString() + " ]"));
                        continue;
                    }
                    ms_log.debug((Object)"executeUpdateAndIgnoreError: hit unexpected exception");
                    throw sqle;
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                    ps = null;
                }
            }
        }
        catch (SQLException ex) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"disableVertexTableIndices: hit SQLException", (Throwable)ex);
            }
            throw ex;
        }
        return llIndicesToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> disableEdgeTableIndices(boolean disableGEIndices) throws SQLException {
        LinkedList<String> llIndices = null;
        LinkedList<String> llIndicesToReturn = null;
        try {
            String szDSEName;
            int iErrorCode;
            Statement ps;
            block45: {
                String szSDEName;
                StringBuilder sbDropIdx;
                block44: {
                    String szUQName;
                    block43: {
                        String szTableName = disableGEIndices ? this.getEdgeTabName() : this.getSkeletonTabName();
                        llIndices = this.getIndexNames(szTableName);
                        llIndicesToReturn = new LinkedList<String>(llIndices);
                        szUQName = disableGEIndices ? this.getEdgeTabIdxName("UQ") : this.getSkeletonTabIdxName("UQ");
                        sbDropIdx = new StringBuilder("\nDrop Index ").append(szUQName);
                        if (ms_log.isDebugEnabled()) {
                            ms_log.debug((Object)"disableEdgeTableIndices: drop index stmt: ", (Object)sbDropIdx.toString());
                        }
                        if (ms_bShowProgress) {
                            ms_log.info((Object)"disableEdgeTableIndices: drop index stmt: ", (Object)sbDropIdx.toString());
                        }
                        ps = null;
                        iErrorCode = 1418;
                        try {
                            if (ms_log.isDebugEnabled()) {
                                ms_log.debug((Object)"disableEdgeTableIndices: szStmt ", (Object)sbDropIdx.toString());
                            }
                            ps = this.getOracle().getConnection().prepareStatement(sbDropIdx.toString());
                            ps.execute();
                            ms_log.debug((Object)"disableEdgeTableIndices: done successfully");
                        }
                        catch (SQLException sqle) {
                            if (sqle.getErrorCode() == iErrorCode) {
                                ms_log.debug((Object)("disableEdgeTableIndices: ignore error per request " + iErrorCode + ", [ " + sbDropIdx.toString() + " ]"));
                                break block43;
                            }
                            ms_log.debug((Object)"disableEdgeTableIndices: hit unexpected exception");
                            throw sqle;
                        }
                        finally {
                            if (ps != null) {
                                ps.close();
                                ps = null;
                            }
                        }
                    }
                    llIndices.remove(this.stripSchema(szUQName).toUpperCase());
                    szSDEName = disableGEIndices ? this.getEdgeTabIdxName("SDE") : this.getSkeletonTabIdxName("SDE");
                    sbDropIdx = new StringBuilder("\nDrop Index ").append(szSDEName);
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"disableEdgeTableIndices: drop index stmt: ", (Object)sbDropIdx.toString());
                    }
                    if (ms_bShowProgress) {
                        ms_log.info((Object)"disableEdgeTableIndices: drop index stmt: ", (Object)sbDropIdx.toString());
                    }
                    ps = null;
                    iErrorCode = 1418;
                    try {
                        if (ms_log.isDebugEnabled()) {
                            ms_log.debug((Object)"disableEdgeTableIndices: szStmt ", (Object)sbDropIdx.toString());
                        }
                        ps = this.getOracle().getConnection().prepareStatement(sbDropIdx.toString());
                        ps.execute();
                        ms_log.debug((Object)"disableEdgeTableIndices: done successfully");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getErrorCode() == iErrorCode) {
                            ms_log.debug((Object)("disableEdgeTableIndices: ignore error per request " + iErrorCode + ", [ " + sbDropIdx.toString() + " ]"));
                            break block44;
                        }
                        ms_log.debug((Object)"disableEdgeTableIndices: hit unexpected exception");
                        throw sqle;
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                            ps = null;
                        }
                    }
                }
                llIndices.remove(this.stripSchema(szSDEName).toUpperCase());
                szDSEName = disableGEIndices ? this.getEdgeTabIdxName("DSE") : this.getSkeletonTabIdxName("DSE");
                sbDropIdx = new StringBuilder("\nDrop Index ").append(szDSEName);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"disableEdgeTableIndices: drop index stmt: ", (Object)sbDropIdx.toString());
                }
                if (ms_bShowProgress) {
                    ms_log.info((Object)"disableEdgeTableIndices: drop index stmt: ", (Object)sbDropIdx.toString());
                }
                ps = null;
                iErrorCode = 1418;
                try {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"disableEdgeTableIndices: szStmt ", (Object)sbDropIdx.toString());
                    }
                    ps = this.getOracle().getConnection().prepareStatement(sbDropIdx.toString());
                    ps.execute();
                    ms_log.debug((Object)"disableEdgeTableIndices: done successfully");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == iErrorCode) {
                        ms_log.debug((Object)("disableEdgeTableIndices: ignore error per request " + iErrorCode + ", [ " + sbDropIdx.toString() + " ]"));
                        break block45;
                    }
                    ms_log.debug((Object)"disableEdgeTableIndices: hit unexpected exception");
                    throw sqle;
                }
                finally {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
            }
            llIndices.remove(this.stripSchema(szDSEName).toUpperCase());
            StringBuilder sbDisableIdx = null;
            for (String szIdxName : llIndices) {
                sbDisableIdx = new StringBuilder("\nAlter Index ").append(Util.enquoteTableName((Connection)this.getOracle().getConnection(), (String)szIdxName)).append(" Unusable");
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"disableEdgeTableIndices: disable index stmt: ", (Object)sbDisableIdx.toString());
                }
                if (ms_bShowProgress) {
                    ms_log.info((Object)"disableEdgeTableIndices: disable index stmt: ", (Object)sbDisableIdx.toString());
                }
                ps = null;
                iErrorCode = 1418;
                try {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"disableEdgeTableIndices: szStmt ", (Object)sbDisableIdx.toString());
                    }
                    ps = this.getOracle().getConnection().prepareStatement(sbDisableIdx.toString());
                    ps.execute();
                    ms_log.debug((Object)"disableEdgeTableIndices: done successfully");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == iErrorCode) {
                        ms_log.debug((Object)("disableEdgeTableIndices: ignore error per request " + iErrorCode + ", [ " + sbDisableIdx.toString() + " ]"));
                        continue;
                    }
                    ms_log.debug((Object)"disableEdgeTableIndices: hit unexpected exception");
                    throw sqle;
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                    ps = null;
                }
            }
        }
        catch (SQLException ex) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"disableEdgeTableIndices: hit SQLException", (Throwable)ex);
            }
            throw ex;
        }
        return llIndicesToReturn;
    }

    @Deprecated
    public void rebuildDistinctVertexTable(List<String> llIndices, int dop, String szOptions) throws SQLException {
        this.validateDistinctTableForDbVersion("Rebuild trigger and indices for distinct table", OracleVertexBase.class);
        this.alterDistinctVertexTableTriggers(true);
        this.rebuildVertexTableIndices(llIndices, dop, false, szOptions);
    }

    public void rebuildDistinctEdgeTable(List<String> llIndices, int dop, String szOptions) throws SQLException {
        if (this.isFeatureSupported(SQLUtils.DbFeature.DISTINCT_PG_TABLES)) {
            ms_log.debug((Object)"RebuildDistinctEdgeTable: rebuild trigger");
            this.alterDistinctEdgeTableTriggers(true);
        }
        this.rebuildEdgeTableIndices(llIndices, dop, false, szOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildVertexTableIndices(List<String> llIndices, int dop, boolean rebuildVTIndices, String szOptions) throws SQLException {
        try {
            String szUQName;
            String szTableName;
            if (rebuildVTIndices) {
                szTableName = this.getVertexTabName();
                szUQName = this.getVertexTabIdxName("UQ");
            } else {
                szTableName = this.getDistinctVertexTabName();
                szUQName = this.getDistinctVertexTabIdxName("UQ");
            }
            StringBuilder sbCreateIdx = new StringBuilder("\nCreate Unique Index ").append(szUQName).append(" On ").append(szTableName).append("\n( VID");
            if (rebuildVTIndices) {
                sbCreateIdx.append(", K");
            }
            sbCreateIdx.append(")");
            sbCreateIdx.append(this.getIndexPtnClause());
            if (dop > 1) {
                sbCreateIdx.append("PARALLEL ").append(dop).append(this.getTbsClause()).append(" NOLOGGING ");
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"rebuildVertexTableIndices: create index stmt: ", (Object)sbCreateIdx.toString());
            }
            if (ms_bShowProgress) {
                ms_log.info((Object)("rebuildVertexTableIndices: create index stmt: " + sbCreateIdx.toString()));
            }
            Statement ps = null;
            try {
                SQLUtils.setEventForPartitioning((Connection)this.getOracle().getConnection(), (int)1);
                ps = this.getOracle().getConnection().prepareStatement(sbCreateIdx.toString());
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
                SQLUtils.setEventForPartitioning((Connection)this.getOracle().getConnection(), (int)0);
            }
            llIndices.remove(this.stripSchema(szUQName).toUpperCase());
            StringBuilder sbEnableIdx = null;
            for (String szIdx : llIndices) {
                sbEnableIdx = new StringBuilder("\nAlter Index ").append(Util.enquoteTableName((Connection)this.getOracle().getConnection(), (String)szIdx)).append(" Rebuild");
                if (dop > 1) {
                    sbEnableIdx.append(" PARALLEL ").append(dop).append(" NOLOGGING ");
                }
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"rebuildVertexTableIndices: rebuild table index stmt: ", (Object)sbEnableIdx.toString());
                }
                if (ms_bShowProgress) {
                    ms_log.info((Object)"rebuildVertexTableIndices: rebuild table index stmt: ", (Object)sbEnableIdx.toString());
                }
                try {
                    SQLUtils.setEventForPartitioning((Connection)this.getOracle().getConnection(), (int)1);
                    ps = this.getOracle().getConnection().prepareStatement(sbEnableIdx.toString());
                    ps.execute();
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() != 14086) continue;
                    this.rebuildAllIndexPartitions(szIdx, dop);
                }
                finally {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                    SQLUtils.setEventForPartitioning((Connection)this.getOracle().getConnection(), (int)0);
                }
            }
            this.getOracle().commitTransaction();
        }
        catch (SQLException ex) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"rebuildVertexTableIndices: hit SQLException", (Throwable)ex);
            }
            throw ex;
        }
    }

    private String getTbsClause() {
        return " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildEdgeTableIndices(List<String> llIndices, int dop, boolean rebuildGEIndices, String szOptions) throws SQLException {
        try {
            String szUQName;
            String szTableName;
            if (rebuildGEIndices) {
                szTableName = this.getEdgeTabName();
                szUQName = this.getEdgeTabIdxName("UQ");
            } else {
                szTableName = this.getSkeletonTabName();
                szUQName = this.getSkeletonTabIdxName("UQ");
            }
            StringBuilder sbCreateIdx = new StringBuilder("\nCreate Unique Index ").append(szUQName).append(" On ").append(szTableName).append("\n( EID");
            if (rebuildGEIndices) {
                sbCreateIdx.append(", K");
            }
            sbCreateIdx.append(")");
            sbCreateIdx.append(this.getIndexPtnClause());
            if (dop > 1) {
                sbCreateIdx.append("PARALLEL ").append(dop).append(this.getTbsClause()).append(" NOLOGGING ");
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"rebuildEdgeTableIndices: create index stmt: ", (Object)sbCreateIdx.toString());
            }
            if (ms_bShowProgress) {
                ms_log.info((Object)"rebuildEdgeTableIndices: create index stmt: ", (Object)sbCreateIdx.toString());
            }
            Statement ps = null;
            try {
                SQLUtils.setEventForPartitioning((Connection)this.getOracle().getConnection(), (int)1);
                ps = this.getOracle().getConnection().prepareStatement(sbCreateIdx.toString());
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
                SQLUtils.setEventForPartitioning((Connection)this.getOracle().getConnection(), (int)0);
            }
            llIndices.remove(this.stripSchema(szUQName).toUpperCase());
            String szSDEName = rebuildGEIndices ? this.getEdgeTabIdxName("SDE") : this.getSkeletonTabIdxName("SDE");
            sbCreateIdx = new StringBuilder("\nCreate Index ").append(szSDEName).append(" On ").append(szTableName).append("\n( SVID, DVID, EID");
            if (rebuildGEIndices) {
                sbCreateIdx.append(", VN");
            }
            sbCreateIdx.append(" )");
            sbCreateIdx.append(this.getIndexPtnClause());
            if (dop > 1) {
                sbCreateIdx.append("PARALLEL ").append(dop).append(this.getTbsClause()).append(" NOLOGGING ");
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"rebuildEdgeTableIndices: create index stmt: ", (Object)sbCreateIdx.toString());
            }
            if (ms_bShowProgress) {
                ms_log.info((Object)"rebuildEdgeTableIndices: create index stmt: ", (Object)sbCreateIdx.toString());
            }
            try {
                SQLUtils.setEventForPartitioning((Connection)this.getOracle().getConnection(), (int)1);
                ps = this.getOracle().getConnection().prepareStatement(sbCreateIdx.toString());
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
                SQLUtils.setEventForPartitioning((Connection)this.getOracle().getConnection(), (int)0);
            }
            llIndices.remove(this.stripSchema(szSDEName).toUpperCase());
            String szDSEName = rebuildGEIndices ? this.getEdgeTabIdxName("DSE") : this.getSkeletonTabIdxName("DSE");
            sbCreateIdx = new StringBuilder("\nCreate Index ").append(szDSEName).append(" On ").append(szTableName).append("\n( DVID, SVID, EID");
            if (rebuildGEIndices) {
                sbCreateIdx.append(", VN");
            }
            sbCreateIdx.append(")");
            sbCreateIdx.append(this.getIndexPtnClause());
            if (dop > 1) {
                sbCreateIdx.append("PARALLEL ").append(dop).append(this.getTbsClause()).append(" NOLOGGING ");
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"rebuildEdgeTableIndices: create index stmt: ", (Object)sbCreateIdx.toString());
            }
            if (ms_bShowProgress) {
                ms_log.info((Object)"rebuildEdgeTableIndices: create index stmt: ", (Object)sbCreateIdx.toString());
            }
            try {
                SQLUtils.setEventForPartitioning((Connection)this.getOracle().getConnection(), (int)1);
                ps = this.getOracle().getConnection().prepareStatement(sbCreateIdx.toString());
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
                SQLUtils.setEventForPartitioning((Connection)this.getOracle().getConnection(), (int)0);
            }
            llIndices.remove(this.stripSchema(szDSEName).toUpperCase());
            StringBuilder sbEnableIdx = null;
            for (String szIdx : llIndices) {
                sbEnableIdx = new StringBuilder("\nAlter Index ").append(Util.enquoteTableName((Connection)this.getOracle().getConnection(), (String)szIdx)).append(" Rebuild");
                if (dop > 1) {
                    sbEnableIdx.append(" PARALLEL ").append(dop).append(" NOLOGGING ");
                }
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"rebuildEdgeTableIndices: rebuild table index stmt: ", (Object)sbEnableIdx.toString());
                }
                if (ms_bShowProgress) {
                    ms_log.info((Object)"rebuildEdgeTableIndices: rebuild table index stmt: ", (Object)sbEnableIdx.toString());
                }
                try {
                    SQLUtils.setEventForPartitioning((Connection)this.getOracle().getConnection(), (int)1);
                    ps = this.getOracle().getConnection().prepareStatement(sbEnableIdx.toString());
                    ps.execute();
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() != 14086) continue;
                    this.rebuildAllIndexPartitions(szIdx, dop);
                }
                finally {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                    SQLUtils.setEventForPartitioning((Connection)this.getOracle().getConnection(), (int)0);
                }
            }
            this.getOracle().commitTransaction();
        }
        catch (SQLException ex) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"rebuildEdgeTableIndices: hit SQLException", (Throwable)ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildAllIndexPartitions(String szIdx, int iDop) throws SQLException {
        String chkSzIdx = Util.enquoteTableName((Connection)this.getOracle().getConnection(), (String)szIdx);
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"rebuildAllIndexPartitions: start with ", (Object)(szIdx + " with iDOP " + iDop));
        }
        CallableStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> slPtns = new ArrayList<String>();
        try {
            String szQuery = "select PARTITION_NAME from USER_IND_PARTITIONS where INDEX_NAME = ? AND user = ?";
            stmt = this.getOracle().getConnection().prepareCall(szQuery);
            stmt.setString(1, szIdx.toUpperCase());
            stmt.setString(2, this.getOracle().getUsername().toUpperCase());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String szPtnName = rs.getString(1);
                slPtns.add(szPtnName);
                ms_log.debug((Object)"rebuildAllIndexPartitions: partition ", (Object)szPtnName);
            }
        }
        catch (SQLException ex) {
            try {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"rebuildAllIndexPartitions: hit SQLException", (Throwable)ex);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                OraclePropertyGraphUtils.quietlyCloseResultSetAndStmt(rs, stmt);
                throw throwable;
            }
        }
        OraclePropertyGraphUtils.quietlyCloseResultSetAndStmt((ResultSet)rs, (Statement)stmt);
        if (slPtns.size() > 0) {
            String szNologging = "alter index " + chkSzIdx + " nologging";
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"rebuildAllIndexPartitions: rebuild partition with ", (Object)szNologging);
            }
            PreparedStatement ps = null;
            try {
                ps = this.getOracle().getConnection().prepareStatement(szNologging);
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
            for (int idx = 0; idx < slPtns.size(); ++idx) {
                StringBuilder sb = new StringBuilder();
                sb.append("alter index ").append(chkSzIdx).append(" rebuild partition ").append(Util.enquoteTableName((Connection)this.getOracle().getConnection(), (String)((String)slPtns.get(idx)))).append(" parallel ").append(iDop);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"rebuildAllIndexPartitions: rebuild partition with ", (Object)sb.toString());
                }
                try {
                    ps = this.getOracle().getConnection().prepareStatement(sb.toString());
                    ps.execute();
                    continue;
                }
                finally {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"rebuildAllIndexPartitions: done");
        }
    }

    public List<String> disableVertexTableConstraints() throws SQLException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"disableVertexTableConstraints: started");
        }
        LinkedList<String> constraints = this.disableConstraints(this.getVertexTabName());
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"disableVertexTableConstraints: done");
        }
        return constraints;
    }

    public List<String> disableEdgeTableConstraints() throws SQLException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"disableEdgeTableConstraints: started");
        }
        LinkedList<String> constraints = this.disableConstraints(this.getEdgeTabName());
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"disableEdgeTableConstraints: done");
        }
        return constraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<String> disableConstraints(String szTableName) throws SQLException {
        LinkedList<String> llConstraints = null;
        try {
            llConstraints = this.getConstraintNames(szTableName);
            StringBuilder sbDisableConstraint = null;
            for (String szConstraintName : llConstraints) {
                sbDisableConstraint = new StringBuilder("\nAlter Table ").append(szTableName).append(" Disable Constraint ").append(Util.enquoteNameSQLName((Connection)this.getOracle().getConnection(), (String)szConstraintName));
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"disableConstraints: disable constraint stmt: ", (Object)sbDisableConstraint.toString());
                }
                if (ms_bShowProgress) {
                    ms_log.info((Object)"disableConstraints: disable constraint stmt: ", (Object)sbDisableConstraint.toString());
                }
                Statement ps = null;
                try {
                    ps = this.getOracle().getConnection().prepareStatement(sbDisableConstraint.toString());
                    ps.execute();
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                    ps = null;
                }
            }
        }
        catch (SQLException ex) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"disableConstraints: hit SQLException", (Throwable)ex);
            }
            throw ex;
        }
        return llConstraints;
    }

    public void rebuildVertexTableConstraints(List<String> llConstraints, int dop, String szOptions) throws SQLException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"rebuildVertexTableConstraints: started");
        }
        this.rebuildConstraints(this.getVertexTabName(), llConstraints, dop, szOptions);
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"rebuildVertexTableConstraints: done");
        }
    }

    public void rebuildEdgeTableConstraints(List<String> llConstraints, int dop, String szOptions) throws SQLException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"rebuildEdgeTableConstraints: started");
        }
        this.rebuildConstraints(this.getEdgeTabName(), llConstraints, dop, szOptions);
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"rebuildEdgeTableConstraints: done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildConstraints(String szTableName, List<String> llConstraints, int dop, String szOptions) throws SQLException {
        try (ResultSet rs = null;){
            StringBuilder sbEnableConstraint = null;
            for (String szConstraint : llConstraints) {
                ResultSet rsDop = this.getOracle().executeQueryWithArg("Select DEGREE from ALL_Tables where OWNER = ? and TABLE_NAME = ?", this.getGraphOwner(), this.stripSchema(szTableName).toUpperCase());
                int iOriginalDop = 1;
                if (rsDop.next()) {
                    iOriginalDop = Integer.parseInt(rsDop.getString(1).trim());
                }
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"rebuildConstraints: enable table constraint stmt part1: original table degree = ", (Object)iOriginalDop);
                }
                if (ms_bShowProgress) {
                    ms_log.info((Object)"rebuildConstraints: enable table constraint stmt part1: original table degree = ", (Object)iOriginalDop);
                }
                sbEnableConstraint = new StringBuilder("\nAlter Table ").append(szTableName).append(" Modify Constraint ").append(Util.enquoteNameSQLName((Connection)this.getOracle().getConnection(), (String)szConstraint)).append(" enable novalidate ");
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"rebuildConstraints: enable table constraint stmt part2: ", (Object)sbEnableConstraint.toString());
                }
                if (ms_bShowProgress) {
                    ms_log.info((Object)"rebuildConstraints: enable table constraint stmt part2: ", (Object)sbEnableConstraint.toString());
                }
                Statement ps = null;
                try {
                    ps = this.getOracle().getConnection().prepareStatement(sbEnableConstraint.toString());
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                sbEnableConstraint = new StringBuilder("\nAlter Table ").append(szTableName).append(" parallel ").append(dop);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"rebuildConstraints: enable table constraint stmt part3: ", (Object)sbEnableConstraint.toString());
                }
                if (ms_bShowProgress) {
                    ms_log.info((Object)"rebuildConstraints: enable table constraint stmt part3: ", (Object)sbEnableConstraint.toString());
                }
                try {
                    ps = this.getOracle().getConnection().prepareStatement(sbEnableConstraint.toString());
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                sbEnableConstraint = new StringBuilder("\nAlter Table ").append(szTableName).append(" Modify Constraint ").append(Util.enquoteNameSQLName((Connection)this.getOracle().getConnection(), (String)szConstraint)).append(" enable validate ");
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"rebuildConstraints: enable table constraint stmt part4: ", (Object)sbEnableConstraint.toString());
                }
                if (ms_bShowProgress) {
                    ms_log.info((Object)"rebuildConstraints: enable table constraint stmt part4: ", (Object)sbEnableConstraint.toString());
                }
                try {
                    ps = this.getOracle().getConnection().prepareStatement(sbEnableConstraint.toString());
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
                sbEnableConstraint = new StringBuilder("\nAlter Table ").append(szTableName).append(" parallel ").append(iOriginalDop);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"rebuildConstraints: enable table constraint stmt part5: ", (Object)sbEnableConstraint.toString());
                }
                if (ms_bShowProgress) {
                    ms_log.info((Object)"rebuildConstraints: enable table constraint stmt part5: ", (Object)sbEnableConstraint.toString());
                }
                try {
                    ps = this.getOracle().getConnection().prepareStatement(sbEnableConstraint.toString());
                    ps.execute();
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                    ps = null;
                }
            }
        }
    }

    private void closeStatements() {
        OraclePropertyGraphUtils.quietlyCloseStmt((Statement)this.m_csGetInternalID);
        OraclePropertyGraphUtils.quietlyCloseStmt((Statement)this.m_csAddVertex);
        OraclePropertyGraphUtils.quietlyCloseStmt((Statement)this.m_csAddEdge);
        OraclePropertyGraphUtils.quietlyCloseStmt((Statement)this.m_csDeleteVertex);
        OraclePropertyGraphUtils.quietlyCloseStmt((Statement)this.m_psDeleteEdge);
        OraclePropertyGraphUtils.quietlyCloseStmt((Statement)this.m_psGetSCN);
        OraclePropertyGraphUtils.quietlyCloseStmt((Statement)this.m_psGetPtnNum);
    }

    private void initStatements() throws SQLException {
        ms_log.debug((Object)"initStatements: start");
        this.m_csGetInternalID = this.m_oracle.getConnection().prepareCall("\n declare r number; \n begin \n   select sys_op_combined_hash(:1)/4 into r from dual ; \n   :2 := r; \n end;");
        this.m_csAddVertex = (OracleCallableStatement)this.m_oracle.getConnection().prepareCall("\n declare towner varchar2(128); vowner varchar2(128); vertextab varchar2(128); vvertextab varchar2(128);\n         s number; vl nvarchar2(3100); df nvarchar2(3100); nf nvarchar2(3100); vs nvarchar2(15000);\n         vts date; vte date; pn_array pnames_array; pt_array ptypes_array; pv_array p_strvalues_array;\n         pvn_array p_numvalues_array; vl_str nvarchar2(200); vl_val_str nvarchar2(200); \n         vt timestamp(6) with time zone; populate_vl number; t number; vn number;  k nvarchar2(3100);\n         sql_stmt varchar2(32000); \n begin \n   towner   := :1; \n   vertextab := :2; \n   populate_vl := :3; \n   s   := :4; \n   vl  := :5; \n   nf  := :6; \n   df  := :7; \n   vts := :8; \n   vte := :9; \n   pn_array := :10; \n   pt_array := :11; \n   pv_array := :12; \n   pvn_array := :13; \n   vl_str := ''; \n   vl_val_str := ''; \n   if (populate_vl = 1) then \n     vl_str := 'vl,'; \n     vl_val_str := ':vl,'; \n   end if; \n   vvertextab := sys.dbms_assert.enquote_name(sys.dbms_assert.qualified_sql_name(vertextab));\n   vowner := sys.dbms_assert.enquote_name(sys.dbms_assert.qualified_sql_name(towner));\n   sql_stmt := 'delete from ' || vowner || '.' || vvertextab || ' where vid = :s '; \n   execute immediate sql_stmt using s; \n     begin \n       if pn_array is NULL or pn_array is empty then \n         sql_stmt := 'insert into ' || vowner || '.' || vvertextab || \n                          ' (vid, ' || vl_str || ' k, t, v, vn, vt, vts, vte)  \n                           values(:s, ' || vl_val_str || ''' '', null, null, null, null, :vts, :vte)';\n         if (populate_vl = 1) then \n           execute immediate sql_stmt using s, vl, vts, vte; \n         else \n           execute immediate sql_stmt using s, vts, vte; \n         end if;\n       else \n         for i in pn_array.FIRST .. pn_array.LAST\n           loop \n             t := pt_array(i);\n             if (t = 5) then \n               vt := to_timestamp_tz(pv_array(i), 'YYYY-MM-DD\"T\"HH24:MI:SS.FF3TZR'); \n             else \n               vt := null; \n             end if; \n             vn := pvn_array(i); \n             k  := pn_array(i); \n             case when t in (2,3,4,7,8,9) then vs:= to_char(vn, nf); \n               when t in (5) then \n                 vs:= to_char(vt, df); \n               else vs:= pv_array(i);\n             end case; \n             if (t >= 1) then \n               sql_stmt := 'insert into ' || vowner || '.' || vvertextab || \n                          ' (vid, ' || vl_str || ' k, t, v, vn, vt, vts, vte)  \n                           values(:s, ' || vl_val_str || ' nvl(:k, '' ''), :t, :vs, :vn, \n                                  :vt, :vts, :vte)';\n               if (populate_vl = 1) then \n                 execute immediate sql_stmt using s, vl, k, t, vs, vn, vt, vts, vte; \n               else \n                 execute immediate sql_stmt using s, k, t, vs, vn, vt, vts, vte; \n               end if;\n             end if;\n           end loop;\n       end if; \n     exception \n       when others then -- need to detect unique key violation \n         raise; \n     end;\n end;");
        this.m_csAddVertex.setFormOfUse(5, (short)2);
        this.m_csAddEdge = (OracleCallableStatement)this.m_oracle.getConnection().prepareCall("\n declare towner varchar2(128); vowner varchar2(128); edgetab varchar2(128); vedgetab varchar2(128);\n         s number; svid number; dvid number; el nvarchar2(3100); df nvarchar2(3100); nf nvarchar2(3100); \n         vts date; vte date; pn_array pnames_array; pt_array ptypes_array; pv_array p_strvalues_array;\n         pvn_array p_numvalues_array; vt timestamp(6) with time zone; t number; \n         vn number; k nvarchar2(3100); sql_stmt varchar2(32000); vs nvarchar2(15000);\n begin \n   towner   := :1; \n   edgetab := :2; \n   s   := :4; \n   svid := :5; \n   dvid := :6; \n   el  := :7; \n   nf  := :8; \n   df  := :9; \n   vts := :10; \n   vte := :11; \n   pn_array := :12; \n   pt_array := :13; \n   pv_array := :14; \n   pvn_array := :16; \n   vedgetab := sys.dbms_assert.enquote_name(sys.dbms_assert.qualified_sql_name(edgetab));\n   vowner := sys.dbms_assert.enquote_name(sys.dbms_assert.qualified_sql_name(towner));\n   sql_stmt := 'delete from ' || vowner || '.' || vedgetab || ' where eid = :s '; \n   execute immediate sql_stmt using s; \n     begin \n       if pn_array is NULL or pn_array is empty then \n         sql_stmt := 'insert into ' || vowner || '.' || vedgetab || \n                          ' (eid, SVID, DVID, EL, k, vts, vte)  \n                           values(:s, :svid, :dvid, :el, '' '', :vts, :vte)';\n         execute immediate sql_stmt using s, svid, dvid, el, vts, vte; \n       else \n         for i in pn_array.FIRST .. pn_array.LAST\n           loop \n             t := pt_array(i);\n             if (t = 5) then \n               vt := to_timestamp_tz(pv_array(i), 'YYYY-MM-DD\"T\"HH24:MI:SS.FF3TZR'); \n             else \n               vt := null; \n             end if; \n             vn := pvn_array(i); \n             k  := pn_array(i); \n             case when t in (2,3,4,7,8,9) then vs:= to_char(vn, nf); \n               when t in (5) then \n                 vs:= to_char(vt, df); \n               else vs:= pv_array(i);\n             end case; \n             if (t >= 1) then \n               sql_stmt := 'insert into ' || vowner || '.' || vedgetab || \n                          ' (eid, SVID, DVID, EL, k, t, v, vn, vt, vts, vte)  \n                           values(:s, :svid, :dvid, :el, nvl(:k, '' ''), :t, :vs, :vn, \n                                  :vt, :vts, :vte)';\n               execute immediate sql_stmt using s, svid, dvid, el, k, t, vs, vn, vt, vts, vte; \n             end if;\n           end loop;\n       end if; \n     exception \n       when others then -- need to detect unique key violation \n         raise; \n     end;\n end;");
        this.m_csAddEdge.setFormOfUse(7, (short)2);
        this.m_csDeleteVertex = this.m_oracle.getConnection().prepareCall("declare n number; begin n := :1;   delete /*+ parallel(1) */ from " + this.getVertexTabName() + " where VID = n;   delete /*+ parallel(1) */ from " + this.getEdgeTabName() + " where SVID=n or DVID=n; end; ");
        this.m_psDeleteEdge = this.m_oracle.getConnection().prepareStatement("delete /*+ parallel(1) */ from " + this.getEdgeTabName() + " where eid = :1");
    }

    public static Oracle getOracle(String datasourceId) throws SQLException {
        ms_log.debug((Object)"create oracle instance from datasource {}", (Object)datasourceId);
        System.err.println("create oracle instance from datasource {}" + datasourceId);
        Connection conn = null;
        try {
            DataSource ds = OraclePropertyGraphUtils.getDataSource(datasourceId);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)("datasource of type: " + ds.getClass().getName()));
            }
            Oracle.setLocale();
            conn = ds.getConnection();
            conn.setAutoCommit(false);
            if (!(conn instanceof OracleConnection)) {
                throw new OraclePropertyGraphException("open: the connection from the datasource is not of OracleConnection type. Got " + conn.getClass().getName());
            }
            return new Oracle((OracleConnection)conn, ds);
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            throw new RuntimeException(e);
        }
    }

    public static Oracle getOracle(PgRdbmsGraphConfig config) throws SQLException {
        if (config.getDataSourceId() != null) {
            return OraclePropertyGraph.getOracle(config.getDataSourceId());
        }
        ms_log.debug((Object)"create oracle instance from URI, username and password");
        String jdbcUrl = config.getJdbcUrl();
        assert (jdbcUrl.toLowerCase().startsWith("jdbc:oracle:thin:@"));
        Object password = config.getValues().get(PgRdbmsGraphConfig.Field.PASSWORD);
        return new Oracle(jdbcUrl, config.getUsername(), password == null ? null : String.valueOf(password));
    }

    private OraclePropertyGraph(PgRdbmsGraphConfig config) throws SQLException {
        super(config);
        ms_log.debug((Object)"constructor (PgRdbmsGraphConfig): started, set flag to true");
        this.m_bIsFromGraphConfig = true;
        this.m_oracle = OraclePropertyGraph.getOracle(config);
        OracleConnection conn = this.m_oracle.getConnection();
        this.m_szGraphName = Util.getValidatedGraphName((Connection)conn, (String)config.getName());
        this.m_szGraphOwner = config.getOwner() != null ? Util.enquoteNameSQLName((Connection)conn, (String)config.getOwner()) : Util.enquoteNameSQLName((Connection)conn, (String)this.m_oracle.getUsername());
        if (config.getSecurityPolicy() != null) {
            if (config.getLabel() != null) {
                this.setLabel(config.getSecurityPolicy(), config.getLabel());
            }
            if (config.getRowLabel() != null) {
                this.setLabel(config.getSecurityPolicy(), config.getRowLabel());
            }
        }
        if (config.getOptions() != null) {
            this.m_szOptions = config.getOptions();
        }
        this.init();
    }

    private OraclePropertyGraph(Oracle oracle, String szGraphName) throws SQLException {
        this(oracle, szGraphName, 8);
    }

    private OraclePropertyGraph(Oracle oracle, String szGraphName, int iHashPartitionsNum) throws SQLException {
        this(oracle, szGraphName, iHashPartitionsNum, 4, "", "", "");
    }

    private OraclePropertyGraph(Oracle oracle, String owner, String szGraphName) throws SQLException {
        this(oracle, owner == null ? oracle.getUsername() : owner, szGraphName, 8, 4, "", "", "");
    }

    public String getGraphOwner() {
        return this.m_szGraphOwner;
    }

    private OraclePropertyGraph(Oracle oracle, String szGraphName, int iHashPartitionsNum, int iDOP, String szTBS, String szOptions) throws SQLException {
        this(oracle, oracle.getUsername(), szGraphName, iHashPartitionsNum, iDOP, szTBS, null, szOptions);
    }

    private OraclePropertyGraph(Oracle oracle, String szGraphName, int iHashPartitionsNum, int iDOP, String szTBS, String szTBSSet, String szOptions) throws SQLException {
        this(oracle, oracle.getUsername(), szGraphName, iHashPartitionsNum, iDOP, szTBS, szTBSSet, szOptions);
    }

    private String getCheckedGraphOwner(String szGraphOwner) {
        return szGraphOwner;
    }

    private OraclePropertyGraph(Oracle oracle, String szGraphOwner, String szGraphName, int iHashPartitionsNum, int iDOP, String szTBS, String szOptions) throws SQLException {
        this(oracle, szGraphOwner, szGraphName, iHashPartitionsNum, iDOP, szTBS, null, szOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePropertyGraph(Oracle oracle, String szGraphOwner, String szGraphName, int iHashPartitionsNum, int iDOP, String szTBS, String szTBSSet, String szOptions) throws SQLException {
        this.m_oracle = oracle;
        this.m_szGraphOwner = this.getCheckedGraphOwner(szGraphOwner);
        OracleConnection conn = this.m_oracle.getConnection();
        this.m_szGraphName = Util.getValidatedGraphName((Connection)conn, (String)szGraphName);
        if (this.m_szGraphOwner != null) {
            this.m_szGraphOwner = Util.enquoteNameSQLName((Connection)conn, (String)szGraphOwner);
        }
        this.m_iDefaultNumHashPtns = iHashPartitionsNum;
        this.m_iDOP = iDOP;
        this.m_szTBS = szTBS;
        this.m_szTBSSet = szTBSSet;
        if (this.isShardingDb() && this.m_szTBSSet == null) {
            throw new OraclePropertyGraphException("Tablespace set cannot be NULL when using a sharding DB");
        }
        if (this.isShardingDb()) {
            ms_log.debug((Object)"constructor: a sharding db, make sure to alter session enable shard ddl");
            PreparedStatement ps = null;
            try {
                ps = this.getOracle().getConnection().prepareStatement("alter session enable shard ddl");
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                    ps = null;
                }
            }
        }
        this.m_szOptions = szOptions != null ? szOptions : " ";
        if (ms_log.isDebugEnabled()) {
            int iCounter = ms_aiInstances.addAndGet(1);
            ms_log.debug((Object)("OraclePropertyGraph: constructor : # [" + iCounter + "] graph name " + szGraphName + " , iHashPartitionsNum " + iHashPartitionsNum + " , iDOP " + iDOP + " , szTBS " + szTBS + " , szTBSSet " + szTBSSet + " , bShardingDb " + this.isShardingDb() + " , szOptions " + szOptions));
        }
        this.init();
    }

    private void init() throws SQLException {
        this.initTableNames();
        this.initIndexNames();
        this.createInternalStructureObjects();
        this.createGraphTables(false, this.isShardingDb());
        this.initStatements();
        this.m_vertexCache = VertexCache.getInstance((OraclePropertyGraphBase)this);
        this.m_edgeCache = EdgeCache.getInstance((OraclePropertyGraphBase)this);
        this.setNumberToCharSqlFormatString("TM9");
        this.setTimeToCharSqlFormatString("SYYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM");
    }

    private void createInternalStructureObjects() throws SQLException {
        SQLUtils.createInitialProcedure((Connection)this.getOracle().getConnection(), (String)"CREATE OR REPLACE TYPE pnames_array AS TABLE OF NVARCHAR2(3100);");
        SQLUtils.createInitialProcedure((Connection)this.getOracle().getConnection(), (String)"CREATE OR REPLACE TYPE ptypes_array AS TABLE OF NUMBER;");
        SQLUtils.createInitialProcedure((Connection)this.getOracle().getConnection(), (String)"CREATE OR REPLACE TYPE p_strvalues_array AS TABLE OF NVARCHAR2(15000);");
        SQLUtils.createInitialProcedure((Connection)this.getOracle().getConnection(), (String)"CREATE OR REPLACE TYPE p_numvalues_array AS TABLE OF NUMBER;");
    }

    public static OraclePropertyGraph getInstance(Oracle oracle, String szGraphName) throws SQLException {
        ms_log.debug((Object)"getInstance: start");
        OraclePropertyGraph opg = new OraclePropertyGraph(oracle, szGraphName);
        return opg;
    }

    public static OraclePropertyGraph getInstance(Oracle oracle, String owner, String szGraphName) throws SQLException {
        return new OraclePropertyGraph(oracle, owner, szGraphName);
    }

    public static OraclePropertyGraph getInstance(Oracle oracle, String szGraphName, int iHashPartitionsNum) throws SQLException {
        ms_log.debug((Object)"getInstance: start");
        OraclePropertyGraph opg = new OraclePropertyGraph(oracle, szGraphName, iHashPartitionsNum);
        return opg;
    }

    public static OraclePropertyGraph getInstance(Oracle oracle, String szGraphName, int iHashPartitionsNum, int iDOP, String szTBS, String szOptions) throws SQLException {
        ms_log.debug((Object)"getInstance: start");
        OraclePropertyGraph opg = new OraclePropertyGraph(oracle, szGraphName, iHashPartitionsNum, iDOP, szTBS, null, szOptions);
        return opg;
    }

    public static OraclePropertyGraph getInstance(Oracle oracle, String szGraphName, int iHashPartitionsNum, int iDOP, String szTBS, String szTBSSet, String szOptions) throws SQLException {
        ms_log.debug((Object)"getInstance: start");
        OraclePropertyGraph opg = new OraclePropertyGraph(oracle, szGraphName, iHashPartitionsNum, iDOP, szTBS, szTBSSet, szOptions);
        return opg;
    }

    public static OraclePropertyGraph getInstance(Oracle oracle, String szGraphOwner, String szGraphName, int iHashPartitionsNum, int iDOP, String szTBS, String szOptions) throws SQLException {
        ms_log.debug((Object)"getInstance: start");
        OraclePropertyGraph opg = new OraclePropertyGraph(oracle, szGraphOwner, szGraphName, iHashPartitionsNum, iDOP, szTBS, null, szOptions);
        return opg;
    }

    public static OraclePropertyGraph getInstance(Oracle oracle, String szGraphOwner, String szGraphName, int iHashPartitionsNum, int iDOP, String szTBS, String szTBSSet, String szOptions) throws SQLException {
        ms_log.debug((Object)"getInstance: start");
        OraclePropertyGraph opg = new OraclePropertyGraph(oracle, szGraphOwner, szGraphName, iHashPartitionsNum, iDOP, szTBS, szTBSSet, szOptions);
        return opg;
    }

    public static OraclePropertyGraph getInstance(PgRdbmsGraphConfig config) throws SQLException {
        return new OraclePropertyGraph(config);
    }

    public void setVTS(java.sql.Date dateVTS) {
        ms_log.debug((Object)"setVTS: start");
        this.m_dateVTS = dateVTS;
    }

    public void setVTE(java.sql.Date dateVTE) {
        ms_log.debug((Object)"setVTE: start");
        this.m_dateVTE = dateVTE;
    }

    public java.sql.Date getVTS() {
        return this.m_dateVTS;
    }

    public java.sql.Date getVTE() {
        return this.m_dateVTE;
    }

    @Deprecated
    public OracleEdgeBase addEdge(Object id, OracleVertexBase outVertex, OracleVertexBase inVertex, String label) {
        if (ms_log.isDebugEnabled()) {
            if (id == null) {
                ms_log.debug((Object)"addEdge: start with NULL object");
            } else {
                ms_log.debug((Object)"addEdge: start with object id ", (Object)id.toString());
            }
        }
        if (this.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        ++this.m_lCntAddEdge;
        if (this.m_lCntAddEdge % 10000L == 0L && ms_log.isInfoEnabled()) {
            ms_log.info((Object)"addEdge: m_lCntAddEdge ", (Object)Long.toString(this.m_lCntAddEdge));
        }
        Long lID = null;
        try {
            lID = OraclePropertyGraph.getObjectIdIfLongType((Object)id);
        }
        catch (NumberFormatException nef) {
            try {
                String szEdgeInternal = OraclePropertyGraph.getEdgeInternalLabel((Object)id);
                this.m_csGetInternalID.setString(1, szEdgeInternal);
                this.m_csGetInternalID.registerOutParameter(2, 2);
                this.m_csGetInternalID.execute();
                lID = this.m_csGetInternalID.getLong(2);
            }
            catch (SQLException sqle) {
                ms_log.debug((Object)"addEdge: SQLException ", (Throwable)sqle);
                throw new OraclePropertyGraphException((Throwable)sqle);
            }
        }
        OracleEdge e = OracleEdge.getInstance(this, (OracleVertex)outVertex, (OracleVertex)inVertex, label, lID);
        this.addUpdatedEdgeWithIndices(e);
        return e;
    }

    public static void setStmtArgumentForDml(int idx, PreparedStatement ps, String szKey, Object objVa1) throws SQLException, IOException {
        SQLUtils.setStmtArgumentForDml((int)idx, (PreparedStatement)ps, (String)szKey, (Object)objVa1);
    }

    protected void addEdgeInternal(OracleEdgeBase e, boolean updateIndices) throws SQLException, IOException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"addEdgeInternal: start, label ", (Object)e.label());
        }
        Set setDelKeys = e.getDeletedKeys();
        boolean bl = updateIndices = updateIndices && this.getOracleIndexManager().isEdgeAutoIndexerEnabled() && this.getOracleIndexManager().getEdgeAutoIndexer(new Parameter[0]) != null;
        if (updateIndices && setDelKeys != null && setDelKeys.size() > 0) {
            Iterator it = setDelKeys.iterator();
            for (int idx = 0; idx < setDelKeys.size(); ++idx) {
                String szKey = (String)it.next();
                ms_log.debug((Object)"addEdgeInternal: remove K/V property from element in automatic indices");
                this.getOracleIndexManager().removePropertyFromIndices(szKey, (Object)e);
            }
        }
        Set setAddedKeys = e.getAddedKeys();
        if (updateIndices && setAddedKeys != null && setAddedKeys.size() > 0) {
            Iterator it = setAddedKeys.iterator();
            for (int idx = 0; idx < setAddedKeys.size(); ++idx) {
                String szKey = (String)it.next();
                Object objVal = e.property(szKey).value();
                if (!this.getOracleIndexManager().containsIndexedKey(szKey, OracleEdgeBase.class) || this.getOracleIndexManager().getEdgeAutoIndexer(new Parameter[0]) == null) continue;
                this.getOracleIndexManager().getEdgeAutoIndexer(new Parameter[0]).put(szKey, objVal, (OracleElementBase)e);
            }
        }
        OracleCallableStatement cs = this.m_csAddEdge;
        if (ms_bDebug) {
            ms_log.debug((Object)"addEdgeInternal: execute statement string ", (Object)"\n declare towner varchar2(128); vowner varchar2(128); edgetab varchar2(128); vedgetab varchar2(128);\n         s number; svid number; dvid number; el nvarchar2(3100); df nvarchar2(3100); nf nvarchar2(3100); \n         vts date; vte date; pn_array pnames_array; pt_array ptypes_array; pv_array p_strvalues_array;\n         pvn_array p_numvalues_array; vt timestamp(6) with time zone; t number; \n         vn number; k nvarchar2(3100); sql_stmt varchar2(32000); vs nvarchar2(15000);\n begin \n   towner   := :1; \n   edgetab := :2; \n   s   := :4; \n   svid := :5; \n   dvid := :6; \n   el  := :7; \n   nf  := :8; \n   df  := :9; \n   vts := :10; \n   vte := :11; \n   pn_array := :12; \n   pt_array := :13; \n   pv_array := :14; \n   pvn_array := :16; \n   vedgetab := sys.dbms_assert.enquote_name(sys.dbms_assert.qualified_sql_name(edgetab));\n   vowner := sys.dbms_assert.enquote_name(sys.dbms_assert.qualified_sql_name(towner));\n   sql_stmt := 'delete from ' || vowner || '.' || vedgetab || ' where eid = :s '; \n   execute immediate sql_stmt using s; \n     begin \n       if pn_array is NULL or pn_array is empty then \n         sql_stmt := 'insert into ' || vowner || '.' || vedgetab || \n                          ' (eid, SVID, DVID, EL, k, vts, vte)  \n                           values(:s, :svid, :dvid, :el, '' '', :vts, :vte)';\n         execute immediate sql_stmt using s, svid, dvid, el, vts, vte; \n       else \n         for i in pn_array.FIRST .. pn_array.LAST\n           loop \n             t := pt_array(i);\n             if (t = 5) then \n               vt := to_timestamp_tz(pv_array(i), 'YYYY-MM-DD\"T\"HH24:MI:SS.FF3TZR'); \n             else \n               vt := null; \n             end if; \n             vn := pvn_array(i); \n             k  := pn_array(i); \n             case when t in (2,3,4,7,8,9) then vs:= to_char(vn, nf); \n               when t in (5) then \n                 vs:= to_char(vt, df); \n               else vs:= pv_array(i);\n             end case; \n             if (t >= 1) then \n               sql_stmt := 'insert into ' || vowner || '.' || vedgetab || \n                          ' (eid, SVID, DVID, EL, k, t, v, vn, vt, vts, vte)  \n                           values(:s, :svid, :dvid, :el, nvl(:k, '' ''), :t, :vs, :vn, \n                                  :vt, :vts, :vte)';\n               execute immediate sql_stmt using s, svid, dvid, el, k, t, vs, vn, vt, vts, vte; \n             end if;\n           end loop;\n       end if; \n     exception \n       when others then -- need to detect unique key violation \n         raise; \n     end;\n end;");
        }
        this.setInsertEdgeParameters(cs, e);
        cs.addBatch();
        ++this.m_lBatchEdgeInserts;
        if (this.m_lBatchEdgeInserts % (long)this.getBatchSize() == 0L) {
            this.m_csAddEdge.executeBatch();
            this.m_lBatchEdgeInserts = 0L;
        }
    }

    @Deprecated
    public OracleVertexBase addVertexById(Object id) {
        if (ms_log.isDebugEnabled()) {
            if (id == null) {
                ms_log.debug((Object)"addVertex: start with null object id ");
            } else {
                ms_log.debug((Object)"addVertex: start with non-null object id ", (Object)id.toString());
            }
        }
        if (this.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        ++this.m_lCntAddVertex;
        if (this.m_lCntAddVertex % 10000L == 0L && ms_log.isInfoEnabled()) {
            ms_log.info((Object)"addVertex: m_lCntAddVertex ", (Object)Long.toString(this.m_lCntAddVertex));
        }
        Long lID = null;
        try {
            lID = OraclePropertyGraph.getObjectIdIfLongType((Object)id);
        }
        catch (NumberFormatException nfe) {
            try {
                String szVertexInternal = OraclePropertyGraph.getVertexInternalLabel((Object)id);
                this.m_csGetInternalID.setString(1, szVertexInternal);
                this.m_csGetInternalID.registerOutParameter(2, 2);
                this.m_csGetInternalID.execute();
                lID = this.m_csGetInternalID.getLong(2);
            }
            catch (SQLException sqle) {
                ms_log.debug((Object)"addVertex: SQLException ", (Throwable)sqle);
                throw new OraclePropertyGraphException((Throwable)sqle);
            }
        }
        OracleVertex v = OracleVertex.getInstance(this, lID);
        this.addUpdatedVertex(v);
        return v;
    }

    protected void removeVertexInternal(OracleVertexBase v) throws SQLException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"removeVertexInternal: start removing Vertex ", v.id());
        }
        this.m_csDeleteVertex.setLong(1, (Long)v.id());
        this.m_csDeleteVertex.addBatch();
        ++this.m_lBatchVertexDeletes;
        if (this.m_lBatchVertexDeletes % (long)this.getBatchSize() == 0L) {
            this.m_csDeleteVertex.executeBatch();
            this.m_lBatchVertexDeletes = 0L;
        }
        if (ms_bDebug) {
            ms_log.debug((Object)"removeVertex: remove vertex from auto-indices");
        }
        this.getOracleIndexManager().remove((Object)v, false);
    }

    protected void removeEdgeInternal(OracleEdgeBase e) throws SQLException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"removeEdgeInternal: start removing Edge ", e.id());
        }
        this.m_psDeleteEdge.setLong(1, (Long)e.id());
        this.m_psDeleteEdge.addBatch();
        ++this.m_lBatchEdgeDeletes;
        if (this.m_lBatchEdgeDeletes % (long)this.getBatchSize() == 0L) {
            this.m_psDeleteEdge.executeBatch();
            this.m_lBatchEdgeDeletes = 0L;
        }
        if (ms_bDebug) {
            ms_log.debug((Object)"removeVertex: remove edge from auto-indices");
        }
        this.getOracleIndexManager().remove((Object)e, false);
    }

    public void setNumberToCharSqlFormatString(String format) {
        this.m_szNumerToCharSqlFormat = format;
    }

    public String getNumberToCharSqlFormatString() {
        return this.m_szNumerToCharSqlFormat;
    }

    public void setTimeToCharSqlFormatString(String format) {
        this.m_szTimeToCharSqlFormat = format;
    }

    public String getTimeToCharSqlFormatString() {
        return this.m_szTimeToCharSqlFormat;
    }

    protected void addVertexInternal(OracleVertexBase v, boolean updateIndices) throws SQLException, IOException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"addVertexInternal: start with Vertex ", v.id());
        }
        Set setDelKeys = v.getDeletedKeys();
        boolean bl = updateIndices = updateIndices && this.getOracleIndexManager().isVertexAutoIndexerEnabled() && this.getOracleIndexManager().getVertexAutoIndexer(new Parameter[0]) != null;
        if (updateIndices && setDelKeys != null && setDelKeys.size() > 0) {
            Iterator it = setDelKeys.iterator();
            for (int idx = 0; idx < setDelKeys.size(); ++idx) {
                String szKey = (String)it.next();
                ms_log.debug((Object)"addVertexInternal: remove K/V property from element in automatic indices");
                this.getOracleIndexManager().removePropertyFromIndices(szKey, (Object)v);
            }
        }
        Set setAddedKeys = v.getAddedKeys();
        if (updateIndices && setAddedKeys != null && setAddedKeys.size() > 0) {
            Iterator it = setAddedKeys.iterator();
            for (int idx = 0; idx < setAddedKeys.size(); ++idx) {
                String szKey = (String)it.next();
                Object objVal = v.property(szKey).value();
                if (!this.getOracleIndexManager().containsIndexedKey(szKey, OracleVertexBase.class) || this.getOracleIndexManager().getVertexAutoIndexer(new Parameter[0]) == null) continue;
                this.getOracleIndexManager().getVertexAutoIndexer(new Parameter[0]).put(szKey, objVal, (OracleElementBase)v);
            }
        }
        OracleCallableStatement cs = this.m_csAddVertex;
        if (ms_bDebug) {
            ms_log.debug((Object)"addVertexInternal: execute statement string ", (Object)"\n declare towner varchar2(128); vowner varchar2(128); vertextab varchar2(128); vvertextab varchar2(128);\n         s number; vl nvarchar2(3100); df nvarchar2(3100); nf nvarchar2(3100); vs nvarchar2(15000);\n         vts date; vte date; pn_array pnames_array; pt_array ptypes_array; pv_array p_strvalues_array;\n         pvn_array p_numvalues_array; vl_str nvarchar2(200); vl_val_str nvarchar2(200); \n         vt timestamp(6) with time zone; populate_vl number; t number; vn number;  k nvarchar2(3100);\n         sql_stmt varchar2(32000); \n begin \n   towner   := :1; \n   vertextab := :2; \n   populate_vl := :3; \n   s   := :4; \n   vl  := :5; \n   nf  := :6; \n   df  := :7; \n   vts := :8; \n   vte := :9; \n   pn_array := :10; \n   pt_array := :11; \n   pv_array := :12; \n   pvn_array := :13; \n   vl_str := ''; \n   vl_val_str := ''; \n   if (populate_vl = 1) then \n     vl_str := 'vl,'; \n     vl_val_str := ':vl,'; \n   end if; \n   vvertextab := sys.dbms_assert.enquote_name(sys.dbms_assert.qualified_sql_name(vertextab));\n   vowner := sys.dbms_assert.enquote_name(sys.dbms_assert.qualified_sql_name(towner));\n   sql_stmt := 'delete from ' || vowner || '.' || vvertextab || ' where vid = :s '; \n   execute immediate sql_stmt using s; \n     begin \n       if pn_array is NULL or pn_array is empty then \n         sql_stmt := 'insert into ' || vowner || '.' || vvertextab || \n                          ' (vid, ' || vl_str || ' k, t, v, vn, vt, vts, vte)  \n                           values(:s, ' || vl_val_str || ''' '', null, null, null, null, :vts, :vte)';\n         if (populate_vl = 1) then \n           execute immediate sql_stmt using s, vl, vts, vte; \n         else \n           execute immediate sql_stmt using s, vts, vte; \n         end if;\n       else \n         for i in pn_array.FIRST .. pn_array.LAST\n           loop \n             t := pt_array(i);\n             if (t = 5) then \n               vt := to_timestamp_tz(pv_array(i), 'YYYY-MM-DD\"T\"HH24:MI:SS.FF3TZR'); \n             else \n               vt := null; \n             end if; \n             vn := pvn_array(i); \n             k  := pn_array(i); \n             case when t in (2,3,4,7,8,9) then vs:= to_char(vn, nf); \n               when t in (5) then \n                 vs:= to_char(vt, df); \n               else vs:= pv_array(i);\n             end case; \n             if (t >= 1) then \n               sql_stmt := 'insert into ' || vowner || '.' || vvertextab || \n                          ' (vid, ' || vl_str || ' k, t, v, vn, vt, vts, vte)  \n                           values(:s, ' || vl_val_str || ' nvl(:k, '' ''), :t, :vs, :vn, \n                                  :vt, :vts, :vte)';\n               if (populate_vl = 1) then \n                 execute immediate sql_stmt using s, vl, k, t, vs, vn, vt, vts, vte; \n               else \n                 execute immediate sql_stmt using s, k, t, vs, vn, vt, vts, vte; \n               end if;\n             end if;\n           end loop;\n       end if; \n     exception \n       when others then -- need to detect unique key violation \n         raise; \n     end;\n end;");
        }
        this.setInsertVertexParameters(cs, v);
        cs.addBatch();
        ++this.m_lBatchVertexInserts;
        if (this.m_lBatchVertexInserts % (long)this.getBatchSize() == 0L) {
            this.m_csAddVertex.executeBatch();
            this.m_lBatchVertexInserts = 0L;
        }
    }

    public int getDatabaseMajorVersion() {
        try {
            if (this.dbMajorVersion == -1) {
                this.dbMajorVersion = SQLUtils.getDatabaseMajorVersion((Connection)this.getOracle().getConnection());
            }
            return this.dbMajorVersion;
        }
        catch (SQLException sqle) {
            throw new OraclePropertyGraphException((Throwable)sqle);
        }
    }

    public String getOpgVersion() {
        try {
            if (this.opgVersion == null) {
                this.opgVersion = SQLUtils.getOpgVersion((Connection)this.getOracle().getConnection());
            }
            return this.opgVersion;
        }
        catch (SQLException sqle) {
            throw new OraclePropertyGraphException((Throwable)sqle);
        }
    }

    public boolean supportVertexLabels() {
        return this.isFeatureSupported(SQLUtils.DbFeature.VERTEX_LABELS);
    }

    public boolean isFeatureSupported(SQLUtils.DbFeature dbFeature) {
        return dbFeature.isSupported(this.getDatabaseMajorVersion(), this.getOpgVersion());
    }

    private void setInsertVertexParameters(OracleCallableStatement cs, OracleVertexBase v) throws SQLException, IOException {
        int idx = 1;
        cs.setString(idx++, this.getGraphOwner());
        cs.setString(idx++, this.m_szVertexTabName);
        cs.setInt(idx++, this.supportVertexLabels() ? 1 : 0);
        cs.setLong(idx++, ((Long)v.id()).longValue());
        String label = null;
        if (this.supportVertexLabels()) {
            label = v.label();
        }
        cs.setString(idx, label);
        cs.setFormOfUse(idx++, (short)2);
        cs.setString(idx++, this.getNumberToCharSqlFormatString());
        cs.setString(idx++, this.getTimeToCharSqlFormatString());
        cs.setDate(idx++, this.getVTS());
        cs.setDate(idx++, this.getVTE());
        Set setKeys = v.keys();
        this.setPropertyParameters((CallableStatement)cs, idx, setKeys, (OracleElementBase)v);
    }

    private void setInsertEdgeParameters(OracleCallableStatement cs, OracleEdgeBase e) throws SQLException, IOException {
        int idx = 1;
        cs.setString(idx++, this.getGraphOwner());
        cs.setString(idx++, this.m_szEdgeTabName);
        cs.setLong(idx++, ((Long)e.id()).longValue());
        cs.setLong(idx++, ((Long)e.outVertex().id()).longValue());
        cs.setLong(idx++, ((Long)e.inVertex().id()).longValue());
        String szEdgeLabel = e.label();
        if (szEdgeLabel != null && szEdgeLabel.isEmpty()) {
            szEdgeLabel = OracleEdge.EMPTY_LBL;
        }
        cs.setString(idx, szEdgeLabel);
        cs.setFormOfUse(idx++, (short)2);
        cs.setString(idx++, this.getNumberToCharSqlFormatString());
        cs.setString(idx++, this.getTimeToCharSqlFormatString());
        cs.setDate(idx++, this.getVTS());
        cs.setDate(idx++, this.getVTE());
        Set setKeys = e.keys();
        this.setPropertyParameters((CallableStatement)cs, idx, setKeys, (OracleElementBase)e);
    }

    protected void setPropertyParameters(CallableStatement cs, int idx, Set<String> setKeys, OracleElementBase e) throws IOException, SQLException {
        int size = setKeys != null ? setKeys.size() : 0;
        String[] propertyNamesAr = new String[size];
        int[] propertyTypesAr = new int[size];
        String[] propertyStrValuesAr = new String[size];
        Object[] propertyNumValuesAr = new Object[size];
        int idxKVS = 0;
        for (String name : setKeys) {
            if (ms_bDebug) {
                ms_log.debug((Object)("setInsertVertexParameters: add property " + name));
            }
            Object value = e.property(name).value();
            propertyNamesAr[idxKVS] = name;
            propertyTypesAr[idxKVS] = OraclePropertyGraphUtils.getPropertyType((Object)value);
            if (OraclePropertyGraphUtils.isNumericValue((int)propertyTypesAr[idxKVS])) {
                propertyNumValuesAr[idxKVS] = value;
                propertyStrValuesAr[idxKVS] = null;
            } else if (OraclePropertyGraphUtils.isDateValue((int)propertyTypesAr[idxKVS])) {
                propertyNumValuesAr[idxKVS] = null;
                propertyStrValuesAr[idxKVS] = this.getSimpleDateFormat().format((Date)value);
            } else {
                String strVal = OraclePropertyGraphUtils.getPropertyValueAsStr((Object)value);
                propertyNumValuesAr[idxKVS] = null;
                propertyStrValuesAr[idxKVS] = strVal;
            }
            ++idxKVS;
        }
        ArrayDescriptor arrPropertyNames = ArrayDescriptor.createDescriptor((String)"PNAMES_ARRAY", (Connection)this.getOracle().getConnection());
        ArrayDescriptor arrPropertyTypes = ArrayDescriptor.createDescriptor((String)"PTYPES_ARRAY", (Connection)this.getOracle().getConnection());
        ArrayDescriptor arrPropertyStrValues = ArrayDescriptor.createDescriptor((String)"P_STRVALUES_ARRAY", (Connection)this.getOracle().getConnection());
        ArrayDescriptor arrPropertyNumValues = ArrayDescriptor.createDescriptor((String)"P_NUMVALUES_ARRAY", (Connection)this.getOracle().getConnection());
        ARRAY propertyNamesArray = new ARRAY(arrPropertyNames, (Connection)this.getOracle().getConnection(), (Object)propertyNamesAr);
        ARRAY propertyTypesArray = new ARRAY(arrPropertyTypes, (Connection)this.getOracle().getConnection(), (Object)propertyTypesAr);
        ARRAY propertyStrValuesArray = new ARRAY(arrPropertyStrValues, (Connection)this.getOracle().getConnection(), (Object)propertyStrValuesAr);
        ARRAY propertyNumValuesArray = new ARRAY(arrPropertyNumValues, (Connection)this.getOracle().getConnection(), (Object)propertyNumValuesAr);
        cs.setArray(idx++, (Array)propertyNamesArray);
        cs.setArray(idx++, (Array)propertyTypesArray);
        cs.setArray(idx++, (Array)propertyStrValuesArray);
        cs.setArray(idx, (Array)propertyNumValuesArray);
    }

    protected OracleVertexBase readVertexFromDB(Long lVID, OracleVertexBase vertexToBeUpdated, boolean skipLucene) throws IOException {
        if (lVID == null) {
            return null;
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"readVertexFromDB: for vid ", (Object)lVID);
        }
        OracleVertex ov = null;
        boolean bTmpPartial = false;
        boolean skipQueue = true;
        if (vertexToBeUpdated != null) {
            bTmpPartial = vertexToBeUpdated.isPartial();
        }
        StringBuilder sbQuery = new StringBuilder();
        sbQuery.append("select ").append(this.getVerticesProjectedVars()).append(" from ").append(this.getVertexTabName()).append(" where VID = ? ");
        try (CallableStatement stmt = this.getOracle().getConnection().prepareCall(sbQuery.toString());){
            stmt.setLong(1, (long)lVID);
            try (ResultSet rs = stmt.executeQuery();){
                int iCount = 0;
                while (rs.next()) {
                    String szLabel;
                    ++iCount;
                    if (ov == null) {
                        ov = vertexToBeUpdated == null ? OracleVertex.getInstance(this, lVID) : (OracleVertex)vertexToBeUpdated;
                        ov.setPartial(false);
                    }
                    int idx = 2;
                    if (this.supportVertexLabels() && (szLabel = rs.getString(idx++)) != null) {
                        if (ms_bDebug) {
                            ms_log.debug((Object)"readVertexFromDB: read label from db, use now ", (Object)szLabel);
                        }
                        ov.setLabel(szLabel, skipQueue, skipLucene);
                    }
                    String szKey = rs.getString(idx++);
                    Object val = OraclePropertyGraph.readObjFromResultSet(rs, idx, this.getTreatTimestampTzAsStr());
                    if (val == null) continue;
                    ov.property(szKey, val, skipQueue, skipLucene);
                }
                if (iCount == 0) {
                    ms_log.debug((Object)"readVertexFromDB: such an vertex ID does not exist");
                }
            }
        }
        catch (IOException | SQLException e) {
            ms_log.debug((Object)"readVertexFromDB:", (Throwable)e);
            if (vertexToBeUpdated != null) {
                vertexToBeUpdated.setPartial(bTmpPartial);
            }
            throw new OraclePropertyGraphException((Throwable)e);
        }
        return ov;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OracleEdgeBase readEdgeFromDB(Long lEID, OracleEdgeBase edgeToBeUpdated, boolean skipLucene) throws IOException {
        if (lEID == null) {
            return null;
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"readEdgeFromDB: for eid ", (Object)lEID);
        }
        ResultSet rs = null;
        CallableStatement stmt = null;
        OracleEdge e = null;
        boolean bTmpPartial = false;
        if (edgeToBeUpdated != null) {
            bTmpPartial = edgeToBeUpdated.isPartial();
        }
        try {
            String szQuery = "select SVID,DVID,el,k,t,v,vn," + this.processVT("vt") + ",vts,vte from " + this.getEdgeTabName() + " where EID = ?";
            stmt = this.getOracle().getConnection().prepareCall(szQuery);
            stmt.setLong(1, (long)lEID);
            rs = stmt.executeQuery();
            int iCount = 0;
            while (rs.next()) {
                ++iCount;
                Long lIID = rs.getLong(1);
                Long lOID = rs.getLong(2);
                String szEdgeLabel = rs.getString(3);
                if (szEdgeLabel != null && szEdgeLabel.equals(OracleEdge.EMPTY_LBL)) {
                    szEdgeLabel = "";
                }
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"readEdgeFromDB: read row from DB eid = ", (Object)(lEID + " , IID " + lIID + ", lOID " + lOID + ", EL -------"));
                }
                OracleVertex outVertex = null;
                OracleVertex inVertex = null;
                inVertex = OracleVertex.getInstance(this, lOID);
                outVertex = OracleVertex.getInstance(this, lIID);
                if (e == null) {
                    ms_log.debug((Object)"readEdgeFromDB: create edge instance");
                    if (edgeToBeUpdated == null) {
                        e = OracleEdge.getInstance(this, outVertex, inVertex, szEdgeLabel, lEID);
                    } else {
                        e = (OracleEdge)edgeToBeUpdated;
                        e.setLabel(szEdgeLabel, true);
                        e.setInVertex(inVertex);
                        e.setOutVertex(outVertex);
                    }
                    e.setPartial(false);
                }
                String szKey = rs.getString(4);
                Object val = OraclePropertyGraph.readObjFromResultSet(rs, 5, this.getTreatTimestampTzAsStr());
                if (val == null) continue;
                e.property(szKey, val, true, skipLucene);
            }
            if (iCount == 0) {
                ms_log.debug((Object)"readEdgeFromDB: such an edge ID does not exist");
            }
        }
        catch (SQLException sqle) {
            try {
                ms_log.debug((Object)"readEdgeFromDB:", (Throwable)sqle);
                if (edgeToBeUpdated == null) throw new OraclePropertyGraphException((Throwable)sqle);
                edgeToBeUpdated.setPartial(bTmpPartial);
                throw new OraclePropertyGraphException((Throwable)sqle);
                catch (IOException ioe) {
                    ms_log.error((Object)"readEdgeFromDB:", (Throwable)ioe);
                    if (edgeToBeUpdated == null) throw new OraclePropertyGraphException((Throwable)ioe);
                    edgeToBeUpdated.setPartial(bTmpPartial);
                    throw new OraclePropertyGraphException((Throwable)ioe);
                }
            }
            catch (Throwable throwable) {
                ms_log.debug((Object)"readEdgeFromDB: done ");
                OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
                throw throwable;
            }
        }
        ms_log.debug((Object)"readEdgeFromDB: done ");
        OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
        return e;
    }

    public OracleEdge getEdge(Object id) {
        boolean bCreateIfAbsentFromCache;
        OracleEdge e;
        Long lID;
        if (id == null) {
            throw new IllegalArgumentException(MSG_ERR_ID_CANNOT_BE_NULL.toString());
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"getEdge: start: Object id ", (Object)id.toString());
        }
        this.flushUpdates();
        try {
            lID = OraclePropertyGraph.getObjectIdIfLongType((Object)id);
        }
        catch (NumberFormatException nef) {
            try {
                String szEdgeInternal = OraclePropertyGraph.getEdgeInternalLabel((Object)id);
                this.m_csGetInternalID.setString(1, szEdgeInternal);
                this.m_csGetInternalID.registerOutParameter(2, 2);
                this.m_csGetInternalID.execute();
                lID = this.m_csGetInternalID.getLong(2);
            }
            catch (SQLException sqle) {
                ms_log.debug((Object)"getEdge: SQLException ", (Throwable)sqle);
                throw new OraclePropertyGraphException((Throwable)sqle);
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"getEdge: ", (Object)lID);
        }
        if ((e = OracleEdge.getInstance(this, lID, bCreateIfAbsentFromCache = false)) == null) {
            ms_log.debug((Object)"getEdge: read edge from database");
            try {
                e = (OracleEdge)this.readEdgeFromDB(lID);
            }
            catch (Exception exception) {
                throw new OraclePropertyGraphException((Throwable)exception);
            }
        }
        if (e == null) {
            ms_log.debug((Object)"getEdge: done. return null");
        } else {
            ms_log.debug((Object)"getEdge: done. return non null");
        }
        return e;
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesBySCN(Connection[] connArray) {
        return this.edgesBySCN(connArray, true, null);
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesBySCN(Connection[] connArray, boolean bOrderBySVID) {
        return this.edgesBySCN(connArray, bOrderBySVID, null);
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesBySCN(Connection[] connArray, boolean bOrderBySVID, Long longEndSCN) {
        return this.edgesBySCN(connArray, bOrderBySVID, longEndSCN, false, 0);
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesBySCN(Connection[] connArray, boolean bOrderBySVID, Long longEndSCN, boolean bSkipStoreToCache, int iStartPartitionID) {
        return this.edgesBySCN(connArray, bOrderBySVID, longEndSCN, bSkipStoreToCache, iStartPartitionID, (String[])null);
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesBySCN(Connection[] connArray, boolean bOrderBySVID, Long longEndSCN, boolean bSkipStoreToCache, int iStartPartitionID, String key) {
        return this.edgesBySCN(connArray, bOrderBySVID, longEndSCN, bSkipStoreToCache, iStartPartitionID, new String[]{key});
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesBySCN(Connection[] connArray, boolean bOrderBySVID, Long longEndSCN, boolean bSkipStoreToCache, int iStartPartitionID, String[] propertyNames) {
        if (!"false".equals(System.getProperty("oracle.pg.rdbms.usePtn"))) {
            return this.edgesPartitioned(connArray, bOrderBySVID, longEndSCN, bSkipStoreToCache, iStartPartitionID, propertyNames);
        }
        return this.edgesNonPartitioned(connArray, bOrderBySVID, longEndSCN, bSkipStoreToCache, propertyNames);
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesPartitioned(Connection[] connArray, boolean skipStoreToCache, int startPartitionID) {
        return this.edgesPartitioned(connArray, true, null, skipStoreToCache, startPartitionID, null);
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesPartitioned(Connection[] connArray, boolean bSkipStoreToCache, int startPartitionID, EdgeFilterCallback efc, OraclePropertyGraphBase.OptimizationFlag flag) {
        return this.edgesPartitioned(connArray, true, null, bSkipStoreToCache, startPartitionID, null, efc, flag);
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesPartitioned(Connection[] connArray, boolean skipStoreToCache, int startPartitionID, String[] propertyNames) {
        return this.edgesPartitioned(connArray, true, null, skipStoreToCache, startPartitionID, propertyNames);
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesPartitioned(Connection[] connArray, boolean bOrderBySVID, Long longEndSCN, String[] propertyNames) {
        return this.edgesPartitioned(connArray, bOrderBySVID, longEndSCN, false, 0, propertyNames);
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesPartitioned(Connection[] connArray, boolean bOrderBySVID, Long longEndSCN, boolean bSkipStoreToCache, int iStartPartitionID, String[] propertyNames) {
        return this.edgesPartitioned(connArray, bOrderBySVID, longEndSCN, bSkipStoreToCache, iStartPartitionID, propertyNames, this.getEdgeFilterCallback(), this.getDefaultEdgeOptFlag());
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesPartitioned(Connection[] connArray, boolean bOrderBySVID, Long longEndSCN, boolean bSkipStoreToCache, int iStartPartitionID, String[] propertyNames, EdgeFilterCallback efc, OraclePropertyGraphBase.OptimizationFlag flag) {
        ms_log.debug((Object)"edgesPartitioned: [PX] start");
        int iArraySize = connArray.length;
        if (iArraySize < 1) {
            throw new IllegalArgumentException("The connection array size is less than 1");
        }
        this.flushUpdates();
        if (ms_log.isInfoEnabled() && Parameters.getInstance().showProgress()) {
            ms_log.info((Object)("edgesPartitioned: [PX] bSkipStoreToCache " + (bSkipStoreToCache ? "true" : "false")));
        }
        ResultSet[] rsArray = new ResultSet[iArraySize];
        PreparedStatement[] stmtArray = new PreparedStatement[iArraySize];
        Iterator[] iteratorArray = new Iterator[iArraySize];
        int dopPtn = 1;
        if (this.getDefaultDOPPerPtn() > 0 && this.getDefaultDOPPerPtn() < 256) {
            dopPtn *= this.getDefaultDOPPerPtn();
        }
        try {
            boolean isView = this.isVirtualPropertyGraph();
            if (!isView && iArraySize + iStartPartitionID > this.getEdgePartitionsNumber()) {
                iArraySize = this.getEdgePartitionsNumber() - iStartPartitionID;
            }
            rsArray = new ResultSet[iArraySize];
            stmtArray = new PreparedStatement[iArraySize];
            iteratorArray = new Iterator[iArraySize];
            String szProjectedVars = null;
            if (flag == null || efc != null) {
                szProjectedVars = "eid,SVID,DVID,EL,k,t,v,vn," + this.processVT("vt") + ",vts,vte";
            } else if (OraclePropertyGraphBase.OptimizationFlag.DO_NOT_CREATE_OBJECT.equals((Object)flag) || OraclePropertyGraphBase.OptimizationFlag.JUST_EDGE_ID.equals((Object)flag)) {
                szProjectedVars = "distinct eid";
                bOrderBySVID = false;
            } else if (OraclePropertyGraphBase.OptimizationFlag.JUST_VERTEX_EDGE_ID.equals((Object)flag)) {
                szProjectedVars = "distinct eid,SVID,DVID";
            } else if (OraclePropertyGraphBase.OptimizationFlag.JUST_LABEL_EDGE_ID.equals((Object)flag)) {
                szProjectedVars = "distinct eid,EL";
                bOrderBySVID = false;
            } else {
                szProjectedVars = OraclePropertyGraphBase.OptimizationFlag.JUST_LABEL_VERTEX_EDGE_ID.equals((Object)flag) ? "distinct eid,SVID,DVID,EL" : "eid,SVID,DVID,EL,k,t,v,vn," + this.processVT("vt") + ",vts,vte";
            }
            for (int idx = 0; idx < iArraySize; ++idx) {
                try {
                    StringBuilder sbQuery = null;
                    int currentPartition = idx + 1 + iStartPartitionID;
                    int partitionId = Integer.decode(String.valueOf(currentPartition));
                    if (!isView && !this.isShardingDb()) {
                        String indexName = Util.enquoteNameSQLName((Connection)this.getOracle().getConnection(), (String)this.stripSchema(this.getEdgeTabIdxName("UQ")));
                        if (propertyNames != null && propertyNames.length > 0) {
                            sbQuery = new StringBuilder().append("select /*+ INDEX(t ").append(indexName).append(") ").append(" parallel(").append(dopPtn).append(") ").append(" */ ").append(szProjectedVars).append(" from ").append(" ( select * from ").append(this.getEdgeTabName()).append(" partition (p").append(partitionId).append(") ").append(" where user = ? and ( K in (");
                            for (int i = 0; i < propertyNames.length; ++i) {
                                sbQuery.append(" ? ");
                                if (i >= propertyNames.length - 1) continue;
                                sbQuery.append(" , ");
                            }
                            sbQuery.append(" ) )  ");
                            if (longEndSCN != null) {
                                sbQuery.append(" as of scn ").append(longEndSCN);
                            }
                            sbQuery.append(" ) t ");
                        } else {
                            indexName = Util.enquoteNameSQLName((Connection)this.getOracle().getConnection(), (String)this.stripSchema(this.getEdgeTabIdxName("SDE")));
                            sbQuery = new StringBuilder().append("select /*+ INDEX(t ").append(indexName).append(") ").append(" parallel(").append(dopPtn).append(") ").append(" */ ").append(szProjectedVars).append(" from ").append(" ( select * from ").append(this.getEdgeTabName()).append(" partition (p").append(partitionId).append(") ");
                            if (longEndSCN != null) {
                                sbQuery.append(" as of scn ").append(longEndSCN);
                            }
                            sbQuery.append(" ) t ");
                        }
                        if (bOrderBySVID) {
                            if (Parameters.getInstance().orderBySDE()) {
                                sbQuery.append(" order by svid, dvid, eid");
                            } else {
                                sbQuery.append(" order by svid, eid");
                            }
                        } else {
                            sbQuery.append(" order by eid ");
                        }
                    } else {
                        sbQuery = new StringBuilder().append("select ").append(" /*+ parallel(").append(dopPtn).append(") ").append(" */ ").append(szProjectedVars).append(" from ").append(" ( select * from ").append(this.getEdgeTabName());
                        if (longEndSCN != null) {
                            sbQuery.append(" as of scn ").append(longEndSCN);
                        }
                        sbQuery.append(" ) t ");
                        if (propertyNames != null && propertyNames.length > 0) {
                            sbQuery.append("where  mod(EID, ").append(iArraySize).append(")=").append(idx).append(" AND EID in (SELECT EID FROM ").append(this.getEdgeTabName()).append(" where user = ? AND ( K in (");
                            for (int i = 0; i < propertyNames.length; ++i) {
                                sbQuery.append(" ? ");
                                if (i >= propertyNames.length - 1) continue;
                                sbQuery.append(" , ");
                            }
                            sbQuery.append(" ) ) ) ");
                        } else {
                            sbQuery.append(" where mod(EID, ").append(iArraySize).append(")=").append(idx);
                        }
                        if (bOrderBySVID) {
                            if (Parameters.getInstance().orderBySDE()) {
                                sbQuery.append(" order by svid, dvid, eid");
                            } else {
                                sbQuery.append(" order by svid, eid");
                            }
                        } else {
                            sbQuery.append(" order by eid ");
                        }
                    }
                    if (ms_log.isInfoEnabled() && Parameters.getInstance().showProgress()) {
                        ms_log.info((Object)("getEdgesPartitioned: [PQ] query " + idx + " = "), (Object)sbQuery.toString());
                    }
                    stmtArray[idx] = connArray[idx].prepareStatement(sbQuery.toString());
                    ((OraclePreparedStatement)stmtArray[idx]).setRowPrefetch(this.getRowPrefetch());
                    if (ms_log.isInfoEnabled() && Parameters.getInstance().showProgress()) {
                        ms_log.info((Object)("getEdgesPartitioned: [PX] setRowPrefetch " + this.getRowPrefetch()));
                    }
                    if (propertyNames == null || propertyNames.length <= 0) continue;
                    stmtArray[idx].setString(1, this.getOracle().getUsername().toUpperCase());
                    for (int i = 0; i < propertyNames.length; ++i) {
                        ((OraclePreparedStatement)stmtArray[idx]).setFormOfUse(i + 2, (short)2);
                        stmtArray[idx].setString(i + 2, propertyNames[i]);
                    }
                    continue;
                }
                catch (SQLException e) {
                    ms_log.debug((Object)"getEdgesPartitioned:", (Throwable)e);
                    OracleElementIteratorImpl.quietlyCloseStmt(stmtArray[idx]);
                    throw new OraclePropertyGraphException((Throwable)e);
                }
            }
            try {
                rsArray = this.parallelExecuteStatements(stmtArray);
            }
            catch (Exception e) {
                ms_log.error((Object)"getEdgesPartitioned:", (Throwable)e);
                for (int idx = 0; idx < iArraySize; ++idx) {
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rsArray[idx], stmtArray[idx]);
                }
                throw new OraclePropertyGraphException((Throwable)e);
            }
            iteratorArray = this.edgesPartitioned(rsArray, bSkipStoreToCache, efc, flag);
        }
        catch (SQLException e) {
            ms_log.debug((Object)"getEdgesPartitioned:[PX] ", (Throwable)e);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        finally {
            ms_log.debug((Object)"getEdgesPartitioned:[PX]  done .................... ");
        }
        return iteratorArray;
    }

    public ResultSet[] parallelExecuteStatements(PreparedStatement[] stmtArray) {
        int dop = stmtArray.length;
        ResultSet[] rsArray = new ResultSet[dop];
        QueryWorker[] workers = new QueryWorker[dop];
        Thread[] threads = new Thread[dop];
        long lStartTime = 0L;
        if (ms_bShowProgress) {
            lStartTime = System.currentTimeMillis();
        }
        try {
            int i;
            for (i = 0; i < dop; ++i) {
                workers[i] = new QueryWorker(stmtArray[i]);
                threads[i] = new Thread(workers[i]);
                threads[i].start();
            }
            for (i = 0; i < dop; ++i) {
                threads[i].join();
                rsArray[i] = workers[i].getResultSet();
            }
            if (ms_bShowProgress) {
                ms_log.info((Object)("parallelExecuteStatements: executed operation in (ms) " + (System.currentTimeMillis() - lStartTime)));
            }
        }
        catch (Exception e) {
            ms_log.error((Object)"parallelExecuteStatements: operation not completed, exception is ", (Throwable)e);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        return rsArray;
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesPartitioned(ResultSet[] rsArray, boolean bSkipStoreToCache, EdgeFilterCallback efc, OraclePropertyGraphBase.OptimizationFlag flag) {
        int idx;
        ms_log.debug((Object)"edgesPartitioned: [PX] ResultSet start");
        int iArraySize = rsArray.length;
        if (iArraySize < 1) {
            throw new IllegalArgumentException("The ResultSet array size is less than 1");
        }
        this.flushUpdates();
        Iterator[] iteratorArray = new Iterator[iArraySize];
        AtomicLong[] atomicLongArray = new AtomicLong[iArraySize];
        OraclePropertyGraph[] opgs = new OraclePropertyGraph[iArraySize];
        for (idx = 0; idx < iArraySize; ++idx) {
            atomicLongArray[idx] = new AtomicLong(1 + iArraySize);
        }
        for (idx = 0; idx < iArraySize; ++idx) {
            try {
                Connection conn = rsArray[idx].getStatement().getConnection();
                opgs[idx] = OraclePropertyGraph.getInstance(new Oracle((OracleConnection)conn), this.getGraphOwner(), this.getGraphName(), this.getDefaultNumHashPtns(), this.getDDLDOP(), this.getTablespace(), this.getTablespaceSet(), this.getOptions());
                opgs[idx].treatTimestampTzAsStr(this.getTreatTimestampTzAsStr());
                opgs[idx].setTransientPropertyGraphInstance(true);
                if (efc != null) {
                    OracleEdgeIteratorImpl iter = new OracleEdgeIteratorImpl(opgs[idx], rsArray[idx], null, this.getQueryFetchSize(), bSkipStoreToCache, atomicLongArray, idx);
                    iteratorArray[idx] = new OracleEdgeFilterIteratorImpl(iter, efc, flag);
                    continue;
                }
                iteratorArray[idx] = new OracleEdgeIteratorImpl(opgs[idx], rsArray[idx], flag, this.getQueryFetchSize(), bSkipStoreToCache, atomicLongArray, idx);
                continue;
            }
            catch (SQLException e) {
                ms_log.debug((Object)"getEdges:[PX] ResultSet ", (Throwable)e);
                OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rsArray[idx]);
                throw new OraclePropertyGraphException((Throwable)e);
            }
        }
        return iteratorArray;
    }

    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesNonPartitioned(Connection[] connArray, boolean bOrderBySVID, Long longEndSCN, String[] propertyNames) {
        return this.edgesNonPartitioned(connArray, bOrderBySVID, longEndSCN, false, propertyNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Iterator<OracleEdgeBase>[] edgesNonPartitioned(Connection[] connArray, boolean bOrderBySVID, Long longEndSCN, boolean bSkipStoreToCache, String[] propertyNames) {
        ms_log.debug((Object)"edgesNonPartitioned: [PX] start");
        int iArraySize = connArray.length;
        if (iArraySize < 1) {
            throw new IllegalArgumentException("The connection array size is less than 1");
        }
        this.flushUpdates();
        ResultSet[] rsArray = new ResultSet[iArraySize];
        PreparedStatement[] stmtArray = new PreparedStatement[iArraySize];
        OracleEdgeIteratorImpl[] iteratorArray = new OracleEdgeIteratorImpl[iArraySize];
        try {
            for (int idx = 0; idx < iArraySize; ++idx) {
                try {
                    int i;
                    StringBuilder sbQuery = new StringBuilder();
                    boolean bUseIndexHint = true;
                    if (bUseIndexHint) {
                        sbQuery.append("select /*+       BEGIN_OUTLINE_DATA INDEX(@\"SEL$1\" \"T\"@\"SEL$1\" (\"").append(this.getEdgeTabName().toUpperCase()).append("\".\"SVID\" \"").append(this.getEdgeTabName().toUpperCase()).append("\".\"EID\")) OUTLINE_LEAF(@\"SEL$1\") ALL_ROWS DB_VERSION('12.1.0.1') OPTIMIZER_FEATURES_ENABLE('12.1.0.1') IGNORE_OPTIM_EMBEDDED_HINTS END_OUTLINE_DATA ").append(this.getDOPStmt(this.getSessionQueryDOP())).append(" */ ");
                    } else {
                        sbQuery.append("select /*+ SKIP_OUTLINE */");
                    }
                    sbQuery.append(" eid,SVID,DVID,EL,k,t,v,vn," + this.processVT("vt") + ",vts,vte from ").append(this.getEdgeTabName());
                    if (longEndSCN != null) {
                        sbQuery.append(" as of scn ").append(longEndSCN);
                    }
                    sbQuery.append(" t ");
                    sbQuery.append(" where mod(abs(eid),").append(iArraySize).append(" )=").append(idx);
                    if (propertyNames != null && propertyNames.length > 0) {
                        sbQuery.append(" and EID in (SELECT EID FROM ").append(this.getEdgeTabName()).append(" where ( K in (");
                        for (i = 0; i < propertyNames.length; ++i) {
                            sbQuery.append(" ? ");
                            if (i >= propertyNames.length - 1) continue;
                            sbQuery.append(" , ");
                        }
                        sbQuery.append(" ) ) ) ");
                    }
                    if (bOrderBySVID) {
                        if (Parameters.getInstance().orderBySDE()) {
                            sbQuery.append(" order by svid, dvid, eid");
                        } else {
                            sbQuery.append(" order by svid, eid");
                        }
                    } else {
                        sbQuery.append(" order by eid ");
                    }
                    if (ms_log.isInfoEnabled() && Parameters.getInstance().showProgress()) {
                        ms_log.info((Object)("getEdges: [PQ] query " + idx + " = "), (Object)sbQuery.toString());
                    }
                    stmtArray[idx] = connArray[idx].prepareStatement(sbQuery.toString());
                    if (propertyNames != null && propertyNames.length > 0) {
                        for (i = 0; i < propertyNames.length; ++i) {
                            ((OraclePreparedStatement)stmtArray[idx]).setFormOfUse(i + 1, (short)2);
                            stmtArray[idx].setString(i + 1, propertyNames[i]);
                        }
                    }
                    rsArray[idx] = stmtArray[idx].executeQuery();
                    iteratorArray[idx] = new OracleEdgeIteratorImpl(this, rsArray[idx], this.getDefaultEdgeOptFlag());
                    iteratorArray[idx].setSkipStoreToCache(bSkipStoreToCache);
                    iteratorArray[idx].setQueryFetchSize(this.getQueryFetchSize());
                    continue;
                }
                catch (SQLException e) {
                    ms_log.debug((Object)"getEdges:", (Throwable)e);
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rsArray[idx], stmtArray[idx]);
                    throw new OraclePropertyGraphException((Throwable)e);
                }
            }
        }
        finally {
            ms_log.debug((Object)"getEdges: done .................... ");
        }
        return iteratorArray;
    }

    String getDOPStmt(int dop) {
        StringBuilder sbQuery = new StringBuilder().append("parallel");
        if (dop != 0) {
            sbQuery.append("(").append(dop).append(")");
        }
        return sbQuery.toString();
    }

    @Deprecated
    public Iterator<OracleEdgeBase> edges() {
        return this.sortedEdges(true);
    }

    @Deprecated
    public Iterator<OracleEdgeBase> edgesBySCN(Long longEndSCN) {
        return this.edgesBySCN(true, longEndSCN);
    }

    @Deprecated
    public Iterator<OracleEdgeBase> sortedEdges(boolean bOrderBySVID) {
        return this.edgesBySCN(bOrderBySVID, null);
    }

    @Deprecated
    public Iterator<OracleEdgeBase> edgesBySCN(boolean bOrderBySVID, Long longEndSCN) {
        return this.edgesBySCN(bOrderBySVID, longEndSCN, (String[])null, this.getEdgeFilterCallback(), this.getDefaultEdgeOptFlag());
    }

    @Deprecated
    public Iterator<OracleEdgeBase> edgesByPropertyKey(String[] propertyNames, EdgeFilterCallback efc, OraclePropertyGraphBase.OptimizationFlag flag) {
        return this.edgesBySCN(true, null, propertyNames, efc, flag);
    }

    @Deprecated
    public Iterator<OracleEdgeBase> edgesFromResultSet(ResultSet rs, EdgeFilterCallback efc, OraclePropertyGraphBase.OptimizationFlag flag) {
        ms_log.debug((Object)"getEdges: with result set started");
        try {
            if (efc != null) {
                OracleEdgeIteratorImpl iterator = new OracleEdgeIteratorImpl(this, rs, null, this.getQueryFetchSize());
                OracleEdgeFilterIteratorImpl oracleEdgeFilterIteratorImpl = new OracleEdgeFilterIteratorImpl(iterator, efc, flag);
                return oracleEdgeFilterIteratorImpl;
            }
            OracleEdgeIteratorImpl iterator = new OracleEdgeIteratorImpl(this, rs, flag, this.getQueryFetchSize());
            return iterator;
        }
        catch (SQLException e) {
            ms_log.debug((Object)"getEdges:", (Throwable)e);
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        finally {
            ms_log.debug((Object)"getEdges: done .................... ");
        }
    }

    @Deprecated
    public Iterator<OracleEdgeBase> edgesBySCN(boolean bOrderBySVID, Long longEndSCN, String[] propertyNames, EdgeFilterCallback efc, OraclePropertyGraphBase.OptimizationFlag flag) {
        ms_log.debug((Object)"edgesBySCN: start");
        this.flushUpdates();
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            String szProjectedVars = null;
            if (flag == null || efc != null) {
                szProjectedVars = "eid,SVID,DVID,EL,k,t,v,vn," + this.processVT("vt") + ",vts,vte";
            } else if (OraclePropertyGraphBase.OptimizationFlag.DO_NOT_CREATE_OBJECT.equals((Object)flag) || OraclePropertyGraphBase.OptimizationFlag.JUST_EDGE_ID.equals((Object)flag)) {
                szProjectedVars = "distinct eid";
                bOrderBySVID = false;
            } else if (OraclePropertyGraphBase.OptimizationFlag.JUST_VERTEX_EDGE_ID.equals((Object)flag)) {
                szProjectedVars = "distinct eid,SVID,DVID";
            } else if (OraclePropertyGraphBase.OptimizationFlag.JUST_LABEL_EDGE_ID.equals((Object)flag)) {
                szProjectedVars = "distinct eid,EL";
                bOrderBySVID = false;
            } else {
                szProjectedVars = OraclePropertyGraphBase.OptimizationFlag.JUST_LABEL_VERTEX_EDGE_ID.equals((Object)flag) ? "distinct eid,SVID,DVID,EL" : "eid,SVID,DVID,EL,k,t,v,vn," + this.processVT("vt") + ",vts,vte";
            }
            boolean isView = this.isVirtualPropertyGraph();
            StringBuilder sbQuery = new StringBuilder("select ");
            String indexName = Util.enquoteNameSQLName((Connection)this.getOracle().getConnection(), (String)this.stripSchema(this.getEdgeTabIdxName("SDE")));
            if (!isView) {
                sbQuery.append(" /*+ INDEX(t ").append(indexName).append(") ").append(" */ ");
            }
            sbQuery.append(szProjectedVars).append(" from ").append(this.getEdgeTabName());
            if (longEndSCN != null) {
                sbQuery.append(" as of scn ").append(longEndSCN);
            }
            if (propertyNames != null && propertyNames.length > 0) {
                boolean bKeyContainsStar = false;
                sbQuery.append(" where EID in (SELECT EID FROM ").append(this.getEdgeTabName()).append(" where ( K in (");
                for (int i = 0; i < propertyNames.length; ++i) {
                    if ("*".equals(propertyNames[i])) {
                        bKeyContainsStar = true;
                    }
                    sbQuery.append(" ? ");
                    if (i >= propertyNames.length - 1) continue;
                    sbQuery.append(" , ");
                }
                sbQuery.append(" ) ");
                if (bKeyContainsStar) {
                    sbQuery.append(" or 1=1 ");
                }
                sbQuery.append(" ) ) ");
            }
            if (bOrderBySVID) {
                if (Parameters.getInstance().orderBySDE()) {
                    sbQuery.append(" order by svid, dvid, eid");
                } else {
                    sbQuery.append(" order by svid, eid");
                }
            } else {
                sbQuery.append(" order by eid ");
            }
            if (ms_log.isInfoEnabled() && Parameters.getInstance().showProgress()) {
                ms_log.info((Object)"getEdges: query ", (Object)sbQuery.toString());
            }
            stmt = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
            if (propertyNames != null && propertyNames.length > 0) {
                for (int i = 0; i < propertyNames.length; ++i) {
                    ((OraclePreparedStatement)stmt).setFormOfUse(i + 1, (short)2);
                    stmt.setString(i + 1, propertyNames[i]);
                }
            }
            rs = stmt.executeQuery();
            Iterator<OracleEdgeBase> iterator = this.edgesFromResultSet(rs, efc, flag);
            return iterator;
        }
        catch (SQLException e) {
            ms_log.debug((Object)"getEdges:", (Throwable)e);
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        finally {
            ms_log.debug((Object)"getEdges: done .................... ");
        }
    }

    private void appendQueryForGet(StringBuilder sbQuery, Object value, String szMarker, boolean acceptWildcard) {
        if (value instanceof String) {
            if (acceptWildcard) {
                sbQuery.append("V like ? and T=");
                sbQuery.append(1);
            } else {
                sbQuery.append("V=? and T=");
                sbQuery.append(1);
            }
        } else if (value instanceof Float) {
            sbQuery.append("VN=? and T=").append(3);
        } else if (value instanceof Integer) {
            sbQuery.append("VN=? and T=").append(2);
        } else if (value instanceof Double) {
            sbQuery.append("VN=? and T=").append(4);
        } else if (value instanceof Long) {
            sbQuery.append("VN=? and T=").append(7);
        } else if (value instanceof Short) {
            sbQuery.append("VN=? and T=").append(8);
        } else if (value instanceof Byte) {
            sbQuery.append("VN=? and T=").append(9);
        } else if (value instanceof Character) {
            sbQuery.append("V=? and T=").append(10);
        } else if (value instanceof Date) {
            sbQuery.append("VT=? and T=").append(5);
        } else if (value instanceof Boolean) {
            sbQuery.append("V=? and T=").append(6);
        } else if (value instanceof SimpleSpatialDataWrapper) {
            sbQuery.append("V=? and T=").append(20);
        } else if (value instanceof SimpleRdfDataWrapper) {
            sbQuery.append("V=? and T=").append(30);
        } else if (value instanceof SimpleJsonDataWrapper) {
            sbQuery.append("V=? and T=").append(25);
        } else if (value instanceof Serializable) {
            sbQuery.append("V=? and T=").append(101);
        } else {
            throw new OraclePropertyGraphException(szMarker + ": TODO  unsupported type. " + value.getClass().getName());
        }
    }

    private void setStmtArgumentForGet(PreparedStatement ps, Object value, int iPos, String szMarker) throws SQLException, IOException {
        if (value instanceof String) {
            ((OraclePreparedStatement)ps).setFormOfUse(iPos, (short)2);
            ps.setString(iPos, (String)value);
        } else if (value instanceof Float) {
            ps.setFloat(iPos, ((Float)value).floatValue());
        } else if (value instanceof Integer) {
            ps.setInt(iPos, (Integer)value);
        } else if (value instanceof Double) {
            ps.setDouble(iPos, (Double)value);
        } else if (value instanceof Long) {
            ps.setLong(iPos, (Long)value);
        } else if (value instanceof Short) {
            ps.setShort(iPos, (Short)value);
        } else if (value instanceof Byte) {
            ps.setByte(iPos, (Byte)value);
        } else if (value instanceof Character) {
            ps.setString(iPos, String.valueOf((Character)value));
        } else if (value instanceof Date) {
            ps.setTimestamp(iPos, new Timestamp(((Date)value).getTime()));
        } else if (value instanceof Boolean) {
            ps.setString(iPos, (Boolean)value != false ? "Y" : "N");
        } else if (value instanceof SimpleSpatialDataWrapper) {
            ((OraclePreparedStatement)ps).setFormOfUse(iPos, (short)2);
            ps.setString(iPos, ((SimpleSpatialDataWrapper)value).serialize());
        } else if (value instanceof SimpleJsonDataWrapper) {
            ((OraclePreparedStatement)ps).setFormOfUse(iPos, (short)2);
            ps.setString(iPos, ((SimpleJsonDataWrapper)value).serialize());
        } else if (value instanceof SimpleRdfDataWrapper) {
            ((OraclePreparedStatement)ps).setFormOfUse(iPos, (short)2);
            ps.setString(iPos, ((SimpleRdfDataWrapper)value).serialize());
        } else if (value instanceof Serializable) {
            ((OraclePreparedStatement)ps).setFormOfUse(iPos, (short)2);
            ps.setString(iPos, OraclePropertyGraph.serializableToStr((Serializable)((Serializable)value)));
        } else {
            throw new OraclePropertyGraphException(szMarker + ": TODO  unsupported type. " + value.getClass().getName());
        }
    }

    @Deprecated
    public Iterator<OracleEdgeBase> edgesByProperty(String key, Object value, Class dtClass, boolean acceptWildcard, boolean useLuceneSyntax) {
        if (key == null) {
            throw new OraclePropertyGraphException("Key cannot be set to null");
        }
        this.flushUpdates();
        if (acceptWildcard && this.isSkipRefreshIndicesEnabled()) {
            ms_log.debug((Object)"edgesByProperty: using wildcards, refresh indices if not done before");
            this.getOracleIndexManager().refreshIndicesCache();
        }
        if (this.isEdgeAutoIndexEnabled(key)) {
            if (ms_bDebug) {
                ms_log.info((Object)"edgesByProperty: get edges from edge auto index");
            }
            if (useLuceneSyntax) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"edgesByProperty: get edges from edge auto index");
                }
                this.getOracleIndexManager().getEdgeAutoIndexer(new Parameter[0]).commit();
                return this.getOracleIndexManager().getEdgeAutoIndexer(new Parameter[0]).get(key, value, dtClass, acceptWildcard);
            }
            if (ms_bDebug) {
                ms_log.debug((Object)"edgesByProperty: value in Oracle syntax, use Oracle Database");
            }
        }
        if (useLuceneSyntax) {
            if (ms_bDebug) {
                ms_log.debug((Object)"edgesByProperty: query in Lucene syntax without automatic index enabled");
            }
            throw new OraclePropertyGraphException("Cannot execute getEdges operation over database with value using Lucene syntax, indices not enabled");
        }
        ResultSet rs = null;
        PreparedStatement ps = null;
        if (ms_bDebug) {
            ms_log.debug((Object)"edgesByProperty: get edges from database");
        }
        OracleEdgeIteratorImpl iterator = null;
        StringBuilder sbQuery = new StringBuilder().append("select eid,SVID,DVID,EL,k,t,v,vn," + this.processVT("vt") + ",vts,vte from ").append(this.getEdgeTabName());
        sbQuery.append(" where EID in (SELECT EID FROM ").append(this.getEdgeTabName());
        sbQuery.append(" where k = ? ");
        if (value != null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"edgesByProperty: value is not null, add to query restrictions");
            }
            sbQuery.append(" and ");
            this.appendQueryForGet(sbQuery, value, "edgesByProperty", acceptWildcard);
        }
        sbQuery.append(" ) ");
        sbQuery.append(" order by eid ");
        try {
            ps = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
            ((OraclePreparedStatement)ps).setFormOfUse(1, (short)2);
            ps.setString(1, key);
            if (value != null) {
                if (ms_bDebug) {
                    ms_log.debug((Object)"edgesByProperty: value is not null, add values to match");
                }
                this.setStmtArgumentForGet(ps, value, 2, "getEdges");
            }
            rs = ps.executeQuery();
            iterator = new OracleEdgeIteratorImpl(this, rs, this.getDefaultEdgeOptFlag());
            iterator.setQueryFetchSize(this.getQueryFetchSize());
        }
        catch (SQLException e) {
            ms_log.debug((Object)"edgesByProperty: ", (Throwable)e);
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, ps);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        catch (IOException e) {
            ms_log.error((Object)"edgesByProperty:", (Throwable)e);
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, ps);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        finally {
            ms_log.debug((Object)"edgesByProperty: done .................... ");
        }
        return iterator;
    }

    @Deprecated
    public OracleVertex getVertex(Object id) {
        boolean bCreateIfAbsentFromCache;
        OracleVertex v;
        Long lID;
        if (id == null) {
            throw new IllegalArgumentException(MSG_ERR_ID_CANNOT_BE_NULL.toString());
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"getVertex: start: Object id ", (Object)(id.toString() + ", type " + id.getClass().getName()));
        }
        this.flushUpdates();
        try {
            lID = OraclePropertyGraph.getObjectIdIfLongType((Object)id);
        }
        catch (NumberFormatException nef) {
            try {
                String szVertexInternal = OraclePropertyGraph.getVertexInternalLabel((Object)id);
                this.m_csGetInternalID.setString(1, szVertexInternal);
                this.m_csGetInternalID.registerOutParameter(2, 2);
                this.m_csGetInternalID.execute();
                lID = this.m_csGetInternalID.getLong(2);
            }
            catch (SQLException sqle) {
                ms_log.debug((Object)"getVertex: SQLException ", (Throwable)sqle);
                throw new OraclePropertyGraphException((Throwable)sqle);
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"getVertex: ", (Object)lID);
        }
        if ((v = OracleVertex.getInstance(this, lID, bCreateIfAbsentFromCache = false)) == null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"getVertex: try get vertex instance from database");
            }
            try {
                v = (OracleVertex)this.readVertexFromDB(lID);
            }
            catch (IOException | ParseException e) {
                throw new OraclePropertyGraphException((Throwable)e);
            }
        } else if (ms_bDebug) {
            ms_log.debug((Object)"getVertex: got instance from cache");
        }
        if (v == null) {
            if (ms_bDebug) {
                ms_log.debug((Object)"getVertex: done. return null");
            }
        } else if (ms_bDebug) {
            ms_log.debug((Object)"getVertex: done. return non null");
        }
        return v;
    }

    public static Object readObjFromResultSet(ResultSet rs, int iIdxTypeCol) throws SQLException, IOException {
        return OraclePropertyGraph.readObjFromResultSet(rs, iIdxTypeCol, Parameters.getInstance().getTreatTimestampTzAsStr());
    }

    public static Object readObjFromResultSet(ResultSet rs, int iIdxTypeCol, boolean bTreatTimestampTzAsStr) throws SQLException, IOException {
        if (ms_bDebug) {
            ms_log.debug((Object)("readObjFromResultSet: started with index " + iIdxTypeCol));
        }
        int iType = rs.getInt(iIdxTypeCol);
        Object val = null;
        if (iType != 0) {
            if (iType == 1) {
                val = rs.getString(iIdxTypeCol + 1);
                if (val == null) {
                    return "";
                }
            } else if (iType == 3) {
                val = Float.valueOf(rs.getFloat(iIdxTypeCol + 2));
                if (((Float)val).floatValue() == 0.0f && rs.wasNull()) {
                    val = null;
                }
            } else if (iType == 2) {
                val = rs.getInt(iIdxTypeCol + 2);
                if ((Integer)val == 0 && rs.wasNull()) {
                    val = null;
                }
            } else if (iType == 4) {
                val = rs.getDouble(iIdxTypeCol + 2);
                if ((Double)val == 0.0 && rs.wasNull()) {
                    val = null;
                }
            } else if (iType == 7) {
                val = rs.getLong(iIdxTypeCol + 2);
                if ((Long)val == 0L && rs.wasNull()) {
                    val = null;
                }
            } else if (iType == 8) {
                val = rs.getShort(iIdxTypeCol + 2);
                if ((Short)val == 0 && rs.wasNull()) {
                    val = null;
                }
            } else if (iType == 9) {
                val = rs.getByte(iIdxTypeCol + 2);
                if ((Byte)val == 0 && rs.wasNull()) {
                    val = null;
                }
            } else if (iType == 10) {
                String s = rs.getString(iIdxTypeCol + 1);
                val = Character.valueOf(s.charAt(0));
            } else if (iType == 6) {
                String s = rs.getString(iIdxTypeCol + 1);
                if (s != null) {
                    val = "Y".equals(s) ? Boolean.TRUE : Boolean.FALSE;
                }
            } else if (iType == 5) {
                val = bTreatTimestampTzAsStr ? rs.getString(iIdxTypeCol + 3) : rs.getTimestamp(iIdxTypeCol + 3);
            } else if (iType == 20) {
                String s = rs.getString(iIdxTypeCol + 1);
                val = SimpleSpatialDataWrapper.getInstance((String)s);
            } else if (iType == 30) {
                String s = rs.getString(iIdxTypeCol + 1);
                val = SimpleRdfDataWrapper.getInstance((String)s);
            } else if (iType == 25) {
                String s = rs.getString(iIdxTypeCol + 1);
                val = SimpleJsonDataWrapper.getInstance((String)s);
            } else if (iType == 101) {
                String s = rs.getString(iIdxTypeCol + 1);
                val = OraclePropertyGraph.strToSerializable((String)s);
            } else {
                throw new OraclePropertyGraphException("readObjFromResultSet: unknown T col value: " + Integer.toString(iType));
            }
        }
        return val;
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesBySCN(Connection[] connArray) {
        return this.verticesBySCN(connArray, null);
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesBySCN(Connection[] connArray, Long longEndSCN) {
        return this.verticesBySCN(connArray, longEndSCN, false, 0);
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesBySCN(Connection[] connArray, Long longEndSCN, boolean bSkipStoreToCache, int iStartPartitionID) {
        return this.verticesBySCN(connArray, longEndSCN, bSkipStoreToCache, iStartPartitionID, (String[])null);
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesBySCN(Connection[] connArray, Long longEndSCN, boolean bSkipStoreToCache, int iStartPartitionID, String key) {
        return this.verticesBySCN(connArray, longEndSCN, bSkipStoreToCache, iStartPartitionID, new String[]{key});
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesBySCN(Connection[] connArray, Long longEndSCN, boolean bSkipStoreToCache, int iStartPartitionID, String[] propertyNames) {
        if (!"false".equals(System.getProperty("oracle.pg.rdbms.usePtn"))) {
            return this.verticesPartitioned(connArray, longEndSCN, bSkipStoreToCache, iStartPartitionID, propertyNames);
        }
        return this.verticesNonPartitioned(connArray, longEndSCN, bSkipStoreToCache, propertyNames);
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesPartitioned(Connection[] connArray, boolean skipStoreToCache, int startPartitionID) {
        return this.verticesPartitioned(connArray, null, skipStoreToCache, startPartitionID, (String[])null);
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesPartitioned(Connection[] connArray, boolean skipStoreToCache, int startPartitionID, String[] propertyNames) {
        return this.verticesPartitioned(connArray, null, skipStoreToCache, startPartitionID, propertyNames);
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesPartitioned(Connection[] connections, boolean bSkipStoreToCache, int startPartitionID, VertexFilterCallback vfc, OraclePropertyGraphBase.OptimizationFlag flag) {
        return this.verticesPartitioned(connections, null, bSkipStoreToCache, startPartitionID, null, vfc, flag);
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesPartitioned(Connection[] connArray, Long longEndSCN, String[] propertyNames) {
        return this.verticesPartitioned(connArray, longEndSCN, false, 0, propertyNames);
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesPartitioned(Connection[] connArray, Long longEndSCN, boolean bSkipStoreToCache, int iStartPartitionID, String[] propertyNames) {
        return this.verticesPartitioned(connArray, longEndSCN, bSkipStoreToCache, iStartPartitionID, propertyNames, this.getVertexFilterCallback());
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesPartitioned(Connection[] connArray, Long longEndSCN, boolean bSkipStoreToCache, int iStartPartitionID, String[] propertyNames, VertexFilterCallback vfc) {
        return this.verticesPartitioned(connArray, longEndSCN, bSkipStoreToCache, iStartPartitionID, propertyNames, vfc, this.getDefaultVertexOptFlag());
    }

    public boolean isVirtualPropertyGraph() {
        try {
            return this.getVertexPartitionsNumberInternal() <= 0;
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    public int getRowPrefetch() {
        return this.m_iRowPrefetch;
    }

    public void setRowPrefetch(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("The prefetch cannot be negative");
        }
        this.m_iRowPrefetch = i;
        ms_log.debug((Object)"setRowPrefetch: m_iRowPrefetch ", (Object)this.m_iRowPrefetch);
    }

    public int getDefaultDOPPerPtn() {
        return this.m_iDefaultDOPPerPtn;
    }

    public void setDefaultDOPPerPtn(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("The DOP cannot be negative");
        }
        this.m_iDefaultDOPPerPtn = i;
        ms_log.debug((Object)"setDefaultDOPPerPtn: m_iDefaultDOPPerPtn ", (Object)this.m_iDefaultDOPPerPtn);
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesPartitioned(Connection[] connArray, Long longEndSCN, boolean bSkipStoreToCache, int iStartPartitionID, String[] propertyNames, VertexFilterCallback vfc, OraclePropertyGraphBase.OptimizationFlag flag) {
        ms_log.debug((Object)"getVerticesPartitioned: [PX] start");
        int iArraySize = connArray.length;
        if (iArraySize < 1) {
            throw new IllegalArgumentException("The connection array size is less than 1");
        }
        this.flushUpdates();
        ResultSet[] rsArray = null;
        PreparedStatement[] stmtArray = null;
        Iterator[] iteratorArray = null;
        int dopPtn = 1;
        if (this.getDefaultDOPPerPtn() > 0 && this.getDefaultDOPPerPtn() < 256) {
            dopPtn = this.getDefaultDOPPerPtn();
        }
        try {
            boolean isView = this.isVirtualPropertyGraph();
            if (!isView && iArraySize + iStartPartitionID > this.getVertexPartitionsNumber()) {
                iArraySize = this.getVertexPartitionsNumber() - iStartPartitionID;
            }
            rsArray = new ResultSet[iArraySize];
            stmtArray = new PreparedStatement[iArraySize];
            iteratorArray = new Iterator[iArraySize];
            String szProjectedVars = null;
            szProjectedVars = vfc != null ? this.getVerticesProjectedVars() : (flag != null && OraclePropertyGraphBase.OptimizationFlag.DO_NOT_CREATE_OBJECT.equals((Object)flag) || OraclePropertyGraphBase.OptimizationFlag.JUST_VERTEX_ID.equals((Object)flag) ? "distinct vid" : this.getVerticesProjectedVars());
            for (int idx = 0; idx < iArraySize; ++idx) {
                try {
                    int i;
                    StringBuilder sbQuery = null;
                    String indexName = Util.enquoteNameSQLName((Connection)this.getOracle().getConnection(), (String)this.stripSchema(this.getVertexTabIdxName("UQ")));
                    if (!isView && !this.isShardingDb()) {
                        if (propertyNames != null && propertyNames.length > 0) {
                            sbQuery = new StringBuilder().append("select /*+ INDEX(t ").append(indexName).append(") ").append(" parallel(").append(dopPtn).append(") ").append(" */ ").append(szProjectedVars).append(" from ").append(" ( select * from ").append(this.getVertexTabName()).append(" partition (p").append(idx + 1 + iStartPartitionID).append(") ").append(" where ( K in (");
                            for (i = 0; i < propertyNames.length; ++i) {
                                sbQuery.append(" ? ");
                                if (i >= propertyNames.length - 1) continue;
                                sbQuery.append(" , ");
                            }
                            sbQuery.append(" ) ) ");
                            if (longEndSCN != null) {
                                sbQuery.append(" as of scn ").append(longEndSCN);
                            }
                            sbQuery.append(" ) t ");
                        } else {
                            sbQuery = new StringBuilder().append("select /*+ INDEX(t ").append(indexName).append(") ").append(" parallel(").append(dopPtn).append(") ").append(" */ ").append(szProjectedVars).append(" from ").append(" ( select * from ").append(this.getVertexTabName()).append(" partition (p").append(idx + 1 + iStartPartitionID).append(") ");
                            if (longEndSCN != null) {
                                sbQuery.append(" as of scn ").append(longEndSCN);
                            }
                            sbQuery.append(" ) t ");
                        }
                        sbQuery.append(" order by vid ");
                    } else {
                        sbQuery = new StringBuilder().append("select ").append(" /*+ parallel(").append(dopPtn).append(") ").append(" */ ").append(szProjectedVars).append(" from ").append(" ( select * from ").append(this.getVertexTabName());
                        if (longEndSCN != null) {
                            sbQuery.append(" as of scn ").append(longEndSCN);
                        }
                        sbQuery.append(" ) t ");
                        if (propertyNames != null && propertyNames.length > 0) {
                            sbQuery.append(" where mod(VID, " + iArraySize + ")=" + idx + " AND VID in (SELECT VID FROM ").append(this.getVertexTabName()).append(" where ( K in (");
                            for (i = 0; i < propertyNames.length; ++i) {
                                sbQuery.append(" ? ");
                                if (i >= propertyNames.length - 1) continue;
                                sbQuery.append(" , ");
                            }
                            sbQuery.append(" ) ) ) ");
                        } else {
                            sbQuery.append(" where mod(VID, " + iArraySize + ")=" + idx);
                        }
                        sbQuery.append(" order by vid ");
                    }
                    stmtArray[idx] = connArray[idx].prepareStatement(sbQuery.toString());
                    if (propertyNames == null || propertyNames.length <= 0) continue;
                    for (i = 0; i < propertyNames.length; ++i) {
                        ((OraclePreparedStatement)stmtArray[idx]).setFormOfUse(i + 1, (short)2);
                        stmtArray[idx].setString(i + 1, propertyNames[i]);
                    }
                    continue;
                }
                catch (SQLException e) {
                    ms_log.debug((Object)"getVertices:[PX] ", (Throwable)e);
                    OracleElementIteratorImpl.quietlyCloseStmt(stmtArray[idx]);
                    throw new OraclePropertyGraphException((Throwable)e);
                }
            }
            try {
                rsArray = this.parallelExecuteStatements(stmtArray);
            }
            catch (Exception e) {
                ms_log.error((Object)"getVerticesPartitioned:", (Throwable)e);
                for (int idx = 0; idx < iArraySize; ++idx) {
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rsArray[idx], stmtArray[idx]);
                }
                throw new OraclePropertyGraphException((Throwable)e);
            }
            iteratorArray = this.verticesPartitioned(rsArray, bSkipStoreToCache, vfc, flag);
        }
        catch (SQLException e) {
            ms_log.debug((Object)"getVertices:[PX] ", (Throwable)e);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        finally {
            ms_log.debug((Object)"getVertices:[PX] done .................... ");
        }
        return iteratorArray;
    }

    public String getVerticesProjectedVars() {
        String projectedVars = null;
        projectedVars = this.supportVertexLabels() ? "vid,vl,k,t,v,vn," : "vid,k,t,v,vn,";
        return projectedVars + this.processVT("vt") + ",vts,vte ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Iterator<OracleVertexBase>[] verticesPartitioned(ResultSet[] rsArray, boolean bSkipStoreToCache, VertexFilterCallback vfc, OraclePropertyGraphBase.OptimizationFlag flag) {
        ms_log.debug((Object)"getVerticesPartitioned: [PX] ResultSet start");
        int iArraySize = rsArray.length;
        if (iArraySize < 1) {
            throw new IllegalArgumentException("The ResultSet array size is less than 1");
        }
        this.flushUpdates();
        Iterator[] iteratorArray = null;
        OraclePropertyGraph[] opgs = null;
        try {
            iteratorArray = new Iterator[iArraySize];
            opgs = new OraclePropertyGraph[iArraySize];
            for (int idx = 0; idx < iArraySize; ++idx) {
                try {
                    Connection conn = rsArray[idx].getStatement().getConnection();
                    opgs[idx] = OraclePropertyGraph.getInstance(new Oracle((OracleConnection)conn), this.getGraphOwner(), this.getGraphName(), this.getDefaultNumHashPtns(), this.getDDLDOP(), this.getTablespace(), this.getTablespaceSet(), this.getOptions());
                    opgs[idx].treatTimestampTzAsStr(this.getTreatTimestampTzAsStr());
                    opgs[idx].setTransientPropertyGraphInstance(true);
                    opgs[idx].setTransientPropertyGraphInstance(true);
                    if (vfc != null) {
                        OracleVertexIteratorImpl iter = new OracleVertexIteratorImpl(opgs[idx], rsArray[idx], null, this.getQueryFetchSize(), bSkipStoreToCache);
                        iteratorArray[idx] = new OracleVertexFilterIteratorImpl(iter, vfc, flag);
                        continue;
                    }
                    iteratorArray[idx] = new OracleVertexIteratorImpl(opgs[idx], rsArray[idx], flag, this.getQueryFetchSize(), bSkipStoreToCache);
                    ((OracleVertexIteratorImpl)((Object)iteratorArray[idx])).setSkipStoreToCache(true);
                    continue;
                }
                catch (SQLException e) {
                    ms_log.debug((Object)"getVertices:[PX] ResultSet ", (Throwable)e);
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rsArray[idx]);
                    throw new OraclePropertyGraphException((Throwable)e);
                }
            }
        }
        finally {
            ms_log.debug((Object)"getVertices:[PX] ResultSet done .................... ");
        }
        return iteratorArray;
    }

    @Deprecated
    public Iterator<OracleVertexBase>[] verticesNonPartitioned(Connection[] connArray, Long longEndSCN, String[] propertyNames) {
        return this.verticesNonPartitioned(connArray, longEndSCN, false, propertyNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Iterator<OracleVertexBase>[] verticesNonPartitioned(Connection[] connArray, Long longEndSCN, boolean bSkipStoreToCache, String[] propertyNames) {
        ms_log.debug((Object)"getVerticesNonPartitioned: [PX] start");
        int iArraySize = connArray.length;
        if (iArraySize < 1) {
            throw new IllegalArgumentException("The connection array size is less than 1");
        }
        this.flushUpdates();
        ResultSet[] rsArray = new ResultSet[iArraySize];
        PreparedStatement[] stmtArray = new PreparedStatement[iArraySize];
        OracleVertexIteratorImpl[] iteratorArray = new OracleVertexIteratorImpl[iArraySize];
        try {
            for (int idx = 0; idx < iArraySize; ++idx) {
                try {
                    int i;
                    StringBuilder sbQuery = new StringBuilder().append("select ").append(this.getVerticesProjectedVars()).append(" from ").append(this.getVertexTabName());
                    if (longEndSCN != null) {
                        sbQuery.append(" as of scn ").append(longEndSCN);
                    }
                    sbQuery.append(" where mod(abs(vid),").append(iArraySize).append(" )=").append(idx);
                    if (propertyNames != null && propertyNames.length > 0) {
                        sbQuery.append(" and VID in (SELECT VID FROM ").append(this.getVertexTabName()).append(" where ( K in (");
                        for (i = 0; i < propertyNames.length; ++i) {
                            sbQuery.append(" ? ");
                            if (i >= propertyNames.length - 1) continue;
                            sbQuery.append(" , ");
                        }
                        sbQuery.append(" ) ) ) ");
                    }
                    sbQuery.append(" order by vid ");
                    if (ms_log.isInfoEnabled() && Parameters.getInstance().showProgress()) {
                        ms_log.info((Object)("getVertices: [PQ] query " + idx + " = "), (Object)sbQuery.toString());
                    }
                    stmtArray[idx] = connArray[idx].prepareStatement(sbQuery.toString());
                    if (propertyNames != null && propertyNames.length > 0) {
                        for (i = 0; i < propertyNames.length; ++i) {
                            ((OraclePreparedStatement)stmtArray[idx]).setFormOfUse(i + 1, (short)2);
                            stmtArray[idx].setString(i + 1, propertyNames[i]);
                        }
                    }
                    rsArray[idx] = stmtArray[idx].executeQuery();
                    iteratorArray[idx] = new OracleVertexIteratorImpl(this, rsArray[idx], this.getDefaultVertexOptFlag());
                    iteratorArray[idx].setSkipStoreToCache(bSkipStoreToCache);
                    iteratorArray[idx].setQueryFetchSize(this.getQueryFetchSize());
                    continue;
                }
                catch (SQLException e) {
                    ms_log.debug((Object)"getVertices:[PX] ", (Throwable)e);
                    OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rsArray[idx], stmtArray[idx]);
                    throw new OraclePropertyGraphException((Throwable)e);
                }
            }
        }
        finally {
            ms_log.debug((Object)"getVertices:[PX] done .................... ");
        }
        return iteratorArray;
    }

    private String getMonitorHint() {
        if (Parameters.getInstance().isSqlMonitor()) {
            return " monitor ";
        }
        return "";
    }

    @Deprecated
    public Iterator<OracleVertexBase> vertices() {
        return this.verticesBySCN((Long)null, (String[])null, this.getVertexFilterCallback(), this.getDefaultVertexOptFlag());
    }

    @Deprecated
    public Iterator<OracleVertexBase> verticesByPropertyKey(String[] propertyNames, VertexFilterCallback vfc, OraclePropertyGraphBase.OptimizationFlag flag) {
        return this.verticesBySCN((Long)null, propertyNames, vfc, flag);
    }

    @Deprecated
    public Iterator<OracleVertexBase> verticesFromResultSet(ResultSet rs, VertexFilterCallback vfc, OraclePropertyGraphBase.OptimizationFlag flag) {
        ms_log.debug((Object)"verticesFromResultSet: with result set start");
        if (rs == null) {
            ms_log.debug((Object)"verticesFromResultSet: result set null");
            return null;
        }
        try {
            if (vfc != null) {
                OracleVertexIteratorImpl iter = new OracleVertexIteratorImpl(this, rs, null, this.getQueryFetchSize());
                OracleVertexFilterIteratorImpl oracleVertexFilterIteratorImpl = new OracleVertexFilterIteratorImpl(iter, vfc, flag);
                return oracleVertexFilterIteratorImpl;
            }
            OracleVertexIteratorImpl iter = new OracleVertexIteratorImpl(this, rs, flag, this.getQueryFetchSize());
            return iter;
        }
        catch (SQLException e) {
            ms_log.debug((Object)"verticesFromResultSet:", (Throwable)e);
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        finally {
            ms_log.debug((Object)"verticesFromResultSet: done .................... ");
        }
    }

    @Deprecated
    public Iterator<OracleVertexBase> verticesBySCN(Long longEndSCN, String[] propertyNames, VertexFilterCallback vfc, OraclePropertyGraphBase.OptimizationFlag flag) {
        ms_log.debug((Object)"verticesBySCN: start");
        this.flushUpdates();
        ResultSet rs = null;
        PreparedStatement stmt = null;
        Iterator<OracleVertexBase> iterator = null;
        try {
            int i;
            String szProjectedVars = null;
            szProjectedVars = vfc != null ? this.getVerticesProjectedVars() : (flag != null && OraclePropertyGraphBase.OptimizationFlag.DO_NOT_CREATE_OBJECT.equals((Object)flag) || OraclePropertyGraphBase.OptimizationFlag.JUST_VERTEX_ID.equals((Object)flag) ? "distinct vid" : this.getVerticesProjectedVars());
            StringBuilder sb = new StringBuilder("select /*+ ").append(this.getMonitorHint());
            boolean isView = this.isVirtualPropertyGraph();
            String indexName = Util.enquoteNameSQLName((Connection)this.getOracle().getConnection(), (String)this.stripSchema(this.getVertexTabIdxName("UQ")));
            if (!isView) {
                sb.append(" INDEX(t ").append(indexName).append(") ");
            }
            sb.append(" */ ").append(szProjectedVars).append(" from ").append(this.getVertexTabName());
            if (longEndSCN != null) {
                sb.append(" as of scn ").append(longEndSCN);
            }
            if (propertyNames != null && propertyNames.length > 0) {
                sb.append(" WHERE VID in (SELECT VID FROM ").append(this.getVertexTabName()).append(" where ( K in (");
                for (i = 0; i < propertyNames.length; ++i) {
                    sb.append(" ? ");
                    if (i >= propertyNames.length - 1) continue;
                    sb.append(" , ");
                }
                sb.append(" ) ) ) ");
            }
            sb.append(" order by vid ");
            if (ms_log.isDebugEnabled()) {
                ms_log.info((Object)"verticesBySCN: query ", (Object)sb.toString());
            }
            stmt = this.m_oracle.getConnection().prepareStatement(sb.toString());
            if (propertyNames != null && propertyNames.length > 0) {
                for (i = 0; i < propertyNames.length; ++i) {
                    ((OraclePreparedStatement)stmt).setFormOfUse(i + 1, (short)2);
                    stmt.setString(i + 1, propertyNames[i]);
                }
            }
            rs = stmt.executeQuery();
            iterator = this.verticesFromResultSet(rs, vfc, flag);
        }
        catch (SQLException e) {
            ms_log.debug((Object)"verticesBySCN:", (Throwable)e);
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, stmt);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        finally {
            ms_log.debug((Object)"getVertices: done .................... ");
        }
        return iterator;
    }

    @Deprecated
    public Iterator<OracleVertexBase> verticesByProperty(String key, Object value, Class dtClass, boolean acceptWildcard, boolean useLuceneSyntax) {
        if (key == null) {
            throw new OraclePropertyGraphException("Key cannot be set to null");
        }
        this.flushUpdates();
        if (acceptWildcard && this.isSkipRefreshIndicesEnabled()) {
            ms_log.debug((Object)"verticesByProperty: using wildcards, refresh indices if not done before");
            this.getOracleIndexManager().refreshIndicesCache();
        }
        if (this.isVertexAutoIndexEnabled(key)) {
            ms_log.info((Object)"verticesByProperty: get vertices from vertex auto index");
            if (useLuceneSyntax) {
                ms_log.debug((Object)"verticesByProperty: get vertices from vertex auto index");
                return this.getOracleIndexManager().getVertexAutoIndexer(new Parameter[0]).get(key, value, dtClass, acceptWildcard);
            }
            ms_log.info((Object)"verticesByProperty: value in Oracle syntax, use Oracle Database");
        }
        if (useLuceneSyntax) {
            ms_log.debug((Object)"verticesByProperty: query in Lucene syntax without automatic index enabled");
            throw new OraclePropertyGraphException("Cannot execute getVertices operation over database with value using Lucene syntax, indices not enabled");
        }
        ms_log.debug((Object)"verticesByProperty: get vertices from database");
        ResultSet rs = null;
        PreparedStatement ps = null;
        OracleVertexIteratorImpl iterator = null;
        try {
            StringBuilder sbQuery = new StringBuilder("select ").append(this.getVerticesProjectedVars()).append(" from ").append(this.getVertexTabName());
            sbQuery.append(" where VID in (SELECT VID FROM ").append(this.getVertexTabName());
            sbQuery.append(" where k = ? ");
            if (value != null) {
                ms_log.debug((Object)"verticesByProperty: value is not null, add to query restrictions");
                sbQuery.append(" and ");
                this.appendQueryForGet(sbQuery, value, "getVertices", acceptWildcard);
            }
            sbQuery.append(" ) ");
            sbQuery.append(" order by vid ");
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"verticesByProperty: query ", (Object)sbQuery.toString());
            }
            ps = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
            ((OraclePreparedStatement)ps).setFormOfUse(1, (short)2);
            ps.setString(1, key);
            if (value != null) {
                ms_log.debug((Object)"verticesByProperty: value is not null, set value to match");
                this.setStmtArgumentForGet(ps, value, 2, "getVertices");
            }
            rs = ps.executeQuery();
            iterator = new OracleVertexIteratorImpl(this, rs, this.getDefaultVertexOptFlag());
            iterator.setQueryFetchSize(this.getQueryFetchSize());
        }
        catch (SQLException e) {
            ms_log.debug((Object)"verticesByProperty:", (Throwable)e);
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, ps);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        catch (IOException e) {
            ms_log.error((Object)"verticesByProperty:", (Throwable)e);
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, ps);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        finally {
            ms_log.debug((Object)"verticesByProperty: done .................... ");
        }
        return iterator;
    }

    @Deprecated
    public void removeEdge(OracleEdgeBase edge) {
        if (edge == null) {
            ms_log.debug((Object)"removeEdge: edge is null. Do nothing.");
            return;
        }
        if (this.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        if (!(edge instanceof OracleEdge)) {
            ms_log.error((Object)"removeEdge: vertex is not of type OracleEdge");
            return;
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"removeEdge: start with edge ", edge.id());
        }
        this.maintainQueue((OracleElementBase)((OracleEdge)edge), OraclePropertyGraphConstants.QueueAction.REMOVE);
        this.m_edgeCache.remove((OracleEdgeBase)((OracleEdge)edge));
    }

    @Deprecated
    public void removeVertex(OracleVertexBase vertex) {
        if (vertex == null) {
            ms_log.debug((Object)"removeVertex: vertex is null. Do nothing.");
            return;
        }
        if (this.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        if (!(vertex instanceof OracleVertex)) {
            ms_log.error((Object)"removeVertex: vertex is not of type OracleVertex");
            return;
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"removeVertex: start with vertex ", vertex.id());
        }
        this.maintainQueue((OracleElementBase)((OracleVertex)vertex), OraclePropertyGraphConstants.QueueAction.REMOVE);
        this.m_vertexCache.remove((OracleVertexBase)((OracleVertex)vertex));
        Iterator<OracleEdgeBase> iter = ((OracleVertex)vertex).edgesNoFlush(Direction.BOTH, null, null);
        if (iter == null) {
            ms_log.debug((Object)"removeVertex: no adjacent edges found");
            return;
        }
        ms_log.debug((Object)"removeVertex: remove adjacent edges from cache");
        while (iter.hasNext()) {
            this.m_edgeCache.remove((OracleEdgeBase)((OracleEdge)iter.next()));
        }
    }

    public void close() {
        ms_log.debug((Object)"close: start");
        if (this.m_bShutdownCalled) {
            ms_log.debug((Object)"close: called before. no op");
            return;
        }
        if (this.m_bDisposed) {
            ms_log.debug((Object)"close: dispose called before. no op");
            return;
        }
        ms_log.debug((Object)"close: start");
        this.commit();
        ms_log.debug((Object)"close: close indices");
        this.getOracleIndexManager().close();
        this.clearCache();
        this.dispose();
        this.m_bShutdownCalled = true;
        ms_log.debug((Object)"close: done");
    }

    public void dispose() {
        ms_log.debug((Object)"dispose: start");
        if (this.m_bDisposed) {
            ms_log.debug((Object)"dispose: called before. no op");
            return;
        }
        ms_log.debug((Object)"dispose: close statements");
        this.closeStatements();
        ms_log.debug((Object)"dispose: clear queue");
        if (this.m_vecElements != null) {
            this.m_vecElements.clear();
        }
        this.getVertexCache().clearCache();
        this.getEdgeCache().clearCache();
        if (this.m_bIsFromGraphConfig) {
            ms_log.debug((Object)"dispose: closing Oracle from graph config");
            try {
                this.getOracle().dispose();
            }
            catch (SQLException ex) {
                throw new OraclePropertyGraphException((Throwable)ex);
            }
        } else {
            ms_log.debug((Object)"dispose: graph not created from config, do not close connection");
        }
        this.m_bDisposed = true;
        ms_log.debug((Object)"dispose: done");
    }

    public void rollback() {
        try {
            ms_log.debug((Object)"rollback: start ");
            this.m_oracle.getConnection().rollback();
        }
        catch (SQLException sqle) {
            ms_log.debug((Object)"rollback: SQLException ", (Throwable)sqle);
            throw new OraclePropertyGraphException((Throwable)sqle);
        }
    }

    public void commit() {
        this.commit(true);
    }

    public void commit(boolean bCommitIndices) {
        if (this.m_bDisposed || this.m_bShutdownCalled) {
            throw new OraclePropertyGraphException("Property Graph is already close");
        }
        try {
            ms_log.debug((Object)"commit: start ");
            long lStartTime = 0L;
            long duration = 0L;
            if (ms_bShowProgress) {
                lStartTime = System.currentTimeMillis();
            }
            ms_log.debug((Object)"commit: refresh indices caches");
            this.getOracleIndexManager().refreshIndicesCache();
            if (ms_bShowProgress) {
                duration = System.currentTimeMillis() - lStartTime;
                ++this.m_lCountRefreshIndicesCall;
                this.m_lTimeSpentInRefreshIndices += duration;
            }
            this.flushUpdates();
            this.m_oracle.getConnection().commit();
            if (bCommitIndices) {
                this.commitIndices();
            }
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 16000) {
                ms_log.debug((Object)"commit: ignore commit problem in READONLY mode");
            }
            ms_log.debug((Object)"commit: SQLException ", (Throwable)sqle);
            throw new OraclePropertyGraphException((Throwable)sqle);
        }
    }

    public String getDistinctVertexTabName() {
        return this.getGraphOwner() + "." + this.m_szDistinctVertexTabName;
    }

    static String getDistinctVertexTabName(Oracle oracle, String szGraphName) throws SQLException {
        try {
            szGraphName = Util.getValidatedGraphName((Connection)oracle.getConnection(), (String)szGraphName);
            return szGraphName + "VD$";
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    public String getDistinctVertexTabNameNoSchema() {
        return this.m_szDistinctVertexTabName;
    }

    public String getSkeletonTabName() {
        return this.getGraphOwner() + "." + this.m_szSkeletonTabName;
    }

    public String getSkeletonTabNameNoSchema() {
        return this.m_szSkeletonTabName;
    }

    static String getSkeletonTabName(Oracle oracle, String szGraphName) throws SQLException {
        try {
            szGraphName = Util.getValidatedGraphName((Connection)oracle.getConnection(), (String)szGraphName);
            return szGraphName + "GT$";
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    static String getEdgeTabName(Oracle oracle, String szGraphName) throws SQLException {
        try {
            szGraphName = Util.getValidatedGraphName((Connection)oracle.getConnection(), (String)szGraphName);
            return szGraphName + "GE$";
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    @Override
    public String getEdgeTabName() {
        try {
            return Util.qualifiedSQLName((Connection)this.getOracle().getConnection(), (String)(this.getGraphOwner() + "." + this.m_szEdgeTabName));
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    public String getEdgeTabNameNoSchema() {
        return this.m_szEdgeTabName;
    }

    public String getSkeletonTabIdxName(String szCode) {
        if ("SDE".equalsIgnoreCase(szCode)) {
            return this.getGraphOwner() + "." + this.m_szXSGIndexName;
        }
        if ("DSE".equalsIgnoreCase(szCode)) {
            return this.getGraphOwner() + "." + this.m_szXDGIndexName;
        }
        if ("UQ".equalsIgnoreCase(szCode)) {
            return this.getGraphOwner() + "." + this.m_szXQGIndexName;
        }
        throw new IllegalArgumentException("getEdgeTabIdxName: code not in (SDE,DSE,UQ)");
    }

    public String getEdgeTabIdxName(String szCode) {
        if ("SDE".equalsIgnoreCase(szCode)) {
            return this.getGraphOwner() + "." + this.m_szXSEIndexName;
        }
        if ("DSE".equalsIgnoreCase(szCode)) {
            return this.getGraphOwner() + "." + this.m_szXDEIndexName;
        }
        if ("UQ".equalsIgnoreCase(szCode)) {
            return this.getGraphOwner() + "." + this.m_szXQEIndexName;
        }
        if ("SP".equalsIgnoreCase(szCode)) {
            return this.getGraphOwner() + "." + this.m_szXEPIndexName;
        }
        throw new IllegalArgumentException("getEdgeTabIdxName: code not in (SDE,DSE,UQ)");
    }

    public String getVertexTabIdxName(String szCode) {
        if ("UQ".equalsIgnoreCase(szCode)) {
            return this.getGraphOwner() + "." + this.m_szXQVIndexName;
        }
        if ("SP".equalsIgnoreCase(szCode)) {
            return this.getGraphOwner() + "." + this.m_szXVPIndexName;
        }
        throw new IllegalArgumentException("getVertexTabIdxName: code not in (UQ)");
    }

    public String getDistinctVertexTabIdxName(String szCode) {
        if ("UQ".equalsIgnoreCase(szCode)) {
            return this.getGraphOwner() + "." + this.m_szXQDIndexName;
        }
        throw new IllegalArgumentException("getVertexTabIdxName: code not in (UQ)");
    }

    static String getTextIndexTabName(Oracle oracle, String szGraphName) {
        try {
            szGraphName = Util.getValidatedGraphName((Connection)oracle.getConnection(), (String)szGraphName);
            return szGraphName + "IT$";
        }
        catch (SQLException ex) {
            throw new OraclePropertyGraphException((Throwable)ex);
        }
    }

    public String getTextIndexTabName() {
        return this.getGraphOwner() + "." + this.m_szIdxMetaTabName;
    }

    static String getSnapshotTabName(Oracle oracle, String szGraphName) throws SQLException {
        try {
            szGraphName = Util.getValidatedGraphName((Connection)oracle.getConnection(), (String)szGraphName);
            return szGraphName + "SS$";
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    public String getSnapshotTabName() {
        return this.getGraphOwner() + "." + this.m_szSnapshotTabName;
    }

    static String getVertexTabName(Oracle oracle, String szGraphName) throws SQLException {
        try {
            szGraphName = Util.getValidatedGraphName((Connection)oracle.getConnection(), (String)szGraphName);
            return szGraphName + "VT$";
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    static String getVertexDistinctTabName(Connection connection, String szGraphName) throws SQLException {
        try {
            szGraphName = Util.getValidatedGraphName((Connection)connection, (String)szGraphName);
            return szGraphName + "VD$";
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    public List<String> getTableNames() {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(this.m_szVertexTabName);
        tables.add(this.m_szEdgeTabName);
        tables.add(this.m_szSkeletonTabName);
        tables.add(this.m_szIdxMetaTabName);
        tables.add(this.m_szSnapshotTabName);
        if (this.isFeatureSupported(SQLUtils.DbFeature.DISTINCT_PG_TABLES)) {
            tables.add(this.m_szDistinctVertexTabName);
        }
        return tables;
    }

    public String getVertexTabName() {
        try {
            return Util.qualifiedSQLName((Connection)this.getOracle().getConnection(), (String)(this.getGraphOwner() + "." + this.m_szVertexTabName));
        }
        catch (SQLException e) {
            throw new OraclePropertyGraphException((Throwable)e);
        }
    }

    public String getVertexTabNameNoSchema() {
        return this.m_szVertexTabName;
    }

    public synchronized void flushUpdates() {
        try {
            if (this.m_vecElements.size() == 0) {
                ms_log.debug((Object)"flushUpdates: no op");
                return;
            }
            super.flushUpdates();
            this.m_csAddVertex.executeBatch();
            this.m_lBatchVertexInserts = 0L;
            this.m_csAddEdge.executeBatch();
            this.m_lBatchEdgeInserts = 0L;
            ((OraclePreparedStatement)this.m_psDeleteEdge).executeBatch();
            this.m_lBatchEdgeDeletes = 0L;
            ((OraclePreparedStatement)this.m_csDeleteVertex).executeBatch();
            this.m_lBatchVertexDeletes = 0L;
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 16000) {
                ms_log.debug((Object)"flushUpdates: ignore flush problem in READONLY mode");
            }
            ms_log.debug((Object)"flushUpdates: SQLException ", (Throwable)sqle);
            throw new OraclePropertyGraphException((Throwable)sqle);
        }
        ms_log.debug((Object)"flushUpdates: done");
    }

    public void clearRepository() throws SQLException {
        ms_log.debug((Object)"clearRepository: start");
        try {
            this.getOracleIndexManager().dropAllIndices();
            ms_log.debug((Object)"clearRepository: external indices removed");
            this.truncateTable(this.getEdgeTabName());
            ms_log.debug((Object)"clearRepository: edge table truncated ");
            this.m_edgeCache.clearCache();
            this.truncateTable(this.getVertexTabName());
            ms_log.debug((Object)"clearRepository: vertex table truncated ");
            this.m_vertexCache.clearCache();
            if (this.isFeatureSupported(SQLUtils.DbFeature.DISTINCT_PG_TABLES)) {
                this.truncateTable(this.getDistinctVertexTabName());
                ms_log.debug((Object)"clearRepository: distinct vertex table truncated ");
            }
            this.truncateTable(this.getSkeletonTabName());
            ms_log.debug((Object)"clearRepository: graph table truncated ");
            this.m_vecElements.clear();
        }
        finally {
            ms_log.debug((Object)"clearRepository: done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncateTable(String tableName) throws SQLException {
        Statement ps = null;
        try {
            String szStmt = "TRUNCATE TABLE " + tableName;
            ps = this.getOracle().getConnection().prepareStatement(szStmt);
            ps.execute();
        }
        finally {
            if (ps != null) {
                ps.close();
                ps = null;
            }
        }
    }

    public void setQueryFetchSize(int size) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"setQueryFetchSize: to new value ", (Object)Integer.toString(size));
        }
        this.queryFetchSize = size;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void createDefaultSpatialIndexOnEdges(int dop) throws SQLException {
        this.createDefaultSpatialIndexOnEdges(dop, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultSpatialIndexOnEdges(int dop, boolean bLocal, boolean bUseV2) throws SQLException {
        PreparedStatement ps = null;
        String szDop = " parallel 1 ";
        if (dop == 0) {
            szDop = " parallel ";
        } else if (dop > 0) {
            szDop = " parallel " + dop + " ";
        }
        ms_log.debug((Object)"createDefaultSpatialIndexOnEdges: dop ", (Object)szDop);
        try {
            block16: {
                ms_log.debug((Object)"createDefaultSpatialIndexOnEdges: starts");
                ps = this.m_oracle.getConnection().prepareStatement("insert into user_sdo_geom_metadata values(?,  'mdsys.opg_apis.get_geometry_from_v_t_cols(v,t)',  sdo_dim_array(    sdo_dim_element('Longitude', -180, 180, 0.005),    sdo_dim_element('Latitude',   -90,  90, 0.005)), 8307)");
                String szTabName = this.getEdgeTabName();
                szTabName = this.stripSchema(szTabName);
                ps.setString(1, szTabName);
                try {
                    ps.executeUpdate();
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == 13223) {
                        ms_log.debug((Object)"createDefaultSpatialIndexOnEdges: hit ORA_DUP_ENTRY, can be ignored ", (Throwable)sqle);
                    }
                    throw sqle;
                }
                ms_log.debug((Object)"createDefaultSpatialIndexOnEdges: done adding into user_sdo_geom_metadata, szTabName ", (Object)szTabName);
                ms_log.debug((Object)"createDefaultSpatialIndexOnEdges: start building the spatial index ", (Object)this.getEdgeTabIdxName("SP"));
                ps = null;
                int iErrorCode = 955;
                String szStmt = "create index " + this.getEdgeTabIdxName("SP") + "  on " + this.getEdgeTabName() + " (mdsys.opg_apis.get_geometry_from_v_t_cols(v, t))  indextype is " + (bUseV2 ? " mdsys.spatial_index_v2 " : "  mdsys.spatial_index ") + szDop + (bLocal ? " local " : " ");
                try {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"executeUpdateAndIgnoreError: szStmt ", (Object)szStmt);
                    }
                    ps = this.getOracle().getConnection().prepareStatement(szStmt);
                    ps.execute();
                    ms_log.debug((Object)"executeUpdateAndIgnoreError: done successfully");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == iErrorCode) {
                        ms_log.debug((Object)("executeUpdateAndIgnoreError: ignore error per request " + iErrorCode + ", [ " + szStmt + " ]"));
                        break block16;
                    }
                    ms_log.debug((Object)"executeUpdateAndIgnoreError: hit unexpected exception");
                    throw sqle;
                }
                finally {
                    if (ps != null) {
                        ps.close();
                        ps = null;
                    }
                }
            }
            ms_log.debug((Object)"createDefaultSpatialIndexOnEdges: done");
        }
        catch (Throwable throwable) {
            OracleElementIteratorImpl.quietlyCloseStmt(ps);
            throw throwable;
        }
        OracleElementIteratorImpl.quietlyCloseStmt(ps);
    }

    public void createDefaultSpatialIndexOnVertices(int dop) throws SQLException {
        this.createDefaultSpatialIndexOnVertices(dop, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultSpatialIndexOnVertices(int dop, boolean bLocal, boolean bUseV2) throws SQLException {
        PreparedStatement ps = null;
        String szDop = " parallel 1 ";
        if (dop == 0) {
            szDop = " parallel ";
        } else if (dop > 0) {
            szDop = " parallel " + dop + " ";
        }
        ms_log.debug((Object)"createDefaultSpatialIndexOnVertices: dop ", (Object)szDop);
        try {
            block16: {
                ms_log.debug((Object)"createDefaultSpatialIndexOnVertices: starts");
                ps = this.m_oracle.getConnection().prepareStatement("insert into user_sdo_geom_metadata values(?,  'mdsys.opg_apis.get_geometry_from_v_t_cols(v,t)',  sdo_dim_array(    sdo_dim_element('Longitude', -180, 180, 0.005),    sdo_dim_element('Latitude',   -90,  90, 0.005)), 8307)");
                String szTabName = this.getVertexTabName();
                szTabName = this.stripSchema(szTabName);
                ps.setString(1, szTabName);
                try {
                    ps.executeUpdate();
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == 13223) {
                        ms_log.debug((Object)"createDefaultSpatialIndexOnVertices: hit ORA_DUP_ENTRY, can be ignored ", (Throwable)sqle);
                    }
                    throw sqle;
                }
                ms_log.debug((Object)"createDefaultSpatialIndexOnVertices: done adding into user_sdo_geom_metadata, szTabName ", (Object)szTabName);
                ms_log.debug((Object)"createDefaultSpatialIndexOnVertices: start building the spatial index ", (Object)this.getVertexTabIdxName("SP"));
                Statement pst = null;
                int iErrorCode = 955;
                String szStmt = "create index " + this.getVertexTabIdxName("SP") + "  on " + this.getVertexTabName() + " (mdsys.opg_apis.get_geometry_from_v_t_cols(v, t))  indextype is " + (bUseV2 ? " mdsys.spatial_index_v2 " : "  mdsys.spatial_index ") + szDop + (bLocal ? " local " : " ");
                try {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"executeUpdateAndIgnoreError: szStmt ", (Object)szStmt);
                    }
                    pst = this.getOracle().getConnection().prepareStatement(szStmt);
                    pst.execute();
                    ms_log.debug((Object)"executeUpdateAndIgnoreError: done successfully");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == iErrorCode) {
                        ms_log.debug((Object)("executeUpdateAndIgnoreError: ignore error per request " + iErrorCode + ", [ " + szStmt + " ]"));
                        break block16;
                    }
                    ms_log.debug((Object)"executeUpdateAndIgnoreError: hit unexpected exception");
                    throw sqle;
                }
                finally {
                    if (pst != null) {
                        pst.close();
                        pst = null;
                    }
                }
            }
            ms_log.debug((Object)"createDefaultSpatialIndexOnVertices: done");
        }
        catch (Throwable throwable) {
            OracleElementIteratorImpl.quietlyCloseStmt(ps);
            throw throwable;
        }
        OracleElementIteratorImpl.quietlyCloseStmt(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropDefaultSpatialIndexOnVertices() throws SQLException {
        PreparedStatement ps = null;
        ms_log.debug((Object)"dropDefaultSpatialIndexOnVertices: starts ");
        try {
            block10: {
                ps = this.m_oracle.getConnection().prepareStatement("delete from user_sdo_geom_metadata where table_name = ?");
                String szTabName = this.getVertexTabName();
                szTabName = this.stripSchema(szTabName);
                ps.setString(1, szTabName.toUpperCase());
                ps.executeUpdate();
                ms_log.debug((Object)"dropDefaultSpatialIndexOnVertices: done removing user_sdo_geom_metadata, szTabName ", (Object)szTabName);
                ms_log.debug((Object)"dropDefaultSpatialIndexOnVertices: start dropping the spatial index ", (Object)this.getVertexTabIdxName("SP"));
                Statement pst = null;
                int iErrorCode = 1418;
                String szStmt = "drop index " + this.getVertexTabIdxName("SP");
                try {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"executeUpdateAndIgnoreError: szStmt ", (Object)szStmt);
                    }
                    pst = this.getOracle().getConnection().prepareStatement(szStmt);
                    pst.execute();
                    ms_log.debug((Object)"executeUpdateAndIgnoreError: done successfully");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == iErrorCode) {
                        ms_log.debug((Object)("executeUpdateAndIgnoreError: ignore error per request " + iErrorCode + ", [ " + szStmt + " ]"));
                        break block10;
                    }
                    ms_log.debug((Object)"executeUpdateAndIgnoreError: hit unexpected exception");
                    throw sqle;
                }
                finally {
                    if (pst != null) {
                        pst.close();
                        pst = null;
                    }
                }
            }
            ms_log.debug((Object)"dropDefaultSpatialIndexOnVertices: done");
        }
        catch (Throwable throwable) {
            OracleElementIteratorImpl.quietlyCloseStmt(ps);
            throw throwable;
        }
        OracleElementIteratorImpl.quietlyCloseStmt(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropDefaultSpatialIndexOnEdges() throws SQLException {
        PreparedStatement ps = null;
        ms_log.debug((Object)"dropDefaultSpatialIndexOnEdges: starts ");
        try {
            block10: {
                ps = this.m_oracle.getConnection().prepareStatement("delete from user_sdo_geom_metadata where table_name = ?");
                String szTabName = this.getEdgeTabName();
                szTabName = this.stripSchema(szTabName);
                ps.setString(1, szTabName.toUpperCase());
                ps.executeUpdate();
                ms_log.debug((Object)"dropDefaultSpatialIndexOnEdges: done removing user_sdo_geom_metadata, szTabName ", (Object)szTabName);
                ms_log.debug((Object)"dropDefaultSpatialIndexOnEdges: start dropping the spatial index ", (Object)this.getEdgeTabIdxName("SP"));
                Statement pst = null;
                int iErrorCode = 1418;
                String szStmt = "drop index " + this.getEdgeTabIdxName("SP");
                try {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"executeUpdateAndIgnoreError: szStmt ", (Object)szStmt);
                    }
                    pst = this.getOracle().getConnection().prepareStatement(szStmt);
                    pst.execute();
                    ms_log.debug((Object)"executeUpdateAndIgnoreError: done successfully");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == iErrorCode) {
                        ms_log.debug((Object)("executeUpdateAndIgnoreError: ignore error per request " + iErrorCode + ", [ " + szStmt + " ]"));
                        break block10;
                    }
                    ms_log.debug((Object)"executeUpdateAndIgnoreError: hit unexpected exception");
                    throw sqle;
                }
                finally {
                    if (pst != null) {
                        pst.close();
                        pst = null;
                    }
                }
            }
            ms_log.debug((Object)"dropDefaultSpatialIndexOnEdges: done");
        }
        catch (Throwable throwable) {
            OracleElementIteratorImpl.quietlyCloseStmt(ps);
            throw throwable;
        }
        OracleElementIteratorImpl.quietlyCloseStmt(ps);
    }

    public OracleIndexManager getOracleIndexManager() {
        if (this.m_indexManager == null) {
            ms_log.debug((Object)"getOracleIndexManager: initialize Index manager");
            this.m_indexManager = new RDBMSIndexManager(this);
        }
        return this.m_indexManager;
    }

    public void refreshIndices(long lStartSCN, long lEndSCN) {
        ms_log.debug((Object)"refreshIndices: refresh indices cache before starting");
        this.getOracleIndexManager().refreshIndicesCache();
        ms_log.debug((Object)"refreshIndices: executed");
        ((RDBMSIndexManager)this.getOracleIndexManager()).refreshIndices(lStartSCN, lEndSCN);
    }

    public void setSessionQueryDOP(int dop) throws SQLException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)("setSessionQueryDOP: dop = " + dop));
        }
        this.getOracle().setSessionQueryDOP(dop);
        this.m_iSessionQueryDOP = dop;
    }

    @Override
    public int getSessionQueryDOP() {
        return this.m_iSessionQueryDOP;
    }

    public String getSessionID() throws SQLException {
        return this.m_oracle.getSessionID();
    }

    public int getEdgePartitionsNumber() throws SQLException {
        int i = this.getEdgePartitionsNumberInternal();
        if (i <= 0) {
            return 1;
        }
        return i;
    }

    private int getEdgePartitionsNumberInternal() throws SQLException {
        return this.getPartitionsNumber(this.getEdgeTabName().toUpperCase());
    }

    public int getVertexPartitionsNumber() throws SQLException {
        int i = this.getVertexPartitionsNumberInternal();
        if (i <= 0) {
            return 1;
        }
        return i;
    }

    private int getVertexPartitionsNumberInternal() throws SQLException {
        return this.getPartitionsNumber(this.getVertexTabName().toUpperCase());
    }

    protected String stripSchema(String tabName) throws SQLException {
        return SQLUtils.stripSchema((Connection)this.getOracle().getConnection(), (String)tabName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int getPartitionsNumber(String szTabName) throws SQLException {
        int iPtnNum = -1;
        ms_log.debug((Object)"getPartitionsNumber: start");
        if (this.m_psGetPtnNum == null) {
            ms_log.debug((Object)"getPartitionsNumber: prepareStatement ");
            this.m_psGetPtnNum = this.m_oracle.getConnection().prepareStatement("select count(1) from all_tab_partitions where table_owner=?  and table_name=?");
        }
        ResultSet rs = null;
        try {
            ms_log.debug((Object)"getPartitionsNumber: table_owner ", (Object)this.getGraphOwner());
            String szOwner = this.getGraphOwner().toUpperCase();
            this.m_psGetPtnNum.setString(1, szOwner.substring(1, szOwner.length() - 1));
            this.m_psGetPtnNum.setString(2, this.stripSchema(szTabName));
            rs = this.m_psGetPtnNum.executeQuery();
            rs.next();
            iPtnNum = rs.getInt(1);
        }
        catch (Throwable throwable) {
            OracleElementIteratorImpl.quietlyCloseResultSet(rs);
            throw throwable;
        }
        OracleElementIteratorImpl.quietlyCloseResultSet(rs);
        return iPtnNum;
    }

    public synchronized Long getCurrentSCNUnsafe() throws SQLException {
        Long lSCN;
        ms_log.debug((Object)"getCurrentSCN: start");
        if (this.m_psGetSCN == null) {
            if (this.m_oracle.isOpgAPIsLoaded()) {
                ms_log.debug((Object)"getCurrentSCN: prepareStatement for get scn through opg_apis");
                this.m_psGetSCN = this.m_oracle.getConnection().prepareStatement("select opg_apis.get_scn from dual");
            } else {
                throw new SQLException("OPG_APIS not loaded in the database. Please check the installation guide to load the necessary PL/SQL packages. As SYSDBA, run @catopg.sql");
            }
        }
        ResultSet rs = null;
        try {
            rs = this.m_psGetSCN.executeQuery();
            rs.next();
            lSCN = rs.getLong(1);
        }
        finally {
            OracleElementIteratorImpl.quietlyCloseResultSet(rs);
        }
        return lSCN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Long getCurrentSCN() throws SQLException {
        Long lSCN = 0L;
        ms_log.debug((Object)"getCurrentSCN: start");
        if (this.m_psGetSCN == null) {
            if (this.m_oracle.isOpgAPIsLoaded()) {
                ms_log.debug((Object)"getCurrentSCN: prepareStatement for get scn through opg_apis");
                this.m_psGetSCN = this.m_oracle.getConnection().prepareStatement("select opg_apis.get_scn from dual");
            } else {
                throw new SQLException("OPG_APIS not loaded in the database. Please check the installation guide to load the necessary PL/SQL packages. As SYSDBA, run @catopg.sql");
            }
        }
        ResultSet rs = null;
        int iRetries = 0;
        boolean bHasTabDefChangedHappened = false;
        SQLException sqleSaved = null;
        while (iRetries <= 32) {
            ++iRetries;
            try {
                Long l;
                rs = this.m_psGetSCN.executeQuery();
                rs.next();
                lSCN = rs.getLong(1);
                rs.close();
                rs = null;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"getCurrentSCN: try out scn = ", (Object)lSCN);
                }
                CallableStatement cs = null;
                try {
                    cs = this.m_oracle.getConnection().prepareCall("declare vcCheckedOwner varchar2(140); vcCheckedGN varchar2(140); scn number;begin   vcCheckedOwner := ?;   if (vcCheckedOwner is null or trim(vcCheckedOwner) is null) then     vcCheckedOwner := sys.dbms_assert.simple_sql_name(sys_context('userenv', 'session_user'));   else      vcCheckedOwner := trim(sys.dbms_assert.simple_sql_name(mdsys.opg_apis.validate_name(vcCheckedOwner)));   end if;   vcCheckedGN := trim(sys.dbms_assert.simple_sql_name(mdsys.opg_apis.validate_name(?)));   scn := ?;   execute immediate 'select count(1) from ' || vcCheckedOwner||'.'|| vcCheckedGN||'VT$ as of scn '|| scn ||' where rownum<=1';   execute immediate 'select count(1) from ' || vcCheckedOwner||'.'|| vcCheckedGN||'GE$ as of scn '|| scn ||' where rownum<=1'; end; ");
                    String szOwner = this.getGraphOwner().toUpperCase();
                    cs.setString(1, szOwner.substring(1, szOwner.length() - 1));
                    cs.setString(2, this.getGraphName());
                    cs.setLong(3, (long)lSCN);
                    cs.execute();
                    ms_log.debug((Object)"getCurrentSCN: flash back tested ok against VT$ and GE$");
                    l = lSCN;
                }
                catch (SQLException sqle) {
                    block18: {
                        try {
                            ms_log.debug((Object)"getCurrentSCN: flash back tested failed against VT$ and GE$.");
                            if (sqle.getErrorCode() == 1466) {
                                if (!bHasTabDefChangedHappened) {
                                    bHasTabDefChangedHappened = true;
                                    sqleSaved = sqle;
                                }
                                ms_log.debug((Object)"getCurrentSCN: flash back tested failed against VT$ and GE$. Sleep and retry");
                                try {
                                    Thread.currentThread();
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException ie) {
                                    ms_log.debug((Object)"getCurrentSCN: hit InterruptedException. continue");
                                }
                                break block18;
                            }
                            throw sqle;
                        }
                        catch (Throwable throwable) {
                            OracleElementIteratorImpl.quietlyCloseStmt(cs);
                            throw throwable;
                        }
                    }
                    OracleElementIteratorImpl.quietlyCloseStmt(cs);
                    continue;
                }
                OracleElementIteratorImpl.quietlyCloseStmt(cs);
                return l;
            }
            finally {
                OracleElementIteratorImpl.quietlyCloseResultSet(rs);
            }
        }
        if (bHasTabDefChangedHappened) {
            throw sqleSaved;
        }
        return lSCN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void enableAtSCN(Long longSCN) throws SQLException {
        ms_log.debug((Object)"enableAtSCN: start");
        if (longSCN == null) {
            throw new IllegalArgumentException("enableAtSCN: longSCN MUST not be null");
        }
        ms_log.debug((Object)"enableAtSCN: prepareStatement for enable at scn");
        CallableStatement cs = null;
        String s = "begin dbms_flashback.enable_at_system_change_number(:1); end;";
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"executeCall: stmt = ", (Object)(s + "  bv1 = " + longSCN.toString()));
        }
        try {
            cs = this.getOracle().getConnection().prepareCall("begin dbms_flashback.enable_at_system_change_number(:1); end;");
            cs.setString(1, longSCN.toString());
            cs.execute();
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    @Override
    public synchronized void disable() throws SQLException {
        ms_log.debug((Object)"disable: start");
        ms_log.debug((Object)"disable: prepareStatement for disable");
        CallableStatement cs = null;
        String s = "begin dbms_flashback.disable; end;";
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"executeCall: stmt = ", (Object)s);
        }
        try {
            cs = this.getOracle().getConnection().prepareCall("begin dbms_flashback.disable; end;");
            cs.execute();
        }
        finally {
            if (cs != null) {
                cs.close();
            }
        }
    }

    @Override
    public Iterator<VertexChange> getVertexChanges(Long longStartSCN, Long longEndSCN) throws SQLException {
        return this.getVertexChanges(longStartSCN, longEndSCN, this.getSessionQueryDOP());
    }

    @Override
    public Iterator<VertexChange> getVertexChanges(Long longStartSCN, Long longEndSCN, int iQueryDOP) throws SQLException {
        return this.getVertexChanges(longStartSCN, longEndSCN, iQueryDOP, false);
    }

    @Override
    public Iterator<VertexChange> getVertexChanges(Long longStartSCN, Long longEndSCN, int iQueryDOP, boolean bFilterOutRemovedInserts) throws SQLException {
        return this.getVertexChanges(longStartSCN, longEndSCN, iQueryDOP, bFilterOutRemovedInserts, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<VertexChange> getVertexChanges(Long longStartSCN, Long longEndSCN, int iQueryDOP, boolean bFilterOutRemovedInserts, String[] propertyNames) throws SQLException {
        VertexChangeIteratorImpl itChanges = null;
        if (iQueryDOP < 0) {
            throw new IllegalArgumentException("getVertexChanges: iQueryDOP must not be negative");
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)("getVertexChanges: start: longStartSCN " + longStartSCN + ", longEndSCN " + longEndSCN + " , iQueryDOP " + iQueryDOP));
        }
        PreparedStatement psGetVertexChanges = null;
        ResultSet rs = null;
        try {
            StringBuilder sbQuery = new StringBuilder().append("select /*+ parallel");
            if (iQueryDOP != 0) {
                sbQuery.append("(").append(iQueryDOP).append(")");
            }
            if (longStartSCN != null && longEndSCN != null) {
                int i;
                sbQuery.append(" */").append(" vid, k, t, v, vn, " + this.processVT("vt") + ", versions_operation vo, ").append(" versions_startscn, versions_endscn, versions_xid");
                if (this.supportVertexLabels()) {
                    sbQuery.append(", vl");
                }
                sbQuery.append(" from ").append(this.getVertexTabName()).append(" versions between scn ? and ? ").append(" where versions_operation is not null").append(bFilterOutRemovedInserts ? " and (not (versions_operation in('I','U') and versions_endscn is not null))" : "");
                if (propertyNames != null && propertyNames.length > 0) {
                    sbQuery.append(" and VID in (SELECT VID FROM ").append(this.getVertexTabName()).append(" where ( K in (");
                    for (i = 0; i < propertyNames.length; ++i) {
                        sbQuery.append(" ? ");
                        if (i >= propertyNames.length - 1) continue;
                        sbQuery.append(" , ");
                    }
                    sbQuery.append(" ) ) ) ");
                }
                sbQuery.append(" order by vid, versions_startscn nulls first ");
                ms_log.debug((Object)"getVertexChanges: query stmt ", (Object)sbQuery.toString());
                psGetVertexChanges = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
                psGetVertexChanges.setLong(1, longStartSCN);
                psGetVertexChanges.setLong(2, longEndSCN);
                if (propertyNames != null && propertyNames.length > 0) {
                    for (i = 0; i < propertyNames.length; ++i) {
                        psGetVertexChanges.setString(i + 3, propertyNames[i]);
                    }
                }
            } else if (longStartSCN != null) {
                int i;
                sbQuery.append(" */").append(" vid, k, t, v, vn, " + this.processVT("vt") + ", versions_operation vo, ").append(" versions_startscn, versions_endscn, versions_xid");
                if (this.supportVertexLabels()) {
                    sbQuery.append(", vl ");
                }
                sbQuery.append(" from ").append(this.getVertexTabName()).append(" versions between scn ? and maxvalue ").append(" where versions_operation is not null").append(bFilterOutRemovedInserts ? " and (not (versions_operation in('I','U') and versions_endscn is not null))" : "");
                if (propertyNames != null && propertyNames.length > 0) {
                    sbQuery.append(" and VID in (SELECT VID FROM ").append(this.getVertexTabName()).append(" where ( K in (");
                    for (i = 0; i < propertyNames.length; ++i) {
                        sbQuery.append(" ? ");
                        if (i >= propertyNames.length - 1) continue;
                        sbQuery.append(" , ");
                    }
                    sbQuery.append(" ) ) ) ");
                }
                sbQuery.append(" order by vid, versions_startscn nulls first, versions_operation ");
                ms_log.debug((Object)"getVertexChanges: query stmt ", (Object)sbQuery.toString());
                psGetVertexChanges = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
                psGetVertexChanges.setLong(1, longStartSCN);
                if (propertyNames != null && propertyNames.length > 0) {
                    for (i = 0; i < propertyNames.length; ++i) {
                        psGetVertexChanges.setString(i + 2, propertyNames[i]);
                    }
                }
            } else if (longEndSCN != null) {
                int i;
                sbQuery.append(" */").append(" vid, k, t, v, vn, " + this.processVT("vt") + ", versions_operation vo, ").append(" versions_startscn, versions_endscn, versions_xid");
                if (this.supportVertexLabels()) {
                    sbQuery.append(", vl ");
                }
                sbQuery.append(" from ").append(this.getVertexTabName()).append(" versions between scn minvalue and ? ").append(" where versions_operation is not null").append(bFilterOutRemovedInserts ? " and (not (versions_operation in('I','U') and versions_endscn is not null))" : "");
                if (propertyNames != null && propertyNames.length > 0) {
                    sbQuery.append(" and VID in (SELECT VID FROM ").append(this.getVertexTabName()).append(" where ( K in (");
                    for (i = 0; i < propertyNames.length; ++i) {
                        sbQuery.append(" ? ");
                        if (i >= propertyNames.length - 1) continue;
                        sbQuery.append(" , ");
                    }
                    sbQuery.append(" ) ) ) ");
                }
                sbQuery.append(" order by vid, versions_startscn nulls first, versions_operation ");
                ms_log.debug((Object)"getVertexChanges: query stmt ", (Object)sbQuery.toString());
                psGetVertexChanges = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
                psGetVertexChanges.setLong(1, longEndSCN);
                if (propertyNames != null && propertyNames.length > 0) {
                    for (i = 0; i < propertyNames.length; ++i) {
                        psGetVertexChanges.setString(i + 2, propertyNames[i]);
                    }
                }
            } else {
                int i;
                sbQuery.append(" */").append(" vid, k, t, v, vn, " + this.processVT("vt") + ", versions_operation vo, ").append(" versions_startscn, versions_endscn, versions_xid");
                if (this.supportVertexLabels()) {
                    sbQuery.append(", vl ");
                }
                sbQuery.append(" from ").append(this.getVertexTabName()).append(" versions between scn minvalue and maxvalue ").append(" where versions_operation is not null").append(bFilterOutRemovedInserts ? " and (not (versions_operation in('I','U') and versions_endscn is not null))" : "");
                if (propertyNames != null && propertyNames.length > 0) {
                    sbQuery.append(" and VID in (SELECT VID FROM ").append(this.getVertexTabName()).append(" where ( K in (");
                    for (i = 0; i < propertyNames.length; ++i) {
                        sbQuery.append(" ? ");
                        if (i >= propertyNames.length - 1) continue;
                        sbQuery.append(" , ");
                    }
                    sbQuery.append(" ) ) ) ");
                }
                sbQuery.append(" order by vid, versions_startscn nulls first , versions_operation");
                ms_log.debug((Object)"getVertexChanges: query stmt ", (Object)sbQuery.toString());
                psGetVertexChanges = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
                if (propertyNames != null && propertyNames.length > 0) {
                    for (i = 0; i < propertyNames.length; ++i) {
                        psGetVertexChanges.setString(i + 1, propertyNames[i]);
                    }
                }
            }
            rs = psGetVertexChanges.executeQuery();
            rs.setFetchSize(this.getQueryFetchSize());
            itChanges = new VertexChangeIteratorImpl(rs, this.getTreatTimestampTzAsStr(), this.supportVertexLabels());
        }
        catch (SQLException ex) {
            OraclePropertyGraphUtils.quietlyCloseResultSetAndStmt(rs);
            if (ex.getErrorCode() == 30052) {
                ms_log.error((Object)"getVertexChanges: invalid lower limit snapshot");
                throw ex;
            }
            if (ex.getErrorCode() == 8181) {
                ms_log.error((Object)"getVertexChanges: specified number is not a valid SCN ");
                throw ex;
            }
            ms_log.error((Object)("getVertexChanges: SQL threw error code " + ex.getErrorCode() + " full stack trace: " + ex));
        }
        return itChanges;
    }

    private String parseHintForRemovedElementsStmt(String s) {
        if (s == null) {
            return "";
        }
        if (("," + s.trim()).toUpperCase().indexOf(",HASH_AJ=T") >= 0) {
            return " HASH_AJ ";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Long> getRemovedEdges(Long longStartSCN, Long longEndSCN, int iQueryDOP, String szOptions) throws SQLException {
        OrderedEdgeIdIteratorImpl itChanges = null;
        ResultSet rs = null;
        try {
            rs = this.getRemovedElements(longStartSCN, longEndSCN, iQueryDOP, szOptions, this.getEdgeTabName(), "eid");
            rs.setFetchSize(this.getQueryFetchSize());
            itChanges = new OrderedEdgeIdIteratorImpl(rs);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 30052) {
                ms_log.error((Object)"getRemovedEdges: invalid lower limit snapshot");
                throw ex;
            }
            if (ex.getErrorCode() == 8181) {
                ms_log.error((Object)"getRemovedEdges: specified number is not a valid SCN ");
                throw ex;
            }
            ms_log.error((Object)("getRemovedEdges: SQL threw error code " + ex.getErrorCode() + " full stack trace: " + ex));
        }
        return itChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Long> getRemovedVertices(Long longStartSCN, Long longEndSCN, int iQueryDOP, String szOptions) throws SQLException {
        OrderedVertexIdIteratorImpl itChanges = null;
        ResultSet rs = null;
        try {
            rs = this.getRemovedElements(longStartSCN, longEndSCN, iQueryDOP, szOptions, this.getVertexTabName(), "vid");
            rs.setFetchSize(this.getQueryFetchSize());
            itChanges = new OrderedVertexIdIteratorImpl(rs);
        }
        catch (SQLException ex) {
            OraclePropertyGraphUtils.quietlyCloseResultSet(rs);
            if (ex.getErrorCode() == 30052) {
                ms_log.error((Object)"getRemovedVertices: invalid lower limit snapshot");
                throw ex;
            }
            if (ex.getErrorCode() == 8181) {
                ms_log.error((Object)"getRemovedVertices: specified number is not a valid SCN ");
                throw ex;
            }
            ms_log.error((Object)("getRemovedVertices: SQL threw error code " + ex.getErrorCode() + " full stack trace: " + ex));
        }
        return itChanges;
    }

    protected ResultSet getRemovedElements(Long longStartSCN, Long longEndSCN, int iQueryDOP, String szOptions, String szTabName, String szCol) throws SQLException {
        if (iQueryDOP < 0) {
            throw new IllegalArgumentException("getRemovedElements: iQueryDOP must not be negative");
        }
        if (szTabName == null) {
            throw new IllegalArgumentException("getRemovedElements: szTabName must not be null");
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)("getRemovedElements: start: longStartSCN " + longStartSCN + ", longEndSCN " + longEndSCN + " , iQueryDOP " + iQueryDOP));
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            StringBuilder sbQuery = new StringBuilder("select /*+ parallel");
            if (iQueryDOP != 0) {
                sbQuery.append("(").append(iQueryDOP).append(")");
            }
            if (longStartSCN != null && longEndSCN != null) {
                sbQuery.append(" */").append(" ").append(szCol).append(" from ( select distinct ").append(szCol).append(" from ").append(szTabName).append(" versions between scn ? and ? ").append(" where versions_operation = 'D') diff ").append(" where not exists ( ").append("   select /*+ ").append(this.parseHintForRemovedElementsStmt(szOptions)).append(" */ 1 from ").append(szTabName).append("    as of scn ? ").append("    where diff.").append(szCol).append("=").append(szCol).append(" ").append(" ) ").append(" order by ").append(szCol).append(" ");
                ms_log.debug((Object)"getRemovedElements: query stmt ", (Object)sbQuery.toString());
                ps = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
                ps.setLong(1, longStartSCN);
                ps.setLong(2, longEndSCN);
                ps.setLong(3, longEndSCN);
            } else if (longStartSCN != null) {
                sbQuery.append(" */").append(" ").append(szCol).append(" from ( select distinct ").append(szCol).append(" from ").append(szTabName).append(" versions between scn ? and maxvalue ").append(" where versions_operation = 'D') diff ").append(" where not exists ( ").append("   select /*+ ").append(this.parseHintForRemovedElementsStmt(szOptions)).append(" */ 1 from ").append(szTabName).append("    where diff.").append(szCol).append("=").append(szCol).append(" ").append(" ) ").append(" order by ").append(szCol).append(" ");
                ms_log.debug((Object)"getRemovedElements: query stmt ", (Object)sbQuery.toString());
                ps = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
                ps.setLong(1, longStartSCN);
            } else if (longEndSCN != null) {
                sbQuery.append(" */").append(" ").append(szCol).append(" from ( select distinct ").append(szCol).append(" from ").append(szTabName).append(" versions between scn minvalue and ? ").append(" where versions_operation = 'D') diff ").append(" where not exists ( ").append("   select /*+ ").append(this.parseHintForRemovedElementsStmt(szOptions)).append(" */ 1 from ").append(szTabName).append("    as of scn ? ").append("    where diff.").append(szCol).append("=").append(szCol).append(" ").append(" ) ").append(" order by ").append(szCol).append(" ");
                ms_log.debug((Object)"getRemovedElements: query stmt ", (Object)sbQuery.toString());
                ps = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
                ps.setLong(1, longEndSCN);
                ps.setLong(2, longEndSCN);
            } else {
                sbQuery.append(" */").append(" ").append(szCol).append(" from ( select distinct ").append(szCol).append(" from ").append(szTabName).append(" versions between scn minvalue and maxvalue ").append(" where versions_operation = 'D') diff ").append(" where not exists ( ").append("   select /*+ ").append(this.parseHintForRemovedElementsStmt(szOptions)).append(" */ 1 from ").append(szTabName).append("    where diff.").append(szCol).append("=").append(szCol).append(" ").append(" ) ").append(" order by ").append(szCol).append(" ");
                ms_log.debug((Object)"getRemovedElements: query stmt ", (Object)sbQuery.toString());
                ps = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
            }
            rs = ps.executeQuery();
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 30052) {
                ms_log.debug((Object)"getRemovedElements: invalid lower limit snapshot");
            }
            if (ex.getErrorCode() == 8181) {
                ms_log.debug((Object)"getRemovedElements: specified number is not a valid SCN ");
            }
            throw ex;
        }
        return rs;
    }

    @Override
    public Iterator<EdgeChange> getEdgeChanges(Long longStartSCN, Long longEndSCN) throws SQLException {
        return this.getEdgeChanges(longStartSCN, longEndSCN, this.getSessionQueryDOP());
    }

    @Override
    public Iterator<EdgeChange> getEdgeChanges(Long longStartSCN, Long longEndSCN, int iQueryDOP) throws SQLException {
        return this.getEdgeChanges(longStartSCN, longEndSCN, iQueryDOP, false);
    }

    @Override
    public Iterator<EdgeChange> getEdgeChanges(Long longStartSCN, Long longEndSCN, int iQueryDOP, boolean bFilterOutRemovedInserts) throws SQLException {
        return this.getEdgeChanges(longStartSCN, longEndSCN, iQueryDOP, bFilterOutRemovedInserts, null);
    }

    public Iterator<EdgeChange> getEdgeChanges(Long longStartSCN, Long longEndSCN, int iQueryDOP, boolean bFilterOutRemovedInserts, String[] propertyNames) throws SQLException {
        EdgeChangeIteratorImpl itChanges = null;
        if (iQueryDOP < 0) {
            throw new IllegalArgumentException("getEdgeChanges: iQueryDOP must not be negative");
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)("getEdgeChanges: start: longStartSCN " + longStartSCN + ", longEndSCN " + longEndSCN + " , iQueryDOP " + iQueryDOP));
        }
        PreparedStatement psGetEdgeChanges = null;
        ResultSet rs = null;
        try {
            StringBuilder sbQuery = new StringBuilder().append("select /*+ ").append(this.getDOPStmt(iQueryDOP));
            if (longStartSCN != null && longEndSCN != null) {
                int i;
                sbQuery.append(" */").append(" eid, k, t, v, vn, " + this.processVT("vt") + ", versions_operation vo, ").append(" versions_startscn, versions_endscn, versions_xid, EL, SVID, DVID from ").append(this.getEdgeTabName()).append(" versions between scn ? and ? ").append(" where versions_operation is not null").append(bFilterOutRemovedInserts ? " and (not (versions_operation in('I','U') and versions_endscn is not null))" : "");
                if (propertyNames != null && propertyNames.length > 0) {
                    sbQuery.append(" and EID in (SELECT EID FROM ").append(this.getEdgeTabName()).append(" where ( K in (");
                    for (i = 0; i < propertyNames.length; ++i) {
                        sbQuery.append(" ? ");
                        if (i >= propertyNames.length - 1) continue;
                        sbQuery.append(" , ");
                    }
                    sbQuery.append(" ) ) ) ");
                }
                sbQuery.append(" order by eid, versions_startscn nulls first ");
                ms_log.debug((Object)"getEdgeChanges: query stmt ", (Object)sbQuery.toString());
                psGetEdgeChanges = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
                psGetEdgeChanges.setLong(1, longStartSCN);
                psGetEdgeChanges.setLong(2, longEndSCN);
                if (propertyNames != null && propertyNames.length > 0) {
                    for (i = 0; i < propertyNames.length; ++i) {
                        psGetEdgeChanges.setString(i + 3, propertyNames[i]);
                    }
                }
            } else if (longStartSCN != null) {
                int i;
                sbQuery.append(" */").append(" eid, k, t, v, vn, " + this.processVT("vt") + ", versions_operation vo, ").append(" versions_startscn, versions_endscn, versions_xid, EL, SVID, DVID from ").append(this.getEdgeTabName()).append(" versions between scn ? and maxvalue ").append(" where versions_operation is not null").append(bFilterOutRemovedInserts ? " and (not (versions_operation in('I','U') and versions_endscn is not null))" : "");
                if (propertyNames != null && propertyNames.length > 0) {
                    sbQuery.append(" and EID in (SELECT EID FROM ").append(this.getEdgeTabName()).append(" where ( K in (");
                    for (i = 0; i < propertyNames.length; ++i) {
                        sbQuery.append(" ? ");
                        if (i >= propertyNames.length - 1) continue;
                        sbQuery.append(" , ");
                    }
                    sbQuery.append(" ) ) ) ");
                }
                sbQuery.append(" order by eid, versions_startscn nulls first, versions_operation ");
                ms_log.debug((Object)"getEdgeChanges: query stmt ", (Object)sbQuery.toString());
                psGetEdgeChanges = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
                psGetEdgeChanges.setLong(1, longStartSCN);
                if (propertyNames != null && propertyNames.length > 0) {
                    for (i = 0; i < propertyNames.length; ++i) {
                        psGetEdgeChanges.setString(i + 2, propertyNames[i]);
                    }
                }
            } else if (longEndSCN != null) {
                int i;
                sbQuery.append(" */").append(" eid, k, t, v, vn, " + this.processVT("vt") + ", versions_operation vo, ").append(" versions_startscn, versions_endscn, versions_xid, EL, SVID, DVID from ").append(this.getEdgeTabName()).append(" versions between scn minvalue and ? ").append(" where versions_operation is not null").append(bFilterOutRemovedInserts ? " and (not (versions_operation in('I','U') and versions_endscn is not null))" : "");
                if (propertyNames != null && propertyNames.length > 0) {
                    sbQuery.append(" and EID in (SELECT EID FROM ").append(this.getEdgeTabName()).append(" where ( K in (");
                    for (i = 0; i < propertyNames.length; ++i) {
                        sbQuery.append(" ? ");
                        if (i >= propertyNames.length - 1) continue;
                        sbQuery.append(" , ");
                    }
                    sbQuery.append(" ) ) ) ");
                }
                sbQuery.append(" order by eid, versions_startscn nulls first, versions_operation ");
                ms_log.debug((Object)"getEdgeChanges: query stmt ", (Object)sbQuery.toString());
                psGetEdgeChanges = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
                psGetEdgeChanges.setLong(1, longEndSCN);
                if (propertyNames != null && propertyNames.length > 0) {
                    for (i = 0; i < propertyNames.length; ++i) {
                        psGetEdgeChanges.setString(i + 2, propertyNames[i]);
                    }
                }
            } else {
                int i;
                sbQuery.append(" */").append(" eid, k, t, v, vn, " + this.processVT("vt") + ", versions_operation vo, ").append(" versions_startscn, versions_endscn, versions_xid, EL, SVID, DVID from ").append(this.getEdgeTabName()).append(" versions between scn minvalue and maxvalue ").append(" where versions_operation is not null").append(bFilterOutRemovedInserts ? " and (not (versions_operation in('I','U') and versions_endscn is not null))" : "");
                if (propertyNames != null && propertyNames.length > 0) {
                    sbQuery.append(" and EID in (SELECT EID FROM ").append(this.getEdgeTabName()).append(" where ( K in (");
                    for (i = 0; i < propertyNames.length; ++i) {
                        sbQuery.append(" ? ");
                        if (i >= propertyNames.length - 1) continue;
                        sbQuery.append(" , ");
                    }
                    sbQuery.append(" ) ) ) ");
                }
                sbQuery.append(" order by eid, versions_startscn nulls first , versions_operation");
                ms_log.debug((Object)"getEdgeChanges: query stmt ", (Object)sbQuery.toString());
                psGetEdgeChanges = this.m_oracle.getConnection().prepareStatement(sbQuery.toString());
                if (propertyNames != null && propertyNames.length > 0) {
                    for (i = 0; i < propertyNames.length; ++i) {
                        psGetEdgeChanges.setString(i + 1, propertyNames[i]);
                    }
                }
            }
            rs = psGetEdgeChanges.executeQuery();
            rs.setFetchSize(this.getQueryFetchSize());
            itChanges = new EdgeChangeIteratorImpl(rs, this.getTreatTimestampTzAsStr());
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 30052) {
                ms_log.error((Object)"getEdgeChanges: invalid lower limit snapshot");
                throw ex;
            }
            if (ex.getErrorCode() == 8181) {
                ms_log.error((Object)"getEdgeChanges: specified number is not a valid SCN ");
                throw ex;
            }
            ms_log.error((Object)("getEdgeChanges: SQL threw error code " + ex.getErrorCode() + " full stack trace: " + ex));
        }
        return itChanges;
    }

    @Override
    public boolean doesVertexExistAt(String szVertexID, Long longEndSCN) throws SQLException {
        return this.doesVertexExistAt(szVertexID, longEndSCN, this.getSessionQueryDOP());
    }

    @Override
    public boolean doesVertexExistAt(String szVertexID, Long longEndSCN, int iQueryDOP) throws SQLException {
        return this.doesElementExistAt(szVertexID, longEndSCN, iQueryDOP, true);
    }

    @Override
    public boolean doesEdgeExistAt(String szEdgeID, Long longEndSCN) throws SQLException {
        return this.doesEdgeExistAt(szEdgeID, longEndSCN, this.getSessionQueryDOP());
    }

    @Override
    public boolean doesEdgeExistAt(String szEdgeID, Long longEndSCN, int iQueryDOP) throws SQLException {
        return this.doesElementExistAt(szEdgeID, longEndSCN, iQueryDOP, false);
    }

    /*
     * Exception decompiling
     */
    private boolean doesElementExistAt(String szElementID, Long longEndSCN, int iQueryDOP, boolean isVertex) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public OracleVertexBase getVertexInstance(Long vid, boolean bCreateIfAbsentFromCache, boolean bSkipStoreToCache) {
        return OracleVertex.getInstance(this, vid, bCreateIfAbsentFromCache, bSkipStoreToCache);
    }

    public OracleEdgeBase getEdgeInstance(Long eid, boolean bCreateIfAbsentFromCache, boolean bSkipStoreToCache) {
        return OracleEdge.getInstance(this, eid, bCreateIfAbsentFromCache, bSkipStoreToCache);
    }

    @Deprecated
    public OracleEdgeBase getEdgeInstance(OracleVertexBase outVertex, OracleVertexBase inVertex, String edgeLabel, Long eid, boolean bCreateIfAbsentFromCache, boolean bSkipStoreToCache) {
        return OracleEdge.getInstance(this, outVertex, inVertex, edgeLabel, eid, bCreateIfAbsentFromCache, bSkipStoreToCache);
    }

    public void revokeAccess(String user, String privilege) throws SQLException {
        if (!SQLUtils.DbFeature.REVOKE_ACCESS.isSupported((Connection)this.m_oracle.getConnection())) {
            throw new OraclePropertyGraphException("Revoke access is not supported for this DB version");
        }
        try (CallableStatement cs = this.m_oracle.getConnection().prepareCall("begin   mdsys.opg_apis.revoke_access(?,?,?,?); end; ");){
            String szOwner = this.getGraphOwner().toUpperCase();
            cs.setString(1, szOwner.substring(1, szOwner.length() - 1));
            cs.setString(2, this.getGraphName());
            cs.setString(3, user);
            cs.setString(4, privilege);
            cs.execute();
            ms_log.debug((Object)"revokeAccess: done");
        }
    }

    public void grantAccess(String user, String privilege) throws SQLException {
        try (CallableStatement cs = this.m_oracle.getConnection().prepareCall("begin   mdsys.opg_apis.grant_access(?,?,?,?); end; ");){
            String szOwner = this.getGraphOwner().toUpperCase();
            cs.setString(1, szOwner.substring(1, szOwner.length() - 1));
            cs.setString(2, this.getGraphName());
            cs.setString(3, user);
            cs.setString(4, privilege);
            cs.execute();
            ms_log.debug((Object)"grantAccess: done");
        }
    }

    public void setLabel(String policy, String label) throws SQLException {
        this.getOracle().setLabel(policy, label);
    }

    public void setRowLabel(String policy, String label) throws SQLException {
        this.getOracle().setRowLabel(policy, label);
    }

    public long countEdges(int dop, ProgressListener pll) {
        return this.countElements(dop, pll, false);
    }

    public long countVertices(int dop, ProgressListener pll) {
        return this.countElements(dop, pll, true);
    }

    /*
     * Exception decompiling
     */
    private long countElements(int dop, ProgressListener pll, boolean isVertex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public long getMinVertexID(int dop, ProgressListener pl) {
        return this.getElementID(dop, pl, OracleVertexBase.class, OraclePropertyGraphBase.ConstraintType.MIN);
    }

    @Deprecated
    public long getMinEdgeID(int dop, ProgressListener pl) {
        return this.getElementID(dop, pl, OracleEdgeBase.class, OraclePropertyGraphBase.ConstraintType.MIN);
    }

    @Deprecated
    public long getMaxVertexID(int dop, ProgressListener pl) {
        return this.getElementID(dop, pl, OracleVertexBase.class, OraclePropertyGraphBase.ConstraintType.MAX);
    }

    @Deprecated
    public long getMaxEdgeID(int dop, ProgressListener pl) {
        return this.getElementID(dop, pl, OracleEdgeBase.class, OraclePropertyGraphBase.ConstraintType.MAX);
    }

    /*
     * Exception decompiling
     */
    private <T extends OracleElementBase> long getElementID(int dop, ProgressListener pl, Class<T> elementClass, OraclePropertyGraphBase.ConstraintType type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public int getEdgePropertyNames(int dop, int timeout, Set<String> propertyNames, ProgressListener pl) {
        return this.getPropertyNames(dop, timeout, propertyNames, null, pl, OracleEdgeBase.class, false);
    }

    @Deprecated
    public int getEdgePropertyNames(int dop, int timeout, Map<String, Class> propertyNames, ProgressListener pl) {
        return this.getPropertyNames(dop, timeout, null, propertyNames, pl, OracleEdgeBase.class, true);
    }

    @Deprecated
    public int getVertexPropertyNames(int dop, int timeout, Set<String> propertyNames, ProgressListener pl) {
        return this.getPropertyNames(dop, timeout, propertyNames, null, pl, OracleVertexBase.class, false);
    }

    @Deprecated
    public int getVertexPropertyNames(int dop, int timeout, Map<String, Class> propertyNames, ProgressListener pl) {
        return this.getPropertyNames(dop, timeout, null, propertyNames, pl, OracleVertexBase.class, true);
    }

    /*
     * Exception decompiling
     */
    protected <T extends OracleElementBase> int getPropertyNames(int dop, int timeout, Set<String> propertyNames, Map<String, Class> propertyNamesMap, ProgressListener pl, Class<T> elementClass, boolean buildClassMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 36[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public <T extends OracleElementBase> void updateGraph(OpCallback<T> oc, boolean skipStoreToCache, int dop, ProgressListener pl, OpCallback.UpdateType updateType) {
        if (oc == null) {
            ms_log.debug((Object)"updateGraph: OpCallback is null, do nothing");
            return;
        }
        if (dop <= 0) {
            ms_log.debug((Object)"updateGraph: dop cannot be smaller than 1, use default (4)");
            dop = 4;
        }
        Oracle[] oracleConns = null;
        Connection[] connections = null;
        try {
            int partitionNum;
            this.commit();
            ms_log.debug((Object)"updateGraph: get connections array");
            oracleConns = new Oracle[dop];
            connections = new Connection[dop];
            for (int idx = 0; idx < dop; ++idx) {
                oracleConns[idx] = this.getOracle().clone();
                connections[idx] = oracleConns[idx].getConnection();
            }
            if (ms_bDebug) {
                ms_log.debug((Object)"updateGraph: get elements using parallel ", (Object)"execution");
            }
            boolean isVertex = OracleVertexBase.class.equals((Object)oc.getEntityType());
            Iterator[] itElemsArray = null;
            int n = partitionNum = isVertex ? this.getVertexPartitionsNumber() : this.getEdgePartitionsNumber();
            if (ms_bShowProgress) {
                ms_log.debug((Object)("updateGraph: number of partitions " + partitionNum));
            }
            int invokeNum = (int)Math.ceil((double)partitionNum / (double)dop);
            if (ms_bShowProgress) {
                ms_log.debug((Object)("updateGraph: number of invocations " + invokeNum));
            }
            for (int i = 0; i < invokeNum; ++i) {
                if (ms_bShowProgress) {
                    ms_log.debug((Object)("updateGraph invocation " + i));
                }
                int startPartitionID = i * dop;
                int numConns = connections.length;
                Connection[] cInvokeArray = connections;
                if (i == invokeNum - 1) {
                    numConns = partitionNum - startPartitionID;
                    if (ms_bDebug) {
                        ms_log.debug((Object)"updateGraph: reduce number of connections to ", (Object)numConns);
                    }
                    cInvokeArray = new Connection[numConns];
                    for (int j = 0; j < numConns; ++j) {
                        cInvokeArray[j] = connections[j];
                    }
                }
                itElemsArray = this.getElements(cInvokeArray, skipStoreToCache, startPartitionID, isVertex);
                if (ms_bDebug) {
                    ms_log.debug((Object)("updateGraph: generate threads to retrieve elements from iterable array of size " + itElemsArray.length));
                }
                this.consumeAndUpdateDataFromIterators(itElemsArray, isVertex, oc, updateType, pl);
            }
        }
        catch (Exception e) {
            try {
                ms_log.error((Object)"updateGraph: operation not completed, exception is ", (Throwable)e);
                throw new OraclePropertyGraphException((Throwable)e);
            }
            catch (Throwable throwable) {
                OraclePropertyGraphUtils.quietlyCloseConnections(oracleConns, connections);
                throw throwable;
            }
        }
        OraclePropertyGraphUtils.quietlyCloseConnections(oracleConns, connections);
    }

    private <T extends OracleElementBase> Iterator<T>[] getElements(Connection[] connections, boolean skipStoreToCache, int startPartitionID, boolean isVertex) {
        Iterator<Object>[] iterators = null;
        iterators = isVertex ? this.verticesPartitioned(connections, skipStoreToCache, startPartitionID) : this.edgesPartitioned(connections, skipStoreToCache, startPartitionID);
        return iterators;
    }

    protected <T extends OracleElementBase> OraclePropertyGraph getPropertyGraphFromIterator(boolean isVertex, Iterator<T> iterator) {
        if (isVertex) {
            OracleVertexIteratorImpl itElems = (OracleVertexIteratorImpl)((Object)iterator);
            return itElems.getPropertyGraph();
        }
        OracleEdgeIteratorImpl itElems = (OracleEdgeIteratorImpl)((Object)iterator);
        return itElems.getPropertyGraph();
    }

    protected Iterable<? extends OracleElementBase> getElements(Object[] ids, int dop, Class<? extends OracleElementBase> elementClass) {
        int idx;
        LinkedList<Object> elements = new LinkedList<Object>();
        if (ids == null) {
            return null;
        }
        if (dop <= 0) {
            dop = ms_defaultDOP;
        }
        Thread[] threads = null;
        threads = new Thread[dop];
        OraclePropertyGraphBase.OracleGetElementsByIdsWorker[] opgIdWorkers = new OraclePropertyGraphBase.OracleGetElementsByIdsWorker[dop];
        for (idx = 0; idx < dop; ++idx) {
            opgIdWorkers[idx] = new OraclePropertyGraphBase.OracleGetElementsByIdsWorker((OraclePropertyGraphBase)this, ids, elementClass, (OraclePropertyGraphBase)this, idx, dop);
            threads[idx] = new Thread((Runnable)opgIdWorkers[idx]);
            threads[idx].start();
        }
        for (idx = 0; idx < dop; ++idx) {
            try {
                threads[idx].join();
                continue;
            }
            catch (InterruptedException ex) {
                Message msg = new Message("ERR_HIT_INTERRUPT", (Object)"getElements(final long[] ids, int dop, Class<? extends OracleElementBase> elementClass)");
                throw new OraclePropertyGraphException(msg.toString(), (Throwable)ex);
            }
        }
        for (idx = 0; idx < dop; ++idx) {
            for (OracleElementBase v : opgIdWorkers[idx].getElements()) {
                if (OracleVertexBase.class.equals(elementClass)) {
                    elements.add((OracleVertexBase)v);
                    continue;
                }
                elements.add((OracleEdgeBase)v);
            }
        }
        return elements;
    }

    public long getMaxValueLengthAllowedInBytes() {
        return this.maxValueLengthAllowed;
    }

    public long getMaxLabelLengthAllowedInBytes() {
        return this.maxLabelLengthAllowed;
    }

    public long getMaxPropertyNameLengthAllowedInBytes() {
        return this.maxPropertyNameLengthAllowed;
    }

    /*
     * Exception decompiling
     */
    public Set<Long> getVertexIDSet(int dop, ProgressListener pl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Set<Long> getInvalidEdgeIDSet(int dop, ProgressListener pl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        ms_bDebug = ms_log.isDebugEnabled();
        ms_aiInstances = new AtomicInteger(0);
    }

    class QueryWorker
    implements Runnable {
        private PreparedStatement ps = null;
        private ResultSet rs = null;

        public QueryWorker(PreparedStatement ps) {
            this.ps = ps;
        }

        @Override
        public void run() {
            try {
                this.rs = this.ps.executeQuery();
            }
            catch (SQLException e) {
                ms_log.debug((Object)"QueryWorker run: hit SQLException ", (Throwable)e);
                throw new OraclePropertyGraphException((Throwable)e);
            }
        }

        public ResultSet getResultSet() {
            return this.rs;
        }
    }
}

