/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.util.NoSuchElementException;
import oracle.pg.common.CloseableIterator;
import oracle.pg.common.EdgeFilterCallback;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.messages.MesgConsts;
import oracle.pg.common.messages.Message;
import oracle.pg.rdbms.OracleEdge;
import oracle.pg.rdbms.OracleEdgeIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraph;
import oracle.pg.rdbms.OracleVertex;

public class OracleEdgeFilterIteratorImpl
implements CloseableIterator<OracleEdgeBase>,
MesgConsts {
    private static final OracleEdge EMPTY_EDGE = null;
    private OracleEdgeIteratorImpl m_eIter = null;
    private EdgeFilterCallback m_efc = null;
    private boolean m_bClosed = false;
    private OracleEdge m_lastEdge = null;
    private boolean m_bUsed = false;
    private OraclePropertyGraphBase.OptimizationFlag m_optFlag;
    Message MSG_ERR_NO_ELEM_TO_BE_CONSUMED = new Message("ERR_NO_ELEM_TO_BE_CONSUMED");

    OracleEdgeFilterIteratorImpl(OracleEdgeIteratorImpl iter, EdgeFilterCallback vfc, OraclePropertyGraphBase.OptimizationFlag flag) {
        this.m_eIter = iter;
        this.m_efc = vfc;
        this.m_bClosed = false;
        this.m_bUsed = false;
        this.m_optFlag = flag;
    }

    public void close() {
        if (this.m_bClosed) {
            return;
        }
        if (this.m_eIter != null) {
            this.m_eIter.close();
        }
        this.m_eIter = null;
        this.m_bClosed = false;
    }

    public boolean hasNext() {
        if (this.m_bClosed) {
            return false;
        }
        if (!this.m_bUsed && this.m_lastEdge != null) {
            return true;
        }
        if (this.m_eIter == null || !this.m_eIter.hasNext()) {
            this.close();
            return false;
        }
        this.moveCursor();
        return this.m_lastEdge != null;
    }

    protected void moveCursor() {
        this.m_lastEdge = null;
        this.m_bUsed = true;
        if (this.m_eIter == null || !this.m_eIter.hasNext()) {
            this.close();
            return;
        }
        while (this.m_eIter.hasNext()) {
            OracleEdge e = this.m_eIter.next();
            if (this.m_efc != null && !this.m_efc.keepEdge((OracleEdgeBase)e)) continue;
            this.m_lastEdge = e;
            this.m_bUsed = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleEdge next() {
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException(this.MSG_ERR_NO_ELEM_TO_BE_CONSUMED.toString());
            }
            OracleEdge e = this.m_lastEdge;
            this.m_lastEdge = null;
            this.m_bUsed = true;
            if (this.m_optFlag != null && OraclePropertyGraphBase.OptimizationFlag.DO_NOT_CREATE_OBJECT.equals((Object)this.m_optFlag)) {
                OracleEdge oracleEdge = EMPTY_EDGE;
                return oracleEdge;
            }
            if (this.m_optFlag != null && OraclePropertyGraphBase.OptimizationFlag.JUST_EDGE_ID.equals((Object)this.m_optFlag)) {
                OracleEdge oe = OracleEdge.getInstance((OraclePropertyGraph)e.graph(), (Long)e.id(), true, this.m_eIter.getSkipStoreToCache());
                oe.setCreatedWithOptFlag(true);
                OracleEdge oracleEdge = oe;
                return oracleEdge;
            }
            if (this.m_optFlag != null && OraclePropertyGraphBase.OptimizationFlag.JUST_LABEL_EDGE_ID.equals((Object)this.m_optFlag)) {
                OracleEdge oe = OracleEdge.getInstance((OraclePropertyGraph)e.graph(), (Long)e.id(), e.label(), true, this.m_eIter.getSkipStoreToCache());
                oe.setCreatedWithOptFlag(true);
                OracleEdge oracleEdge = oe;
                return oracleEdge;
            }
            if (this.m_optFlag != null && OraclePropertyGraphBase.OptimizationFlag.JUST_VERTEX_EDGE_ID.equals((Object)this.m_optFlag)) {
                OracleVertex inVertex = OracleVertex.getInstance((OraclePropertyGraph)e.graph(), (Long)e.inVertexID(), true, this.m_eIter.getSkipStoreToCache());
                inVertex.setPartial(true);
                OracleVertex outVertex = OracleVertex.getInstance((OraclePropertyGraph)e.graph(), (Long)e.outVertexID(), true, this.m_eIter.getSkipStoreToCache());
                outVertex.setPartial(true);
                outVertex.setCreatedWithOptFlag(true);
                inVertex.setCreatedWithOptFlag(true);
                OracleEdge oe = OracleEdge.getInstance((OraclePropertyGraph)e.graph(), (OracleVertexBase)outVertex, (OracleVertexBase)inVertex, (Long)e.id(), true, this.m_eIter.getSkipStoreToCache());
                oe.setCreatedWithOptFlag(true);
                OracleEdge oracleEdge = oe;
                return oracleEdge;
            }
            if (this.m_optFlag != null && OraclePropertyGraphBase.OptimizationFlag.JUST_LABEL_VERTEX_EDGE_ID.equals((Object)this.m_optFlag)) {
                OracleVertex inVertex = OracleVertex.getInstance((OraclePropertyGraph)e.graph(), (Long)e.inVertexID(), true, this.m_eIter.getSkipStoreToCache());
                inVertex.setPartial(true);
                OracleVertex outVertex = OracleVertex.getInstance((OraclePropertyGraph)e.graph(), (Long)e.outVertexID(), true, this.m_eIter.getSkipStoreToCache());
                outVertex.setPartial(true);
                outVertex.setCreatedWithOptFlag(true);
                inVertex.setCreatedWithOptFlag(true);
                OracleEdge oe = OracleEdge.getInstance((OraclePropertyGraph)e.graph(), outVertex, inVertex, e.label(), (Long)e.id(), true, this.m_eIter.getSkipStoreToCache());
                oe.setCreatedWithOptFlag(true);
                OracleEdge oracleEdge = oe;
                return oracleEdge;
            }
            OracleEdge oracleEdge = e;
            return oracleEdge;
        }
        finally {
            this.moveCursor();
        }
    }

    public void remove() {
        Message msg = new Message("ERR_NO_OP_SUPPORTED", (Object)"remove");
        throw new UnsupportedOperationException(msg.toString());
    }
}

