/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import oracle.pg.common.EdgeCache;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.rdbms.OraclePropertyGraph;
import oracle.pg.rdbms.OracleVertex;

public class OracleEdge
extends OracleEdgeBase
implements Comparable<Object> {
    static SimpleLog ms_log = SimpleLog.getLog(OracleEdge.class);
    private static boolean ms_bDebug = ms_log.isDebugEnabled();
    private static OracleEdge ms_emptyEdge = null;

    OracleEdge() {
    }

    OracleEdge(OraclePropertyGraph opg, Long eid) {
        super((OraclePropertyGraphBase)opg, eid);
    }

    OracleEdge(OraclePropertyGraph opg, Long eid, String label) {
        super((OraclePropertyGraphBase)opg, eid, label);
    }

    OracleEdge(OraclePropertyGraph opg, OracleVertexBase outVertex, OracleVertexBase inVertex, String edgeLabel, Long eid) {
        super((OraclePropertyGraphBase)opg, outVertex, inVertex, edgeLabel, eid);
    }

    OracleEdge(OraclePropertyGraph opg, OracleVertexBase outVertex, OracleVertexBase inVertex, Long eid) {
        super((OraclePropertyGraphBase)opg, outVertex, inVertex, eid);
    }

    public static OracleEdge getInstance(OraclePropertyGraph opg, Long eid) {
        return OracleEdge.getInstance(opg, eid, true);
    }

    public static OracleEdge getInstance(OraclePropertyGraph opg, Long eid, boolean bCreateIfAbsentFromCache) {
        return OracleEdge.getInstance(opg, eid, bCreateIfAbsentFromCache, false);
    }

    public static OracleEdge getInstance(OraclePropertyGraph opg, Long eid, boolean bCreateIfAbsentFromCache, boolean bSkipStoreToCache) {
        EdgeCache ec;
        OracleEdge oe;
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"getInstance: start with only eid ", (Object)eid);
        }
        if ((oe = (OracleEdge)(ec = opg.getEdgeCache()).get(eid)) != null) {
            ms_log.debug((Object)"getInstance: fetched one edge from the cache");
            return oe;
        }
        if (bCreateIfAbsentFromCache) {
            oe = new OracleEdge(opg, eid);
            if (ec != null && !bSkipStoreToCache) {
                ms_log.debug((Object)"getInstance: start a new edge and put into the cache");
                ec.put((OracleEdgeBase)oe);
            } else {
                ms_log.debug((Object)"getInstance: start a new edge. skip caching");
            }
        } else {
            ms_log.debug((Object)"getInstance: return NULL per bCreateIfAbsentFromCache");
        }
        return oe;
    }

    public static OracleEdge getInstance(OraclePropertyGraph opg, OracleVertexBase outVertex, OracleVertexBase inVertex, String edgeLabel, Long eid) {
        return OracleEdge.getInstance(opg, outVertex, inVertex, edgeLabel, eid, true);
    }

    public static OracleEdge getInstance(OraclePropertyGraph opg, OracleVertexBase outVertex, OracleVertexBase inVertex, String edgeLabel, Long eid, boolean bCreateIfAbsentFromCache) {
        return OracleEdge.getInstance(opg, outVertex, inVertex, edgeLabel, eid, bCreateIfAbsentFromCache, false);
    }

    public static OracleEdge getInstance(OraclePropertyGraph opg, Long eid, String label, boolean bCreateIfAbsentFromCache, boolean bSkipStoreToCache) {
        if (ms_bDebug) {
            ms_log.debug((Object)"getInstance: start with only eid ", (Object)eid);
        }
        EdgeCache ec = opg.getEdgeCache();
        OracleEdge oe = null;
        if (ec != null && (oe = (OracleEdge)ec.get(eid)) != null) {
            ms_log.debug((Object)"getInstance: fetched one edge from the cache");
            return oe;
        }
        if (bCreateIfAbsentFromCache) {
            oe = new OracleEdge(opg, eid, label);
            if (ec != null && !bSkipStoreToCache) {
                ms_log.debug((Object)"getInstance: start a new edge and put into the cache");
                ec.put((OracleEdgeBase)oe);
            } else {
                ms_log.debug((Object)"getInstance: start a new edge. skip caching");
            }
        } else {
            ms_log.debug((Object)"getInstance: return NULL per bCreateIfAbsentFromCache");
        }
        return oe;
    }

    public static OracleEdge getInstance(OraclePropertyGraph opg, OracleVertexBase outVertex, OracleVertexBase inVertex, Long eid, boolean bCreateIfAbsentFromCache, boolean bSkipStoreToCache) {
        if (ms_bDebug) {
            ms_log.debug((Object)("getInstance: start with outVertex " + outVertex.id() + ", inVertex " + inVertex.id() + ", eid " + eid));
        }
        EdgeCache ec = opg.getEdgeCache();
        OracleEdge oe = null;
        if (ec != null) {
            oe = (OracleEdge)ec.get(eid);
        }
        if (oe != null) {
            ms_log.debug((Object)"getInstance: get edge from cache");
            oe.m_vOut = (OracleVertex)outVertex;
            oe.m_vIn = (OracleVertex)inVertex;
            return oe;
        }
        if (bCreateIfAbsentFromCache) {
            ms_log.debug((Object)"getInstance: create edge because it is absent from cache");
            oe = new OracleEdge(opg, outVertex, inVertex, eid);
            if (bSkipStoreToCache) {
                ms_log.debug((Object)"getInstance: skip store to cache");
            } else {
                ec.put((OracleEdgeBase)oe);
                ms_log.debug((Object)"getInstance: put it into cache");
            }
        } else {
            ms_log.debug((Object)"getInstance: return NULL per bCreateIfAbsentFromCache");
        }
        return oe;
    }

    public static OracleEdge getInstance(OraclePropertyGraph opg, OracleVertexBase outVertex, OracleVertexBase inVertex, String edgeLabel, Long eid, boolean bCreateIfAbsentFromCache, boolean bSkipStoreToCache) {
        EdgeCache ec;
        OracleEdge ov;
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)("getInstance: start with outVertex " + outVertex.id() + ", inVertex " + inVertex.id() + ", edgeLabel " + edgeLabel + ", eid " + eid));
        }
        if ((ov = (OracleEdge)(ec = opg.getEdgeCache()).get(eid)) != null) {
            ov.m_szEdgeLabel = edgeLabel;
            ov.m_vOut = (OracleVertex)outVertex;
            ov.m_vIn = (OracleVertex)inVertex;
            return ov;
        }
        if (bCreateIfAbsentFromCache) {
            ov = new OracleEdge(opg, outVertex, inVertex, edgeLabel, eid);
            if (!bSkipStoreToCache) {
                ec.put((OracleEdgeBase)ov);
            }
        } else {
            ms_log.debug((Object)"getInstance: return NULL per bCreateIfAbsentFromCache");
        }
        return ov;
    }

    public static OracleEdge getEmptyInstance() {
        if (ms_emptyEdge == null) {
            ms_emptyEdge = new OracleEdge();
            ms_emptyEdge.setCreatedWithOptFlag(true);
        }
        return ms_emptyEdge;
    }
}

