/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Locale;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.pool.OracleDataSource;
import oracle.pg.common.SimpleLog;
import oracle.pg.rdbms.OracleElementIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraphException;
import oracle.sql.ArrayDescriptor;

public class Oracle
implements Cloneable {
    static SimpleLog log = SimpleLog.getLog(Oracle.class);
    private OracleConnection conn;
    private OracleDataSource ods = null;
    private DataSource m_ds = null;
    private String pass;
    private String url = null;
    private String user;
    private boolean bHasOpgAPIsLoaded = true;
    private boolean m_bIsShardingDB = false;
    public static final int ORA_NAME_IN_USE_BY_EXISTING_OBJECT = 955;
    public static final int ORA_NON_SHARD_DATABASE = 2521;
    public static final int ORA_RESOURCE_BUSY = 54;
    public static final int ORA_COL_ALREADY_INDEXED = 1408;
    public static final int ORA_INVALID_ID = 904;
    public static final int ORA_INVALID_LOWER_LIMIT_SNAPSHOT = 30052;
    public static final int ORA_INVALID_SCN = 8181;
    public static final int ORA_PTNED_IDX_MAY_NOT_BUILD_AS_WHOLE = 14086;
    public static final int ORA_TAB_DEF_HAS_CHANGED = 1466;
    public static final int ORA_LENGTH_TOO_LONG_FOR_DT = 910;
    public static final int ORA_TABLE_NOT_EXISTS = 942;
    public static final int ORA_INSUFFICIENT_PRIV = 1031;
    public static final int ORA_INDEX_NOT_EXIST = 1418;
    public static final int ORA_DUP_ENTRY = 13223;
    public static final String DEFAULT_PG_DS_NAME = "OraclePgDS";
    public static final int DEFAULT_OPT_DYN_SAMPLING = 2;
    public static final int DEFAULT_INDEX_DOP = 1;
    boolean bHasNumTripleID;
    ArrayDescriptor m_ad = null;

    public boolean isOpgAPIsLoaded() {
        return this.bHasOpgAPIsLoaded;
    }

    void validateIfShardingDb() {
        try {
            log.debug((Object)"validateIfShardingDb: a sharding db, make sure to alter session enable shard ddl");
            Oracle.executeSQL((Connection)this.getConnection(), "alter session enable shard ddl");
            this.m_bIsShardingDB = true;
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 2521) {
                log.debug((Object)"validateIfShardingDb: error ORA-02521, non shared database");
                this.m_bIsShardingDB = false;
                return;
            }
            this.m_bIsShardingDB = false;
            return;
        }
    }

    public String getUsername() {
        return this.user;
    }

    public boolean isShardingDb() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"isShardingDB: sharding db flag is ", (Object)this.m_bIsShardingDB);
        }
        return this.m_bIsShardingDB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionID() throws SQLException {
        String szSID;
        PreparedStatement ps = null;
        log.debug((Object)"getSessionID: start");
        log.debug((Object)"getSessionID: prepareStatement for get session ID");
        ps = this.getConnection().prepareStatement("select sys_context('userenv', 'sid') from dual");
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            rs.next();
            szSID = rs.getString(1);
        }
        finally {
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, ps);
        }
        return szSID;
    }

    public Oracle(Connection conn) {
        if (conn == null) {
            throw new RuntimeException("Connection must not be null.");
        }
        try {
            this.conn = conn.unwrap(OracleConnection.class);
            conn.setAutoCommit(false);
            this.user = conn.getMetaData().getUserName();
            log.debug((Object)"Oracle constructor. username = ", (Object)this.user);
            this.setClientID();
            this.validateIfShardingDb();
        }
        catch (SQLException sqle) {
            throw new RuntimeException("Oracle constructor: ", sqle);
        }
    }

    public Oracle(OracleConnection conn, DataSource ds) {
        if (conn == null) {
            throw new RuntimeException("Connection must not be null.");
        }
        try {
            this.conn = conn;
            this.m_ds = ds;
            conn.setAutoCommit(false);
            this.user = conn.getMetaData().getUserName();
            log.debug((Object)"Oracle constructor. username = ", (Object)this.user);
            this.setClientID();
            this.validateIfShardingDb();
        }
        catch (SQLException sqle) {
            throw new RuntimeException("Oracle constructor: ", sqle);
        }
    }

    public Oracle(OracleConnection conn) {
        if (conn == null) {
            throw new RuntimeException("Connection must not be null.");
        }
        try {
            this.conn = conn;
            conn.setAutoCommit(false);
            this.user = conn.getMetaData().getUserName();
            log.debug((Object)"Oracle constructor. username = ", (Object)this.user);
            this.setClientID();
            this.validateIfShardingDb();
        }
        catch (SQLException sqle) {
            throw new RuntimeException("Oracle constructor: ", sqle);
        }
    }

    public Oracle(OracleDataSource ods) {
        if (ods == null) {
            throw new RuntimeException("OracleDataSource must not be null.");
        }
        log.debug((Object)"Oracle constructor: use ods");
        this.ods = ods;
        try {
            this.conn = (OracleConnection)ods.getConnection();
            this.conn.setAutoCommit(false);
            this.user = this.conn.getMetaData().getUserName();
            log.debug((Object)"Oracle constructor. username = ", (Object)this.user);
            this.setClientID();
            this.validateIfShardingDb();
        }
        catch (SQLException sqle) {
            throw new RuntimeException("Oracle constructor: ", sqle);
        }
    }

    public Oracle(String url, String user, String pass) {
        if (url == null || url.trim().length() == 0) {
            throw new RuntimeException("url is null or an empty string.");
        }
        this.url = url;
        this.user = user;
        this.pass = pass;
        try {
            this.getConnection();
            this.validateIfShardingDb();
        }
        catch (Throwable t) {
            log.debug((Object)"Oracle: constructor ", t);
            throw new OraclePropertyGraphException(t);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                block5: {
                    try {
                        OracleConnection conn = Oracle.this.getConnection();
                        if (conn == null || conn.isClosed()) break block5;
                        log.debug((Object)"Shutdown: rollback and close in case of interruption");
                        conn.rollback();
                        try {
                            conn.close();
                        }
                        catch (SQLException sqle) {
                            if (sqle.getErrorCode() == 17008) {
                                log.debug((Object)"dispose: connection already closed. done.");
                                break block5;
                            }
                            throw sqle;
                        }
                    }
                    catch (SQLException sqle) {
                        if (log == null) break block5;
                        log.debug((Object)"Shutdown: ", (Throwable)sqle);
                    }
                }
            }
        });
    }

    public synchronized void rollbackTransaction() throws SQLException {
        this.getConnection().rollback();
    }

    public synchronized void commitTransaction() throws SQLException {
        try {
            this.getConnection().commit();
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 1013) {
                log.debug((Object)"commitTransaction: hit user requested cancel of current operation. retry commit");
                this.getConnection().commit();
            }
            throw sqle;
        }
    }

    public synchronized void dispose() throws SQLException {
        log.debug((Object)"dispose: start");
        if (this.conn != null && !this.conn.isClosed()) {
            log.debug((Object)"dispose: rollback and then close connection");
            this.conn.rollback();
            try {
                this.conn.close();
            }
            catch (SQLException sqle) {
                if (sqle.getErrorCode() == 17008) {
                    log.debug((Object)"dispose: connection already closed. done.");
                }
                throw sqle;
            }
        }
    }

    public synchronized ResultSet executeQuery(String s) throws SQLException {
        return this.executeQuery(s, 0, 1);
    }

    public synchronized ResultSet executeQuery(String s, int iTimeout, int iDOP) throws SQLException {
        return this.executeQuery(s, iTimeout, iDOP, 0L);
    }

    public synchronized ResultSet executeQuery(String s, int iTimeout, int iDOP, List listBindValues) throws SQLException {
        return this.executeQuery(s, iTimeout, iDOP, 0L, listBindValues);
    }

    synchronized ResultSet executeQuery(String s, int iTimeout, int iDOP, long lQID) throws SQLException {
        return this.executeQuery(s, iTimeout, iDOP, lQID, null);
    }

    synchronized ResultSet executeQuery(String s, int iTimeout, int iDOP, long lQID, List listBindValues) throws SQLException {
        return this.executeQuery(s, iTimeout, iDOP, lQID, listBindValues, 2);
    }

    synchronized ResultSet executeQuery(String s, int iTimeout, int iDOP, long lQID, List listBindValues, int iSDS) throws SQLException {
        return this.executeQuery(s, iTimeout, iDOP, lQID, listBindValues, iSDS, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized ResultSet executeQuery(String s, int iTimeout, int iDOP, long lQID, List listBindValues, int iSDS, boolean bPlanAfterExe) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("executeQuery: in [" + iTimeout + "] seconds, qid " + lQID + ", dop [" + iDOP + "], ods " + iSDS + " "), (Object)s);
        }
        Statement ps = null;
        ResultSet rs = null;
        try {
            if (iSDS != 2 && iDOP > 1) {
                log.debug((Object)"executeQuery: combine sds and dop");
                this.executeSQL("BEGIN EXECUTE IMMEDIATE 'ALTER SESSION SET OPTIMIZER_DYNAMIC_SAMPLING=" + iSDS + "'; EXECUTE IMMEDIATE 'ALTER SESSION FORCE PARALLEL QUERY PARALLEL " + iDOP + "'; END;");
            } else {
                if (iSDS != 2) {
                    log.debug((Object)"executeQuery: set sds ");
                    this.executeSQL("ALTER SESSION SET OPTIMIZER_DYNAMIC_SAMPLING=" + iSDS);
                }
                if (iDOP > 1) {
                    log.debug((Object)"executeQuery: set dop ");
                    this.executeSQL("ALTER SESSION FORCE PARALLEL QUERY PARALLEL " + iDOP);
                }
            }
            ps = this.conn.prepareStatement(s);
            if (iTimeout > 0) {
                ps.setQueryTimeout(iTimeout);
            }
            if (listBindValues != null && listBindValues.size() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"executeQuery: bind list size ", (Object)Integer.toString(listBindValues.size()));
                }
                for (int idx = 0; idx < listBindValues.size(); ++idx) {
                    Object o = listBindValues.get(idx);
                    if (o instanceof String) {
                        ps.setNString(idx + 1, (String)o);
                        continue;
                    }
                    if (o instanceof Integer) {
                        ps.setInt(idx + 1, (Integer)o);
                        continue;
                    }
                    if (o instanceof Long) {
                        ps.setLong(idx + 1, (Long)o);
                        continue;
                    }
                    if (o instanceof Float) {
                        ps.setFloat(idx + 1, ((Float)o).floatValue());
                        continue;
                    }
                    if (o instanceof Double) {
                        ps.setDouble(idx + 1, (Double)o);
                        continue;
                    }
                    if (o instanceof Timestamp) {
                        ps.setTimestamp(idx + 1, (Timestamp)o);
                        continue;
                    }
                    throw new SQLException("Unrecognized bind value type: " + o.getClass().toString());
                }
            }
            rs = ps.executeQuery();
        }
        catch (SQLException sqle) {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw sqle;
        }
        finally {
            if (bPlanAfterExe) {
                ResultSet rsPlan = null;
                try {
                    String szFinalQuery = s;
                    log.info((Object)"PLAN --------------------- query --------------------- ");
                    try {
                        String[] szQueryLines = szFinalQuery.split("\n|\r");
                        for (int idx = 0; idx < szQueryLines.length; ++idx) {
                            String szQueryLine = szQueryLines[idx];
                            log.debug((Object)"PLAN ", (Object)szQueryLine);
                        }
                    }
                    catch (Throwable szQueryLines) {}
                    log.info((Object)"PLAN --------------------- start --------------------- ");
                    rsPlan = this.executeQuery("select plan_table_output from table(dbms_xplan.display_cursor)", 0, 1, 0L, null);
                    if (rsPlan != null) {
                        while (rsPlan.next()) {
                            String szPlanRow = rsPlan.getString(1);
                            log.info((Object)"PLAN ", (Object)szPlanRow);
                        }
                    }
                    log.info((Object)"PLAN --------------------- done --------------------- ");
                }
                catch (Throwable throwable) {}
            }
            if (iSDS != 2 && iDOP > 1) {
                log.debug((Object)"executeSQL: reset combine sds and dop");
                this.executeSQL("BEGIN EXECUTE IMMEDIATE 'ALTER SESSION SET OPTIMIZER_DYNAMIC_SAMPLING=2'; EXECUTE IMMEDIATE 'ALTER SESSION FORCE PARALLEL QUERY PARALLEL 1'; END;");
            } else {
                try {
                    if (iDOP > 1) {
                        log.debug((Object)"executeSQL: reset dop");
                        this.executeSQL("ALTER SESSION FORCE PARALLEL QUERY PARALLEL 1");
                    }
                }
                finally {
                    if (iSDS != 2) {
                        log.debug((Object)"executeSQL: reset sds");
                        this.executeSQL("ALTER SESSION SET OPTIMIZER_DYNAMIC_SAMPLING=2");
                    }
                }
            }
        }
        return rs;
    }

    public synchronized ResultSet executeQueryWithArg(String s, String arg, String arg2) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ps = this.getConnection().prepareStatement(s);
        ps.setString(1, arg);
        ps.setString(2, arg2);
        rs = ps.executeQuery();
        return rs;
    }

    public synchronized ResultSet executeQueryWithArg(String s, String arg, String arg2, String arg3) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ps = this.getConnection().prepareStatement(s);
        ps.setString(1, arg);
        ps.setString(2, arg2);
        ps.setString(3, arg3);
        rs = ps.executeQuery();
        return rs;
    }

    public static synchronized void executeSQL(Connection conn, String s) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"executeSQL: stmt = ", (Object)s);
        }
        try (Statement stmt = conn.createStatement();){
            stmt.execute(s);
        }
    }

    public synchronized void executeSQL(String s) throws SQLException {
        Oracle.executeSQL((Connection)this.getConnection(), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void executeSQL(String s, String bindVarValue) throws SQLException {
        try (PreparedStatement ps = null;){
            ps = this.getConnection().prepareStatement(s);
            ps.setString(1, bindVarValue);
            ps.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void executeSQL(String s, String bv1, String bv2) throws SQLException {
        try (PreparedStatement ps = null;){
            ps = this.getConnection().prepareStatement(s);
            ps.setString(1, bv1);
            ps.setString(2, bv2);
            ps.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void executeSQL(String s, String bv1, String bv2, String bv3) throws SQLException {
        try (PreparedStatement ps = null;){
            ps = this.getConnection().prepareStatement(s);
            ps.setString(1, bv1);
            ps.setString(2, bv2);
            ps.setString(3, bv3);
            ps.execute();
        }
    }

    public synchronized void executeCall(String s) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"executeCall: stmt = ", (Object)s);
        }
        try (CallableStatement cs = null;){
            cs = this.getConnection().prepareCall(s);
            cs.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void executeCall(String s, String bindVarValue) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"executeCall: stmt = ", (Object)(s + "  bv1 = " + bindVarValue));
        }
        try (CallableStatement cs = null;){
            cs = this.getConnection().prepareCall(s);
            cs.setString(1, bindVarValue);
            cs.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void executeCall(String s, String bv1, String bv2) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"executeCall: stmt = ", (Object)(s + "  bv1 = " + bv1 + ", bv2 = " + bv2));
        }
        try (CallableStatement cs = null;){
            cs = this.getConnection().prepareCall(s);
            cs.setString(1, bv1);
            cs.setString(2, bv2);
            cs.execute();
            cs.close();
            cs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void executeCall(String s, String bv1, String bv2, String bv3) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"executeCall: stmt = ", (Object)(s + "  bv1 = " + bv1 + ", bv2 = " + bv2 + ", bv3 = " + bv3));
        }
        try (CallableStatement cs = null;){
            cs = this.getConnection().prepareCall(s);
            cs.setString(1, bv1);
            cs.setString(2, bv2);
            cs.setString(3, bv3);
            cs.execute();
            cs.close();
            cs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void executeCall(String s, String bv1, String bv2, String bv3, String bv4) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"executeCall: stmt = ", (Object)(s + "  bv1 = " + bv1 + ", bv2 = " + bv2 + ", bv3 = " + bv3 + ", bv4 = " + bv4));
        }
        try (CallableStatement cs = null;){
            cs = this.getConnection().prepareCall(s);
            cs.setString(1, bv1);
            cs.setString(2, bv2);
            cs.setString(3, bv3);
            cs.setString(4, bv4);
            cs.execute();
            cs.close();
            cs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void executeCall(String s, String bv1, String bv2, String bv3, String bv4, String bv5) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"executeCall: stmt = ", (Object)(s + "  bv1 = " + bv1 + ", bv2 = " + bv2 + ", bv3 = " + bv3 + ", bv4 = " + bv4 + ", bv5 = " + bv5));
        }
        try (CallableStatement cs = null;){
            cs = this.getConnection().prepareCall(s);
            cs.setString(1, bv1);
            cs.setString(2, bv2);
            cs.setString(3, bv3);
            cs.setString(4, bv4);
            cs.setString(5, bv5);
            cs.execute();
            cs.close();
            cs = null;
        }
    }

    boolean hasNumTripleID() {
        return this.bHasNumTripleID;
    }

    boolean isVer10gR2() {
        return this.bHasNumTripleID;
    }

    public synchronized OracleConnection cloneConnection() throws SQLException {
        OracleConnection oc = null;
        if (this.url == null) {
            if (this.ods == null && this.m_ds == null) {
                throw new RuntimeException("cloneConnection is only supported when JDBC URL or OracleDataSource is provided");
            }
            if (this.ods != null) {
                log.debug((Object)"cloneConnection: use data source");
                oc = (OracleConnection)this.ods.getConnection();
                oc.setAutoCommit(false);
            } else if (this.m_ds != null) {
                log.debug((Object)"cloneConnection: use a compatible data source");
                oc = (OracleConnection)this.m_ds.getConnection();
                oc.setAutoCommit(false);
            }
            return oc;
        }
        log.debug((Object)"cloneConnection: use url + user info");
        OracleDataSource ds = new OracleDataSource();
        ds.setURL(this.url);
        oc = (OracleConnection)ds.getConnection(this.user, this.pass);
        oc.setAutoCommit(false);
        return oc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OracleConnection getConnection() throws SQLException {
        if (this.conn == null) {
            block14: {
                Oracle.setLocale();
                try {
                    DriverManager.registerDriver((Driver)new OracleDriver());
                }
                catch (Throwable t) {
                    if (!log.isFatalEnabled()) break block14;
                    log.fatal((Object)"getConnection: ", t);
                }
            }
            ResultSet rs = null;
            Statement stmt = null;
            try {
                log.debug((Object)"getConnection: create new connection");
                long l = System.currentTimeMillis();
                OracleDataSource ds = new OracleDataSource();
                ds.setURL(this.url);
                this.conn = (OracleConnection)ds.getConnection(this.user, this.pass);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getting a connection end" + (System.currentTimeMillis() - l)));
                }
                this.conn.setAutoCommit(false);
                stmt = this.conn.createStatement();
                rs = stmt.executeQuery("select 1 from all_objects where object_name like 'OPG_APIS' and owner='MDSYS' and status='VALID' and object_type='PACKAGE'");
                this.bHasOpgAPIsLoaded = rs.next();
                rs.close();
                stmt.close();
                this.setClientID();
                if (log.isDebugEnabled()) {
                    if (rs != null) {
                        rs.close();
                    }
                    rs = null;
                    if (stmt != null) {
                        stmt.close();
                    }
                    stmt = null;
                    stmt = this.conn.createStatement();
                    rs = stmt.executeQuery("select 'CI= ' || sys_context('USERENV','CLIENT_IDENTIFIER') || ' MOD= ' || sys_context('USERENV','MODULE') || ' SID= ' || sys_context('USERENV','SID') || ' PU= ' || sys_context('USERENV', 'PROXY_USER')  || ' SN= ' || sys_context('USERENV', 'SERVICE_NAME') from dual ");
                    try {
                        rs.next();
                        String s = rs.getString(1);
                        log.debug((Object)"getConnection: db info ", (Object)s);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        return this.conn;
    }

    private void setClientID() {
        String scid = "OracleSpatialPropertyGraph";
        log.debug((Object)"getConnection: set client identifier ", (Object)scid);
        try {
            this.executeSQL("BEGIN DBMS_SESSION.set_identifier(?); END;", scid);
        }
        catch (Throwable t) {
            log.debug((Object)"getConnection: set client identifier exception", t);
        }
    }

    public static void setLocale() {
        String szLang = null;
        String szCount = null;
        if (szLang != null && szLang.trim().length() > 0) {
            try {
                Locale.setDefault(new Locale(szLang, szCount));
                log.debug((Object)"setLocale: use the vm property setting ...");
            }
            catch (Throwable t) {
                log.debug((Object)"setLocale: ", t);
            }
        }
    }

    public static void setSessionQueryDOP(Connection conn, int dop) throws SQLException {
        if (dop < 0) {
            return;
        }
        int iDop = dop;
        log.debug((Object)"setSessionQueryDOP: dop ", (Object)Integer.toString(iDop));
        if (iDop == 0) {
            log.debug((Object)"setSessionQueryDOP: just parallel");
            Oracle.executeSQL(conn, "BEGIN EXECUTE IMMEDIATE 'ALTER SESSION FORCE PARALLEL QUERY PARALLEL; END;");
        } else {
            Oracle.executeSQL(conn, "BEGIN EXECUTE IMMEDIATE 'ALTER SESSION FORCE PARALLEL QUERY PARALLEL " + iDop + "'; END;");
        }
        log.debug((Object)"setSessionQueryDOP: done");
    }

    public void setSessionQueryDOP(int dop) throws SQLException {
        Oracle.setSessionQueryDOP((Connection)this.getConnection(), dop);
    }

    public Oracle clone() {
        if (this.ods != null) {
            return new Oracle(this.ods);
        }
        return new Oracle(this.url, this.user, this.pass);
    }

    public void setLabel(String policy, String label) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setLabel: " + policy + " , label " + label));
        }
        this.executeSQL("BEGIN sa_utl.set_label(:1,char_to_label(:2,:3)); END;", policy, policy, label);
    }

    public void setRowLabel(String policy, String label) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setRowLabel: " + policy + " , label " + label));
        }
        this.executeSQL("BEGIN sa_utl.set_row_label(:1,char_to_label(:2,:3)); END;", policy, policy, label);
    }
}

