/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.messages.MesgConsts;
import oracle.pg.common.messages.Message;
import oracle.pg.rdbms.DataChange;
import oracle.pg.rdbms.EdgeChange;
import oracle.pg.rdbms.OracleCommonIteratorImpl;
import oracle.pg.rdbms.OracleEdge;
import oracle.pg.rdbms.OraclePropertyGraph;
import oracle.pg.rdbms.OraclePropertyGraphException;
import oracle.pg.rdbms.Parameters;

public class EdgeChangeIteratorImpl
extends OracleCommonIteratorImpl
implements Iterator<EdgeChange>,
MesgConsts {
    static SimpleLog ms_log = SimpleLog.getLog(EdgeChangeIteratorImpl.class);
    Message MSG_ERR_NO_ELEM_TO_BE_CONSUMED = new Message("ERR_NO_ELEM_TO_BE_CONSUMED");

    EdgeChangeIteratorImpl(ResultSet rs, boolean bTreatTimestampTzAsStr) {
        ms_log.debug((Object)"EdgeChangeIteratorImpl: constructor");
        this.rs = rs;
        this.m_bTreatTimestampTzAsStr = bTreatTimestampTzAsStr;
        this.bNextInovked = false;
        this.bNextExhausted = false;
    }

    public void close() {
    }

    @Override
    public EdgeChange next() {
        boolean b;
        if (ms_log.isDebugEnabled() && Parameters.getInstance().isSuperVerboseOn()) {
            ms_log.debug((Object)"next: start");
        }
        if (!this.bNextInovked && !(b = this.hasNext())) {
            throw new NoSuchElementException(this.MSG_ERR_NO_ELEM_TO_BE_CONSUMED.toString());
        }
        EdgeChange ec = null;
        try {
            Long lVID = this.rs.getLong(1);
            String szKey = this.rs.getString(2);
            Object val = OraclePropertyGraph.readObjFromResultSet(this.rs, 3, this.m_bTreatTimestampTzAsStr);
            String szOperation = this.rs.getString(7);
            Long longStartSCN = this.rs.getLong(8);
            Long longEndSCN = this.rs.getLong(9);
            String szXID = this.rs.getString(10);
            String szLbl = this.rs.getString(11);
            Long longSVID = this.rs.getLong(12);
            Long longDVID = this.rs.getLong(13);
            if (szLbl != null && szLbl.equals(OracleEdge.EMPTY_LBL)) {
                szLbl = "";
            }
            ec = EdgeChange.getInstance(DataChange.translateIntoChangeAction(szOperation), lVID, szKey, val, longStartSCN, longEndSCN, szXID, szLbl, longSVID, longDVID);
            this.moveCursor();
            if (this.m_gracefulTimeout) {
                this.m_bTimedOut = this.checkGracefulTimeout();
            } else {
                this.checkQueryExecutionTimeOut();
            }
        }
        catch (Exception sqle) {
            ms_log.debug((Object)"next: Exception ", (Throwable)sqle);
            try {
                this.safeCloseAndDeregisterIfNeeded(this.rs);
                this.rs = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sqle instanceof SQLException) {
                if (((SQLException)sqle).getErrorCode() == 1013) {
                    this.m_bHitTimeoutAlready = true;
                    ms_log.debug((Object)"next: Query timeout exception(1013)");
                    if (this.m_gracefulTimeout) {
                        return ec;
                    }
                }
            } else {
                ms_log.debug((Object)"next: exception ", (Throwable)sqle);
            }
            throw new OraclePropertyGraphException(sqle);
        }
        return ec;
    }
}

