/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataConnector;
import oracle.pg.rdbms.pgql.pgview.translation.LabelTranslator;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.VertexPairConnection;

public class TableTranslator {
    static VariableTableBinding generateVariableTableBinding(GraphPattern graphPattern, MetadataConnector metadataConnector) {
        if (graphPattern == null) {
            return null;
        }
        Map<QueryVariable, Set<String>> variableLabelMap = LabelTranslator.generateVariableLabelMap(graphPattern, metadataConnector);
        return TableTranslator.generateVariableTableBinding(variableLabelMap, metadataConnector);
    }

    static VariableTableBinding generateVariableTableBinding(QueryPath queryPath, MetadataConnector metadataConnector) {
        Map<QueryVariable, Set<String>> variableLabelMap = LabelTranslator.generateVariableLabelMap(queryPath, metadataConnector);
        return TableTranslator.generateVariableTableBinding(variableLabelMap, metadataConnector);
    }

    private static VariableTableBinding generateVariableTableBinding(Map<QueryVariable, Set<String>> variableLabelMap, MetadataConnector metadataConnector) {
        HashMap vertexTableMap = new HashMap();
        HashMap edgeTableMap = new HashMap();
        HashMap<QueryPath, String> pathTableMap = new HashMap<QueryPath, String>();
        block5: for (QueryVariable var : variableLabelMap.keySet()) {
            Set<String> labels = variableLabelMap.get(var);
            switch (var.getVariableType()) {
                case VERTEX: {
                    HashSet<String> vertexTables = new HashSet<String>();
                    for (String string : labels) {
                        vertexTables.addAll(metadataConnector.getVertexTablesForLabel(string));
                    }
                    vertexTableMap.put((QueryVertex)var, vertexTables);
                    continue block5;
                }
                case EDGE: {
                    HashSet<String> edgeTables = new HashSet<String>();
                    for (String label2 : labels) {
                        edgeTables.addAll(metadataConnector.getEdgeTablesForLabel(label2));
                    }
                    edgeTableMap.put((QueryEdge)var, edgeTables);
                    continue block5;
                }
                case PATH: {
                    QueryPath queryPath = (QueryPath)var;
                    pathTableMap.put(queryPath, "");
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Label for a var that is not vertex nor edge");
        }
        return new VariableTableBinding(vertexTableMap, edgeTableMap, pathTableMap);
    }

    static List<Map<QueryVariable, String>> generateAllPatternInstantiations(GraphPattern graphPattern, VariableTableBinding variableTableBinding, MetadataConnector metadataConnector) {
        return TableTranslator.generateAllPatternInstantiations(graphPattern.getVertices(), graphPattern.getConnections(), variableTableBinding, metadataConnector);
    }

    static List<Map<QueryVariable, String>> generateAllPatternInstantiations(QueryPath queryPath, VariableTableBinding variableTableBinding, MetadataConnector metadataConnector) {
        return TableTranslator.generateAllPatternInstantiations(new HashSet<QueryVertex>(queryPath.getVertices()), new HashSet<VertexPairConnection>(queryPath.getConnections()), variableTableBinding, metadataConnector);
    }

    static List<Map<QueryVariable, String>> generateAllPatternInstantiations(Set<QueryVertex> vertices, Set<VertexPairConnection> connections, VariableTableBinding variableTableBinding, MetadataConnector metadataConnector) {
        HashMap possibilitiesPerVar = new HashMap();
        TableTranslator.sanitizeWhileMakesSense(variableTableBinding, vertices, connections, metadataConnector);
        variableTableBinding.vertexTableMap.forEach((vertexVar, metadata) -> possibilitiesPerVar.put(vertexVar, metadata.size()));
        variableTableBinding.edgeTableMap.forEach((edgeVar, metadata) -> possibilitiesPerVar.put(edgeVar, metadata.size()));
        variableTableBinding.pathTableMap.forEach((pathVar, metadata) -> possibilitiesPerVar.put(pathVar, 1));
        ArrayList vars = new ArrayList(possibilitiesPerVar.keySet());
        vars.sort(Comparator.comparing(possibilitiesPerVar::get));
        if (vars.size() == 0) {
            return Collections.emptyList();
        }
        if ((Integer)possibilitiesPerVar.get(vars.get(vars.size() - 1)) == 1) {
            ArrayList<Map<QueryVariable, String>> list = new ArrayList<Map<QueryVariable, String>>();
            list.add(variableTableBinding.flatten());
            return list;
        }
        for (QueryVariable splitAt : vars) {
            int numOfPossibleDecisions = (Integer)possibilitiesPerVar.get(splitAt);
            if (numOfPossibleDecisions == 0) {
                return Collections.emptyList();
            }
            if (numOfPossibleDecisions <= 1) continue;
            return variableTableBinding.splitAt(splitAt).stream().flatMap(binding -> TableTranslator.generateAllPatternInstantiations(vertices, connections, binding, metadataConnector).stream()).collect(Collectors.toList());
        }
        throw new IllegalStateException("Not splittable, but also not every one is singleton");
    }

    private static void sanitizeWhileMakesSense(VariableTableBinding variableTablesMap, Set<QueryVertex> vertices, Set<VertexPairConnection> connections, MetadataConnector metadataConnector) {
        boolean hasEffect = true;
        while (hasEffect) {
            hasEffect = TableTranslator.sanitizeEdgeTables(variableTablesMap, connections, metadataConnector) || TableTranslator.sanitizeVertexTables(variableTablesMap, vertices, connections, metadataConnector);
        }
    }

    private static boolean sanitizeEdgeTables(VariableTableBinding variableTablesMap, Set<VertexPairConnection> connections, MetadataConnector metadataConnector) {
        boolean hasEffect = false;
        for (VertexPairConnection vertexPairConnection : connections) {
            QueryVertex src = vertexPairConnection.getSrc();
            QueryVertex dest = vertexPairConnection.getDst();
            Set<String> possibleSrcTables = variableTablesMap.vertexTableMap.get(src);
            Set<String> possibleDestTables = variableTablesMap.vertexTableMap.get(dest);
            if (vertexPairConnection.getVariableType() != QueryVariable.VariableType.EDGE) continue;
            QueryEdge queryEdge = (QueryEdge)vertexPairConnection;
            Set<String> possibleEdgeTables = variableTablesMap.edgeTableMap.get(queryEdge);
            Set updatedPossibleEdgeTables = possibleEdgeTables.stream().filter(edgeTable -> possibleSrcTables.contains(metadataConnector.getSrcTable((String)edgeTable))).filter(edgeTable -> possibleDestTables.contains(metadataConnector.getDstTable((String)edgeTable))).collect(Collectors.toSet());
            if (possibleEdgeTables.size() > updatedPossibleEdgeTables.size()) {
                hasEffect = true;
            }
            variableTablesMap.edgeTableMap.put(queryEdge, updatedPossibleEdgeTables);
        }
        return hasEffect;
    }

    private static boolean sanitizeVertexTables(VariableTableBinding variableTablesMap, Set<QueryVertex> vertices, Set<VertexPairConnection> connections, MetadataConnector metadataConnector) {
        boolean hasEffect = false;
        for (QueryVertex vertex : vertices) {
            Set sourceOf = connections.stream().filter(vc -> vc.getVariableType() == QueryVariable.VariableType.EDGE).map(vc -> (QueryEdge)vc).filter(edge -> edge.getSrc() == vertex).map(variableTablesMap.edgeTableMap::get).map(set -> set.stream().map(metadataConnector::getSrcTable).collect(Collectors.toSet())).collect(Collectors.toSet());
            Set destOf = connections.stream().filter(vc -> vc.getVariableType() == QueryVariable.VariableType.EDGE).map(vc -> (QueryEdge)vc).filter(edge -> edge.getDst() == vertex).map(variableTablesMap.edgeTableMap::get).map(set -> set.stream().map(metadataConnector::getDstTable).collect(Collectors.toSet())).collect(Collectors.toSet());
            Set<String> possibleVertexTables = variableTablesMap.vertexTableMap.get(vertex);
            Set actuallyPossibleVertexTables = possibleVertexTables.stream().filter(vertexTable -> sourceOf.stream().allMatch(set -> set.contains(vertexTable)) && destOf.stream().allMatch(set -> set.contains(vertexTable))).collect(Collectors.toSet());
            if (possibleVertexTables.size() > actuallyPossibleVertexTables.size()) {
                hasEffect = true;
            }
            variableTablesMap.vertexTableMap.put(vertex, actuallyPossibleVertexTables);
        }
        return hasEffect;
    }

    static class VariableTableBinding {
        final Map<QueryVertex, Set<String>> vertexTableMap;
        final Map<QueryEdge, Set<String>> edgeTableMap;
        final Map<QueryPath, String> pathTableMap;

        private VariableTableBinding(Map<QueryVertex, Set<String>> vertexTableMap, Map<QueryEdge, Set<String>> edgeTableMap, Map<QueryPath, String> pathTableMap) {
            this.vertexTableMap = vertexTableMap;
            this.edgeTableMap = edgeTableMap;
            this.pathTableMap = pathTableMap;
        }

        public Map<QueryVariable, String> flatten() {
            HashMap<QueryVariable, String> entityTables = new HashMap<QueryVariable, String>();
            for (QueryVertex vertex : this.vertexTableMap.keySet()) {
                Set<String> vertexTableNames = this.vertexTableMap.get(vertex);
                if (vertexTableNames.size() != 1) {
                    throw new IllegalStateException();
                }
                entityTables.put((QueryVariable)vertex, vertexTableNames.iterator().next());
            }
            for (QueryEdge edge : this.edgeTableMap.keySet()) {
                Set<String> edgeTableNames = this.edgeTableMap.get(edge);
                if (edgeTableNames.size() != 1) {
                    throw new IllegalStateException();
                }
                entityTables.put((QueryVariable)edge, edgeTableNames.iterator().next());
            }
            for (QueryPath path : this.pathTableMap.keySet()) {
                entityTables.put((QueryVariable)path, this.pathTableMap.get(path));
            }
            return entityTables;
        }

        List<VariableTableBinding> splitAt(QueryVariable var) {
            if (var.getVariableType() == QueryVariable.VariableType.VERTEX) {
                QueryVertex vertex = (QueryVertex)var;
                Set<String> allOptions = this.vertexTableMap.get(vertex);
                return allOptions.stream().map(chosenMetadata -> {
                    HashMap<QueryVertex, Set<String>> newVertexTableMaps = new HashMap<QueryVertex, Set<String>>(this.vertexTableMap);
                    newVertexTableMaps.put(vertex, Collections.singleton(chosenMetadata));
                    HashMap<QueryEdge, Set<String>> newEdgeTableMaps = new HashMap<QueryEdge, Set<String>>(this.edgeTableMap);
                    HashMap<QueryPath, String> newPathTableMaps = new HashMap<QueryPath, String>(this.pathTableMap);
                    return new VariableTableBinding(newVertexTableMaps, newEdgeTableMaps, newPathTableMaps);
                }).collect(Collectors.toList());
            }
            QueryEdge edge = (QueryEdge)var;
            Set<String> allOptions = this.edgeTableMap.get(edge);
            return allOptions.stream().map(chosenMetadata -> {
                HashMap<QueryVertex, Set<String>> newVertexTableMaps = new HashMap<QueryVertex, Set<String>>(this.vertexTableMap);
                HashMap<QueryEdge, Set<String>> newEdgeTableMaps = new HashMap<QueryEdge, Set<String>>(this.edgeTableMap);
                newEdgeTableMaps.put(edge, Collections.singleton(chosenMetadata));
                HashMap<QueryPath, String> newPathTableMaps = new HashMap<QueryPath, String>(this.pathTableMap);
                return new VariableTableBinding(newVertexTableMaps, newEdgeTableMaps, newPathTableMaps);
            }).collect(Collectors.toList());
        }

        public boolean hasPathTable() {
            return this.pathTableMap.size() > 0;
        }
    }
}

