/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.Direction;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

class AnyDirectedEdgeExtender {
    private final List<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> extendedConnections;
    private final Set<QueryExpression> constraints;
    private final GraphPattern graphPattern;
    private final QueryPath queryPath;
    private final List<ExpAsVar> selectElements;
    private final boolean isGraphPattern;

    public AnyDirectedEdgeExtender(GraphPattern graphPattern, List<ExpAsVar> selectElements) {
        this(graphPattern.getConnections(), graphPattern.getConstraints(), graphPattern, null, selectElements, true);
    }

    public AnyDirectedEdgeExtender(QueryPath queryPath, List<ExpAsVar> selectElements) {
        this(queryPath.getConnections(), queryPath.getConstraints(), null, queryPath, selectElements, false);
    }

    private AnyDirectedEdgeExtender(Collection<VertexPairConnection> connections, Set<QueryExpression> constraints, GraphPattern graphPattern, QueryPath queryPath, List<ExpAsVar> selectElements, boolean isGraphPattern) {
        this.extendedConnections = this.extendAnyDirectedEdges(new Pair<List<VertexPairConnection>, Map<String, QueryEdge>>(new ArrayList<VertexPairConnection>(connections), new HashMap()));
        this.constraints = constraints;
        this.graphPattern = graphPattern;
        this.queryPath = queryPath;
        this.selectElements = selectElements;
        this.isGraphPattern = isGraphPattern;
    }

    public int getExtendedConnectionsSize() {
        return this.extendedConnections.size();
    }

    private List<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> extendAnyDirectedEdges(Pair<List<VertexPairConnection>, Map<String, QueryEdge>> previousExtension) {
        ArrayList<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> extension = new ArrayList<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>>();
        List connections = (List)previousExtension.first;
        Map extendedEdges = (Map)previousExtension.second;
        for (VertexPairConnection connection : connections) {
            if (connection.getVariableType() != QueryVariable.VariableType.EDGE || ((QueryEdge)connection).isDirected()) continue;
            connections.remove(connection);
            QueryEdge edge = (QueryEdge)connection;
            QueryEdge outgoingEdge = new QueryEdge(edge.getSrc(), edge.getDst(), edge.getName(), edge.isAnonymous(), Direction.OUTGOING);
            ArrayList<QueryEdge> connectionsOutgoing = new ArrayList<QueryEdge>(connections);
            connectionsOutgoing.add(outgoingEdge);
            HashMap<String, QueryEdge> extendedOutgoing = new HashMap<String, QueryEdge>(extendedEdges);
            extendedOutgoing.put(edge.getName(), outgoingEdge);
            extension.add(new Pair(connectionsOutgoing, extendedOutgoing));
            QueryEdge incomingEdge = new QueryEdge(edge.getDst(), edge.getSrc(), edge.getName(), edge.isAnonymous(), Direction.INCOMING);
            ArrayList<QueryEdge> connectionsIncoming = new ArrayList<QueryEdge>(connections);
            connectionsIncoming.add(incomingEdge);
            HashMap<String, QueryEdge> extendedIncoming = new HashMap<String, QueryEdge>(extendedEdges);
            extendedIncoming.put(edge.getName(), incomingEdge);
            extension.add(new Pair(connectionsIncoming, extendedIncoming));
            return this.extendAnyDirectedEdges(extension);
        }
        extension.add(previousExtension);
        return extension;
    }

    private List<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> extendAnyDirectedEdges(List<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> previousExtension) {
        ArrayList<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>> extension = new ArrayList<Pair<List<VertexPairConnection>, Map<String, QueryEdge>>>();
        for (Pair<List<VertexPairConnection>, Map<String, QueryEdge>> pair : previousExtension) {
            extension.addAll(this.extendAnyDirectedEdges(pair));
        }
        return extension;
    }

    void replaceExtendedEdges(int idx) {
        if (this.extendedConnections.size() > 1) {
            Pair<List<VertexPairConnection>, Map<String, QueryEdge>> extension = this.extendedConnections.get(idx);
            this.replaceEdges(extension, false);
        }
    }

    void compressExtendedEdges() {
        if (this.extendedConnections.size() > 1) {
            Pair<List<VertexPairConnection>, Map<String, QueryEdge>> extension = this.extendedConnections.get(0);
            this.compressExtendedEdges(extension);
            this.replaceEdges(extension, true);
        }
    }

    private void compressExtendedEdges(Pair<List<VertexPairConnection>, Map<String, QueryEdge>> extension) {
        Map extendedEdges = (Map)extension.second;
        for (QueryEdge edge : extendedEdges.values()) {
            edge.setDirection(Direction.ANY);
        }
    }

    private void replaceEdges(Pair<List<VertexPairConnection>, Map<String, QueryEdge>> extension, boolean forCompress) {
        Set<QueryExpression> constraints;
        EdgeReplacer edgeReplacer = new EdgeReplacer((Map)extension.second);
        edgeReplacer.replaceEdges(this.constraints);
        Set<QueryExpression> set = constraints = forCompress ? this.constraints : edgeReplacer.eliminateSelfEdgesDuplicates(this.constraints);
        if (this.isGraphPattern) {
            this.graphPattern.setConnections(new HashSet((Collection)extension.first));
            this.graphPattern.setConstraints(constraints);
        } else {
            this.queryPath.setConnections((List)extension.first);
            this.queryPath.setConstraints(constraints);
        }
        edgeReplacer.replaceEdges(this.selectElements);
    }

    static class EdgeReplacer
    extends AbstractQueryExpressionVisitor {
        final Map<String, QueryEdge> extendedEdges;

        public EdgeReplacer(Map<String, QueryEdge> extendedEdges) {
            this.extendedEdges = extendedEdges;
        }

        void replaceEdges(Set<QueryExpression> constraints) {
            for (QueryExpression exp : constraints) {
                exp.accept((QueryExpressionVisitor)this);
            }
        }

        void replaceEdges(List<ExpAsVar> selectElements) {
            for (ExpAsVar exp : selectElements) {
                exp.getExp().accept((QueryExpressionVisitor)this);
            }
        }

        Set<QueryExpression> eliminateSelfEdgesDuplicates(Collection<QueryExpression> constraints) {
            HashSet<QueryExpression> newConstraints = new HashSet<QueryExpression>(constraints);
            for (QueryEdge edge : this.extendedEdges.values()) {
                if (edge.getDirection() != Direction.INCOMING) continue;
                newConstraints.add((QueryExpression)new QueryExpression.RelationalExpression.NotEqual((QueryExpression)new QueryExpression.VarRef((QueryVariable)edge.getSrc()), (QueryExpression)new QueryExpression.VarRef((QueryVariable)edge.getDst())));
            }
            return newConstraints;
        }

        public void visit(QueryExpression.VarRef varRef) {
            QueryEdge edge;
            if (varRef.getVariable().getVariableType() == QueryVariable.VariableType.EDGE && this.extendedEdges.containsKey((edge = (QueryEdge)varRef.getVariable()).getName())) {
                QueryEdge extendedEdge = this.extendedEdges.get(edge.getName());
                edge.setSrc(extendedEdge.getSrc());
                edge.setDst(extendedEdge.getDst());
                edge.setDirection(extendedEdge.getDirection());
            }
        }
    }
}

