/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.metadata;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.pg.rdbms.pgql.BindValueInfo;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlExecution;
import oracle.pg.rdbms.pgql.PgqlSqlTrans;
import oracle.pg.rdbms.pgql.pgview.metadata.Cache;
import oracle.pg.rdbms.pgql.pgview.metadata.CacheMap;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataRefreshTimes;
import oracle.pg.rdbms.pgql.pgview.util.Pair;

public class TranslationCache
extends CacheMap<UserTranslationCache, Pair<PgqlSqlTrans, BindValueInfo>> {
    public void cacheTranslation(PgqlConnection pgqlConn, String graphSchema, String graphName, String pgql, String matchOptions, String options, PgqlSqlTrans sqlTrans, BindValueInfo bvInfo) {
        UserTranslationCache userCache = (UserTranslationCache)this.getUserCache(pgqlConn.getJdbcConnection());
        MetadataRefreshTimes metadataRefreshTimes = new MetadataRefreshTimes(userCache.getLastDdlDateTime(pgqlConn.getJdbcConnection(), graphSchema, graphName));
        userCache.cacheValue(new String[]{pgqlConn.getSchema(), pgqlConn.getGraph(), pgql, matchOptions, options}, new Pair<PgqlSqlTrans, BindValueInfo>(sqlTrans, bvInfo), metadataRefreshTimes);
        userCache.graphTranslations.cacheTranslation(pgqlConn, graphSchema, graphName, pgql, matchOptions, options, metadataRefreshTimes);
    }

    public boolean containsTranslation(PgqlConnection pgqlConn, String pgql, String matchOptions, String options) {
        UserTranslationCache userCache = (UserTranslationCache)this.getUserCache(pgqlConn.getJdbcConnection());
        return userCache.containsKey(pgqlConn.getSchema(), pgqlConn.getGraph(), pgql, matchOptions, options);
    }

    public Pair<PgqlSqlTrans, BindValueInfo> getTranslation(PgqlConnection pgqlConn, String pgql, String matchOptions, String options) {
        UserTranslationCache userCache = (UserTranslationCache)this.getUserCache(pgqlConn.getJdbcConnection());
        Pair translation = userCache.get(pgqlConn.getJdbcConnection(), false, pgqlConn.getSchema(), pgqlConn.getGraph(), pgql, matchOptions, options);
        return (Pair)translation.first;
    }

    public void deleteGraphTranslations(Connection conn, String graphSchema, String graphName) {
        for (Cache.CacheKey key : this.userCaches.keySet()) {
            if (!this.getURL(key).equals(TranslationCache.getConnectionURL(conn))) continue;
            UserTranslationCache userCache = (UserTranslationCache)this.userCaches.get(key);
            if (!userCache.graphTranslations.containsKey(graphSchema, graphName)) continue;
            for (Pair pair : (List)((UserTranslationCache)userCache).graphTranslations.get((Connection)conn, (boolean)false, (String[])new String[]{graphSchema, graphName}).first) {
                userCache.removeEntry((String[])pair.second);
            }
            userCache.graphTranslations.removeEntry(graphSchema, graphName);
        }
    }

    public MetadataRefreshTimes getTimestampLastRefreshed(PgqlConnection pgqlConn, String pgql, String matchOptions, String options) {
        UserTranslationCache userCache = (UserTranslationCache)this.getUserCache(pgqlConn.getJdbcConnection());
        Pair translation = userCache.get(pgqlConn.getJdbcConnection(), false, pgqlConn.getSchema(), pgqlConn.getGraph(), pgql, matchOptions, options);
        return translation == null ? null : (MetadataRefreshTimes)translation.second;
    }

    public boolean isTranslationCacheRefreshed(PgqlConnection pgqlConn, String pgql, String matchOptions, String options) {
        UserTranslationCache userCache = (UserTranslationCache)this.getUserCache(pgqlConn.getJdbcConnection());
        MetadataRefreshTimes metadataRefreshTimes = this.getTimestampLastRefreshed(pgqlConn, pgql, matchOptions, options);
        if (metadataRefreshTimes != null && !userCache.isRefreshed(pgqlConn.getJdbcConnection(), pgqlConn.getSchema(), pgqlConn.getGraph(), metadataRefreshTimes)) {
            PgqlExecution.deleteCache(pgqlConn.getJdbcConnection(), pgqlConn.getSchema(), pgqlConn.getGraph());
            return false;
        }
        return true;
    }

    @Override
    protected UserTranslationCache buildUserCache() {
        return new UserTranslationCache();
    }

    static class UserTranslationCache
    extends Cache<Pair<PgqlSqlTrans, BindValueInfo>> {
        private final GraphTranslations graphTranslations = new GraphTranslations();

        UserTranslationCache() {
        }

        private static class GraphTranslations
        extends Cache<List<Pair<Connection, String[]>>> {
            private GraphTranslations() {
            }

            public void cacheTranslation(PgqlConnection pgqlConn, String graphSchema, String graphName, String pgql, String matchOptions, String options, MetadataRefreshTimes metadataRefreshTimes) {
                if (!this.containsKey(graphSchema, graphName)) {
                    this.cacheValue(new String[]{graphSchema, graphName}, new ArrayList(), metadataRefreshTimes);
                }
                Connection conn = pgqlConn.getJdbcConnection();
                List list = (List)this.get((Connection)conn, (boolean)false, (String[])new String[]{graphSchema, graphName}).first;
                list.add(new Pair<Connection, String[]>(conn, new String[]{pgqlConn.getSchema(), pgqlConn.getGraph(), pgql, matchOptions, options}));
            }
        }
    }
}

