/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.metadata;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.pgview.metadata.Cache;

public abstract class CacheMap<T extends Cache<V>, V> {
    Map<Cache.CacheKey, T> userCaches = new HashMap<Cache.CacheKey, T>();

    protected static String getConnectionURL(Connection conn) {
        try {
            return conn.getMetaData().getURL();
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    protected static String getConnectionUser(Connection conn) {
        try {
            return conn.getMetaData().getUserName();
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    private Cache.CacheKey getKey(Connection conn) {
        String url = CacheMap.getConnectionURL(conn);
        if (url == null) {
            return null;
        }
        String user = CacheMap.getConnectionUser(conn);
        if (user == null) {
            return null;
        }
        return new Cache.CacheKey(url, user);
    }

    protected String getURL(Cache.CacheKey key) {
        return key.keyComponents[0];
    }

    protected T getUserCache(Connection conn) {
        Cache.CacheKey key = this.getKey(conn);
        if (!this.userCaches.containsKey(key)) {
            this.userCaches.put(key, this.buildUserCache());
        }
        return (T)((Cache)this.userCaches.get(key));
    }

    protected abstract T buildUserCache();

    public boolean containsKey(Connection conn, String ... keyComponents) {
        T userCache = this.getUserCache(conn);
        return ((Cache)userCache).containsKey(keyComponents);
    }

    public void clear(Connection conn) {
        ((Cache)this.getUserCache(conn)).clear();
    }

    public void disable(Connection conn) {
        ((Cache)this.getUserCache(conn)).disable();
    }

    public void enable(Connection conn) {
        ((Cache)this.getUserCache(conn)).enable();
    }

    public void setMaxCapacity(Connection conn, int maxCapacity) {
        ((Cache)this.getUserCache(conn)).setMaxCapacity(maxCapacity);
    }

    public void setRefreshInterval(Connection conn, long interval) {
        ((Cache)this.getUserCache(conn)).setRefreshInterval(interval);
    }
}

