/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.ElementTable;
import oracle.pgql.lang.ddl.propertygraph.Key;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public class PgqlCreatePgUtils {
    static List<String> getColumns(PgqlConnection pgqlConn, String tableOwner, String tableName) {
        ArrayList<String> columns = new ArrayList<String>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String query = "\nSELECT column_name FROM sys.all_tab_columns \nWHERE owner = ?\n AND table_name= ?";
            ps = pgqlConn.getJdbcConnection().prepareStatement(query);
            ps.setString(1, tableOwner);
            ps.setString(2, tableName);
            rs = ps.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    columns.add(rs.getString(1));
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new PgqlToSqlException(ex);
            }
            catch (Throwable throwable) {
                DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
                throw throwable;
            }
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
        return columns;
    }

    static String getDataType(PgqlConnection pgqlConn, String tableOwner, String tableName, String columnName) {
        String columnType;
        ResultSet rs;
        PreparedStatement ps;
        block7: {
            ps = null;
            rs = null;
            try {
                String query = "\nSELECT data_type, data_precision, data_scale FROM sys.all_tab_columns \nWHERE owner = ?\n AND table_name = ?\n AND column_name = ?";
                ps = pgqlConn.getJdbcConnection().prepareStatement(query);
                ps.setString(1, tableOwner);
                ps.setString(2, tableName);
                ps.setString(3, columnName);
                rs = ps.executeQuery();
                if (rs != null && rs.next()) {
                    columnType = rs.getString(1);
                    if (!columnType.startsWith("NUMBER")) {
                        columnType = PgqlCreatePgUtils.removeTypePrecision(columnType);
                    } else {
                        int precision = rs.getInt(2);
                        int scale = rs.getInt(3);
                        StringBuilder stringBuilder = new StringBuilder(columnType);
                        columnType = stringBuilder.append("(").append(precision).append(",").append(scale).append(")").toString();
                    }
                    break block7;
                }
                String schemaTableName = tableOwner + "." + tableName;
                throw new PgqlToSqlException("Table " + schemaTableName + " does not exist or column " + columnName + " in table " + schemaTableName + " does not exist");
            }
            catch (SQLException ex) {
                try {
                    throw new PgqlToSqlException(ex);
                }
                catch (Throwable throwable) {
                    DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
                    throw throwable;
                }
            }
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
        return columnType;
    }

    public static String removeTypePrecision(String columnType) {
        int parenStart = columnType.indexOf("(");
        if (parenStart > 0) {
            int parenEnd = columnType.indexOf(")");
            return columnType.substring(0, parenStart) + columnType.substring(parenEnd + 1);
        }
        return columnType;
    }

    static List<String> getPrimaryKey(PgqlConnection pgqlConn, ElementTable et) {
        SchemaQualifiedName tableName = et.getTableName();
        ArrayList<String> primaryKey = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String query = "\nSELECT cls.column_name\nFROM sys.all_cons_columns cls, sys.all_constraints cst\nWHERE cls.owner = ?\n  AND cls.table_name = ?\n  AND cls.owner = cst.owner\n  AND cls.constraint_name = cst.constraint_name\n  AND cst.constraint_type = 'P'\nORDER BY 1";
            ps = pgqlConn.getJdbcConnection().prepareStatement(query);
            ps.setString(1, tableName.getSchemaName());
            ps.setString(2, tableName.getName());
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                primaryKey = new ArrayList<String>();
                do {
                    primaryKey.add(rs.getString(1));
                } while (rs.next());
            }
        }
        catch (SQLException ex) {
            try {
                throw new PgqlToSqlException(ex);
            }
            catch (Throwable throwable) {
                DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
                throw throwable;
            }
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
        return primaryKey;
    }

    static List<List<String>> getForeignKeys(PgqlConnection pgqlConn, EdgeTable et, VertexTable vt) {
        SchemaQualifiedName vtName = vt.getTableName();
        SchemaQualifiedName etName = et.getTableName();
        ArrayList foreignKeys = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String query = "\nSELECT edge_cols.constraint_name, edge_cols.column_name\nFROM sys.all_constraints vertex_cst, sys.all_constraints edge_cst, sys.all_cons_columns edge_cols\nWHERE vertex_cst.owner = ?\n  AND vertex_cst.table_name = ?\n  AND vertex_cst.owner=edge_cst.r_owner\n  AND vertex_cst.constraint_name=edge_cst.r_constraint_name\n  AND edge_cst.constraint_type='R'\n  AND edge_cst.constraint_name=edge_cols.constraint_name\n  AND edge_cols.owner = ?\n  AND edge_cst.table_name = ?\nORDER BY edge_cols.constraint_name, edge_cols.position";
            ps = pgqlConn.getJdbcConnection().prepareStatement(query);
            ps.setString(1, vtName.getSchemaName());
            ps.setString(2, vtName.getName());
            ps.setString(3, etName.getSchemaName());
            ps.setString(4, etName.getName());
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                foreignKeys = new ArrayList();
                String previousConstraint = "";
                ArrayList<String> currentForeignKey = null;
                do {
                    String currentConstraint;
                    if (!(currentConstraint = rs.getString(1)).equals(previousConstraint)) {
                        currentForeignKey = new ArrayList<String>();
                        foreignKeys.add(currentForeignKey);
                        previousConstraint = currentConstraint;
                    }
                    currentForeignKey.add(rs.getString(2));
                } while (rs.next());
            }
        }
        catch (SQLException ex) {
            try {
                throw new PgqlToSqlException(ex);
            }
            catch (Throwable throwable) {
                DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
                throw throwable;
            }
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
        return foreignKeys;
    }

    static String getKeyExpr(PgqlConnection pgqlConn, Key key) {
        return key == null ? "null" : key.getColumnNames().stream().map(s -> {
            try {
                return DbmsUtils.enquoteTableName(pgqlConn.getJdbcConnection(), s);
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        }).collect(Collectors.joining(" || '|' || "));
    }

    static String getNotNullKeyExpr(PgqlConnection pgqlConn, Key key) {
        return key == null ? "null IS NOT null" : key.getColumnNames().stream().map(s -> {
            try {
                return DbmsUtils.enquoteTableName(pgqlConn.getJdbcConnection(), s);
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        }).collect(Collectors.joining(" IS NOT NULL AND "));
    }

    static boolean existsGraph(PgqlConnection pgqlConn, String graphOwner, String graphName) {
        return PgqlUtils.getGraphType(pgqlConn.getJdbcConnection(), graphOwner, graphName) != null;
    }

    /*
     * Exception decompiling
     */
    static boolean existsTableOrView(PgqlConnection pgqlConn, String objectOwner, String objectName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static boolean existsColumn(PgqlConnection pgqlConn, String tableOwner, String tableName, String columnName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

