/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import javax.xml.bind.annotation.XmlRootElement;
import oracle.pgx.api.PgxVect;
import oracle.pgx.common.pojo.TypedObject;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.JsonUtil;

@XmlRootElement
public class PropertyTypedObject
extends TypedObject<PropertyType> {
    public boolean isVector = false;

    public PropertyTypedObject() {
    }

    public PropertyTypedObject(Object source) throws JsonGenerationException, JsonMappingException, IOException {
        this(PropertyTypedObject.getPropertyType(source), JsonUtil.toJson((Object)source));
        this.isVector = source instanceof PgxVect;
    }

    private static PropertyType getPropertyType(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof PgxVect) {
            return ((PgxVect)source).getType();
        }
        return PropertyType.getTypeFor(source.getClass());
    }

    public PropertyTypedObject(PropertyType type, String value) {
        super(type, value);
    }

    @JsonIgnore
    public Class<?> getTypeClass() {
        if (this.isVector) {
            return PgxVect.class;
        }
        return ((PropertyType)this.type).getTypeClass();
    }
}

