/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Collections;
import oracle.pgql.lang.spatial.Point2D;
import oracle.pgx.common.pojo.BindValueImpl;
import oracle.pgx.common.types.internal.ValueType;
import oracle.pgx.common.util.JsonUtil;

public class BindValueDeserializer
extends JsonDeserializer<BindValueImpl> {
    public BindValueImpl deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object value;
        JsonNode node = (JsonNode)jsonParser.readValueAsTree();
        ValueType type = (ValueType)JsonUtil.fromJsonNode((JsonNode)node.get("type"), ValueType.class);
        JsonNode valueNode = node.get("value");
        switch (type) {
            case BOOLEAN: {
                value = JsonUtil.fromJsonNode((JsonNode)valueNode, Boolean.class);
                break;
            }
            case DOUBLE: {
                value = JsonUtil.fromJsonNode((JsonNode)valueNode, Double.class);
                break;
            }
            case FLOAT: {
                value = JsonUtil.fromJsonNode((JsonNode)valueNode, Float.class);
                break;
            }
            case INTEGER: {
                value = JsonUtil.fromJsonNode((JsonNode)valueNode, Integer.class);
                break;
            }
            case LONG: {
                value = JsonUtil.fromJsonNode((JsonNode)valueNode, Long.class);
                break;
            }
            case STRING: {
                value = JsonUtil.fromJsonNode((JsonNode)valueNode, String.class);
                break;
            }
            case LOCAL_DATE: {
                value = JsonUtil.fromJsonNode((JsonNode)valueNode, LocalDate.class);
                break;
            }
            case TIME: {
                value = JsonUtil.fromJsonNode((JsonNode)valueNode, LocalTime.class);
                break;
            }
            case TIMESTAMP: {
                value = JsonUtil.fromJsonNode((JsonNode)valueNode, LocalDateTime.class);
                break;
            }
            case TIME_WITH_TIMEZONE: {
                value = JsonUtil.fromJsonNode((JsonNode)valueNode, OffsetTime.class);
                break;
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                value = JsonUtil.fromJsonNode((JsonNode)valueNode, OffsetDateTime.class);
                break;
            }
            case POINT2D: {
                value = JsonUtil.fromJsonNode((JsonNode)valueNode, Point2D.class);
                break;
            }
            case ARRAY: {
                JsonNode valueType = node.get("valueType");
                if ("EMPTY".equals(valueType.asText())) {
                    value = Collections.emptyList();
                    break;
                }
                ValueType listValueType = (ValueType)JsonUtil.fromJsonNode((JsonNode)valueType, ValueType.class);
                CollectionType listType = JsonUtil.getTypeFactory().constructCollectionType(ArrayList.class, listValueType.getTypeClass());
                value = JsonUtil.readValue((String)valueNode.toString(), (JavaType)listType);
                break;
            }
            default: {
                throw new UnsupportedOperationException("type not supported: " + type);
            }
        }
        return new BindValueImpl(type, value);
    }
}

