/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import java.io.IOException;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.PreparedStatementProxy;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.pojo.PreparedStatementResponse;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.RemotePreparedStatementProxyFactory;

public class PreparedStatementMarshaler
implements Marshaler<PreparedStatementProxy> {
    private final SessionContext sessionContext;
    private final RemotePreparedStatementProxyFactory factory;

    public PreparedStatementMarshaler(SessionContext sessionContext) {
        this(sessionContext, null);
    }

    public PreparedStatementMarshaler(SessionContext sessionContext, RemotePreparedStatementProxyFactory factory) {
        this.sessionContext = sessionContext;
        this.factory = factory;
    }

    @Override
    public String marshal(PreparedStatementProxy proxy) throws IOException {
        PreparedStatementResponse response = new PreparedStatementResponse(this.sessionContext, proxy.getId(), proxy.getBindVariableCount(), proxy.getGraphId(), proxy.getStatementType(), proxy.getCreatePropertyGraphConfig());
        return JsonUtil.toJson((Object)((Object)response));
    }

    @Override
    public PreparedStatementProxy unmarshal(String content) throws IOException {
        PreparedStatementResponse response = (PreparedStatementResponse)((Object)JsonUtil.readTopLevelJson((String)content, PreparedStatementResponse.class));
        return this.factory.createRemotePreparedStatementProxy(this.sessionContext, response.preparedStatementId, response.bindVariableCount, response.graphId, response.statementType, response.graphConfig);
    }
}

