/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.subgraph.internal;

import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.SourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PgGraphConfigUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PgGraphConfigUtil.class);

    private PgGraphConfigUtil() {
    }

    public static SourceType getAndValidateSourceTypeOrNull(PartitionedGraphConfig graphConfig) {
        return graphConfig == null ? null : PgGraphConfigUtil.getAndValidateSourceType(graphConfig);
    }

    public static SourceType getAndValidateSourceType(PartitionedGraphConfig graphConfig) {
        SourceType sourceType = graphConfig.getSourceType();
        String pgViewName = graphConfig.getPgViewName();
        if (sourceType != null) {
            PgGraphConfigUtil.throwOnConfigFieldClash(pgViewName, (ConfigField)PartitionedGraphConfig.Field.PG_VIEW_NAME, (ConfigField)PartitionedGraphConfig.Field.SOURCE_TYPE);
            return sourceType;
        }
        if (pgViewName != null) {
            LOG.warn("Deprecated config field {} is used instead of {} and {}", new Object[]{PartitionedGraphConfig.Field.PG_VIEW_NAME, PartitionedGraphConfig.Field.SOURCE_TYPE, PartitionedGraphConfig.Field.SOURCE_NAME});
            return SourceType.PG_VIEW;
        }
        return null;
    }

    public static String getAndValidateSourceNameOrNull(PartitionedGraphConfig graphConfig) {
        return graphConfig == null ? null : PgGraphConfigUtil.getAndValidateSourceName(graphConfig);
    }

    public static String getAndValidateSourceName(PartitionedGraphConfig graphConfig) {
        String sourceName = graphConfig.getSourceName();
        String pgViewName = graphConfig.getPgViewName();
        if (sourceName != null) {
            PgGraphConfigUtil.throwOnConfigFieldClash(pgViewName, (ConfigField)PartitionedGraphConfig.Field.PG_VIEW_NAME, (ConfigField)PartitionedGraphConfig.Field.SOURCE_NAME);
            return sourceName;
        }
        if (pgViewName != null) {
            LOG.warn("Deprecated config field {} is used instead of {} and {}", new Object[]{PartitionedGraphConfig.Field.PG_VIEW_NAME, PartitionedGraphConfig.Field.SOURCE_TYPE, PartitionedGraphConfig.Field.SOURCE_NAME});
            return pgViewName;
        }
        return null;
    }

    public static void checkIfConfigCanBeUsedForSubgraphLoading(PartitionedGraphConfig config) {
        for (EntityProviderConfig vertexProvider : config.getVertexProviders()) {
            if (vertexProvider.getFormat() == ProviderFormat.RDBMS) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"RDBMS_PROVIDER_FORMAT_ONLY_EXPECTED", (Object[])new Object[0]));
        }
        for (EntityProviderConfig edgeProvider : config.getEdgeProviders()) {
            if (edgeProvider.getFormat() == ProviderFormat.RDBMS) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"RDBMS_PROVIDER_FORMAT_ONLY_EXPECTED", (Object[])new Object[0]));
        }
        ErrorMessages.requireNonNull((Object)PgGraphConfigUtil.getAndValidateSourceType(config), (String)PartitionedGraphConfig.Field.SOURCE_TYPE.toKey());
        ErrorMessages.requireNonNull((Object)PgGraphConfigUtil.getAndValidateSourceName(config), (String)PartitionedGraphConfig.Field.SOURCE_NAME.toKey());
    }

    public static void checkIfConfigCanBeUsedForPgqlExpansion(PartitionedGraphConfig config) {
        try {
            PgGraphConfigUtil.checkIfConfigCanBeUsedForSubgraphLoading(config);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPANSION_WITH_PGQL_NOT_POSSIBLE", (Object[])new Object[0]), iae);
        }
    }

    private static void throwOnConfigFieldClash(String configValue, ConfigField deprecatedField, ConfigField newField) {
        if (configValue == null) {
            return;
        }
        LOG.error("Deprecated config field {} was used in combination with {}", (Object)deprecatedField, (Object)newField);
        throw new IllegalStateException(ErrorMessages.getMessage((String)"DEPRECATED_CONFIG_USED_TOGETHER_WITH_UPDATED_CONFIG", (Object[])new Object[]{deprecatedField, newField}));
    }
}

