/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.subgraph;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.subgraph.AbstractSubgraphReader;
import oracle.pgx.api.subgraph.internal.KeystoreLookup;
import oracle.pgx.api.subgraph.internal.PgGraphConfigUtil;
import oracle.pgx.api.subgraph.internal.PreparedPgqlQueryBuilderImpl;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.OnMismatch;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.PartitionedGraphConfigBuilder;
import oracle.pgx.config.PreparedQueryConfig;
import oracle.pgx.config.SourceType;

public abstract class PgqlBasedSubgraphReader<R extends PgqlBasedSubgraphReader<R, P>, P extends PgqlBasedSubgraphReader<R, P>>
extends AbstractSubgraphReader<R> {
    protected final SourceType graphSourceType;
    protected final String dbGraphName;
    protected final List<PreparedPgqlQueryBuilderImpl> preparedQueries = new ArrayList<PreparedPgqlQueryBuilderImpl>();
    private final ArrayList<String> queries = new ArrayList();
    private PartitionedGraphConfig config;
    String jdbcUrl;
    String dataSourceId;
    String owner;
    String username;
    String password;
    String keystoreAlias;
    private int numConnections;

    public PgqlBasedSubgraphReader(PgxSession session, KeystoreLookup keystoreLookup, Function<GraphConfig, PgxFuture<PgxGraph>> readFunction, SourceType graphSourceType, String owner, String dbGraphName) {
        super(session, keystoreLookup, readFunction);
        this.graphSourceType = graphSourceType;
        this.owner = owner;
        this.dbGraphName = dbGraphName;
    }

    @Override
    protected abstract R getThis();

    abstract PgxFuture<GraphConfig> runDescribeGraphAsync();

    private PgxFuture<GraphConfig> buildConfig(String name) {
        PgxFuture<Object> configFuture = this.config != null ? PgxFuture.completedFuture(this.config) : this.runDescribeGraphAsync();
        return configFuture.thenApply(graphConfig -> {
            if (!(graphConfig instanceof PartitionedGraphConfig)) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPECTED_PARTITIONED_GRAPH_CONFIG", (Object[])new Object[0]));
            }
            PartitionedGraphConfig partitionedGraphConfig = (PartitionedGraphConfig)graphConfig;
            PartitionedGraphConfigBuilder configBuilder = new PartitionedGraphConfigBuilder().copyFrom(partitionedGraphConfig);
            configBuilder.setSourceName(this.dbGraphName);
            configBuilder.setSourceType(this.graphSourceType);
            configBuilder.setQueries(this.queries);
            if (name != null) {
                configBuilder.setName(name);
            }
            if (this.jdbcUrl != null) {
                configBuilder.setJdbcUrl(this.jdbcUrl);
            }
            if (this.dataSourceId != null) {
                configBuilder.setDataSourceId(this.dataSourceId);
            }
            if (this.owner != null) {
                configBuilder.setSchema(this.owner);
            }
            if (this.username != null) {
                configBuilder.setUsername(this.username);
            }
            if (this.password != null) {
                configBuilder.setPassword(this.password);
            }
            if (this.keystoreAlias != null) {
                configBuilder.setKeystoreAlias(this.keystoreAlias);
            }
            if (this.numConnections > 0) {
                configBuilder.setNumConnections(this.numConnections);
            }
            if (!this.preparedQueries.isEmpty()) {
                ArrayList<PreparedQueryConfig> preparedQueryConfigs = new ArrayList<PreparedQueryConfig>(this.preparedQueries.size());
                for (PreparedPgqlQueryBuilderImpl preparedQueryBuilder : this.preparedQueries) {
                    preparedQueryConfigs.add(preparedQueryBuilder.buildQueryWithArguments());
                }
                configBuilder.setPreparedQueries(preparedQueryConfigs);
            }
            configBuilder.setErrorHandlingOnDuplicateEntityId(OnMismatch.SILENT);
            return configBuilder.build();
        });
    }

    private PgxFuture<GraphConfig> buildConfig() {
        return this.buildConfig(null);
    }

    public R withConfig(PartitionedGraphConfig config) {
        PgGraphConfigUtil.checkIfConfigCanBeUsedForSubgraphLoading(config);
        this.config = config;
        return (R)this.getThis();
    }

    public R dataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
        return (R)this.getThis();
    }

    public R jdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return (R)this.getThis();
    }

    public R username(String userName) {
        this.username = userName;
        return (R)this.getThis();
    }

    public R keystoreAlias(String keystoreAlias) {
        try {
            this.password(this.keystoreLookup.getPasswordForAlias(keystoreAlias));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
        this.keystoreAlias = keystoreAlias;
        return (R)this.getThis();
    }

    public R password(String password) {
        this.password = password;
        return (R)this.getThis();
    }

    @Deprecated
    public R schema(String schema) {
        this.owner = schema;
        return (R)this.getThis();
    }

    @Deprecated
    public R owner(String owner) {
        return this.schema(owner);
    }

    public R connections(int numConnections) {
        this.numConnections = numConnections;
        return (R)this.getThis();
    }

    public R queryPgql(String query) {
        this.queries.add(query);
        return (R)this.getThis();
    }

    public abstract P preparedPgqlQuery(String var1);

    @Override
    public PgxFuture<PgxGraph> loadAsync() {
        return this.buildConfig().thenCompose(this.readFunction);
    }

    @Override
    public PgxFuture<PgxGraph> loadAsync(String graphName) {
        return this.buildConfig(graphName).thenCompose(this.readFunction);
    }
}

