/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.List;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.mllib.ModelRepository;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.DbModelRepositoryConfiguration;
import oracle.pgx.config.mllib.ModelRepositoryConfiguration;

public class DbModelRepository
extends ModelRepository {
    private final DbModelRepositoryConfiguration modelRepositoryConfiguration;

    public DbModelRepository(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, DbModelRepositoryConfiguration modelRepositoryConfiguration) {
        super(session, core, keystorePathSupplier, keystorePasswordSupplier);
        this.modelRepositoryConfiguration = modelRepositoryConfiguration;
    }

    private void checkModelStoreNameForNull(String modelStoreName) {
        if (modelStoreName == null) {
            String error = ErrorMessages.getMessage((String)"MODEL_REPOSITORY_MODEL_STORE_NAME_IS_NULL", (Object[])new Object[0]);
            throw new IllegalArgumentException(error);
        }
    }

    private void checkModelNameForNull(String modelName) {
        if (modelName == null) {
            String error = ErrorMessages.getMessage((String)"MODEL_REPOSITORY_MODEL_NAME_IS_NULL", (Object[])new Object[0]);
            throw new IllegalArgumentException(error);
        }
    }

    private <T> PgxFuture<T> adaptConfigAndThen(Supplier<PgxFuture<T>> pgxFuture) {
        try {
            this.adaptConfig((ModelRepositoryConfiguration)this.modelRepositoryConfiguration);
        }
        catch (Exception e) {
            return PgxFuture.exceptionallyCompletedFuture(e);
        }
        return pgxFuture.get();
    }

    @Override
    public PgxFuture<Void> deleteModelStoreAsync(String modelStoreName) {
        return this.adaptConfigAndThen(() -> {
            this.checkModelStoreNameForNull(modelStoreName);
            return this.core.deleteModelStore(this.session.getSessionContext(), modelStoreName, (ModelRepositoryConfiguration)this.modelRepositoryConfiguration);
        });
    }

    @Override
    public PgxFuture<Void> createAsync(String modelStoreName) {
        return this.adaptConfigAndThen(() -> {
            this.checkModelStoreNameForNull(modelStoreName);
            return this.core.createModelStore(this.session.getSessionContext(), modelStoreName, (ModelRepositoryConfiguration)this.modelRepositoryConfiguration);
        });
    }

    @Override
    public PgxFuture<List<String>> listModelStoresNamesAsync() {
        return this.adaptConfigAndThen(() -> this.core.listModelStoresNames(this.session.getSessionContext(), (ModelRepositoryConfiguration)this.modelRepositoryConfiguration));
    }

    @Override
    public PgxFuture<List<String>> listModelsAsync(String modelStoreName) {
        return this.adaptConfigAndThen(() -> {
            this.checkModelStoreNameForNull(modelStoreName);
            return this.core.listModelsInModelStore(this.session.getSessionContext(), modelStoreName, (ModelRepositoryConfiguration)this.modelRepositoryConfiguration);
        });
    }

    @Override
    public PgxFuture<String> getModelDescriptionAsync(String modelStoreName, String modelName) {
        return this.adaptConfigAndThen(() -> {
            this.checkModelStoreNameForNull(modelStoreName);
            this.checkModelNameForNull(modelName);
            return this.core.getModelDescription(this.session.getSessionContext(), modelStoreName, modelName, (ModelRepositoryConfiguration)this.modelRepositoryConfiguration);
        });
    }

    @Override
    public PgxFuture<Void> deleteModelAsync(String modelStoreName, String modelName) {
        return this.adaptConfigAndThen(() -> {
            this.checkModelStoreNameForNull(modelStoreName);
            this.checkModelNameForNull(modelName);
            return this.core.deleteModel(this.session.getSessionContext(), modelStoreName, modelName, (ModelRepositoryConfiguration)this.modelRepositoryConfiguration);
        });
    }
}

