/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.mllib;

import oracle.pgx.api.internal.mllib.ModelMetadata;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.mllib.DeepWalkModelConfig;
import oracle.pgx.config.mllib.ModelKind;

public class DeepWalkModelMetadata
extends ModelMetadata {
    private String modelName;
    private int minWordFrequency = 1;
    private int batchSize = 128;
    private int numEpochs = 2;
    private int layerSize = 200;
    private double learningRate = 0.025;
    private double minLearningRate = 0.001;
    private int windowSize = 5;
    private int walkLength = 5;
    private int walksPerVertex = 4;
    private double sampleRate = 1.0E-5;
    private int negativeSample = 10;
    private Double trainingLoss = null;
    private double validationFraction = 0.05;
    private PropertyType vertexIdPropertyType = PropertyType.STRING;
    private Long seed = null;
    private boolean shuffle = false;
    private boolean ignoreIsolated = true;

    public DeepWalkModelMetadata() {
        super(ModelKind.DEEPWALK);
    }

    public DeepWalkModelMetadata(String modelName, DeepWalkModelMetadata configMetaData) {
        super(ModelKind.DEEPWALK);
        this.modelName = modelName;
        this.walkLength = configMetaData.getWalkLength();
        this.walksPerVertex = configMetaData.getWalksPerVertex();
        this.minWordFrequency = configMetaData.getMinWordFrequency();
        this.batchSize = configMetaData.getBatchSize();
        this.numEpochs = configMetaData.getNumEpochs();
        this.layerSize = configMetaData.getLayerSize();
        this.learningRate = configMetaData.getLearningRate();
        this.minLearningRate = configMetaData.getMinLearningRate();
        this.windowSize = configMetaData.getWindowSize();
        this.sampleRate = configMetaData.getSampleRate();
        this.negativeSample = configMetaData.getNegativeSample();
        this.trainingLoss = configMetaData.getLoss();
        this.validationFraction = configMetaData.getValidationFraction();
        this.vertexIdPropertyType = configMetaData.getVertexIdPropertyType();
        this.seed = configMetaData.getSeed();
        this.shuffle = configMetaData.isShuffle();
        this.ignoreIsolated = configMetaData.ignoreIsolated;
    }

    public DeepWalkModelMetadata(String modelName, DeepWalkModelConfig modelConfig) {
        this.modelName = modelName;
        this.walkLength = modelConfig.getWalkLength();
        this.walksPerVertex = modelConfig.getWalksPerVertex();
        this.minWordFrequency = modelConfig.getMinWordFrequency();
        this.batchSize = modelConfig.getBatchSize();
        this.numEpochs = modelConfig.getNumEpochs();
        this.layerSize = modelConfig.getLayerSize();
        this.learningRate = modelConfig.getLearningRate();
        this.minLearningRate = modelConfig.getMinLearningRate();
        this.windowSize = modelConfig.getWindowSize();
        this.sampleRate = modelConfig.getSampleRate();
        this.negativeSample = modelConfig.getNegativeSample();
        this.trainingLoss = modelConfig.getLoss();
        this.validationFraction = modelConfig.getValidationFraction();
        this.vertexIdPropertyType = modelConfig.getVertexIdPropertyType();
        this.seed = modelConfig.getSeed();
        this.shuffle = modelConfig.isShuffle();
        this.ignoreIsolated = modelConfig.isIgnoreIsolated();
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Double getLoss() {
        return this.trainingLoss;
    }

    public void setLoss(Double trainingLoss) {
        this.trainingLoss = trainingLoss;
    }

    public int getWalkLength() {
        return this.walkLength;
    }

    public void setWalkLength(int walkLength) {
        this.walkLength = walkLength;
    }

    public int getWalksPerVertex() {
        return this.walksPerVertex;
    }

    public void setWalksPerVertex(int walksPerVertex) {
        this.walksPerVertex = walksPerVertex;
    }

    public int getMinWordFrequency() {
        return this.minWordFrequency;
    }

    public void setMinWordFrequency(int minWordFrequency) {
        this.minWordFrequency = minWordFrequency;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getNumEpochs() {
        return this.numEpochs;
    }

    public void setNumEpochs(int numEpochs) {
        this.numEpochs = numEpochs;
    }

    public int getLayerSize() {
        return this.layerSize;
    }

    public void setLayerSize(int layerSize) {
        this.layerSize = layerSize;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public double getMinLearningRate() {
        return this.minLearningRate;
    }

    public void setMinLearningRate(double minLearningRate) {
        this.minLearningRate = minLearningRate;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getNegativeSample() {
        return this.negativeSample;
    }

    public void setNegativeSample(int negativeSample) {
        this.negativeSample = negativeSample;
    }

    public double getValidationFraction() {
        return this.validationFraction;
    }

    public void setValidationFraction(double validationFraction) {
        this.validationFraction = validationFraction;
    }

    public PropertyType getVertexIdPropertyType() {
        return this.vertexIdPropertyType;
    }

    public void setVertexIdPropertyType(PropertyType vertexIdPropertyType) {
        this.vertexIdPropertyType = vertexIdPropertyType;
    }

    public Double getTrainingLoss() {
        return this.trainingLoss;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public boolean isIgnoreIsolated() {
        return this.ignoreIsolated;
    }

    public void setIgnoreIsolated(boolean ignoreIsolated) {
        this.ignoreIsolated = ignoreIsolated;
    }
}

