/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.characteristic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import oracle.pgx.api.internal.characteristic.WorkloadCharacteristic;
import oracle.pgx.api.internal.characteristic.WorkloadCharacteristicSet;
import oracle.pgx.common.util.SimpleLruCache;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkloadCharacteristicTranslation<T> {
    private static final Logger LOG = LoggerFactory.getLogger(WorkloadCharacteristicTranslation.class);
    public static final int CACHE_SIZE = 10;
    private final List<Pair<Predicate<WorkloadCharacteristicSet>, Supplier<T>>> predicates = new ArrayList<Pair<Predicate<WorkloadCharacteristicSet>, Supplier<T>>>();
    private final Map<WorkloadCharacteristicSet, T> cache = new SimpleLruCache(10);
    private T lastResort;

    public T translate(WorkloadCharacteristicSet workloadCharacteristicSet) {
        return (T)this.cache.computeIfAbsent(workloadCharacteristicSet, this::translateInternal);
    }

    private T translateInternal(WorkloadCharacteristicSet workloadCharacteristicSet) {
        LOG.trace("Cache miss for {}", (Object)workloadCharacteristicSet);
        Optional<Supplier> translation = this.predicates.stream().filter(pair -> ((Predicate)pair.getLeft()).test(workloadCharacteristicSet)).map(Pair::getRight).findFirst();
        if (this.lastResort == null) {
            return translation.orElseThrow(IllegalArgumentException::new).get();
        }
        return (T)translation.orElse(() -> this.lastResort).get();
    }

    public ThenSelector ifContainsAll(WorkloadCharacteristic ... workloadCharacteristics) {
        return new ThenSelector(set -> {
            LOG.trace("Matching {} against predicate {}", set, Arrays.asList(workloadCharacteristics));
            return set.containsAll(workloadCharacteristics);
        });
    }

    public ThenSelector ifIs(WorkloadCharacteristic workloadCharacteristic) {
        return new ThenSelector(set -> {
            LOG.trace("Matching {} against predicate {}", set, (Object)workloadCharacteristic);
            return set.contains(workloadCharacteristic);
        });
    }

    public WorkloadCharacteristicTranslation<T> orElse(T alternative) {
        this.lastResort = alternative;
        return this;
    }

    public final class ThenSelector {
        private final Predicate<WorkloadCharacteristicSet> predicate;

        private ThenSelector(Predicate<WorkloadCharacteristicSet> predicate) {
            this.predicate = predicate;
        }

        public WorkloadCharacteristicTranslation<T> thenReturn(T element) {
            return this.thenReturn(() -> element);
        }

        public WorkloadCharacteristicTranslation<T> thenReturn(Supplier<T> returnValue) {
            WorkloadCharacteristicTranslation.this.predicates.add(Pair.of(this.predicate, returnValue));
            return WorkloadCharacteristicTranslation.this;
        }

        public <E extends RuntimeException> WorkloadCharacteristicTranslation<T> thenThrow(Supplier<? extends E> exceptionSupplier) {
            WorkloadCharacteristicTranslation.this.predicates.add(Pair.of(this.predicate, () -> {
                throw (RuntimeException)exceptionSupplier.get();
            }));
            return WorkloadCharacteristicTranslation.this;
        }
    }
}

