/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.algorithm.arguments;

import java.util.Arrays;
import java.util.Collection;
import oracle.pgx.api.internal.algorithm.arguments.AbstractArguments;

public final class PagerankArguments
extends AbstractArguments {
    public static final double MAX_ERROR = 0.001;
    public static final double DAMPING_FACTOR = 0.85;
    public static final int MAX_ITERATIONS = 100;
    public static final boolean NORMALIZED = false;
    private static final String DEFAULT_NAME = "pagerank";
    private static final String DEFAULT_APPROXIMATE_NAME = "approx_pagerank";
    private static final String DEFAULT_WEIGHTED_NAME = "weighted_pagerank";
    private static final String DEFAULT_PERSONALIZED_NAME = "personalized_pagerank";
    private static final String DEFAULT_PERSONALIZED_WEIGHTED_NAME = "personalized_weighted_pagerank";

    public String getDefaultName(PagerankVariant variant) {
        switch (variant) {
            case APPROXIMATE: {
                return DEFAULT_APPROXIMATE_NAME;
            }
            case WEIGHTED: {
                return DEFAULT_WEIGHTED_NAME;
            }
            case PERSONALIZED: {
                return DEFAULT_PERSONALIZED_NAME;
            }
            case PERSONALIZED_WEIGHTED: {
                return DEFAULT_PERSONALIZED_WEIGHTED_NAME;
            }
        }
        return DEFAULT_NAME;
    }

    @Override
    protected Collection<String> getAvailableArgs() {
        return Arrays.asList("graph", "error", "dampingFactor", "maxIterations", "normalize", DEFAULT_NAME, "pagerankPropertyName", "variant", "weight", "vertex", "vertices");
    }

    public static enum PagerankVariant {
        DEFAULT,
        APPROXIMATE,
        WEIGHTED,
        PERSONALIZED,
        PERSONALIZED_WEIGHTED;

    }
}

