/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.graphalteration.internal;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import oracle.pgx.api.GraphMetaData;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.graphalteration.GraphAlterationBuilder;
import oracle.pgx.api.graphalteration.internal.GraphAlterationEmptyEdgeProviderBuilderImpl;
import oracle.pgx.api.graphalteration.internal.GraphAlterationEmptyVertexProviderBuilderImpl;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AnyFormatEntityProviderConfigFactory;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.internal.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphAlterationBuilderImpl
implements GraphAlterationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GraphAlterationBuilderImpl.class);
    private final Core core;
    private final PgxSession session;
    private final String keystorePath;
    private final char[] keystorePassword;
    private final PgxGraph graph;
    private final BiFunction<PgxSession, Graph, PgxGraph> pgxGraphConstructor;
    private String dataSourceVersion;
    private boolean cascadeEdgeProviderRemovals = false;
    private final LinkedHashMap<String, EntityProviderConfig> addedVertexProviders = new LinkedHashMap();
    private final LinkedHashMap<String, EntityProviderConfig> addedEdgeProviders = new LinkedHashMap();
    private final LinkedHashMap<String, GraphAlterationEmptyVertexProviderBuilderImpl> addedEmptyVertexProviders = new LinkedHashMap();
    private final LinkedHashMap<String, GraphAlterationEmptyEdgeProviderBuilderImpl> addedEmptyEdgeProviders = new LinkedHashMap();
    private final Set<String> removedVertexProviders = new HashSet<String>();
    private final Set<String> removedEdgeProviders = new HashSet<String>();

    public GraphAlterationBuilderImpl(Core core, PgxSession session, String keystorePath, char[] keystorePassword, PgxGraph graph, BiFunction<PgxSession, Graph, PgxGraph> pgxGraphConstructor) {
        this.core = core;
        this.session = session;
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.graph = graph;
        this.pgxGraphConstructor = pgxGraphConstructor;
    }

    private static EntityProviderConfig readConfig(String configPath) throws IOException {
        return (EntityProviderConfig)new AnyFormatEntityProviderConfigFactory().fromPath(configPath);
    }

    private static EntityProviderConfig getConfigWithCredentials(String keystorePath, char[] password, EntityProviderConfig config) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return ConfigUtils.createProviderConfigWithCredentials((String)keystorePath, (char[])password, (EntityProviderConfig)config);
    }

    @Override
    public void setDataSourceVersion(String dataSourceVersion) {
        this.dataSourceVersion = dataSourceVersion;
    }

    @Override
    public GraphAlterationBuilder cascadeEdgeProviderRemovals(boolean cascadeEdgeProviderRemovals) {
        this.cascadeEdgeProviderRemovals = cascadeEdgeProviderRemovals;
        return this;
    }

    @Override
    public GraphAlterationBuilder addVertexProvider(String pathToVertexProviderConfig) throws IOException {
        return this.addVertexProvider(GraphAlterationBuilderImpl.readConfig(pathToVertexProviderConfig));
    }

    @Override
    public GraphAlterationBuilder addVertexProvider(EntityProviderConfig vertexProviderConfig) {
        String providerName = vertexProviderConfig.getName();
        this.checkVertexProviderNotAlreadyAdded(providerName);
        this.addedVertexProviders.put(providerName, vertexProviderConfig);
        return this;
    }

    @Override
    public GraphAlterationEmptyVertexProviderBuilderImpl addEmptyVertexProvider(String providerName) {
        GraphAlterationEmptyVertexProviderBuilderImpl vertexProviderBuilder = new GraphAlterationEmptyVertexProviderBuilderImpl(this, providerName);
        this.checkVertexProviderNotAlreadyAdded(providerName);
        this.addedEmptyVertexProviders.put(providerName, vertexProviderBuilder);
        return vertexProviderBuilder;
    }

    public void checkVertexProviderNotAlreadyAdded(String providerName) {
        if (this.addedVertexProviders.containsKey(providerName) || this.addedEmptyVertexProviders.containsKey(providerName)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_ALTERATION_VERTEX_PROVIDER_ALREADY_ADDED", (Object[])new Object[]{providerName}));
        }
    }

    @Override
    public GraphAlterationBuilder removeVertexProvider(String vertexProviderName) {
        if (this.removedVertexProviders.contains(vertexProviderName)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_ALTERATION_VERTEX_PROVIDER_ALREADY_REMOVED", (Object[])new Object[]{vertexProviderName}));
        }
        this.removedVertexProviders.add(vertexProviderName);
        return this;
    }

    @Override
    public GraphAlterationBuilder addEdgeProvider(String pathToEdgeProviderConfig) throws IOException {
        return this.addEdgeProvider(GraphAlterationBuilderImpl.readConfig(pathToEdgeProviderConfig));
    }

    @Override
    public GraphAlterationBuilder addEdgeProvider(EntityProviderConfig edgeProviderConfig) {
        String providerName = edgeProviderConfig.getName();
        this.checkEdgeProviderNotAlreadyAdded(providerName);
        this.addedEdgeProviders.put(providerName, edgeProviderConfig);
        return this;
    }

    @Override
    public GraphAlterationEmptyEdgeProviderBuilderImpl addEmptyEdgeProvider(String providerName, String sourceProvider, String destProvider) {
        GraphAlterationEmptyEdgeProviderBuilderImpl edgeProviderBuilder = new GraphAlterationEmptyEdgeProviderBuilderImpl(this, providerName, sourceProvider, destProvider);
        this.checkEdgeProviderNotAlreadyAdded(providerName);
        this.addedEmptyEdgeProviders.put(providerName, edgeProviderBuilder);
        return edgeProviderBuilder;
    }

    public void checkEdgeProviderNotAlreadyAdded(String providerName) {
        if (this.addedEdgeProviders.containsKey(providerName) || this.addedEmptyEdgeProviders.containsKey(providerName)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_ALTERATION_EDGE_PROVIDER_ALREADY_ADDED", (Object[])new Object[]{providerName}));
        }
    }

    @Override
    public GraphAlterationBuilder removeEdgeProvider(String edgeProviderName) {
        if (this.removedEdgeProviders.contains(edgeProviderName)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_ALTERATION_EDGE_PROVIDER_ALREADY_REMOVED", (Object[])new Object[]{edgeProviderName}));
        }
        this.removedEdgeProviders.add(edgeProviderName);
        return this;
    }

    @Override
    public PgxFuture<PgxGraph> buildAsync(String newGraphName) {
        LinkedHashMap<String, EntityProviderConfig> addedVertexProvidersWithCredentials = new LinkedHashMap<String, EntityProviderConfig>();
        PgxFuture<PgxGraph> exceptionFuture = this.addCredentialsInConfigs(this.addedVertexProviders, addedVertexProvidersWithCredentials);
        if (exceptionFuture != null) {
            return exceptionFuture;
        }
        LinkedHashMap<String, EntityProviderConfig> addedEmptyVertexConfigs = new LinkedHashMap<String, EntityProviderConfig>();
        this.addedEmptyVertexProviders.forEach((name, builder) -> addedEmptyVertexConfigs.put((String)name, builder.buildProviderConfig()));
        LinkedHashMap<String, EntityProviderConfig> addedEdgeProvidersWithCredentials = new LinkedHashMap<String, EntityProviderConfig>();
        exceptionFuture = this.addCredentialsInConfigs(this.addedEdgeProviders, addedEdgeProvidersWithCredentials);
        if (exceptionFuture != null) {
            return exceptionFuture;
        }
        LinkedHashMap<String, EntityProviderConfig> addedEmptyEdgeConfigs = new LinkedHashMap<String, EntityProviderConfig>();
        this.addedEmptyEdgeProviders.forEach((name, builder) -> addedEmptyEdgeConfigs.put((String)name, builder.buildProviderConfig()));
        return this.core.alterGraph(this.session.getSessionContext(), this.graph.getId(), newGraphName, this.cascadeEdgeProviderRemovals, addedVertexProvidersWithCredentials, addedEdgeProvidersWithCredentials, addedEmptyVertexConfigs, addedEmptyEdgeConfigs, this.removedVertexProviders, this.removedEdgeProviders, this.dataSourceVersion).thenApply(graph -> {
            GraphMetaData metaData = graph.getMetaData();
            LOG.info("Altered a graph with {} vertices and {} edges. Vertex properties: {}. Edge properties: {}.", new Object[]{metaData.getNumVertices(), metaData.getNumEdges(), graph.getVertexPropertyNames(), graph.getEdgePropertyNames()});
            return this.pgxGraphConstructor.apply(this.session, (Graph)((Object)graph));
        });
    }

    @Override
    public PgxFuture<PgxGraph> buildNewSnapshotAsync() {
        LinkedHashMap<String, EntityProviderConfig> addedVertexProvidersWithCredentials = new LinkedHashMap<String, EntityProviderConfig>();
        PgxFuture<PgxGraph> exceptionFuture = this.addCredentialsInConfigs(this.addedVertexProviders, addedVertexProvidersWithCredentials);
        if (exceptionFuture != null) {
            return exceptionFuture;
        }
        LinkedHashMap<String, EntityProviderConfig> addedEmptyVertexConfigs = new LinkedHashMap<String, EntityProviderConfig>();
        this.addedEmptyVertexProviders.forEach((name, builder) -> addedEmptyVertexConfigs.put((String)name, builder.buildProviderConfig()));
        LinkedHashMap<String, EntityProviderConfig> addedEdgeProvidersWithCredentials = new LinkedHashMap<String, EntityProviderConfig>();
        exceptionFuture = this.addCredentialsInConfigs(this.addedEdgeProviders, addedEdgeProvidersWithCredentials);
        if (exceptionFuture != null) {
            return exceptionFuture;
        }
        LinkedHashMap<String, EntityProviderConfig> addedEmptyEdgeConfigs = new LinkedHashMap<String, EntityProviderConfig>();
        this.addedEmptyEdgeProviders.forEach((name, builder) -> addedEmptyEdgeConfigs.put((String)name, builder.buildProviderConfig()));
        return this.core.alterGraphNewSnapshot(this.session.getSessionContext(), this.graph.getId(), this.cascadeEdgeProviderRemovals, addedVertexProvidersWithCredentials, addedEdgeProvidersWithCredentials, addedEmptyVertexConfigs, addedEmptyEdgeConfigs, this.removedVertexProviders, this.removedEdgeProviders, this.dataSourceVersion).thenApply(graph -> {
            GraphMetaData metaData = graph.getMetaData();
            LOG.info("Created a new snapshot from graph alteration  with {} vertices and {} edges. Vertex properties: {}. Edge properties: {}.", new Object[]{metaData.getNumVertices(), metaData.getNumEdges(), graph.getVertexPropertyNames(), graph.getEdgePropertyNames()});
            return this.pgxGraphConstructor.apply(this.session, (Graph)((Object)graph));
        });
    }

    protected PgxFuture<PgxGraph> addCredentialsInConfigs(LinkedHashMap<String, EntityProviderConfig> providers, LinkedHashMap<String, EntityProviderConfig> addedEdgeProvidersWithCredentials) {
        try {
            for (Map.Entry<String, EntityProviderConfig> entry : providers.entrySet()) {
                String name = entry.getKey();
                EntityProviderConfig config = entry.getValue();
                addedEdgeProvidersWithCredentials.put(name, GraphAlterationBuilderImpl.getConfigWithCredentials(this.keystorePath, this.keystorePassword, config));
            }
        }
        catch (Exception e) {
            return PgxFuture.exceptionallyCompletedFuture(e);
        }
        return null;
    }
}

