/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.schema.internal.dispatchers.collection;

import java.util.function.Function;
import oracle.pgx.api.frames.schema.datatypes.collection.CollectionType;
import oracle.pgx.api.frames.schema.datatypes.collection.SetType;
import oracle.pgx.api.frames.schema.datatypes.collection.VectorType;
import oracle.pgx.api.frames.schema.internal.dispatchers.DataTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.collection.SetTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.collection.VectorTypeDispatcher;

@FunctionalInterface
public interface CollectionTypeDispatcher<R>
extends Function<CollectionType, R> {
    public static <R> CollectionTypeDispatcher<R> dispatcher(final SetTypeDispatcher<R> setTypeDispatcher, final VectorTypeDispatcher<R> vectorTypeDispatcher) {
        return new DefaultCollectionTypeDispatcher<R>(){

            @Override
            public R applySetType(SetType type) {
                return DataTypeDispatcher.applyType(setTypeDispatcher, type);
            }

            @Override
            public R applyVectorType(VectorType type) {
                return DataTypeDispatcher.applyType(vectorTypeDispatcher, type);
            }
        };
    }

    public static <R> R dispatch(SetTypeDispatcher<R> setTypeDispatcher, VectorTypeDispatcher<R> vectorTypeDispatcher, CollectionType dataType) {
        return CollectionTypeDispatcher.dispatcher(setTypeDispatcher, vectorTypeDispatcher).apply(dataType);
    }

    public static interface DefaultCollectionTypeDispatcher<R>
    extends CollectionTypeDispatcher<R> {
        @Override
        default public R apply(CollectionType dataType) {
            if (dataType instanceof SetType) {
                return (R)DataTypeDispatcher.applyType(this::applySetType, (SetType)dataType);
            }
            if (dataType instanceof VectorType) {
                return (R)DataTypeDispatcher.applyType(this::applyVectorType, (VectorType)dataType);
            }
            return (R)DataTypeDispatcher.throwNoDispatcherForType(dataType);
        }

        default public R applySetType(SetType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyVectorType(VectorType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }
    }
}

