/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.schema.internal.dispatchers;

import java.util.function.Function;
import oracle.pgx.api.frames.schema.datatypes.BooleanType;
import oracle.pgx.api.frames.schema.datatypes.DataType;
import oracle.pgx.api.frames.schema.datatypes.StringType;
import oracle.pgx.api.frames.schema.datatypes.collection.CollectionType;
import oracle.pgx.api.frames.schema.datatypes.graph.GraphEntityType;
import oracle.pgx.api.frames.schema.datatypes.numeric.NumericType;
import oracle.pgx.api.frames.schema.datatypes.spatial.SpatialType;
import oracle.pgx.api.frames.schema.datatypes.temporal.TemporalType;
import oracle.pgx.api.frames.schema.internal.dispatchers.BooleanTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.StringTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.collection.CollectionTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.graph.GraphEntityTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.numeric.NumericTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.spatial.SpatialTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.temporal.TemporalTypeDispatcher;
import oracle.pgx.common.util.ErrorMessages;

@FunctionalInterface
public interface DataTypeDispatcher<R>
extends Function<DataType, R> {
    public static <R> DataTypeDispatcher<R> dispatcher(final BooleanTypeDispatcher<R> booleanTypeDispatcher, final StringTypeDispatcher<R> stringTypeDispatcher, final NumericTypeDispatcher<R> numericTypeDispatcher, final TemporalTypeDispatcher<R> temporalTypeDispatcher, final CollectionTypeDispatcher<R> collectionTypeDispatcher, final SpatialTypeDispatcher<R> spatialTypeDispatcher, final GraphEntityTypeDispatcher<R> graphTypeDispatcher) {
        return new DefaultDataTypeDispatcher<R>(){

            @Override
            public R applyBooleanType(BooleanType type) {
                return DataTypeDispatcher.applyType(booleanTypeDispatcher, type);
            }

            @Override
            public R applyStringType(StringType type) {
                return DataTypeDispatcher.applyType(stringTypeDispatcher, type);
            }

            @Override
            public R applyNumericType(NumericType type) {
                return DataTypeDispatcher.applyType(numericTypeDispatcher, type);
            }

            @Override
            public R applyTemporalType(TemporalType type) {
                return DataTypeDispatcher.applyType(temporalTypeDispatcher, type);
            }

            @Override
            public R applyCollectionType(CollectionType type) {
                return DataTypeDispatcher.applyType(collectionTypeDispatcher, type);
            }

            @Override
            public R applySpatialType(SpatialType type) {
                return DataTypeDispatcher.applyType(spatialTypeDispatcher, type);
            }

            @Override
            public R applyGraphEntityType(GraphEntityType type) {
                return DataTypeDispatcher.applyType(graphTypeDispatcher, type);
            }
        };
    }

    public static <R> R dispatch(BooleanTypeDispatcher<R> booleanTypeDispatcher, StringTypeDispatcher<R> stringTypeDispatcher, NumericTypeDispatcher<R> numericTypeDispatcher, TemporalTypeDispatcher<R> temporalTypeDispatcher, CollectionTypeDispatcher<R> collectionTypeDispatcher, SpatialTypeDispatcher<R> spatialTypeDispatcher, GraphEntityTypeDispatcher<R> graphTypeDispatcher, DataType dataType) {
        return DataTypeDispatcher.dispatcher(booleanTypeDispatcher, stringTypeDispatcher, numericTypeDispatcher, temporalTypeDispatcher, collectionTypeDispatcher, spatialTypeDispatcher, graphTypeDispatcher).apply(dataType);
    }

    public static <T> T throwNoDispatcherForType(DataType dataType) {
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_DATATYPE", (Object[])new Object[]{dataType}));
    }

    public static <R, D extends DataType> R applyType(Function<D, R> consumer, D dataType) {
        if (consumer == null) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(dataType);
        }
        return consumer.apply(dataType);
    }

    public static interface DefaultDataTypeDispatcher<R>
    extends DataTypeDispatcher<R> {
        @Override
        default public R apply(DataType dataType) {
            if (dataType instanceof BooleanType) {
                return (R)DataTypeDispatcher.applyType(this::applyBooleanType, (BooleanType)dataType);
            }
            if (dataType instanceof StringType) {
                return (R)DataTypeDispatcher.applyType(this::applyStringType, (StringType)dataType);
            }
            if (dataType instanceof NumericType) {
                return (R)DataTypeDispatcher.applyType(this::applyNumericType, (NumericType)dataType);
            }
            if (dataType instanceof TemporalType) {
                return (R)DataTypeDispatcher.applyType(this::applyTemporalType, (TemporalType)dataType);
            }
            if (dataType instanceof CollectionType) {
                return (R)DataTypeDispatcher.applyType(this::applyCollectionType, (CollectionType)dataType);
            }
            if (dataType instanceof SpatialType) {
                return (R)DataTypeDispatcher.applyType(this::applySpatialType, (SpatialType)dataType);
            }
            if (dataType instanceof GraphEntityType) {
                return (R)DataTypeDispatcher.applyType(this::applyGraphEntityType, (GraphEntityType)dataType);
            }
            return (R)DataTypeDispatcher.throwNoDispatcherForType(dataType);
        }

        default public R applyBooleanType(BooleanType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyStringType(StringType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyNumericType(NumericType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyTemporalType(TemporalType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyCollectionType(CollectionType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applySpatialType(SpatialType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyGraphEntityType(GraphEntityType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }
    }
}

