/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.expansion;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.expansion.PropertyMergeStrategy;
import oracle.pgx.api.expansion.internal.GraphExpansionConfig;
import oracle.pgx.api.subgraph.internal.KeystoreLookup;
import oracle.pgx.config.PartitionedGraphConfig;

@BetaApi
public abstract class AbstractGraphExpander<E extends AbstractGraphExpander<E>> {
    protected final PartitionedGraphConfig graphConfig;
    protected PartitionedGraphConfig expansionConfig;
    protected final PgxSession session;
    protected final Function<GraphExpansionConfig, PgxFuture<PgxGraph>> expansionFunction;
    protected PropertyMergeStrategy vertexPropertyMergeStrategy;
    protected PropertyMergeStrategy edgePropertyMergeStrategy;
    protected final KeystoreLookup keystoreLookup;

    public AbstractGraphExpander(PartitionedGraphConfig graphConfig, PgxSession session, Function<GraphExpansionConfig, PgxFuture<PgxGraph>> expansionFunction, KeystoreLookup keystoreLookup) {
        this.graphConfig = graphConfig;
        this.session = session;
        this.expansionFunction = expansionFunction;
        this.keystoreLookup = keystoreLookup;
        this.vertexPropertyMergeStrategy = PropertyMergeStrategy.getDefault();
        this.edgePropertyMergeStrategy = PropertyMergeStrategy.getDefault();
    }

    protected abstract E getThis();

    protected abstract PgxFuture<GraphExpansionConfig> buildExpansionConfig(String var1, boolean var2);

    public PgxFuture<PgxGraph> expandAsync() {
        return this.expandAsync(null);
    }

    public PgxFuture<PgxGraph> expandAsync(String newGraphName) {
        return this.buildExpansionConfig(newGraphName, false).thenCompose(this.expansionFunction);
    }

    public PgxFuture<PgxGraph> expandNewSnapshotAsync() {
        return this.buildExpansionConfig(null, true).thenCompose(this.expansionFunction);
    }

    public PgxGraph expand() throws ExecutionException, InterruptedException {
        return this.expand(null);
    }

    public PgxGraph expand(String newGraphName) throws ExecutionException, InterruptedException {
        return this.expandAsync(newGraphName).get();
    }

    public PgxGraph expandNewSnapshot() throws ExecutionException, InterruptedException {
        return this.expandNewSnapshotAsync().get();
    }

    public E vertexPropertiesMergingStrategy(PropertyMergeStrategy vertexPropertyMergeStrategy) {
        this.vertexPropertyMergeStrategy = Objects.requireNonNull(vertexPropertyMergeStrategy);
        return this.getThis();
    }

    public E edgePropertiesMergingStrategy(PropertyMergeStrategy edgePropertyMergeStrategy) {
        this.edgePropertyMergeStrategy = Objects.requireNonNull(edgePropertyMergeStrategy);
        return this.getThis();
    }

    public E withConfig(PartitionedGraphConfig config) {
        this.expansionConfig = config;
        return this.getThis();
    }
}

