/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.executionenvironment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PoolType;
import oracle.pgx.api.executionenvironment.AbstractEnvironment;
import oracle.pgx.api.executionenvironment.CpuEnvironment;
import oracle.pgx.api.executionenvironment.ExecutionEnvironmentField;
import oracle.pgx.api.executionenvironment.IoEnvironment;
import oracle.pgx.api.internal.ApiObject;
import oracle.pgx.api.internal.CoreSessionApi;
import oracle.pgx.config.UpdateConsistencyModel;

public final class ExecutionEnvironment
extends ApiObject {
    private final PgxSession session;
    private final IoEnvironment ioEnvironment;
    private final CpuEnvironment analysisEnvironment;
    private final CpuEnvironment fastAnalysisEnvironment;
    private final Map<PoolType, AbstractEnvironment> allEnvironments = new HashMap<PoolType, AbstractEnvironment>();
    private final CoreSessionApi coreSessionApi;

    public ExecutionEnvironment(PgxSession session, CoreSessionApi coreSessionApi) {
        this.session = session;
        this.ioEnvironment = new IoEnvironment(session, coreSessionApi);
        this.analysisEnvironment = new CpuEnvironment(session, coreSessionApi, PoolType.ANALYSIS_POOL);
        this.fastAnalysisEnvironment = new CpuEnvironment(session, coreSessionApi, PoolType.FAST_TRACK_ANALYSIS_POOL);
        this.allEnvironments.put(PoolType.IO_POOL, this.ioEnvironment);
        this.allEnvironments.put(PoolType.ANALYSIS_POOL, this.analysisEnvironment);
        this.allEnvironments.put(PoolType.FAST_TRACK_ANALYSIS_POOL, this.fastAnalysisEnvironment);
        this.coreSessionApi = coreSessionApi;
    }

    private static List<Map.Entry<String, Object>> addPoolType(Set<Map.Entry<String, Object>> entries, PoolType poolType) {
        return entries.stream().map(entry -> ExecutionEnvironment.entry((Object)((Object)poolType) + "." + (String)entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    public PgxFuture<List<Map.Entry<String, Object>>> getValuesAsync() {
        CopyOnWriteArrayList values = new CopyOnWriteArrayList();
        ArrayList futures = new ArrayList();
        for (Map.Entry<PoolType, AbstractEnvironment> environmentEntry : this.allEnvironments.entrySet()) {
            PoolType poolType = environmentEntry.getKey();
            AbstractEnvironment environment = environmentEntry.getValue();
            CompletableFuture valuesFuture = ((PgxFuture)((PgxFuture)environment.getValuesAsync().thenApply(Map::entrySet)).thenApply(entries -> ExecutionEnvironment.addPoolType(entries, poolType))).thenAccept(values::addAll);
            futures.add(valuesFuture);
        }
        return PgxFuture.allOf(futures).thenReturn(values);
    }

    public <T> PgxFuture<T> withMaxNumThreadsAsync(int maxNumThreads, Supplier<PgxFuture<T>> asyncRequest) {
        return this.ioEnvironment.withNumThreadsPerTaskAsync(maxNumThreads, () -> this.analysisEnvironment.withMaxNumThreadsAsync(maxNumThreads, () -> this.lambda$null$2(maxNumThreads, (Supplier)asyncRequest)));
    }

    public PgxFuture<Void> resetAsync() {
        List resetFutures = this.allEnvironments.values().stream().map(AbstractEnvironment::resetAsync).collect(Collectors.toList());
        resetFutures.add(this.resetUpdateConsistencyModelAsync());
        return PgxFuture.allOf(resetFutures);
    }

    public void reset() throws ExecutionException, InterruptedException {
        this.resetAsync().get();
    }

    public <T> T withMaxNumThreads(int maxNumThreads, Supplier<PgxFuture<T>> asyncRequest) throws ExecutionException, InterruptedException {
        return this.withMaxNumThreadsAsync(maxNumThreads, asyncRequest).get();
    }

    public List<Map.Entry<String, Object>> getValues() throws ExecutionException, InterruptedException {
        return this.getValuesAsync().get();
    }

    public PgxSession getSession() {
        return this.session;
    }

    public IoEnvironment getIoEnvironment() {
        return this.ioEnvironment;
    }

    public PgxFuture<Void> setUpdateConsistencyModelAsync(UpdateConsistencyModel model) {
        return this.coreSessionApi.updateExecutionEnvironment(this.session.getSessionContext(), null, ExecutionEnvironmentField.UPDATE_CONSISTENCY_MODEL, model);
    }

    public PgxFuture<UpdateConsistencyModel> getUpdateConsistencyModelAsync() {
        return this.coreSessionApi.getExecutionEnvironment(this.session.getSessionContext(), null, ExecutionEnvironmentField.UPDATE_CONSISTENCY_MODEL).thenApply(UpdateConsistencyModel.class::cast);
    }

    public PgxFuture<Void> resetUpdateConsistencyModelAsync() {
        return this.setUpdateConsistencyModelAsync(null);
    }

    public <T> PgxFuture<T> withUpdateConsistencyModelAsync(UpdateConsistencyModel model, Supplier<PgxFuture<T>> asyncRequest) {
        return this.getUpdateConsistencyModelAsync().thenCompose(updateConsistencyModel -> ((PgxFuture)this.setUpdateConsistencyModelAsync(model).thenCompose(arg_0 -> ExecutionEnvironment.lambda$null$4((Supplier)asyncRequest, arg_0))).thenCompose(result -> this.setUpdateConsistencyModelAsync((UpdateConsistencyModel)updateConsistencyModel).thenReturn(result)));
    }

    public void setUpdateConsistencyModel(UpdateConsistencyModel model) {
        this.setUpdateConsistencyModelAsync(model).join();
    }

    public void resetUpdateConsistencyModel() {
        this.resetUpdateConsistencyModelAsync().join();
    }

    public <T> T withUpdateConsistencyModel(UpdateConsistencyModel model, Supplier<PgxFuture<T>> asyncRequest) {
        return this.withUpdateConsistencyModelAsync(model, asyncRequest).join();
    }

    public UpdateConsistencyModel getUpdateConsistencyModel() {
        return this.getUpdateConsistencyModelAsync().join();
    }

    public CpuEnvironment getAnalysisEnvironment() {
        return this.analysisEnvironment;
    }

    public CpuEnvironment getFastAnalysisEnvironment() {
        return this.fastAnalysisEnvironment;
    }

    public PgxFuture<Boolean> allowsConcurrentTasksAsync() {
        return this.coreSessionApi.getExecutionEnvironment(this.session.getSessionContext(), null, ExecutionEnvironmentField.ALLOW_MULTIPLE_CONCURRENT_TASKS).thenApply(Boolean.class::cast);
    }

    public boolean allowsConcurrentTasks() {
        return this.allowsConcurrentTasksAsync().join();
    }

    public String toString() {
        return this.toString(ExecutionEnvironment.entry("session", this.session.getId()));
    }

    private static /* synthetic */ CompletionStage lambda$null$4(Supplier asyncRequest, Void aVoid) {
        return (PgxFuture)asyncRequest.get();
    }

    private /* synthetic */ PgxFuture lambda$null$2(int maxNumThreads, Supplier asyncRequest) {
        return this.fastAnalysisEnvironment.withMaxNumThreadsAsync(maxNumThreads, asyncRequest);
    }
}

