/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.admin.internal;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.admin.PgxShutdownException;
import oracle.pgx.api.admin.internal.AbstractControl;
import oracle.pgx.api.admin.internal.ServerState;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractEngineConfig;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.GraphConfigFactory;
import oracle.pgx.config.PgxConfig;
import oracle.pgx.config.PreloadGraphConfig;
import oracle.pgx.config.StaticConfig;
import oracle.pgx.config.internal.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEmbeddedControl<PgxConfigType extends AbstractEngineConfig>
extends AbstractControl {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEmbeddedControl.class);
    private static final int SHUTDOWN_GRACE_PERIOD_SECS = 10;
    protected ExecutorService exec = null;
    protected AtomicBoolean graphPreloadingDone = new AtomicBoolean(false);
    protected final AtomicReference<PgxConfig> pgxConfigAtomicReference = new AtomicReference();
    protected final Map<String, Object> adminUserData = new HashMap<String, Object>();

    protected GraphConfig getPreloadedGraphConfig(String keystorePath, char[] keystorePassword, GraphConfigFactory factory, PreloadGraphConfig currentGraphConfig) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        String path = currentGraphConfig.getPath();
        GraphConfig cfg = (GraphConfig)factory.fromPath(path);
        return ConfigUtils.createGraphConfigWithCredentials((GraphConfig)cfg, (String)keystorePath, (char[])keystorePassword);
    }

    protected final PgxConfigType loadConfig(String json) throws IOException {
        PgxConfigType config = this.doLoadConfig(json);
        this.validateConfig(config);
        return config;
    }

    protected abstract PgxConfigType doLoadConfig(String var1) throws IOException;

    protected void validateConfig(PgxConfigType config) {
    }

    @Override
    public synchronized PgxFuture<Void> shutdownNow() {
        return this.shutdown(10L, TimeUnit.SECONDS).thenAccept(shutdownSuccessful -> {
            if (!shutdownSuccessful.booleanValue()) {
                LOG.debug("shutdownNow timed out");
                this.logThreadStackDump();
                throw new PgxShutdownException(ErrorMessages.getMessage((String)"SHUTDOWN_GRACE_PERIOD_TIMED_OUT", (Object[])new Object[0]));
            }
        });
    }

    protected void logThreadStackDump() {
        LogLevelPrinter logLevelPrinter;
        BooleanSupplier loggingLevelCheck;
        if (StaticConfig.get().isRelease().booleanValue()) {
            loggingLevelCheck = () -> ((Logger)LOG).isTraceEnabled();
            logLevelPrinter = (arg_0, arg_1) -> ((Logger)LOG).trace(arg_0, arg_1);
        } else {
            loggingLevelCheck = () -> ((Logger)LOG).isDebugEnabled();
            logLevelPrinter = (arg_0, arg_1) -> ((Logger)LOG).debug(arg_0, arg_1);
        }
        if (loggingLevelCheck.getAsBoolean()) {
            Thread.getAllStackTraces().forEach((thread, stackTraceElements) -> {
                logLevelPrinter.log("Thread: {}", thread.getName());
                Stream.of(stackTraceElements).forEach(stackTraceElement -> logLevelPrinter.log("    {}", stackTraceElement));
                logLevelPrinter.log("", new Object[0]);
            });
        }
    }

    protected ExecutorService getExec() {
        return this.exec;
    }

    protected synchronized void setExec(ExecutorService exec) {
        this.exec = exec;
        this.graphPreloadingDone.set(false);
    }

    protected abstract PgxFuture<JsonNode> getServerState(ServerState ... var1);

    @Override
    public PgxFuture<Boolean> isRunning() {
        double runningMemoryUsageRatio = this.getMemoryUsageRatio(PgxConfig::getRunningMemoryUsageRatio);
        return AbstractEmbeddedControl.runOnCallerThread(this::up).thenCombine(this.hasAvailableMemory(runningMemoryUsageRatio), (up, hasMem) -> up != false && hasMem != false);
    }

    @Override
    public PgxFuture<Boolean> isReady() {
        double readinessMemoryUsageRatio = this.getMemoryUsageRatio(PgxConfig::getReadinessMemoryUsageRatio);
        return this.hasAvailableMemory(readinessMemoryUsageRatio);
    }

    protected double getMemoryUsageRatio(Function<PgxConfig, Double> memoryUsageGetter) {
        if (this.pgxConfigAtomicReference != null && this.pgxConfigAtomicReference.get() != null) {
            return memoryUsageGetter.apply(this.pgxConfigAtomicReference.get());
        }
        return 1.0;
    }

    protected PgxFuture<Boolean> hasAvailableMemory(double memoryUsageRatio) {
        if (memoryUsageRatio == 1.0) {
            return PgxFuture.completedFuture(true);
        }
        return this.getServerState(ServerState.MEMORY).thenApply(jsonNode -> {
            double maximumOnHeap;
            JsonNode rawMemoryUsage = (JsonNode)((Map.Entry)jsonNode.get("memory").fields().next()).getValue();
            JsonNode onHeap = AbstractEmbeddedControl.getHeapInfo(rawMemoryUsage);
            JsonNode offHeap = AbstractEmbeddedControl.getOffHeapInfo(rawMemoryUsage);
            double usedOffHeap = offHeap.get("used_off_heap_mb").asDouble();
            double maximumOffHeap = offHeap.get("maximum_off_heap_mb").asDouble();
            double usedOnHeap = onHeap.get("used_heap_mb").asDouble();
            double memoryUsage = (usedOffHeap + usedOnHeap) / (maximumOffHeap + (maximumOnHeap = onHeap.get("maximum_heap_mb").asDouble()));
            return memoryUsage < memoryUsageRatio;
        });
    }

    protected static JsonNode getHeapInfo(JsonNode memoryInfo) {
        return AbstractEmbeddedControl.getStreamFromJsonNode(memoryInfo).filter(jsonNode -> jsonNode.get("type").asText().equals("java_heap")).findFirst().get();
    }

    protected static JsonNode getOffHeapInfo(JsonNode memoryInfo) {
        return AbstractEmbeddedControl.getStreamFromJsonNode(memoryInfo).filter(jsonNode -> jsonNode.get("type").asText().equals("unmanaged")).findFirst().get();
    }

    protected static Stream<JsonNode> getStreamFromJsonNode(JsonNode jsonNode) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(jsonNode.iterator(), 16), false);
    }

    @Override
    public PgxFuture<Boolean> isGraphPreloadingDone() {
        return AbstractEmbeddedControl.runOnCallerThread(this::getGraphPreloadingDone);
    }

    public boolean up() {
        if (this.isShutdown()) {
            return false;
        }
        return this.isUp();
    }

    protected boolean isShutdown() {
        return false;
    }

    protected synchronized boolean isUp() {
        return this.exec != null;
    }

    protected void setGraphPreloadingDone() {
        this.graphPreloadingDone.set(true);
    }

    private boolean getGraphPreloadingDone() {
        return this.graphPreloadingDone.get();
    }

    protected synchronized boolean down() {
        return !this.up();
    }

    protected abstract void reset();

    public void throwIfNotRunning() {
        if (this.down()) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"ENGINE_NOT_RUNNING", (Object[])new Object[0]));
        }
    }

    public PgxFuture<Void> throwIfNotRunningAsync() {
        return AbstractEmbeddedControl.runOnCallerThread(() -> {
            this.throwIfNotRunning();
            return null;
        });
    }

    protected void throwIfRunning() {
        if (this.up()) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"ENGINE_STILL_RUNNING", (Object[])new Object[0]));
        }
    }

    public synchronized void startImplicitlyIfNotRunning() throws ExecutionException, InterruptedException {
        if (this.down()) {
            this.start();
        }
    }

    static interface LogLevelPrinter {
        public void log(String var1, Object ... var2);
    }
}

