/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import oracle.pgx.api.Pgx;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PoolType;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.admin.Control;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.internal.ApiObject;
import oracle.pgx.api.internal.ApiProvider;
import oracle.pgx.api.internal.ClientSessionContext;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.ProxyServer;
import oracle.pgx.common.MemoryUnit;
import oracle.pgx.common.UserContext;
import oracle.pgx.common.VersionInfo;
import oracle.pgx.common.auth.PgxGenericPermission;
import oracle.pgx.common.pojo.admin.CacheStatistics;
import oracle.pgx.common.pojo.admin.GraphInfo;
import oracle.pgx.common.pojo.admin.MemoryInfo;
import oracle.pgx.common.pojo.admin.PoolInfo;
import oracle.pgx.common.pojo.admin.SessionInfo;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.config.InteractionMode;
import oracle.pgx.config.PgxConfig;
import oracle.pgx.config.StaticConfig;
import oracle.pgx.realm.client.RealmClient;
import oracle.pgx.vfs.VirtualFileManager;
import oracle.pgx.vfs.VirtualFileManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInstance
extends ApiObject {
    private static final Logger LOG = LoggerFactory.getLogger(ServerInstance.class);
    private final ClientConfig config;
    private final ApiProvider provider;
    private final PgxFuture<Control> control;
    private final PgxFuture<String> version;
    private final PgxFuture<VersionInfo> extendedVersion;
    private final VirtualFileManager vfm;
    private final RealmClient realmClient;

    ServerInstance(ClientConfig config) {
        this(config, Pgx.getProviderFor(config.getBaseUrl()));
    }

    ServerInstance(ClientConfig config, ApiProvider apiProvider) {
        this(config, apiProvider, Pgx.getRealmClientFor(config));
    }

    ServerInstance(ClientConfig config, RealmClient realmClient) {
        this(config, Pgx.getProviderFor(config.getBaseUrl()), realmClient);
    }

    ServerInstance(ClientConfig config, ApiProvider apiProvider, RealmClient realmClient) {
        this.config = config;
        this.provider = apiProvider;
        this.realmClient = realmClient;
        this.control = this.provider.createControl(config, realmClient);
        this.extendedVersion = this.onControl(Control::getExtendedVersion);
        this.version = this.extendedVersion.thenApply(VersionInfo::getReleaseVersion);
        StaticConfig.get().isEnablePluginVersionChecks();
        this.vfm = VirtualFileManagerFactory.getInstance();
    }

    ApiProvider getApiProvider() {
        return this.provider;
    }

    public boolean isEmbeddedInstance() {
        return this.getBaseUrl() == Pgx.EMBEDDED_URL || this.getBaseUrl().equals("DIST");
    }

    public String getBaseUrl() {
        return this.config.getBaseUrl();
    }

    public Integer getPrefetchSize() {
        return this.config.getPrefetchSize();
    }

    public Integer getUploadBatchSize() {
        return this.config.getUploadBatchSize();
    }

    public Integer getRemoteFutureTimeout() {
        return this.config.getRemoteFutureTimeout();
    }

    public InteractionMode getClientServerInteractionMode() {
        return this.config.getClientServerInteractionMode();
    }

    public Integer getRemoteFuturePendingRetryInterval() {
        return this.config.getRemoteFuturePendingRetryInterval();
    }

    public PgxFuture<PgxSession> createSessionAsync(String source) {
        return this.createSessionAsync(source, null, null, null);
    }

    public PgxFuture<Control> getControl() {
        return this.control;
    }

    public PgxFuture<Core> getCore() {
        PgxFuture<Boolean> promise = this.isEmbeddedInstance() ? this.isEngineRunningAsync() : PgxFuture.completedFuture(true);
        return ((PgxFuture)promise.thenCompose(isRunning -> {
            if (!isRunning.booleanValue()) {
                if (this.isEmbeddedInstance()) {
                    LOG.info("embedded mode: engine is not up, starting implicitly");
                    return this.startEngineAsync();
                }
                throw new IllegalStateException(ErrorMessages.getMessage((String)"ENGINE_NOT_RUNNING", (Object[])new Object[0]));
            }
            return PgxFuture.completedFuture(null);
        })).thenCompose(arg -> this.getApiProvider().createCore(this.config, this.realmClient));
    }

    public ProxyServer getProxyServer() {
        return this.getApiProvider().createProxyServer();
    }

    public PgxFuture<PgxSession> createSessionAsync(String source, Long idleTimeout, Long taskTimeout, TimeUnit unit) {
        return this.getCore().thenCompose(core -> {
            assert (core != null);
            URI baseUri = null;
            if (this.getBaseUrl() != null) {
                baseUri = URI.create(this.getBaseUrl());
            }
            return core.createSession(source, idleTimeout, taskTimeout, unit).thenApply(sessionContext -> new PgxSession(this, (Core)core, (SessionContext)sessionContext, source, idleTimeout, taskTimeout, unit));
        });
    }

    private <T> PgxFuture<T> onControl(Function<Control, PgxFuture<T>> fun) {
        return this.control.thenCompose(fun);
    }

    public PgxFuture<PgxSession> getSessionAsync(String id) {
        PgxFuture<Core> corePromise = this.getApiProvider().createCore(this.config, this.realmClient);
        ClientSessionContext sessionContext = new ClientSessionContext(id, null);
        return this.getSessionInfoAsync(sessionContext).thenCombine(corePromise, (info, core) -> new PgxSession(this, (Core)core, sessionContext, info.source, info.idleTimeoutMs, info.taskTimeoutMs, TimeUnit.MILLISECONDS));
    }

    public PgxFuture<PgxSession> getSessionAsync(SessionContext sessionContext) {
        PgxFuture<Core> corePromise = this.getApiProvider().createCore(this.config, this.realmClient);
        return this.getSessionInfoAsync(sessionContext).thenCombine(corePromise, (info, core) -> new PgxSession(this, (Core)core, sessionContext, info.source, info.idleTimeoutMs, info.taskTimeoutMs, TimeUnit.MILLISECONDS));
    }

    public void setToken(String token) {
        this.realmClient.setToken(token);
    }

    public String getPgxUsername() {
        return this.getPgxUsernameAsync().join();
    }

    public Set<String> getPgxUserRoles() {
        return this.getPgxUserRolesAsync().join();
    }

    public Set<PgxGenericPermission> getPgxGenericPermissions() {
        return this.getPgxGenericPermissionsAsync().join();
    }

    public PgxFuture<String> getPgxUsernameAsync() {
        return this.onControl(Control::getUsername);
    }

    public PgxFuture<Set<String>> getPgxUserRolesAsync() {
        return this.onControl(Control::getUserRoles);
    }

    public PgxFuture<Set<PgxGenericPermission>> getPgxGenericPermissionsAsync() {
        return this.onControl(Control::getSystemPermissions);
    }

    public PgxFuture<VersionInfo> getVersionAsync() {
        return this.extendedVersion;
    }

    public PgxFuture<Map<PgxConfig.Field, Object>> getPgxConfigAsync() {
        return this.onControl(Control::getPgxConfig);
    }

    public PgxFuture<PgxConfig> getPgxConfigObjectAsync() {
        return this.onControl(Control::getPgxConfigObject);
    }

    public PgxFuture<Void> startEngineAsync() {
        return this.onControl(Control::start);
    }

    public PgxFuture<Void> startEngineAsync(Map<PgxConfig.Field, Object> config) {
        return this.onControl(control -> control.start(config));
    }

    public PgxFuture<Void> startEngineAsync(InputStream config) {
        return this.onControl(control -> control.start(config));
    }

    public PgxFuture<Void> startEngineAsync(PgxConfig config) {
        return this.onControl(control -> control.start(config));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PgxFuture<Void> startEngineAsync(String path) {
        try (InputStream is = this.vfm.getInputStream(path, UserContext.UNAUTHENTICATED_USER_CONTEXT);){
            PgxFuture<Void> pgxFuture = this.startEngineAsync(is);
            return pgxFuture;
        }
        catch (Throwable th) {
            return PgxFuture.exceptionallyCompletedFuture(th);
        }
    }

    public PgxFuture<Void> updatePgxConfigAsync(PgxConfig config) {
        return this.onControl(control -> control.updatePgxConfig(config));
    }

    public PgxFuture<Void> updatePgxConfigAsync(Map<PgxConfig.Field, Object> config) {
        return this.onControl(control -> control.updatePgxConfig(config));
    }

    public PgxFuture<Void> updatePgxConfigAsync(InputStream config) {
        return this.onControl(control -> control.updatePgxConfig(config));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PgxFuture<Void> updatePgxConfigAsync(String path) {
        try (InputStream stream = this.vfm.getInputStream(path, UserContext.UNAUTHENTICATED_USER_CONTEXT);){
            PgxFuture<Void> pgxFuture = this.updatePgxConfigAsync(stream);
            return pgxFuture;
        }
        catch (Throwable t) {
            return PgxFuture.exceptionallyCompletedFuture(t);
        }
    }

    public PgxFuture<Boolean> isEngineRunningAsync() {
        return this.onControl(Control::isRunning);
    }

    public PgxFuture<Boolean> isEngineReadyAsync() {
        return this.onControl(Control::isReady);
    }

    public PgxFuture<Boolean> isGraphPreloadingDoneAsync() {
        return this.onControl(Control::isGraphPreloadingDone);
    }

    public PgxFuture<Boolean> shutdownEngineAsync(long timeout, TimeUnit unit) {
        return this.onControl(control -> control.shutdown(timeout, unit));
    }

    public PgxFuture<Void> shutdownEngineNowAsync() {
        return this.onControl(Control::shutdownNow);
    }

    public PgxFuture<Void> shutdownEngineNowIfRunningAsync() {
        return this.onControl(Control::shutdownNowIfRunning);
    }

    @Deprecated
    public PgxFuture<Collection<SessionInfo>> getSessionInfosAsync() {
        return this.onControl(Control::getSessionInfos);
    }

    @Deprecated
    public PgxFuture<Collection<GraphInfo>> getGraphInfosAsync() {
        return this.onControl(Control::getGraphInfos);
    }

    @Deprecated
    public PgxFuture<SessionInfo> getSessionInfoAsync(String sessionId) {
        return this.onControl(control -> control.getSessionInfo(sessionId));
    }

    private PgxFuture<SessionInfo> getSessionInfoAsync(SessionContext sessionContext) {
        return this.onControl(control -> control.getSessionInfo(sessionContext));
    }

    @Deprecated
    public PgxFuture<GraphInfo> getGraphInfoAsync(String graphName) {
        return this.onControl(control -> control.getGraphInfo(graphName));
    }

    @Deprecated
    public PgxFuture<GraphInfo> getGraphInfoAsync(String sessionId, String graphName) {
        return this.onControl(control -> control.getGraphInfo(sessionId, graphName));
    }

    @Deprecated
    public PgxFuture<MemoryInfo> getMemoryInfoAsync() {
        return this.onControl(Control::getMemoryInfo);
    }

    @Deprecated
    public PgxFuture<PoolInfo> getThreadPoolInfoAsync(PoolType type) {
        return this.onControl(control -> control.getThreadPoolInfo(type));
    }

    @BetaApi
    public PgxFuture<JsonNode> getServerStateAsync() {
        return this.onControl(Control::getServerState);
    }

    public PgxFuture<CacheStatistics> freeCachedMemoryAsync() {
        return this.onControl(Control::freeCachedMemory);
    }

    public PgxFuture<CacheStatistics> freeCachedMemoryAsync(double threshold) {
        return this.onControl(control -> control.freeCachedMemory(threshold));
    }

    public PgxFuture<Void> killSessionAsync(String sessionId) {
        return this.onControl(control -> control.killSession(sessionId));
    }

    public PgxFuture<Void> unpinGraphAsync(String graphName) {
        return this.onControl(control -> control.unpinGraph(graphName));
    }

    public String toString() {
        LinkedList<Map.Entry<String, Object>> entries = new LinkedList<Map.Entry<String, Object>>();
        entries.add(ServerInstance.entry("embedded", this.isEmbeddedInstance()));
        if (!this.isEmbeddedInstance()) {
            entries.add(ServerInstance.entry("baseUrl", this.getBaseUrl()));
        }
        if (this.version.isDone()) {
            String key = this.isEmbeddedInstance() ? "version" : "serverVersion";
            entries.add(ServerInstance.entry(key, this.version.join()));
        }
        return this.toString(entries);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServerInstance)) {
            return false;
        }
        ServerInstance other = (ServerInstance)obj;
        return Objects.equals(this.getBaseUrl(), other.getBaseUrl());
    }

    public int hashCode() {
        return Objects.hashCode(this.getBaseUrl());
    }

    public VersionInfo getVersion() throws ExecutionException, InterruptedException {
        return this.getVersionAsync().get();
    }

    public PgxSession createSession(String source) throws ExecutionException, InterruptedException {
        return this.createSessionAsync(source).get();
    }

    public PgxSession getSession(String id) throws ExecutionException, InterruptedException {
        return this.getSessionAsync(id).get();
    }

    public PgxSession getSession(SessionContext sessionContext) throws ExecutionException, InterruptedException {
        return this.getSessionAsync(sessionContext).get();
    }

    public PgxSession createSession(String source, Long idleTimeout, Long taskTimeout, TimeUnit unit) throws ExecutionException, InterruptedException {
        return this.createSessionAsync(source, idleTimeout, taskTimeout, unit).get();
    }

    public Map<PgxConfig.Field, Object> getPgxConfig() throws ExecutionException, InterruptedException {
        return this.getPgxConfigAsync().get();
    }

    public PgxConfig getPgxConfigObject() throws ExecutionException, InterruptedException {
        return this.getPgxConfigObjectAsync().get();
    }

    public void startEngine(String path) throws ExecutionException, InterruptedException {
        this.startEngineAsync(path).get();
    }

    public boolean isEngineRunning() throws ExecutionException, InterruptedException {
        return this.isEngineRunningAsync().get();
    }

    public boolean isEngineReady() throws ExecutionException, InterruptedException {
        return this.isEngineReadyAsync().get();
    }

    public boolean isGraphPreloadingDone() throws ExecutionException, InterruptedException {
        return this.isGraphPreloadingDoneAsync().get();
    }

    public boolean shutdownEngine(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException {
        return this.shutdownEngineAsync(timeout, unit).get();
    }

    public void shutdownEngineNow() throws ExecutionException, InterruptedException {
        this.shutdownEngineNowAsync().get();
    }

    public void shutdownEngineNowIfRunning() throws ExecutionException, InterruptedException {
        this.shutdownEngineNowIfRunningAsync().get();
    }

    @Deprecated
    public Collection<SessionInfo> getSessionInfos() throws ExecutionException, InterruptedException {
        return this.getSessionInfosAsync().get();
    }

    @Deprecated
    public Collection<GraphInfo> getGraphInfos() throws ExecutionException, InterruptedException {
        return this.getGraphInfosAsync().get();
    }

    @Deprecated
    public SessionInfo getSessionInfo(String sessionId) throws ExecutionException, InterruptedException {
        return this.getSessionInfoAsync(sessionId).get();
    }

    @Deprecated
    public GraphInfo getGraphInfo(String graphName) throws ExecutionException, InterruptedException {
        return this.getGraphInfoAsync(graphName).get();
    }

    @Deprecated
    public GraphInfo getGraphInfo(String sessionId, String graphName) throws ExecutionException, InterruptedException {
        return this.getGraphInfoAsync(sessionId, graphName).get();
    }

    @Deprecated
    public MemoryInfo getMemoryInfo() throws ExecutionException, InterruptedException {
        return this.getMemoryInfoAsync().get();
    }

    @Deprecated
    public PoolInfo getThreadPoolInfo(PoolType type) throws ExecutionException, InterruptedException {
        return this.getThreadPoolInfoAsync(type).get();
    }

    @BetaApi
    public JsonNode getServerState() throws ExecutionException, InterruptedException {
        return this.getServerStateAsync().get();
    }

    public CacheStatistics freeCachedMemory() throws ExecutionException, InterruptedException {
        return this.freeCachedMemoryAsync().get();
    }

    public CacheStatistics freeCachedMemory(double threshold) throws ExecutionException, InterruptedException {
        return this.freeCachedMemoryAsync(threshold).get();
    }

    public void killSession(String sessionId) throws ExecutionException, InterruptedException {
        this.killSessionAsync(sessionId).get();
    }

    public void startEngine() throws ExecutionException, InterruptedException {
        this.startEngineAsync().get();
    }

    public void startEngine(Map<PgxConfig.Field, Object> config) throws ExecutionException, InterruptedException {
        this.startEngineAsync(config).get();
    }

    public void startEngine(InputStream config) throws ExecutionException, InterruptedException {
        this.startEngineAsync(config).get();
    }

    public void startEngine(PgxConfig config) throws ExecutionException, InterruptedException {
        this.startEngineAsync(config).get();
    }

    public void updatePgxConfig(PgxConfig config) throws ExecutionException, InterruptedException {
        this.updatePgxConfigAsync(config).get();
    }

    public void unpinGraph(String graphName) {
        this.unpinGraphAsync(graphName).join();
    }

    public void updatePgxConfig(Map<PgxConfig.Field, Object> config) throws ExecutionException, InterruptedException {
        this.updatePgxConfigAsync(config).get();
    }

    public void updatePgxConfig(InputStream config) throws ExecutionException, InterruptedException {
        this.updatePgxConfigAsync(config).get();
    }

    public void updatePgxConfig(String path) throws ExecutionException, InterruptedException {
        this.updatePgxConfigAsync(path).get();
    }

    public PgxFuture<Void> setSessionMaxMemorySize(PgxSession session, int size, MemoryUnit unit) {
        return this.onControl(control -> control.setSessionMaxMemorySize(session.getId(), size, unit));
    }
}

