/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.FrontierRedactedVerticesConfig;
import oracle.pgx.config.FrontierRedactedVerticesConfigBuilder;
import oracle.pgx.config.PgxRedactionRulesConfig;

public final class PgxRedactionRulesConfigBuilder {
    private final Map<PgxRedactionRulesConfig.Field, Object> values = new HashMap<PgxRedactionRulesConfig.Field, Object>();

    public static PgxRedactionRulesConfig buildPgxRedactionRulesConfig(Consumer<PgxRedactionRulesConfigBuilder> builderSetup) {
        PgxRedactionRulesConfigBuilder builder = new PgxRedactionRulesConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public PgxRedactionRulesConfigBuilder() {
    }

    public PgxRedactionRulesConfigBuilder(Map<PgxRedactionRulesConfig.Field, Object> values) {
        this.putAll(values);
    }

    public PgxRedactionRulesConfigBuilder(PgxRedactionRulesConfig config) {
        this.putAll(config);
    }

    public PgxRedactionRulesConfigBuilder(PgxRedactionRulesConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public PgxRedactionRulesConfigBuilder putAll(Map<PgxRedactionRulesConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public PgxRedactionRulesConfigBuilder putAll(PgxRedactionRulesConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public PgxRedactionRulesConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public PgxRedactionRulesConfig build(String parentPath) {
        try {
            return PgxRedactionRulesConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public PgxRedactionRulesConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<PgxRedactionRulesConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "PgxRedactionRulesConfigBuilder" + this.values;
    }

    public PgxRedactionRulesConfigBuilder setRedactionRules(Object ... redactionRules) {
        this.values.put(PgxRedactionRulesConfig.Field.REDACTION_RULES, redactionRules);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setRedactionRules(List<?> redactionRules) {
        this.values.put(PgxRedactionRulesConfig.Field.REDACTION_RULES, redactionRules);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setRuleName(String ruleName) {
        this.values.put(PgxRedactionRulesConfig.Field.RULE_NAME, ruleName);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setRedactVertex(String redactVertex) {
        this.values.put(PgxRedactionRulesConfig.Field.REDACT_VERTEX, redactVertex);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setShowFrontierVertex(FrontierRedactedVerticesConfig showFrontierVertex) {
        this.values.put(PgxRedactionRulesConfig.Field.SHOW_FRONTIER_VERTEX, showFrontierVertex);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setShowFrontierVertex(Consumer<FrontierRedactedVerticesConfigBuilder> showFrontierVertexBuilderSetup) {
        FrontierRedactedVerticesConfigBuilder builder = new FrontierRedactedVerticesConfigBuilder();
        showFrontierVertexBuilderSetup.accept(builder);
        this.setShowFrontierVertex(builder.build());
        return this;
    }

    public PgxRedactionRulesConfigBuilder setRedactEdge(String redactEdge) {
        this.values.put(PgxRedactionRulesConfig.Field.REDACT_EDGE, redactEdge);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setRedactVertexProperties(Object ... redactVertexProperties) {
        this.values.put(PgxRedactionRulesConfig.Field.REDACT_VERTEX_PROPERTIES, redactVertexProperties);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setRedactEdgeProperties(Object ... redactEdgeProperties) {
        this.values.put(PgxRedactionRulesConfig.Field.REDACT_EDGE_PROPERTIES, redactEdgeProperties);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setRedactVertexProperties(List<?> redactVertexProperties) {
        this.values.put(PgxRedactionRulesConfig.Field.REDACT_VERTEX_PROPERTIES, redactVertexProperties);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setRedactEdgeProperties(List<?> redactEdgeProperties) {
        this.values.put(PgxRedactionRulesConfig.Field.REDACT_EDGE_PROPERTIES, redactEdgeProperties);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setLabel(String label) {
        this.values.put(PgxRedactionRulesConfig.Field.LABEL, label);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setProperties(String ... properties) {
        this.values.put(PgxRedactionRulesConfig.Field.PROPERTIES, properties);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setRuleTrigger(String ruleTrigger) {
        this.values.put(PgxRedactionRulesConfig.Field.RULE_TRIGGER, ruleTrigger);
        return this;
    }

    public PgxRedactionRulesConfigBuilder setWithVisibleProperties(String ... withVisibleProperties) {
        this.values.put(PgxRedactionRulesConfig.Field.WITH_VISIBLE_PROPERTIES, withVisibleProperties);
        return this;
    }
}

