/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.Aggregate;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.StringPoolingStrategy;

public final class GraphPropertyConfigBuilder {
    private final Map<GraphPropertyConfig.Field, Object> values = new HashMap<GraphPropertyConfig.Field, Object>();

    public static GraphPropertyConfig buildGraphPropertyConfig(Consumer<GraphPropertyConfigBuilder> builderSetup) {
        GraphPropertyConfigBuilder builder = new GraphPropertyConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public GraphPropertyConfigBuilder() {
    }

    public GraphPropertyConfigBuilder(Map<GraphPropertyConfig.Field, Object> values) {
        this.putAll(values);
    }

    public GraphPropertyConfigBuilder(GraphPropertyConfig config) {
        this.putAll(config);
    }

    public GraphPropertyConfigBuilder(GraphPropertyConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public GraphPropertyConfigBuilder putAll(Map<GraphPropertyConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public GraphPropertyConfigBuilder putAll(GraphPropertyConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public GraphPropertyConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public GraphPropertyConfig build(String parentPath) {
        try {
            return GraphPropertyConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public GraphPropertyConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<GraphPropertyConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "GraphPropertyConfigBuilder" + this.values;
    }

    public GraphPropertyConfigBuilder setName(String name) {
        this.values.put(GraphPropertyConfig.Field.NAME, name);
        return this;
    }

    public GraphPropertyConfigBuilder setDimension(int dimension) {
        this.values.put(GraphPropertyConfig.Field.DIMENSION, dimension);
        return this;
    }

    public GraphPropertyConfigBuilder setFormat(String ... format) {
        this.values.put(GraphPropertyConfig.Field.FORMAT, format);
        return this;
    }

    public GraphPropertyConfigBuilder setType(PropertyType type) {
        this.values.put(GraphPropertyConfig.Field.TYPE, type);
        return this;
    }

    public GraphPropertyConfigBuilder setDefault(Object defaultVal) {
        this.values.put(GraphPropertyConfig.Field.DEFAULT, defaultVal);
        return this;
    }

    public GraphPropertyConfigBuilder setColumn(Object column) {
        this.values.put(GraphPropertyConfig.Field.COLUMN, column);
        return this;
    }

    public GraphPropertyConfigBuilder setStores(Object ... stores) {
        this.values.put(GraphPropertyConfig.Field.STORES, stores);
        return this;
    }

    public GraphPropertyConfigBuilder setMaxDistinctStringsPerPool(int maxDistinctStringsPerPool) {
        this.values.put(GraphPropertyConfig.Field.MAX_DISTINCT_STRINGS_PER_POOL, maxDistinctStringsPerPool);
        return this;
    }

    public GraphPropertyConfigBuilder setStringPoolingStrategy(StringPoolingStrategy stringPoolingStrategy) {
        this.values.put(GraphPropertyConfig.Field.STRING_POOLING_STRATEGY, (Object)stringPoolingStrategy);
        return this;
    }

    public GraphPropertyConfigBuilder setAggregate(Aggregate aggregate) {
        this.values.put(GraphPropertyConfig.Field.AGGREGATE, (Object)aggregate);
        return this;
    }

    public GraphPropertyConfigBuilder setField(Object field) {
        this.values.put(GraphPropertyConfig.Field.FIELD, field);
        return this;
    }

    public GraphPropertyConfigBuilder setGroupKey(String groupKey) {
        this.values.put(GraphPropertyConfig.Field.GROUP_KEY, groupKey);
        return this;
    }

    public GraphPropertyConfigBuilder setDropAfterLoading(boolean dropAfterLoading) {
        this.values.put(GraphPropertyConfig.Field.DROP_AFTER_LOADING, dropAfterLoading);
        return this;
    }

    public GraphPropertyConfigBuilder setStores(List<?> stores) {
        this.values.put(GraphPropertyConfig.Field.STORES, stores);
        return this;
    }
}

