/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.HashMap;
import oracle.pgx.api.filter.GraphFilter;
import oracle.pgx.api.filter.GraphFilterWithExpression;
import oracle.pgx.config.FilterExpressionConfig;

public class FilterExpressionConfigFactory {
    public static FilterExpressionConfig createFromGraphFilter(GraphFilter graphFilter) {
        if (!graphFilter.hasExpression()) {
            throw new UnsupportedOperationException("Only graph filters with expression allowed");
        }
        GraphFilterWithExpression filter = graphFilter.asGraphFilterWithExpression();
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(FilterExpressionConfig.Field.TYPE.toKey(), filter.getType().toString().toLowerCase());
        values.put(FilterExpressionConfig.Field.EXPRESSION.toKey(), filter.getFilterExpression());
        return FilterExpressionConfig.parse(values, true, null);
    }
}

