/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.math.BigDecimal;
import java.math.RoundingMode;
import oracle.pgx.common.MemoryValue;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.DataMemoryLimitType;

public final class DataMemoryLimit {
    private final DataMemoryLimitType limitType;
    public final long absoluteLimit;
    public double ratioLimit = 0.0;

    public DataMemoryLimit(DataMemoryLimitType limitType, String absoluteLimit, Double ratioLimit, boolean isRatioSet) {
        this(limitType, absoluteLimit);
        DataMemoryLimit.validateInput(limitType, absoluteLimit, ratioLimit, isRatioSet);
        this.ratioLimit = ratioLimit;
    }

    public DataMemoryLimit(DataMemoryLimitType limitType, String absoluteLimit) {
        this.limitType = limitType;
        if (absoluteLimit == null) {
            this.absoluteLimit = Long.MAX_VALUE;
        } else {
            DataMemoryLimit.validateInput(limitType, absoluteLimit);
            this.absoluteLimit = MemoryValue.byteCountFromString((String)absoluteLimit);
        }
    }

    public DataMemoryLimit(DataMemoryLimitType limitType, long absoluteLimit) {
        this.limitType = limitType;
        this.absoluteLimit = absoluteLimit;
    }

    public static void validateInput(DataMemoryLimitType limitType, String absoluteLimit, Double ratioLimit, boolean isRatioSet) {
        DataMemoryLimit.validateInput(limitType, absoluteLimit);
        if (ratioLimit.isNaN() || !(ratioLimit > 0.0) || !(ratioLimit <= 1.0)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_RATIO_MEMORY_LIMIT", (Object[])new Object[]{limitType}));
        }
        if (absoluteLimit != null && isRatioSet) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"MEMORY_LIMITS_BOTH_SPECIFIED", (Object[])new Object[]{limitType}));
        }
    }

    static void validateInput(DataMemoryLimitType limitType, String absoluteLimit) {
        if (absoluteLimit != null && MemoryValue.byteCountFromString((String)absoluteLimit) == Long.MAX_VALUE) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_ABSOLUTE_MEMORY_LIMIT", (Object[])new Object[]{limitType}));
        }
    }

    public boolean isAbsoluteLimitSet() {
        return this.absoluteLimit != Long.MAX_VALUE;
    }

    public DataMemoryLimitType getType() {
        return this.limitType;
    }

    public long toBytes(long parentLimitBytes) {
        if (this.isAbsoluteLimitSet()) {
            return this.absoluteLimit;
        }
        return DataMemoryLimit.parseRelativeMemorySizeToBytes(this.ratioLimit, parentLimitBytes);
    }

    private static long parseRelativeMemorySizeToBytes(Double ratioLimit, long parentLimitBytes) {
        BigDecimal ratio = BigDecimal.valueOf(ratioLimit).setScale(4, RoundingMode.DOWN);
        return BigDecimal.valueOf(parentLimitBytes).multiply(ratio).longValue();
    }
}

