/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import oracle.pgx.common.UserContext;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.types.ReturnType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.common.util.ConversionHelper;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.NameValidator;
import oracle.pgx.common.util.SystemUtils;
import oracle.pgx.config.AbstractConfigParser;
import oracle.pgx.config.AnyFormatEntityProviderConfigFactory;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.StaticConfig;
import oracle.pgx.vfs.VirtualFileManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigParser<F extends ConfigField>
extends AbstractConfigParser<F>
implements ParseResult<F> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigParser.class);
    public static final String NO_OF_CPUS_WILDCARD = "<no-of-CPUs>";
    public static final String TMP_DIR_WILDCARD = "<system-tmp-dir>";
    public static final String JAVA_HOME_DIR_WILDCARD = "<system-java-home-dir>";
    public static final String POSITIVE_INFINITY_WILDCARD1 = "+INF";
    public static final String POSITIVE_INFINITY_WILDCARD2 = "INF";
    public static final String NEGATIVE_INFINITY_WILDCARD = "-INF";
    public static final String MAX_HEAP_SIZE_WILDCARD = "<available-physical-memory>";
    public static final String JAVA_HOME = "java.home";
    private final Map<String, Object> raw;
    private final String parent;
    private final boolean parseHiddenValues;
    private final Map<F, Object> values;
    private final Set<F> defaults;

    public static OptionalLong getTotalPhysicalMemorySize() {
        try {
            OperatingSystemMXBean mxbean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return OptionalLong.of(mxbean.getTotalPhysicalMemorySize());
        }
        catch (Exception e) {
            LOG.error("Error when getting physical memory size", (Throwable)e);
            return OptionalLong.empty();
        }
    }

    public static Object replaceWildcards(Class<?> type, Object given) {
        assert (given != null);
        if (given.getClass() != String.class) {
            return given;
        }
        String givenStr = (String)given;
        if (givenStr.equalsIgnoreCase(NO_OF_CPUS_WILDCARD)) {
            return Runtime.getRuntime().availableProcessors();
        }
        if (givenStr.equalsIgnoreCase(MAX_HEAP_SIZE_WILDCARD)) {
            long totalMemoryBytes = ConfigParser.getTotalPhysicalMemorySize().orElseThrow(() -> new IllegalArgumentException(ErrorMessages.getMessage((String)"UNABLE_TO_GET_PHYSICAL_MEMORY", (Object[])new Object[]{MAX_HEAP_SIZE_WILDCARD})));
            int maxOffHeapSize = (int)ConversionHelper.toMB(totalMemoryBytes);
            LOG.debug("defaulting to total physical memory (~{} MBs)", (Object)maxOffHeapSize);
            return maxOffHeapSize;
        }
        if (givenStr.equalsIgnoreCase(POSITIVE_INFINITY_WILDCARD1) || givenStr.equalsIgnoreCase(POSITIVE_INFINITY_WILDCARD2)) {
            if (type == Integer.class) {
                return Integer.MAX_VALUE;
            }
            if (type == Float.class) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if (type == Long.class) {
                return Long.MAX_VALUE;
            }
            if (type == Double.class) {
                return Double.POSITIVE_INFINITY;
            }
        }
        if (givenStr.equalsIgnoreCase(NEGATIVE_INFINITY_WILDCARD)) {
            if (type == Integer.class) {
                return Integer.MIN_VALUE;
            }
            if (type == Float.class) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            if (type == Long.class) {
                return Long.MIN_VALUE;
            }
            if (type == Double.class) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        if (givenStr.equalsIgnoreCase(TMP_DIR_WILDCARD)) {
            return ConfigParser.getSystemTempDir();
        }
        if (givenStr.equalsIgnoreCase(JAVA_HOME_DIR_WILDCARD)) {
            return ConfigParser.getSystemJavaHomeDir();
        }
        return givenStr;
    }

    private static String getSystemTempDir() {
        File tmpDir;
        String tmpDirPath = System.getProperty("java.io.tmpdir");
        NameValidator.validateDirectoryPath((String)tmpDirPath);
        if (tmpDirPath == null) {
            tmpDirPath = SystemUtils.IS_OS_WINDOWS ? "C:\\temp" : "/tmp";
        }
        if (!(tmpDir = new File(tmpDirPath)).exists() && !tmpDir.mkdirs()) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"TEMP_DIR_NOT_FOUND", (Object[])new Object[0]));
        }
        if (!tmpDir.canWrite() && !tmpDir.setWritable(true)) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"TEMP_DIR_NOT_WRITABLE", (Object[])new Object[]{tmpDirPath}));
        }
        return tmpDirPath;
    }

    private static String getSystemJavaHomeDir() {
        String javaHomeDirPath = System.getProperty(JAVA_HOME);
        NameValidator.validateDirectoryPath((String)javaHomeDirPath);
        if (javaHomeDirPath == null) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"JAVA_HOME_DIR_NOT_FOUND", (Object[])new Object[0]));
        }
        if (!new File(javaHomeDirPath).exists()) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"JAVA_HOME_DIR_NON_EXISTENT", (Object[])new Object[]{javaHomeDirPath}));
        }
        return javaHomeDirPath;
    }

    public static Map<String, Object> parseRaw(InputStream is) throws IOException {
        return ConfigJsonUtil.readValue(new BufferedInputStream(is), new TypeReference<Map<String, Object>>(){});
    }

    public static <F extends ConfigField> ParseResult<F> parse(Map<String, Object> raw, F[] fields, boolean strict, String parent) {
        return new ConfigParser(raw, fields, strict, parent).parse();
    }

    public static <F extends ConfigField> ParseResult<F> parse(Map<String, Object> raw, F[] fields, boolean strict, String parent, boolean parseHiddenValues) {
        return new ConfigParser(raw, fields, strict, parent, parseHiddenValues).parse();
    }

    private ConfigParser(Map<String, Object> raw, F[] fields, boolean strict, String parent) {
        this(raw, (ConfigField[])fields, strict, parent, false);
    }

    private ConfigParser(Map<String, Object> raw, F[] fields, boolean strict, String parent, boolean parseHiddenValues) {
        super(fields, strict);
        this.raw = raw;
        this.parent = parent;
        this.parseHiddenValues = parseHiddenValues;
        this.values = new HashMap<F, Object>();
        this.defaults = new HashSet<F>();
    }

    public ParseResult<F> parse() {
        for (ConfigField field : this.fields) {
            Object parsed;
            if (field.isHidden() && !this.parseHiddenValues) continue;
            Object given = this.removeIgnoreCase(field.toKey(), this.raw);
            List<String> aliases = field.getKeyAliases();
            if (given == null) {
                given = aliases.stream().map(name -> this.removeIgnoreCase((String)name, this.raw)).filter(Objects::nonNull).findFirst().orElse(null);
            }
            List<String> singletonListAliases = field.getSingletonListKeyAliases();
            if (given == null) {
                given = singletonListAliases.stream().map(name -> this.removeIgnoreCase((String)name, this.raw)).filter(Objects::nonNull).findFirst().map(Collections::singletonList).orElse(null);
            }
            if ((parsed = this.parse(field, given)) == null) continue;
            this.values.put(field, parsed);
        }
        if (!this.raw.isEmpty()) {
            this.error("FOUND_INVALID_CONFIG_FIELDS", this.raw.keySet().toString());
        }
        return this;
    }

    @Override
    public Map<F, Object> getValues() {
        return this.values;
    }

    @Override
    public Set<F> getDefaults() {
        return this.defaults;
    }

    private Object parse(F field, Object given) {
        if (given == null) {
            return this.parseNull(field);
        }
        return this.parseNonNull(field, given);
    }

    private Object parseNull(F field) {
        if (field.isRequired()) {
            throw this.criticalError("FIELD_REQUIRED", field.toKey());
        }
        this.defaults.add(field);
        return this.getDefault(field);
    }

    private Object getDefault(F field) {
        Object defaultVal = field.getDefaultVal();
        if (defaultVal == null) {
            return null;
        }
        return this.parseNonNull(field, defaultVal);
    }

    private Object parseEnumArray(F field, Object given) {
        if (!field.isArray() || !field.isEnum()) {
            throw new IllegalArgumentException(field.toKey() + " needs to be an enum array");
        }
        if (!Iterable.class.isAssignableFrom(given.getClass())) {
            throw this.criticalError("UNEXPECTED_ENUM_TYPE", field.toKey(), given.getClass());
        }
        Iterable iterableGiven = (Iterable)given;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object value : iterableGiven) {
            values.add(this.parseEnum(field, value));
        }
        return values;
    }

    private Object parseNonNull(F field, Object given) {
        if (field.isEnum() && field.isArray()) {
            return this.parseEnumArray(field, given);
        }
        if (field.isEnum()) {
            return this.parseEnum(field, given);
        }
        if (field.isPrimitive()) {
            return this.parsePrimitive(field, given);
        }
        return this.parseComplex(field, given);
    }

    private Object parseEnum(F field, Object given) {
        if (given.getClass() == field.getType()) {
            return given;
        }
        if (given.getClass() != String.class) {
            throw this.criticalError("UNEXPECTED_ENUM_TYPE", field.toKey(), given.getClass());
        }
        String givenStr = (String)given;
        Class<?> enumType = field.getType();
        if (enumType == PropertyType.class) {
            return PropertyType.parsePropertyType((String)givenStr);
        }
        if (enumType == IdType.class) {
            return IdType.parseIdType((String)givenStr);
        }
        if (enumType == EntityType.class) {
            return EntityType.parseEntityType((String)givenStr);
        }
        if (enumType == CollectionType.class) {
            return CollectionType.parseCollectionType((String)givenStr);
        }
        if (enumType == ReturnType.class) {
            return ReturnType.parseReturnType((String)givenStr);
        }
        return Enum.valueOf(enumType, givenStr.toUpperCase());
    }

    private Object parsePrimitive(F field, Object given) {
        if (!field.isArray()) {
            return this.parsePrimitiveScalar(field, given);
        }
        return this.parsePrimitiveArray(field, given);
    }

    private Object parsePrimitiveScalar(F field, Object given) {
        given = ConfigParser.replaceWildcards(field.getType(), given);
        this.typeCheck(field, given);
        if (field.isPath()) {
            assert (field.getType() == String.class);
            try {
                StaticConfig.get().isEnablePluginVersionChecks();
                return VirtualFileManagerFactory.getInstance().resolve(this.parent, (String)given, UserContext.UNAUTHENTICATED_USER_CONTEXT);
            }
            catch (IOException e) {
                throw this.criticalError("CANNOT_READ_THE_FILE", e, given);
            }
        }
        if (field.getType() == Long.class) {
            return ((Number)given).longValue();
        }
        if (field.getType() == Character.class) {
            if (given instanceof String) {
                String givenString = (String)given;
                if (givenString.length() != 1) {
                    throw this.criticalError("CHARACTER_FIELD_CANNOT_BE_PARSED_FROM_STRING", field.toKey(), givenString);
                }
                return Character.valueOf(givenString.charAt(0));
            }
            if (given instanceof Character) {
                return given;
            }
            throw this.criticalError("CHARACTER_FIELD_CANNOT_BE_PARSED", field.toKey(), given.getClass().getSimpleName());
        }
        return given;
    }

    private Object parsePrimitiveArray(F field, Object given) {
        if (!List.class.isAssignableFrom(given.getClass())) {
            throw this.criticalError("UNEXPECTED_ARRAY_TYPE", field.toKey(), given.getClass());
        }
        List givenArray = (List)given;
        ArrayList parsedArray = new ArrayList(givenArray.size());
        givenArray.stream().filter(Objects::nonNull).forEach(elem -> parsedArray.add(this.parsePrimitiveScalar(field, elem)));
        return parsedArray;
    }

    private Object parseComplex(F field, Object given) {
        if (!field.isArray()) {
            return this.parseComplexScalar(field, given);
        }
        return this.parseComplexArray(field, given);
    }

    private Object parseComplexScalar(F field, Object given) {
        if (field.getType().isAssignableFrom(given.getClass())) {
            return given;
        }
        if (!Map.class.isAssignableFrom(given.getClass())) {
            throw this.criticalError("UNEXPECTED_MAP_TYPE", field.toKey(), given.getClass());
        }
        try {
            HashMap<String, Object> raw = new HashMap<String, Object>((Map)given);
            this.insertDefaultValuesInMap(field, raw);
            if (field.getType().isAssignableFrom(EntityProviderConfig.class)) {
                return this.parseTableConfig(raw);
            }
            Method parse = field.getType().getDeclaredMethod("parse", Map.class, Boolean.TYPE, String.class);
            return parse.invoke(null, raw, this.strict, this.parent);
        }
        catch (IOException | InvocationTargetException e) {
            if (this.strict) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new IllegalArgumentException(e.getCause().getMessage(), e.getCause());
            }
            LOG.error("could not parse complex scalar: " + e.getMessage(), (Throwable)e);
            return null;
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
            throw this.criticalError("UNSUPPORTED_COMPLEX_TYPE", e, field.getType());
        }
    }

    private Object parseTableConfig(Map<String, Object> raw) throws IOException {
        return new AnyFormatEntityProviderConfigFactory(this.strict, this.parseHiddenValues).fromMap((Map)raw, this.parent);
    }

    private void insertDefaultValuesInMap(F field, Map<String, Object> raw) {
        if (!field.isArray()) {
            Map defaultValues = (Map)field.getDefaultVal();
            for (Map.Entry defaultEntry : defaultValues.entrySet()) {
                raw.putIfAbsent((String)defaultEntry.getKey(), defaultEntry.getValue());
            }
        }
    }

    private Object parseComplexArray(F field, Object given) {
        if (!List.class.isAssignableFrom(given.getClass())) {
            throw this.criticalError("UNEXPECTED_ARRAY_TYPE", field.toKey(), given.getClass());
        }
        List givenArray = (List)given;
        ArrayList<Object> parsedArray = new ArrayList<Object>(givenArray.size());
        for (Object givenElem : givenArray) {
            Object parsed = this.parseComplexScalar(field, givenElem);
            if (parsed == null) continue;
            parsedArray.add(parsed);
        }
        return parsedArray;
    }

    private void typeCheck(F field, Object given) {
        if (field.getType() == Object.class) {
            return;
        }
        if (field.getType() == Long.class) {
            if (given.getClass() != Integer.class && given.getClass() != Long.class) {
                throw this.criticalError("UNEXPECTED_FIELD_TYPE", field.getType(), field.toKey(), given.getClass());
            }
            return;
        }
        if (field.getType() == Character.class) {
            if (given.getClass() != String.class && given.getClass() != Character.class) {
                throw this.criticalError("UNEXPECTED_FIELD_TYPE", field.getType(), field.toKey(), given.getClass());
            }
            return;
        }
        if (given.getClass() != field.getType()) {
            throw this.criticalError("UNEXPECTED_FIELD_TYPE", field.getType(), field.toKey(), given.getClass());
        }
    }

    private Object removeIgnoreCase(String fieldName, Map<String, Object> map) {
        Optional<String> key = map.keySet().stream().filter(k -> k.equalsIgnoreCase(fieldName)).findAny();
        if (key.isPresent()) {
            return map.remove(key.get());
        }
        return null;
    }
}

