/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;
import oracle.pgx.config.TaskPriority;

public class AnalysisTaskConfig
extends AbstractConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static AnalysisTaskConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return AnalysisTaskConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static AnalysisTaskConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return AnalysisTaskConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static AnalysisTaskConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new AnalysisTaskConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static AnalysisTaskConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new AnalysisTaskConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static AnalysisTaskConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new AnalysisTaskConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected AnalysisTaskConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    public Integer getWeight() {
        return (Integer)this.values.get(Field.WEIGHT);
    }

    public TaskPriority getPriority() {
        return (TaskPriority)((Object)this.values.get(Field.PRIORITY));
    }

    public Integer getMaxThreads() {
        return (Integer)this.values.get(Field.MAX_THREADS);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalysisTaskConfig other = (AnalysisTaskConfig)obj;
        if (!Objects.equals(this.getWeight(), other.getWeight())) {
            return false;
        }
        if (!Objects.equals((Object)this.getPriority(), (Object)other.getPriority())) {
            return false;
        }
        return Objects.equals(this.getMaxThreads(), other.getMaxThreads());
    }

    public static enum Field implements ConfigField
    {
        WEIGHT(Collections.emptyList(), Collections.emptyList(), Integer.class, true, null, false, false, false, false),
        PRIORITY(Collections.emptyList(), Collections.emptyList(), TaskPriority.class, true, null, false, false, false, false),
        MAX_THREADS(Collections.emptyList(), Collections.emptyList(), Integer.class, true, null, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("analysis.task.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

