/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.auth;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import oracle.pgx.common.UserContext;
import oracle.pgx.common.auth.PgxResource;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.StaticConfig;
import oracle.pgx.vfs.VirtualFileManager;
import oracle.pgx.vfs.VirtualFileManagerFactory;
import org.apache.commons.vfs2.provider.UriParser;

public class PgxFileLocationResource
implements PgxResource {
    private static final VirtualFileManager VIRTUAL_FILE_MANAGER = PgxFileLocationResource.initializeVirtualFileManager();
    private final String name;
    private final Path path;

    public PgxFileLocationResource(String name, String location) {
        this(name, location, UserContext.SYSTEM_USER_CONTEXT);
    }

    private PgxFileLocationResource(String name, String location, UserContext userContext) {
        this(name, PgxFileLocationResource.normalizeLocation(location, userContext));
    }

    public PgxFileLocationResource(String name, Path path) {
        this.name = name;
        this.path = path;
    }

    private static VirtualFileManager initializeVirtualFileManager() {
        StaticConfig.get().isEnablePluginVersionChecks();
        return VirtualFileManagerFactory.getInstance();
    }

    public static PgxFileLocationResource of(String location, UserContext userContext) {
        return new PgxFileLocationResource(null, location, userContext);
    }

    public static boolean isFileResource(String uri) {
        String scheme = PgxFileLocationResource.getScheme(uri);
        return scheme == null || scheme.equals("file") || scheme.equals("hdfs") || scheme.equals("classpath");
    }

    private static String getScheme(String uri) {
        return UriParser.extractScheme((String)uri);
    }

    public static Path normalizeLocation(String location, UserContext userContext) {
        if (!PgxFileLocationResource.isFileResource(location)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_FILE_LOCATION_RESOURCE", (Object[])new Object[0]));
        }
        String scheme = PgxFileLocationResource.getScheme(location);
        if (scheme == null || scheme.equals("file")) {
            return PgxFileLocationResource.resolveLocalFileFullPath(location, userContext);
        }
        return Paths.get(location, new String[0]);
    }

    private static Path resolveLocalFileFullPath(String uri, UserContext userContext) {
        String path = null;
        try {
            path = VIRTUAL_FILE_MANAGER.resolve(uri, null, false, userContext).getPath();
            return Paths.get(path, new String[0]);
        }
        catch (IOException e) {
            return Paths.get(uri, new String[0]);
        }
        catch (IllegalArgumentException e) {
            try {
                return Paths.get(new URI(path));
            }
            catch (URISyntaxException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Path getPath() {
        return this.path;
    }

    public PgxResource.Type getResourceType() {
        return PgxResource.Type.STORAGE;
    }

    public String toString() {
        return "PgxFileLocationResource{" + this.path + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PgxFileLocationResource)) {
            return false;
        }
        PgxFileLocationResource that = (PgxFileLocationResource)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

