/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.loaders.location;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.Format;

public abstract class GraphLocation {
    public static final String TYPE_ID_PROPERTY = "@type";
    @Nullable
    private final Format format;
    @Nonnull
    private final GraphLocationType graphLocationType;

    protected GraphLocation(@Nonnull GraphLocationType graphLocationType, @Nullable Format format) {
        this.graphLocationType = graphLocationType;
        this.format = format;
    }

    @JsonProperty(value="@type")
    @Nonnull
    public final GraphLocationType getGraphLocationType() {
        return this.graphLocationType;
    }

    @Nullable
    public final Format getFormat() {
        return this.format;
    }

    @JsonIgnore
    public abstract boolean isFileLocation();

    @JsonIgnore
    public List<String> getFilePaths() {
        throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"LOCATION_DOES_NOT_REFERENCE_FILE_PATHS", (Object[])new Object[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphLocation that = (GraphLocation)o;
        return this.format == that.format;
    }

    public int hashCode() {
        return Objects.hash(this.format);
    }

    public static enum GraphLocationType {
        FILE_GRAPH_LOCATION("FileGraphLocation"),
        PG_VIEW_LOCATION("PgViewGraphLocation"),
        PG_SQL_LOCATION("PgSqlGraphLocation");

        private final String typeId;

        private GraphLocationType(String typeId) {
            this.typeId = typeId;
        }

        @JsonValue
        public String getTypeId() {
            return this.typeId;
        }

        public static GraphLocationType fromTypeId(String typeId) {
            return Stream.of(GraphLocationType.values()).filter(t -> Objects.equals(typeId, t.typeId)).findAny().orElseThrow(() -> new IllegalArgumentException(ErrorMessages.getMessage((String)"LOCATION_ID_NOT_FOUND", (Object[])new Object[0])));
        }
    }
}

