/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.loaders.location;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.Format;
import oracle.pgx.loaders.location.GraphLocation;

public final class FileGraphLocation
extends GraphLocation {
    private final List<String> vertexFilePaths;
    private final List<String> edgeFilePaths;
    private final Map<String, String> attributes;

    public FileGraphLocation(List<String> vertexFilePaths, @Nullable List<String> edgeFilePaths, @Nullable Format format) {
        this(vertexFilePaths, edgeFilePaths, format, null);
    }

    public FileGraphLocation(String vertexFilePath, String edgeFilePath, @Nullable Format format) {
        this(Collections.singletonList(vertexFilePath), Collections.singletonList(edgeFilePath), format);
    }

    @JsonCreator
    public FileGraphLocation(@JsonProperty(value="vertexFilePaths") @Nonnull List<String> vertexFilePaths, @JsonProperty(value="edgeFilePaths") @Nullable List<String> edgeFilePaths, @JsonProperty(value="format") @Nullable Format format, @JsonProperty(value="attributes") @Nullable Map<String, String> attributes) {
        super(GraphLocation.GraphLocationType.FILE_GRAPH_LOCATION, format);
        assert (format == null || format.isFileFormat());
        ErrorMessages.requireNonNull(vertexFilePaths, (String)"vertexFilePaths");
        this.vertexFilePaths = vertexFilePaths;
        if (edgeFilePaths != null) {
            assert (format == null || format.hasVerticesAndEdgesSeparatedFileFormat());
            this.edgeFilePaths = edgeFilePaths;
        } else {
            this.edgeFilePaths = Collections.emptyList();
        }
        this.attributes = attributes == null ? Collections.emptyMap() : attributes;
    }

    public FileGraphLocation(List<String> filePaths, @Nullable Format format) {
        this(filePaths, null, format, null);
    }

    public FileGraphLocation(String path, @Nullable Format format) {
        this(Collections.singletonList(path), format);
    }

    public List<String> getVertexFilePaths() {
        return this.vertexFilePaths;
    }

    public List<String> getEdgeFilePaths() {
        return this.edgeFilePaths;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isFileLocation() {
        return true;
    }

    @Override
    public List<String> getFilePaths() {
        ArrayList<String> result = new ArrayList<String>(this.vertexFilePaths.size() + this.edgeFilePaths.size());
        result.addAll(this.vertexFilePaths);
        result.addAll(this.edgeFilePaths);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileGraphLocation that = (FileGraphLocation)o;
        return Objects.equals(this.vertexFilePaths, that.vertexFilePaths) && Objects.equals(this.edgeFilePaths, that.edgeFilePaths) && Objects.equals(this.attributes, that.attributes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.vertexFilePaths, this.edgeFilePaths, this.attributes);
    }
}

