/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.loaders.location;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pgx.common.Pair;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.SqlSanitizationUtils;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphOptimizedFor;
import oracle.pgx.config.OnMissingVertex;
import oracle.pgx.config.ReadGraphOption;
import oracle.pgx.config.SourceType;
import oracle.pgx.loaders.location.GraphLocation;

abstract class AbstractDatabaseGraphLocation
extends GraphLocation {
    protected final String sourceGraphName;
    protected final String schemaName;
    protected final String jdbcUrl;
    protected final String username;
    protected final String password;
    protected final String dataSourceId;
    protected final GraphOptimizedFor optimizedFor;
    protected final boolean synchronizable;
    protected final OnMissingVertex onMissingVertex;
    protected final Integer parallelHintDegree;

    protected AbstractDatabaseGraphLocation(@Nonnull GraphLocation.GraphLocationType graphLocationType, @Nullable Format format, @Nonnull String sourceGraphName, @Nullable String schemaName, @Nullable Integer parallelHintDegree, @Nullable String jdbcUrl, @Nullable String username, @Nullable String password, @Nullable String dataSourceId, @Nullable GraphOptimizedFor optimizedFor, @Nullable Boolean synchronizable, @Nullable OnMissingVertex onMissingVertex) {
        super(graphLocationType, format);
        this.sourceGraphName = sourceGraphName;
        this.schemaName = schemaName;
        this.parallelHintDegree = parallelHintDegree;
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.dataSourceId = dataSourceId;
        this.optimizedFor = optimizedFor;
        this.synchronizable = synchronizable == null ? false : synchronizable;
        this.onMissingVertex = onMissingVertex;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public boolean isFileLocation() {
        return false;
    }

    @Override
    public List<String> getFilePaths() {
        return Collections.emptyList();
    }

    public boolean isSynchronizable() {
        return this.synchronizable;
    }

    public GraphOptimizedFor getOptimizedFor() {
        return this.optimizedFor;
    }

    public OnMissingVertex getOnMissingVertex() {
        return this.onMissingVertex;
    }

    public Integer getParallelHintDegree() {
        return this.parallelHintDegree;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public abstract SourceType getGraphSourceType();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractDatabaseGraphLocation that = (AbstractDatabaseGraphLocation)o;
        return this.synchronizable == that.synchronizable && Objects.equals(this.sourceGraphName, that.sourceGraphName) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.jdbcUrl, that.jdbcUrl) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.dataSourceId, that.dataSourceId) && this.optimizedFor == that.optimizedFor && this.onMissingVertex == that.onMissingVertex && Objects.equals(this.parallelHintDegree, that.parallelHintDegree);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sourceGraphName, this.schemaName, this.jdbcUrl, this.username, this.password, this.dataSourceId, this.optimizedFor, this.synchronizable, this.onMissingVertex, this.parallelHintDegree);
    }

    public String toString() {
        return "AbstractDatabaseGraphLocation{graphSourceType='" + this.getGraphSourceType() + "', sourceGraphName='" + this.sourceGraphName + '\'' + ", schemaName='" + this.schemaName + '\'' + ", jdbcUrl='" + this.jdbcUrl + '\'' + ", username='" + this.username + '\'' + ", password='" + "*******" + '\'' + ", dataSourceId='" + this.dataSourceId + '\'' + ", optimizedFor=" + this.optimizedFor + ", synchronizable=" + this.synchronizable + ", onMissingVertex=" + this.onMissingVertex + ", parallelHintDegree=" + this.parallelHintDegree + '}';
    }

    @Deprecated
    protected static Pair<String, String> parseSchemaAndName(String schemaName, String graphName) {
        if (schemaName == null) {
            int schemaEnd = graphName.indexOf(".");
            schemaName = schemaEnd == -1 ? null : graphName.substring(0, schemaEnd);
            String string = graphName = schemaEnd == -1 ? graphName : graphName.substring(schemaEnd + 1);
        }
        if (schemaName != null) {
            SqlSanitizationUtils.validateIdentifier((String)schemaName);
        }
        SqlSanitizationUtils.validateIdentifier((String)graphName);
        return new Pair((Object)schemaName, (Object)graphName);
    }

    static ReadGraphOption.ReadGraphOptionDataBuilder getOptionBuilder(List<ReadGraphOption> options) {
        if (options != null && options.contains(ReadGraphOption.OPTIMIZED_FOR_READ) && options.contains(ReadGraphOption.OPTIMIZED_FOR_UPDATES)) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"OPTIMIZED_FOR_READ_AND_UPDATES", (Object[])new Object[0]));
        }
        ReadGraphOption.validateUnique(options, ReadGraphOption.OnMissingVertexOption.class, (String)ErrorMessages.getMessage((String)"MULTIPLE_ON_MISSING_VERTEX_OPTIONS", (Object[])new Object[0]));
        ReadGraphOption.validateUnique(options, ReadGraphOption.ParallelHintDegreeReadGraphOption.class, (String)ErrorMessages.getMessage((String)"MULTIPLE_PARALLEL_HINT_DEGREE_OPTIONS", (Object[])new Object[0]));
        ReadGraphOption.ReadGraphOptionDataBuilder optionBuilder = new ReadGraphOption.ReadGraphOptionDataBuilder();
        if (options != null) {
            for (ReadGraphOption option : options) {
                option.apply(optionBuilder);
            }
        }
        return optionBuilder;
    }
}

