/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.mutations;

import oracle.pgx.common.mutations.PickingStrategy;

public abstract class EdgeStrategy {
    public final StrategyType strategyType;
    private final boolean noSelfEdges;

    public EdgeStrategy(StrategyType strategyType, boolean noSelfEdges) {
        this.strategyType = strategyType;
        this.noSelfEdges = noSelfEdges;
    }

    public boolean isNoSelfEdges() {
        return this.noSelfEdges;
    }

    public boolean keepEdgeKeys() {
        return true;
    }

    public static EdgeStrategy getDefaultMultiEdgeHandler(boolean noMultiEdges, boolean noSelfEdges) {
        return noMultiEdges ? new PickingStrategy.PickAnyStrategy(noSelfEdges) : new KeepMultiEdgesStrategy(noSelfEdges);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgeStrategy that = (EdgeStrategy)o;
        return this.strategyType == that.strategyType;
    }

    public int hashCode() {
        return this.strategyType.hashCode();
    }

    public static final class KeepMultiEdgesStrategy
    extends EdgeStrategy {
        public KeepMultiEdgesStrategy(boolean noSelfEdges) {
            super(StrategyType.KEEP_ALL, noSelfEdges);
        }
    }

    public static enum StrategyType {
        KEEP_ALL,
        PICK_ANY,
        PICK_BY_EDGE_ID,
        PICK_BY_PROPERTY,
        MERGE;

    }
}

