/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.ir;

import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.pgql.lang.ir.CommonPathExpression;
import oracle.pgql.lang.ir.DerivedTable;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.GroupBy;
import oracle.pgql.lang.ir.OrderBy;
import oracle.pgql.lang.ir.OrderByElem;
import oracle.pgql.lang.ir.PathFindingGoal;
import oracle.pgql.lang.ir.Projection;
import oracle.pgql.lang.ir.QueryEdge;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.TableExpression;
import oracle.pgql.lang.ir.TableExpressionType;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgql.lang.ir.modify.ModifyQuery;
import oracle.pgql.lang.ir.unnest.OneRowPerEdge;
import oracle.pgql.lang.ir.unnest.OneRowPerStep;
import oracle.pgql.lang.ir.unnest.OneRowPerVertex;
import oracle.pgql.lang.ir.unnest.RowsPerMatch;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;

public class PgqlUtils {
    private static final Pattern ALL_UPPERCASED_IDENTIFIER = Pattern.compile("^[A-Z][A-Z0-9_]*$");
    public static final String GENERATED_VAR_PREFIX = "<<anonymous>>_";
    private static final Set<String> RESERVED_WORDS = new HashSet<String>(Arrays.asList("true", "false", "null", "not", "distinct"));
    static DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.#");

    public static Set<QueryVariable> getVariables(QueryExpression exp) {
        final HashSet<QueryVariable> result = new HashSet<QueryVariable>();
        exp.accept(new AbstractQueryExpressionVisitor(){

            @Override
            public void visit(QueryExpression.VarRef varRef) {
                result.add(varRef.getVariable());
            }

            @Override
            public void visit(QueryExpression.PropertyAccess propAccess) {
                result.add(propAccess.getVariable());
            }

            @Override
            public void visit(QueryVertex queryVertex) {
                result.add(queryVertex);
            }

            @Override
            public void visit(QueryEdge queryEdge) {
                result.add(queryEdge);
            }

            @Override
            public void visit(QueryPath queryPath) {
                result.add(queryPath);
                RowsPerMatch rowsPerMatch = queryPath.getRowsPerMatch();
                switch (queryPath.getRowsPerMatch().getRowsPerMatchType()) {
                    case ONE_ROW_PER_VERTEX: {
                        result.add(((OneRowPerVertex)rowsPerMatch).getVertex());
                        break;
                    }
                    case ONE_ROW_PER_EDGE: {
                        result.add(((OneRowPerEdge)rowsPerMatch).getEdge());
                        break;
                    }
                    case ONE_ROW_PER_MATCH: {
                        break;
                    }
                    case ONE_ROW_PER_STEP: {
                        OneRowPerStep oneRowPerStep = (OneRowPerStep)rowsPerMatch;
                        result.add(oneRowPerStep.getVertex1());
                        result.add(oneRowPerStep.getEdge());
                        result.add(oneRowPerStep.getVertex2());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException((Object)((Object)rowsPerMatch.getRowsPerMatchType()) + " not supported");
                    }
                }
            }
        });
        return result;
    }

    public static Set<QueryExpression.Aggregation> getAggregations(QueryExpression exp) {
        final HashSet<QueryExpression.Aggregation> result = new HashSet<QueryExpression.Aggregation>();
        exp.accept(new AbstractQueryExpressionVisitor(){

            @Override
            public void visit(QueryExpression.Aggregation.AggrCount aggrCount) {
                result.add(aggrCount);
            }

            @Override
            public void visit(QueryExpression.Aggregation.AggrListagg aggrListagg) {
                result.add(aggrListagg);
            }

            @Override
            public void visit(QueryExpression.Aggregation.AggrMin aggrMin) {
                result.add(aggrMin);
            }

            @Override
            public void visit(QueryExpression.Aggregation.AggrMax aggrMax) {
                result.add(aggrMax);
            }

            @Override
            public void visit(QueryExpression.Aggregation.AggrSum aggrSum) {
                result.add(aggrSum);
            }

            @Override
            public void visit(QueryExpression.Aggregation.AggrAvg aggrAvg) {
                result.add(aggrAvg);
            }

            @Override
            public void visit(QueryExpression.Aggregation.AggrArrayAgg aggrArrayAgg) {
                result.add(aggrArrayAgg);
            }

            @Override
            public void visit(QueryExpression.Function.Exists exists) {
            }

            @Override
            public void visit(QueryExpression.ScalarSubquery subquery) {
            }

            @Override
            public void visit(DerivedTable derivedTable) {
            }
        });
        return result;
    }

    public static String printConnectionWithSrcAndDst(VertexPairConnection connection) {
        return connection.getSrc() + " " + connection + " " + connection.getDst();
    }

    public static String printReverseConnectionWithSrcAndDst(VertexPairConnection connection) {
        QueryVertex dst = connection.getDst();
        QueryVertex src = connection.getSrc();
        Set<QueryExpression> constraints = Collections.emptySet();
        return dst + " " + PgqlUtils.printConnection(dst, connection, constraints) + " " + src;
    }

    public static String printIdentifier(String identifier) {
        return "\"" + identifier.replace("\"", "\"\"") + "\"";
    }

    public static String printIdentifier(String identifier, boolean alwaysQuote) {
        String lowerCasedIdentifier = identifier.toLowerCase();
        if (!alwaysQuote && ALL_UPPERCASED_IDENTIFIER.matcher(identifier).matches() && !RESERVED_WORDS.contains(lowerCasedIdentifier)) {
            return lowerCasedIdentifier;
        }
        return PgqlUtils.printIdentifier(identifier);
    }

    protected static String printPgqlString(GraphQuery graphQuery) {
        QueryExpression offset;
        QueryExpression limit;
        OrderBy orderBy;
        QueryExpression having;
        GroupBy groupBy;
        String result = PgqlUtils.printPathPatterns(graphQuery.getCommonPathExpressions());
        switch (graphQuery.getQueryType()) {
            case SELECT: {
                result = result + ((SelectQuery)graphQuery).getProjection();
                break;
            }
            case MODIFY: {
                ModifyQuery modifyQuery = (ModifyQuery)graphQuery;
                result = result + modifyQuery.getModifications().stream().map(x -> x.toString()).collect(Collectors.joining("\n"));
                break;
            }
            default: {
                throw new IllegalArgumentException(graphQuery.getQueryType().toString());
            }
        }
        List<TableExpression> tableExpressions = graphQuery.getTableExpressions();
        if (!tableExpressions.isEmpty()) {
            result = result + "\nFROM ";
            ArrayList<String> tableExpressionStrings = new ArrayList<String>();
            for (TableExpression tableExpression : tableExpressions) {
                tableExpressionStrings.add(tableExpression.getTableExpressionType() == TableExpressionType.GRAPH_PATTERN ? PgqlUtils.printPgqlString((GraphPattern)tableExpression, graphQuery.getGraphName()) : tableExpression.toString());
            }
            result = result + tableExpressionStrings.stream().collect(Collectors.joining(", "));
        }
        if ((groupBy = graphQuery.getGroupBy()) != null && !groupBy.getElements().isEmpty()) {
            result = result + "\n" + groupBy;
        }
        if ((having = graphQuery.getHaving()) != null) {
            result = result + "\nHAVING " + having;
        }
        if (!(orderBy = graphQuery.getOrderBy()).getElements().isEmpty()) {
            result = result + "\n" + orderBy;
        }
        if ((limit = graphQuery.getLimit()) != null) {
            result = result + "\nLIMIT " + limit;
        }
        if ((offset = graphQuery.getOffset()) != null) {
            result = result + "\nOFFSET " + offset;
        }
        return result;
    }

    protected static String printPgqlString(Projection projection) {
        if (projection.getElements().isEmpty()) {
            return "SELECT *";
        }
        return "SELECT " + (projection.isDistinct() ? "DISTINCT " : "") + projection.getElements().stream().map(x -> x.toString()).collect(Collectors.joining(", "));
    }

    protected static String printPgqlString(QueryVariable variable) {
        ExpAsVar expAsVar;
        if (variable.getVariableType() == QueryVariable.VariableType.EXP_AS_VAR && (expAsVar = (ExpAsVar)variable).isAnonymous()) {
            return expAsVar.getExp().toString();
        }
        return PgqlUtils.printIdentifier(variable.name, false);
    }

    protected static String printPgqlString(ExpAsVar expAsVar) {
        if (expAsVar.isAnonymous()) {
            return expAsVar.getExp().toString();
        }
        return expAsVar.getExp() + " AS " + PgqlUtils.printIdentifier(expAsVar.getName(), false);
    }

    protected static String printPgqlString(GraphPattern graphPattern) {
        return PgqlUtils.printPgqlString(graphPattern, null);
    }

    private static String printPgqlString(GraphPattern graphPattern, SchemaQualifiedName graphName) {
        LinkedHashSet<QueryVertex> uncoveredVertices = new LinkedHashSet<QueryVertex>(graphPattern.getVertices());
        ArrayList<String> graphPatternMatches = new ArrayList<String>();
        for (VertexPairConnection connection : graphPattern.getConnections()) {
            uncoveredVertices.remove(connection.getSrc());
            uncoveredVertices.remove(connection.getDst());
            if (PgqlUtils.isVariableLengthPathPatternNotReaches(connection)) {
                graphPatternMatches.add("MATCH " + connection.toString() + PgqlUtils.printOnClause(graphName));
                continue;
            }
            graphPatternMatches.add("MATCH " + connection.getSrc() + " " + connection + " " + connection.getDst() + PgqlUtils.printOnClause(graphName));
        }
        Iterator vertexIt = uncoveredVertices.iterator();
        while (vertexIt.hasNext()) {
            graphPatternMatches.add("MATCH " + vertexIt.next() + PgqlUtils.printOnClause(graphName));
        }
        String result = graphPatternMatches.stream().collect(Collectors.joining("\n   , "));
        if (!graphPattern.getConstraints().isEmpty()) {
            result = result + "\nWHERE " + graphPattern.getConstraints().stream().map(x -> x.toString()).collect(Collectors.joining("\n  AND "));
        }
        return result;
    }

    private static boolean isVariableLengthPathPatternNotReaches(VertexPairConnection connection) {
        if (connection.getVariableType() != QueryVariable.VariableType.PATH) {
            return false;
        }
        QueryPath queryPath = (QueryPath)connection;
        PathFindingGoal goal = queryPath.getPathFindingGoal();
        return goal != PathFindingGoal.REACHES || queryPath.getPathExpressionName().startsWith(GENERATED_VAR_PREFIX);
    }

    private static String printOnClause(SchemaQualifiedName graphName) {
        if (graphName == null) {
            return "";
        }
        return " ON " + graphName.toString();
    }

    private static String printPathPatterns(List<CommonPathExpression> commonPathExpressions) {
        return commonPathExpressions.stream().map(x -> PgqlUtils.printCommonPathExpression(x)).collect(Collectors.joining());
    }

    private static String printCommonPathExpression(CommonPathExpression commonPathExpression) {
        String result = "PATH " + PgqlUtils.printIdentifier(commonPathExpression.getName(), false) + " AS ";
        result = result + PgqlUtils.printPathExpression(commonPathExpression, false);
        return result + "\n";
    }

    protected static String printPathExpression(CommonPathExpression commonPathExpression, boolean tryOmitSrcAndDst) {
        Iterator<QueryVertex> vertexIt = commonPathExpression.getVertices().iterator();
        HashSet<QueryExpression> constraintsCopy = new HashSet<QueryExpression>(commonPathExpression.getConstraints());
        QueryVertex vertex = vertexIt.next();
        String result = PgqlUtils.deanonymizeIfNeeded(vertex, constraintsCopy);
        for (VertexPairConnection connection : commonPathExpression.getConnections()) {
            result = result + " " + PgqlUtils.printConnection(vertex, connection, constraintsCopy);
            vertex = vertexIt.next();
            result = result + " " + PgqlUtils.deanonymizeIfNeeded(vertex, constraintsCopy);
        }
        if (tryOmitSrcAndDst) {
            if (result.startsWith("()")) {
                result = result.substring(3);
            }
            if (result.endsWith("()")) {
                result = result.substring(0, result.length() - 3);
            }
        }
        if (!constraintsCopy.isEmpty()) {
            result = result + " WHERE " + constraintsCopy.stream().map(x -> x.toString()).collect(Collectors.joining(" AND "));
        }
        if (commonPathExpression.getCost() != null) {
            result = result + " COST " + commonPathExpression.getCost();
        }
        return result;
    }

    private static String deanonymizeIfNeeded(QueryVariable var, Set<QueryExpression> constraintsCopy) {
        QueryExpression labelPredicate = null;
        Iterator<QueryExpression> it = constraintsCopy.iterator();
        while (it.hasNext()) {
            QueryExpression exp = it.next();
            if (!PgqlUtils.isHasLabelFunctionForVar(exp, var)) continue;
            labelPredicate = exp;
            it.remove();
            break;
        }
        Set variables = constraintsCopy.stream().map(c -> PgqlUtils.getVariables(c)).collect(HashSet::new, Set::addAll, Set::addAll);
        boolean printVariableName = !var.isAnonymous() || var.isAnonymous() && variables.contains(var);
        switch (var.getVariableType()) {
            case EDGE: {
                String edge = !printVariableName && labelPredicate == null ? "-" : "-[" + PgqlUtils.printVariableAndLabelPredicate(var, printVariableName, labelPredicate) + "]-";
                QueryEdge queryEdge = (QueryEdge)var;
                if (queryEdge.isDirected()) {
                    return edge + ">";
                }
                return edge;
            }
            case PATH: {
                QueryPath queryPath = (QueryPath)var;
                return "-/" + (queryPath.isAnonymous() ? "" : PgqlUtils.printIdentifier(var.name, false)) + ":" + PgqlUtils.printIdentifier(queryPath.getPathExpressionName(), false) + PgqlUtils.printHops(queryPath) + "/->";
            }
            case VERTEX: {
                return "(" + PgqlUtils.printVariableAndLabelPredicate(var, printVariableName, labelPredicate) + ")";
            }
        }
        throw new UnsupportedOperationException("variable type not supported: " + (Object)((Object)var.getVariableType()));
    }

    private static String printVariableAndLabelPredicate(QueryVariable var, boolean printVariableName, QueryExpression labelPredicate) {
        String result;
        String string = result = printVariableName ? PgqlUtils.printIdentifier(var.getName(), false) : "";
        if (labelPredicate != null) {
            result = result + " IS " + PgqlUtils.printLabelPredicate(labelPredicate);
        }
        return result;
    }

    public static boolean isHasLabelFunctionForVar(QueryExpression exp, QueryVariable var) {
        switch (exp.getExpType()) {
            case FUNCTION_CALL: {
                boolean hasLabelFunctionName;
                QueryExpression.FunctionCall functionCall = (QueryExpression.FunctionCall)exp;
                boolean bl = hasLabelFunctionName = functionCall.getFunctionName().equals("has_label") || functionCall.getFunctionName().equals("HAS_LABEL");
                if (functionCall.getPackageName() == null && hasLabelFunctionName && functionCall.getArgs().size() == 2) {
                    QueryExpression arg0 = functionCall.getArgs().get(0);
                    QueryExpression arg1 = functionCall.getArgs().get(1);
                    if (arg0.getExpType() == QueryExpression.ExpressionType.VARREF && arg1.getExpType() == QueryExpression.ExpressionType.STRING && ((QueryExpression.VarRef)arg0).getVariable() == var) {
                        return true;
                    }
                }
                return false;
            }
            case OR: {
                QueryExpression.LogicalExpression.Or or = (QueryExpression.LogicalExpression.Or)exp;
                return PgqlUtils.isHasLabelFunctionForVar(or.getExp1(), var) && PgqlUtils.isHasLabelFunctionForVar(or.getExp2(), var);
            }
        }
        return false;
    }

    private static String printLabelPredicate(QueryExpression labelPredicate) {
        switch (labelPredicate.getExpType()) {
            case FUNCTION_CALL: {
                QueryExpression.FunctionCall hasLabelPredicate = (QueryExpression.FunctionCall)labelPredicate;
                QueryExpression.Constant.ConstString constString = (QueryExpression.Constant.ConstString)hasLabelPredicate.getArgs().get(1);
                return PgqlUtils.printIdentifier((String)constString.getValue(), false);
            }
            case OR: {
                QueryExpression.LogicalExpression.Or or = (QueryExpression.LogicalExpression.Or)labelPredicate;
                return PgqlUtils.printLabelPredicate(or.getExp1()) + "|" + PgqlUtils.printLabelPredicate(or.getExp2());
            }
        }
        throw new IllegalArgumentException("unexpected expression type: " + (Object)((Object)labelPredicate.getExpType()));
    }

    private static String printConnection(QueryVertex vertexOnTheLeft, VertexPairConnection connection, Set<QueryExpression> constraintsCopy) {
        boolean isUndirectedEdge;
        String connectionAsString = PgqlUtils.deanonymizeIfNeeded(connection, constraintsCopy);
        boolean bl = isUndirectedEdge = connection.getVariableType() == QueryVariable.VariableType.EDGE && !((QueryEdge)connection).isDirected();
        if (isUndirectedEdge || connection.getSrc() == vertexOnTheLeft) {
            return connectionAsString;
        }
        return "<" + connectionAsString.substring(0, connectionAsString.length() - 1);
    }

    protected static String printHops(QueryPath path) {
        long minHops = path.getMinHops();
        long maxHops = path.getMaxHops();
        if (minHops == 1L && maxHops == 1L && path.getPathFindingGoal() == PathFindingGoal.REACHES) {
            return "";
        }
        if (minHops == 0L && maxHops == -1L) {
            return "*";
        }
        if (minHops == 1L && maxHops == -1L) {
            return "+";
        }
        if (minHops == maxHops) {
            return "{" + minHops + "}";
        }
        if (maxHops == -1L) {
            return "{" + minHops + ",}";
        }
        if (minHops == 0L) {
            return "{," + maxHops + "}";
        }
        return "{" + minHops + "," + maxHops + "}";
    }

    protected static String printPgqlString(GroupBy groupBy) {
        return "GROUP BY " + groupBy.getElements().stream().map(x -> x.toString()).collect(Collectors.joining(", "));
    }

    protected static String printPgqlString(OrderBy orderBy) {
        return "ORDER BY " + orderBy.getElements().stream().map(orderByElem -> PgqlUtils.printPgqlString(orderByElem)).collect(Collectors.joining(", "));
    }

    protected static String printPgqlString(OrderByElem orderByElem) {
        return orderByElem.getExp() + (orderByElem.isAscending() ? "" : " DESC");
    }

    private static String printTime(LocalTime time) {
        StringBuilder buf = new StringBuilder(18);
        int hourValue = time.getHour();
        int minuteValue = time.getMinute();
        int secondValue = time.getSecond();
        int nanoValue = time.getNano();
        buf.append(hourValue < 10 ? "0" : "").append(hourValue).append(minuteValue < 10 ? ":0" : ":").append(minuteValue);
        buf.append(secondValue < 10 ? ":0" : ":").append(secondValue);
        if (nanoValue > 0) {
            buf.append('.');
            if (nanoValue % 1000000 == 0) {
                buf.append(Integer.toString(nanoValue / 1000000 + 1000).substring(1));
            } else if (nanoValue % 1000 == 0) {
                buf.append(Integer.toString(nanoValue / 1000 + 1000000).substring(1));
            } else {
                buf.append(Integer.toString(nanoValue + 1000000000).substring(1));
            }
        }
        return buf.toString();
    }

    public static String printLiteral(double val) {
        return DECIMAL_FORMAT.format(val);
    }

    public static String printLiteral(String val) {
        return "'" + val.replace("'", "''") + "'";
    }

    public static String printLiteral(LocalDate val) {
        return "DATE '" + val + "'";
    }

    public static String printLiteral(LocalTime val) {
        return "TIME '" + PgqlUtils.printTime(val) + "'";
    }

    public static String printLiteral(LocalDateTime val) {
        return "TIMESTAMP '" + val.toLocalDate() + " " + PgqlUtils.printTime(val.toLocalTime()) + "'";
    }

    public static String printLiteral(OffsetTime val) {
        return "TIME '" + PgqlUtils.printTime(val.toLocalTime()) + val.getOffset() + "'";
    }

    public static String printLiteral(OffsetDateTime val) {
        return "TIMESTAMP '" + val.toLocalDate() + " " + PgqlUtils.printTime(val.toLocalTime()) + val.getOffset() + "'";
    }

    static {
        DECIMAL_FORMAT.setDecimalSeparatorAlwaysShown(true);
        DECIMAL_FORMAT.setMaximumFractionDigits(Integer.MAX_VALUE);
    }
}

