/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.Date;
import oracle.pgx.common.util.DateUtils;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.vfs.AbstractUriVirtualFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpVirtualFile
extends AbstractUriVirtualFile {
    private static final Logger LOG = LoggerFactory.getLogger(HttpVirtualFile.class);
    public static final String ASCTIME_FORMAT = "EEE MMM d HH:mm:ss yyyy";
    public static final String RFC1036_FORMAT = "EEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String RFC1123_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";

    public HttpVirtualFile(String path) throws IOException {
        super(path);
    }

    public HttpVirtualFile(String parent, String relative) throws IOException {
        super(parent, relative);
    }

    @Override
    public boolean exists() throws IOException {
        URLConnection connection = this.uri.toURL().openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            return false;
        }
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        httpConnection.setRequestMethod("HEAD");
        httpConnection.setInstanceFollowRedirects(true);
        httpConnection.connect();
        return httpConnection.getResponseCode() == 200;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.uri.toURL().openStream();
    }

    @Override
    public long getLastModifiedTimestamp() throws IOException {
        URLConnection connection = this.uri.toURL().openConnection();
        String lastModified = connection.getHeaderField("Last-Modified");
        if (lastModified == null) {
            return this.getCurrentTimeMillis();
        }
        try {
            Date date = DateUtils.parseDate(lastModified, RFC1123_FORMAT, RFC1036_FORMAT, ASCTIME_FORMAT);
            return date.getTime();
        }
        catch (ParseException e) {
            LOG.warn("received invalid Last-Modified date format, will return current time", (Throwable)e);
            return this.getCurrentTimeMillis();
        }
    }

    @Override
    public long getSizeInBytes() throws IOException {
        URLConnection connection = this.uri.toURL().openConnection();
        return connection.getContentLengthLong();
    }

    private long getCurrentTimeMillis() {
        return new Date().getTime();
    }

    @Override
    protected RuntimeException readOnlyException() {
        return new UnsupportedOperationException(ErrorMessages.getMessage("CANNOT_WRITE_TO_URL", new Object[0]));
    }
}

