/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import oracle.pgql.lang.spatial.Point2D;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.TemporalTypeUtils;

public final class UnboxedDefaultValue {
    private int intVal;
    private long longVal;
    private double doubleVal;
    private float floatVal;
    private boolean boolVal;
    private String stringVal;
    private Date dateVal;
    private LocalDate localDateVal;
    private LocalTime localTimeVal;
    private LocalDateTime localDateTimeVal;
    private OffsetTime offsetTimeVal;
    private OffsetDateTime offsetDateTimeVal;
    private Point2D point2DVal;
    private Set<String> stringSetVal;

    public UnboxedDefaultValue(PropertyType propertyType, Object defVal) {
        this(propertyType, defVal, true);
    }

    public UnboxedDefaultValue(PropertyType propertyType, Object defVal, boolean useDefaultDefaultForNull) {
        this.intVal = 0;
        this.longVal = 0L;
        this.doubleVal = 0.0;
        this.floatVal = 0.0f;
        this.boolVal = false;
        this.stringVal = "";
        this.dateVal = new Date(0L);
        this.localDateVal = LocalDate.ofEpochDay(0L);
        this.localTimeVal = LocalTime.ofNanoOfDay(0L);
        this.localDateTimeVal = LocalDateTime.of(this.localDateVal, this.localTimeVal);
        this.offsetTimeVal = TemporalTypeUtils.parseTimeWithTimezone(0, 0);
        this.offsetDateTimeVal = TemporalTypeUtils.parseTimestampWithTimezone(0L, 0);
        this.point2DVal = new Point2D(0.0, 0.0);
        this.stringSetVal = new HashSet<String>();
        this.assignDefaultValue(propertyType, defVal, useDefaultDefaultForNull);
    }

    public UnboxedDefaultValue(PropertyType propertyType, IdType vertexKeyType, Object defVal) {
        this(propertyType, vertexKeyType, defVal, true);
    }

    public UnboxedDefaultValue(PropertyType propertyType, IdType vertexKeyType, Object defVal, boolean useDefaultDefaultForNull) {
        block6: {
            block5: {
                this.intVal = 0;
                this.longVal = 0L;
                this.doubleVal = 0.0;
                this.floatVal = 0.0f;
                this.boolVal = false;
                this.stringVal = "";
                this.dateVal = new Date(0L);
                this.localDateVal = LocalDate.ofEpochDay(0L);
                this.localTimeVal = LocalTime.ofNanoOfDay(0L);
                this.localDateTimeVal = LocalDateTime.of(this.localDateVal, this.localTimeVal);
                this.offsetTimeVal = TemporalTypeUtils.parseTimeWithTimezone(0, 0);
                this.offsetDateTimeVal = TemporalTypeUtils.parseTimestampWithTimezone(0L, 0);
                this.point2DVal = new Point2D(0.0, 0.0);
                this.stringSetVal = new HashSet<String>();
                if (propertyType != PropertyType.VERTEX) break block5;
                switch (vertexKeyType) {
                    case INTEGER: {
                        this.assignDefaultValue(PropertyType.INTEGER, defVal, useDefaultDefaultForNull);
                        break block6;
                    }
                    case LONG: {
                        this.assignDefaultValue(PropertyType.LONG, defVal, useDefaultDefaultForNull);
                        break block6;
                    }
                    case STRING: {
                        this.assignDefaultValue(PropertyType.STRING, defVal, useDefaultDefaultForNull);
                        break block6;
                    }
                    default: {
                        throw new UnsupportedOperationException(ErrorMessages.getMessage("UNSUPPORTED_NODE_KEY_TYPE", vertexKeyType));
                    }
                }
            }
            this.assignDefaultValue(propertyType, defVal, useDefaultDefaultForNull);
        }
    }

    private void assignDefaultValue(PropertyType propertyType, Object defVal, boolean useDefaultDefaultForNull) {
        if (defVal == null && useDefaultDefaultForNull) {
            return;
        }
        switch (propertyType) {
            case BOOLEAN: {
                this.boolVal = (Boolean)defVal;
                break;
            }
            case LOCAL_DATE: {
                this.localDateVal = (LocalDate)defVal;
                break;
            }
            case TIME: {
                this.localTimeVal = (LocalTime)defVal;
                break;
            }
            case TIMESTAMP: {
                this.localDateTimeVal = (LocalDateTime)defVal;
                break;
            }
            case TIME_WITH_TIMEZONE: {
                this.offsetTimeVal = (OffsetTime)defVal;
                break;
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                this.offsetDateTimeVal = (OffsetDateTime)defVal;
                break;
            }
            case POINT2D: {
                this.point2DVal = (Point2D)defVal;
                break;
            }
            case DOUBLE: {
                this.doubleVal = (Double)defVal;
                break;
            }
            case FLOAT: {
                this.floatVal = ((Float)defVal).floatValue();
                break;
            }
            case INTEGER: {
                this.intVal = (Integer)defVal;
                break;
            }
            case EDGE: 
            case LONG: {
                this.longVal = (Long)defVal;
                break;
            }
            case STRING: {
                this.stringVal = (String)defVal;
                break;
            }
            case RO_STRING_SET: {
                this.stringSetVal = (Set)defVal;
                break;
            }
            default: {
                throw new UnsupportedOperationException(ErrorMessages.getMessage("UNSUPPORTED_PROPERTY_TYPE", propertyType));
            }
        }
    }

    public int getInt() {
        return this.intVal;
    }

    public long getLong() {
        return this.longVal;
    }

    public double getDouble() {
        return this.doubleVal;
    }

    public float getFloat() {
        return this.floatVal;
    }

    public boolean getBoolean() {
        return this.boolVal;
    }

    public String getString() {
        return this.stringVal;
    }

    public Date getDate() {
        return this.dateVal;
    }

    public LocalDate getLocalDate() {
        return this.localDateVal;
    }

    public LocalTime getTime() {
        return this.localTimeVal;
    }

    public LocalDateTime getTimestamp() {
        return this.localDateTimeVal;
    }

    public OffsetTime getTimeWithTimezone() {
        return this.offsetTimeVal;
    }

    public OffsetDateTime getTimestampWithTimezone() {
        return this.offsetDateTimeVal;
    }

    public Point2D getPoint() {
        return this.point2DVal;
    }

    public Set<String> getStringSet() {
        return this.stringSetVal;
    }
}

