/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class SafeThreadLocal<T> {
    private final ConcurrentHashMap<Thread, T> threadLocals = new ConcurrentHashMap();

    public static <S> SafeThreadLocal<S> withInitial(Supplier<? extends S> supplier) {
        return new SafeSuppliedThreadLocal<S>(supplier);
    }

    protected T initialValue() {
        return null;
    }

    public T get() {
        Thread t = Thread.currentThread();
        return (T)this.threadLocals.computeIfAbsent(t, thread -> this.initialValue());
    }

    public void set(T value) {
        if (value == null) {
            this.remove();
        } else {
            Thread t = Thread.currentThread();
            this.threadLocals.put(t, value);
        }
    }

    public void remove() {
        Thread t = Thread.currentThread();
        this.threadLocals.remove(t);
    }

    static final class SafeSuppliedThreadLocal<T>
    extends SafeThreadLocal<T> {
        private final Supplier<? extends T> supplier;

        SafeSuppliedThreadLocal(Supplier<? extends T> supplier) {
            this.supplier = Objects.requireNonNull(supplier);
        }

        @Override
        protected T initialValue() {
            return this.supplier.get();
        }
    }
}

