/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.types;

import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;

public final class TypeConverter {
    private TypeConverter() {
    }

    public static PropertyType entityTypeToPropertyType(EntityType type) {
        switch (type) {
            case VERTEX: {
                return PropertyType.VERTEX;
            }
            case EDGE: {
                return PropertyType.EDGE;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    public static EntityType propertyTypeToEntityType(PropertyType type) {
        return TypeConverter.propertyTypeToEntityType(type, true);
    }

    public static EntityType propertyTypeToEntityType(PropertyType type, boolean strict) {
        switch (type) {
            case VERTEX: {
                return EntityType.VERTEX;
            }
            case EDGE: {
                return EntityType.EDGE;
            }
        }
        if (strict) {
            throw new IllegalArgumentException(type.toString());
        }
        return null;
    }

    public static PropertyType getPropertyTypeForIdType(IdType idType) {
        switch (idType) {
            case INTEGER: {
                return PropertyType.INTEGER;
            }
            case LONG: {
                return PropertyType.LONG;
            }
            case STRING: {
                return PropertyType.STRING;
            }
        }
        throw new IllegalArgumentException(idType.toString());
    }

    public static IdType getIdTypeForPropertyType(PropertyType propertyType) {
        switch (propertyType) {
            case INTEGER: {
                return IdType.INTEGER;
            }
            case LONG: {
                return IdType.LONG;
            }
            case STRING: {
                return IdType.STRING;
            }
        }
        throw new IllegalArgumentException(propertyType.toString());
    }
}

