/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.auth;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pgx.common.auth.PermissionEntity;
import oracle.pgx.common.auth.PgxRole;
import oracle.pgx.common.types.AuthorizationType;

public class PgxUser
implements PermissionEntity {
    public static final PgxUser UNAUTHENTICATED_USER = new PgxUser(null);
    private final String name;
    private final Set<PgxRole> roles;
    private final Map<Object, Object> context;

    public PgxUser(String name, Set<PgxRole> roles, Map<Object, Object> context) {
        this.name = name;
        this.roles = roles;
        this.context = context;
    }

    public PgxUser(String name, Set<PgxRole> roles) {
        this(name, roles, Collections.emptyMap());
    }

    public PgxUser(String name) {
        this(name, Collections.emptySet(), Collections.emptyMap());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AuthorizationType getType() {
        return AuthorizationType.USER;
    }

    public Set<PgxRole> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public Set<String> getRolesNames() {
        return this.getRoles().stream().map(PgxRole::getName).collect(Collectors.toSet());
    }

    public Map<Object, Object> getContext() {
        return this.context;
    }

    public String toString() {
        return "PgxUser(" + this.name + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PgxUser)) {
            return false;
        }
        PgxUser user = (PgxUser)o;
        return Objects.equals(this.name, user.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

