/*
 * Decompiled with CFR 0.152.
 */
package com.google.json;

import com.google.json.JsonSanitizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class EvalMinifier {
    private static final String ENVELOPE_P1 = "(function(";
    private static final String ENVELOPE_P2 = "){return";
    private static final String ENVELOPE_P3 = "}(";
    private static final String ENVELOPE_P4 = "))";
    private static final int BOILERPLATE_COST = "(function(){return}())".length();
    private static final int MARGINAL_VAR_COST = ",,".length();
    private static final int SAVINGS_THRESHOLD = 32;
    private static final String[][] RESERVED_KEYWORDS = new String[][]{new String[0], new String[0], {"as", "do", "if", "in", "of"}, {"for", "get", "let", "new", "set", "try", "var"}, {"case", "else", "enum", "eval", "from", "null", "this", "true", "void", "with"}, {"async", "await", "break", "catch", "class", "const", "false", "super", "throw", "while", "yield"}, {"delete", "export", "import", "public", "return", "switch", "static", "target", "typeof"}, {"default", "extends", "finally", "package", "private"}, {"continue", "debugger", "function"}, {"arguments", "interface", "protected"}, {"implements", "instanceof"}};

    public static String minify(String jsonish) {
        JsonSanitizer s = new JsonSanitizer(jsonish);
        s.sanitize();
        return EvalMinifier.minify(s.toCharSequence()).toString();
    }

    public static String minify(String jsonish, int maximumNestingDepth) {
        JsonSanitizer s = new JsonSanitizer(jsonish, maximumNestingDepth);
        s.sanitize();
        return EvalMinifier.minify(s.toCharSequence()).toString();
    }

    private static CharSequence minify(CharSequence json) {
        HashMap<Token, Token> pool = new HashMap<Token, Token>();
        int n = json.length();
        for (int i = 0; i < n; ++i) {
            Token tok;
            Token last;
            char wch;
            int nextNonWhitespace;
            int tokEnd;
            char ch = json.charAt(i);
            if (ch == '\"') {
                for (tokEnd = i + 1; tokEnd < n; ++tokEnd) {
                    char tch = json.charAt(tokEnd);
                    if (tch == '\\') {
                        ++tokEnd;
                        continue;
                    }
                    if (tch != '\"') {
                        continue;
                    }
                    break;
                }
            } else {
                if (!EvalMinifier.isLetterOrNumberChar(ch)) continue;
                for (tokEnd = i + 1; tokEnd < n && EvalMinifier.isLetterOrNumberChar(json.charAt(tokEnd)); ++tokEnd) {
                }
            }
            for (nextNonWhitespace = ++tokEnd; nextNonWhitespace < n && ((wch = json.charAt(nextNonWhitespace)) == '\t' || wch == '\n' || wch == '\r' || wch == ' '); ++nextNonWhitespace) {
            }
            if ((nextNonWhitespace == n || ':' != json.charAt(nextNonWhitespace) && tokEnd - i >= 4) && (last = pool.put(tok = new Token(i, tokEnd, json), tok)) != null) {
                tok.prev = last;
            }
            i = nextNonWhitespace - 1;
        }
        int potentialSavings = 0;
        ArrayList<Object> dupes = new ArrayList<Object>();
        Iterator values = pool.values().iterator();
        while (values.hasNext()) {
            Token tok = (Token)values.next();
            if (tok.prev == null) {
                values.remove();
                continue;
            }
            int chainDepth = 0;
            Token t = tok;
            while (t != null) {
                ++chainDepth;
                t = t.prev;
            }
            int tokSavings = (chainDepth - 1) * (tok.end - tok.start) - MARGINAL_VAR_COST;
            if (tokSavings <= 0) continue;
            potentialSavings += tokSavings;
            Object t2 = tok;
            while (t2 != null) {
                dupes.add(t2);
                t2 = ((Token)t2).prev;
            }
        }
        if (potentialSavings <= BOILERPLATE_COST + 32) {
            return json;
        }
        Collections.sort(dupes);
        int nTokens = dupes.size();
        StringBuilder sb = new StringBuilder(n);
        sb.append(ENVELOPE_P1);
        NameGenerator nameGenerator = new NameGenerator();
        boolean first = true;
        for (Token tok : pool.values()) {
            String name = nameGenerator.next();
            Token t = tok;
            while (t != null) {
                t.name = name;
                t = t.prev;
            }
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(name);
        }
        sb.append(ENVELOPE_P2);
        int afterReturn = sb.length();
        int pos = 0;
        int tokIndex = 0;
        while (true) {
            Token tok;
            tok = tokIndex < nTokens ? (Token)dupes.get(tokIndex++) : null;
            int limit = tok != null ? tok.start : n;
            boolean inString = false;
            for (int i = pos; i < limit; ++i) {
                char ch = json.charAt(i);
                if (inString) {
                    if (ch == '\"') {
                        inString = false;
                        continue;
                    }
                    if (ch != '\\') continue;
                    ++i;
                    continue;
                }
                if (ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ') {
                    if (pos != i) {
                        sb.append(json, pos, i);
                    }
                    pos = i + 1;
                    continue;
                }
                if (ch != '\"') continue;
                inString = true;
            }
            assert (!inString);
            if (pos != limit) {
                sb.append(json, pos, limit);
            }
            if (tok == null) break;
            sb.append(tok.name);
            pos = tok.end;
        }
        char ch = sb.charAt(afterReturn);
        if (ch != '{' && ch != '[' && ch != '\"') {
            sb.insert(afterReturn, ' ');
        }
        sb.append(ENVELOPE_P3);
        boolean first2 = true;
        for (Token tok : pool.values()) {
            if (first2) {
                first2 = false;
            } else {
                sb.append(',');
            }
            sb.append(tok.seq, tok.start, tok.end);
        }
        sb.append(ENVELOPE_P4);
        return sb;
    }

    private static boolean isLetterOrNumberChar(char ch) {
        if ('0' <= ch && ch <= '9') {
            return true;
        }
        char lch = (char)(ch | 0x20);
        if ('a' <= lch && lch <= 'z') {
            return true;
        }
        return ch == '_' || ch == '$' || ch == '-' || ch == '.';
    }

    static boolean regionMatches(CharSequence a, int as, int ae, CharSequence b, int bs, int be) {
        int n = ae - as;
        if (be - bs != n) {
            return false;
        }
        int ai = as;
        int bi = bs;
        while (ai < ae) {
            if (a.charAt(ai) != b.charAt(bi)) {
                return false;
            }
            ++ai;
            ++bi;
        }
        return true;
    }

    static int nextIdentChar(char ch, boolean allowDigits) {
        if (ch == 'z') {
            return 65;
        }
        if (ch == 'Z') {
            return 95;
        }
        if (ch == '_') {
            return 36;
        }
        if (ch == '$') {
            if (allowDigits) {
                return 48;
            }
            return -1;
        }
        if (ch == '9') {
            return -1;
        }
        return (char)(ch + '\u0001');
    }

    static final class NameGenerator {
        private final StringBuilder sb = new StringBuilder("a");

        NameGenerator() {
        }

        public String next() {
            String name;
            int nameLen;
            block0: do {
                int sbLen;
                name = this.sb.toString();
                int i = sbLen = this.sb.length();
                while (--i >= 0) {
                    int next = EvalMinifier.nextIdentChar(this.sb.charAt(i), i != 0);
                    if (next < 0) {
                        this.sb.setCharAt(i, 'a');
                        if (i != 0) continue;
                        this.sb.append('a');
                        continue;
                    }
                    this.sb.setCharAt(i, (char)next);
                    continue block0;
                }
            } while ((nameLen = name.length()) < RESERVED_KEYWORDS.length && Arrays.binarySearch(RESERVED_KEYWORDS[nameLen], name) >= 0);
            return name;
        }
    }

    private static final class Token
    implements Comparable<Token> {
        private final int start;
        private final int end;
        private final int hashCode;
        @Nonnull
        private final CharSequence seq;
        @Nullable
        Token prev;
        @Nullable
        String name;

        Token(int start, int end, CharSequence seq) {
            this.start = start;
            this.end = end;
            this.seq = seq;
            int hc = 0;
            for (int i = start; i < end; ++i) {
                char ch = seq.charAt(i);
                hc = hc * 31 + ch;
            }
            this.hashCode = hc;
        }

        public boolean equals(@Nullable Object o) {
            if (!(o instanceof Token)) {
                return false;
            }
            Token that = (Token)o;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            return EvalMinifier.regionMatches(this.seq, this.start, this.end, that.seq, that.start, that.end);
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public int compareTo(Token t) {
            return this.start - t.start;
        }
    }
}

