/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.imports.parser;

import oracle.pg.imports.GraphImportOutputFormat;
import oracle.pg.imports.GraphImporter;
import oracle.pg.imports.exceptions.GraphImportException;
import oracle.pg.imports.graph.PropertyGraphSqlWriter;
import oracle.pg.imports.graph.PropertyGraphViewWriter;
import oracle.pg.imports.graph.PropertyGraphWriter;
import oracle.pg.imports.parser.ReaderResult;

public final class WriterFactory {
    public static PropertyGraphWriter getWriter(GraphImportOutputFormat format, GraphImporter importer, ReaderResult readerResult) throws GraphImportException {
        if (format == null) {
            throw new GraphImportException("Output format not valid.");
        }
        PropertyGraphWriter writer = null;
        switch (format) {
            case PG_VIEW: {
                writer = new PropertyGraphViewWriter();
                break;
            }
            case PG_SQL: {
                writer = new PropertyGraphSqlWriter();
                break;
            }
            default: {
                throw new GraphImportException(String.format("Output format: %s not valid.", new Object[]{format}));
            }
        }
        WriterFactory.initWriter(writer, format, importer, readerResult);
        return writer;
    }

    private static void initWriter(PropertyGraphWriter writer, GraphImportOutputFormat format, GraphImporter importer, ReaderResult readerResult) {
        if (format == GraphImportOutputFormat.PG_VIEW || format == GraphImportOutputFormat.PG_SQL) {
            PropertyGraphWriter propertyGraphWriter = writer;
            propertyGraphWriter.setParallelism(importer.getParallelism()).setDynamicSampling(importer.getDynamicSampling()).setMatchOptions(importer.getMatchOptions()).setOptions(importer.getOptions());
        }
        writer.setReaderResult(readerResult).setConnectionManager(importer.getConnectionManager()).setGraphName(importer.getGraphName());
    }
}

