/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.pg.text.Parameter;

public class OracleIndexParameters {
    protected List<Parameter> m_indexParameters;
    public static final String BATCH_SIZE_PARAMETER = "batch-size";
    public static final String REINDEX_NUM_CONNS_PARAMETER = "reindex-numConns";
    public static final String COMMIT_BATCH_SIZE_PARAMETER = "commit-batch-size";
    public static final String WRITE_TIMEOUT_PARAMETER = "write-timeout";
    public static final int MAX_BATCH = 1000000;
    public static final int MAX_COMMIT_BATCH = 10000000;
    public static final Integer MAX_COMMIT = 100000000;
    public static final Integer MAX_WAIT_TIMEOUT = 120000;
    public static final Integer MAX_CONNS = Integer.MAX_VALUE;
    public static final String SEARCH_ENGINE_PARAMETER = "search-engine";
    public static final Integer LUCENE_ENGINE = 1;
    public static final Integer SOLR_ENGINE = 0;
    private static final Integer DEFAULT_COMMIT_SIZE = 100000;
    private static final Integer DEFAULT_BATCH_SIZE = 500000;
    private static final Integer DEFAULT_CONNS = 1;

    public OracleIndexParameters() {
        this.m_indexParameters = this.defaultIndexParamsAsList();
    }

    public OracleIndexParameters(Parameter[] parameters) {
        if (parameters != null) {
            this.m_indexParameters = Arrays.asList(parameters);
        }
    }

    public OracleIndexParameters(List<Parameter> parameters) {
        if (parameters != null) {
            this.m_indexParameters = parameters;
        }
    }

    public final Parameter[] defaultIndexParams() {
        List<Parameter> params = this.defaultIndexParamsAsList();
        return params.toArray(new Parameter[params.size()]);
    }

    public List<Parameter> defaultIndexParamsAsList() {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(new Parameter<String, Integer>(SEARCH_ENGINE_PARAMETER, LUCENE_ENGINE));
        params.add(new Parameter<String, Integer>(REINDEX_NUM_CONNS_PARAMETER, DEFAULT_CONNS));
        params.add(new Parameter<String, Integer>(BATCH_SIZE_PARAMETER, DEFAULT_BATCH_SIZE));
        params.add(new Parameter<String, Integer>(COMMIT_BATCH_SIZE_PARAMETER, DEFAULT_COMMIT_SIZE));
        return params;
    }

    public final Parameter[] getParameters() {
        if (this.m_indexParameters != null) {
            return this.m_indexParameters.toArray(new Parameter[this.m_indexParameters.size()]);
        }
        return new Parameter[0];
    }

    public String toString() {
        if (this.m_indexParameters != null) {
            return this.m_indexParameters.toString();
        }
        return "Parameters empty";
    }

    public void addParameter(Parameter parameter) {
        if (parameter != null) {
            this.m_indexParameters.add(parameter);
        }
    }
}

